/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.events.PageInitializingEvent;
import org.icepdf.core.events.PageLoadingEvent;
import org.icepdf.core.events.PageLoadingListener;
import org.icepdf.core.events.PagePaintingEvent;
import org.icepdf.core.events.PaintPageEvent;
import org.icepdf.core.events.PaintPageListener;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.OptionalContent;
import org.icepdf.core.pobjects.PDimension;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.Thumbnail;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.FreeTextAnnotation;
import org.icepdf.core.pobjects.fonts.Font;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.WatermarkCallback;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.pobjects.graphics.text.WordText;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.GraphicsRenderingHints;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;
import org.icepdf.core.util.content.ContentParser;
import org.icepdf.core.util.content.ContentParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page
extends Dictionary {
    private static final Logger logger;
    public static final float SELECTION_ALPHA = 0.3f;
    public static Color selectionColor;
    public static Color highlightColor;
    public static final Name TYPE;
    public static final Name ANNOTS_KEY;
    public static final Name CONTENTS_KEY;
    public static final Name RESOURCES_KEY;
    public static final Name THUMB_KEY;
    public static final Name PARENT_KEY;
    public static final Name ROTATE_KEY;
    public static final Name MEDIABOX_KEY;
    public static final Name CROPBOX_KEY;
    public static final Name ARTBOX_KEY;
    public static final Name BLEEDBOX_KEY;
    public static final Name TRIMBOX_KEY;
    public static final int BOUNDARY_MEDIABOX = 1;
    public static final int BOUNDARY_CROPBOX = 2;
    public static final int BOUNDARY_BLEEDBOX = 3;
    public static final int BOUNDARY_TRIMBOX = 4;
    public static final int BOUNDARY_ARTBOX = 5;
    private Resources resources;
    private List<Annotation> annotations;
    private List<Stream> contents;
    private Shapes shapes = null;
    private final List<PaintPageListener> paintPageListeners = new ArrayList<PaintPageListener>(8);
    private final List<PageLoadingListener> pageLoadingListeners = new ArrayList<PageLoadingListener>();
    private PRectangle mediaBox;
    private PRectangle cropBox;
    private PRectangle bleedBox;
    private PRectangle trimBox;
    private PRectangle artBox;
    private float pageRotation = 0.0f;
    private int pageIndex;
    private int imageCount;
    private boolean pageInitialized;
    private boolean pagePainted;
    private WatermarkCallback watermarkCallback;

    public Page(Library l, HashMap h) {
        super(l, h);
    }

    public boolean isInitiated() {
        return this.inited;
    }

    private void initPageContents() throws InterruptedException {
        Object pageContent = this.library.getObject(this.entries, CONTENTS_KEY);
        if (pageContent instanceof Stream) {
            this.contents = new ArrayList<Stream>(1);
            Stream tmpStream = (Stream)pageContent;
            tmpStream.setPObjectReference(this.library.getObjectReference(this.entries, CONTENTS_KEY));
            this.contents.add(tmpStream);
        } else if (pageContent instanceof List) {
            List conts = (List)pageContent;
            int sz = conts.size();
            this.contents = new ArrayList<Stream>(Math.max(sz, 1));
            for (int i = 0; i < sz; ++i) {
                Stream tmpStream;
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("Page Content initialization thread interrupted");
                }
                Object tmp = this.library.getObject(conts.get(i));
                if (!(tmp instanceof Stream) || (tmpStream = (Stream)tmp) == null || tmpStream.getRawBytes().length <= 0) continue;
                tmpStream.setPObjectReference((Reference)conts.get(i));
                this.contents.add(tmpStream);
            }
        }
    }

    public void initPageResources() throws InterruptedException {
        Resources res = this.library.getResources(this.entries, RESOURCES_KEY);
        if (res == null) {
            for (PageTree pageTree = this.getParent(); pageTree != null; pageTree = pageTree.getParent()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("Page Resource initialization thread interrupted");
                }
                Resources parentResources = pageTree.getResources();
                if (parentResources == null) continue;
                res = parentResources;
                break;
            }
        }
        this.resources = res;
    }

    public ArrayList<Reference> getAnnotationReferences() {
        Object annots = this.library.getObject(this.entries, ANNOTS_KEY);
        if (annots != null && annots instanceof ArrayList) {
            return (ArrayList)annots;
        }
        return null;
    }

    private void initPageAnnotations() throws InterruptedException {
        Object annots = this.library.getObject(this.entries, ANNOTS_KEY);
        if (annots != null && annots instanceof List) {
            List v = (List)annots;
            this.annotations = new ArrayList<Annotation>(v.size() + 1);
            Annotation a = null;
            for (int i = 0; i < v.size(); ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("Page Annotation initialization thread interrupted");
                }
                Object annotObj = v.get(i);
                Reference ref = null;
                if (annotObj instanceof Reference) {
                    ref = (Reference)v.get(i);
                    annotObj = this.library.getObject(ref);
                }
                if (annotObj instanceof Annotation) {
                    a = (Annotation)annotObj;
                } else if (annotObj instanceof HashMap) {
                    a = Annotation.buildAnnotation(this.library, (HashMap)annotObj);
                }
                try {
                    if (ref != null && a != null) {
                        a.setPObjectReference(ref);
                        a.init();
                    }
                    this.annotations.add(a);
                    continue;
                }
                catch (IllegalStateException e) {
                    logger.warning("Malformed annotation could not be initialized. " + a != null ? " " + a.getPObjectReference() + a.getEntries() : "");
                }
            }
        }
    }

    @Override
    public void setPObjectReference(Reference reference) {
        super.setPObjectReference(reference);
    }

    public void resetInitializedState() {
        this.inited = false;
    }

    @Override
    public synchronized void init() {
        block11: {
            try {
                if (this.inited) {
                    return;
                }
                this.pageInitialized = false;
                this.inited = true;
                this.initPageResources();
                this.initPageAnnotations();
                this.initPageContents();
                if (this.resources != null) {
                    this.imageCount = this.resources.getImageCount();
                    int contentCount = 0;
                    if (this.contents != null) {
                        contentCount = this.contents.size();
                    }
                    this.notifyPageLoadingStarted(contentCount, this.resources.getImageCount());
                }
                this.notifyPageInitializationStarted();
                if (this.contents != null) {
                    try {
                        ContentParser cp = ContentParserFactory.getInstance().getContentParser(this.library, this.resources);
                        byte[][] streams = new byte[this.contents.size()][];
                        int max = this.contents.size();
                        for (int i = 0; i < max; ++i) {
                            byte[] stream = this.contents.get(i).getDecodedStreamBytes();
                            if (stream == null) continue;
                            streams[i] = stream;
                        }
                        OptionalContent optionalContent = this.library.getCatalog().getOptionalContent();
                        if (optionalContent != null) {
                            optionalContent.init();
                        }
                        if (streams.length > 0) {
                            this.shapes = cp.parse(streams, this).getShapes();
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        this.shapes = new Shapes();
                        logger.log(Level.FINE, "Error initializing Page.", e);
                    }
                    break block11;
                }
                this.shapes = new Shapes();
            }
            catch (InterruptedException e) {
                this.inited = false;
                logger.log(Level.SEVERE, "Page initializing thread interrupted.", e);
            }
        }
        this.notifyPageInitializationEnded(this.inited);
    }

    public Thumbnail getThumbnail() {
        Object thumb = this.library.getObject(this.entries, THUMB_KEY);
        if (thumb != null && thumb instanceof Stream) {
            return new Thumbnail(this.library, this.entries);
        }
        return null;
    }

    public void requestInterrupt() {
        if (this.shapes != null) {
            this.shapes.interruptPaint();
        }
    }

    public void setWatermarkCallback(WatermarkCallback watermarkCallback) {
        this.watermarkCallback = watermarkCallback;
    }

    public void paint(Graphics g, int renderHintType, int boundary, float userRotation, float userZoom) {
        this.paint(g, renderHintType, boundary, userRotation, userZoom, true, true);
    }

    public void paint(Graphics g, int renderHintType, int boundary, float userRotation, float userZoom, boolean paintAnnotations, boolean paintSearchHighlight) {
        if (!this.inited) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        GraphicsRenderingHints grh = GraphicsRenderingHints.getDefault();
        g2.setRenderingHints(grh.getRenderingHints(renderHintType));
        AffineTransform at = this.getPageTransform(boundary, userRotation, userZoom);
        g2.transform(at);
        AffineTransform prePagePaintState = g2.getTransform();
        PRectangle pageBoundary = this.getPageBoundary(boundary);
        float x = 0.0f - pageBoundary.x;
        float y = 0.0f - (pageBoundary.y - pageBoundary.height);
        Color backgroundColor = grh.getPageBackgroundColor(renderHintType);
        if (backgroundColor != null) {
            g2.setColor(backgroundColor);
            g2.fillRect((int)(0.0f - x), (int)(0.0f - y), (int)pageBoundary.width, (int)pageBoundary.height);
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(-x, -y, pageBoundary.width, pageBoundary.height);
        Shape oldClip = g2.getClip();
        if (oldClip == null) {
            g2.setClip(rect);
        } else {
            Area area = new Area(oldClip);
            area.intersect(new Area(rect));
            g2.setClip(area);
        }
        this.paintPageContent(g2, renderHintType, userRotation, userZoom, paintAnnotations, paintSearchHighlight);
        this.notifyPaintPageListeners();
        g2.setTransform(prePagePaintState);
        if (this.watermarkCallback != null) {
            this.watermarkCallback.paintWatermark(g, this, renderHintType, boundary, userRotation, userZoom);
        }
    }

    public void paintPageContent(Graphics g, int renderHintType, float userRotation, float userZoom, boolean paintAnnotations, boolean paintSearchHighlight) {
        if (!this.inited) {
            this.init();
        }
        this.paintPageContent((Graphics2D)g, renderHintType, userRotation, userZoom, paintAnnotations, paintSearchHighlight);
    }

    private void paintPageContent(Graphics2D g2, int renderHintType, float userRotation, float userZoom, boolean paintAnnotations, boolean paintSearchHighlight) {
        PageText pageText;
        if (this.shapes != null) {
            this.pagePainted = false;
            this.notifyPagePaintingStarted(this.shapes.getShapesCount());
            AffineTransform pageTransform = g2.getTransform();
            Shape pageClip = g2.getClip();
            this.shapes.setPageParent(this);
            this.shapes.paint(g2);
            this.shapes.setPageParent(null);
            g2.setTransform(pageTransform);
            g2.setClip(pageClip);
        } else {
            this.notifyPagePaintingStarted(0);
        }
        if (this.annotations != null && paintAnnotations) {
            float totalRotation = this.getTotalRotation(userRotation);
            int num = this.annotations.size();
            for (int i = 0; i < num; ++i) {
                Annotation annotation = this.annotations.get(i);
                annotation.render(g2, renderHintType, totalRotation, userZoom, false);
            }
        }
        if (paintSearchHighlight && (pageText = this.getViewText()) != null) {
            g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
            if (pageText.getPageLines() != null) {
                for (LineText lineText : pageText.getPageLines()) {
                    if (lineText == null) continue;
                    for (WordText wordText : lineText.getWords()) {
                        GeneralPath textPath;
                        if (wordText.isHighlighted()) {
                            textPath = new GeneralPath(wordText.getBounds());
                            g2.setColor(highlightColor);
                            g2.fill(textPath);
                            continue;
                        }
                        for (GlyphText glyph : wordText.getGlyphs()) {
                            if (!glyph.isHighlighted()) continue;
                            textPath = new GeneralPath(glyph.getBounds());
                            g2.setColor(highlightColor);
                            g2.fill(textPath);
                        }
                    }
                }
            }
        }
        this.pagePainted = true;
        if (this.shapes != null) {
            this.notifyPagePaintingEnded(this.shapes.isInterrupted());
        } else {
            this.notifyPagePaintingEnded(false);
        }
        this.notifyPaintPageListeners();
        if (this.imageCount == 0 || this.pageInitialized && this.pagePainted) {
            this.notifyPageLoadingEnded();
        }
    }

    public AffineTransform getPageTransform(int boundary, float userRotation, float userZoom) {
        AffineTransform at = new AffineTransform();
        Rectangle2D.Double boundingBox = this.getBoundingBox(boundary, userRotation, userZoom);
        at.translate(0.0, boundingBox.getHeight());
        at.scale(1.0, -1.0);
        at.scale(userZoom, userZoom);
        float totalRotation = this.getTotalRotation(userRotation);
        PRectangle pageBoundary = this.getPageBoundary(boundary);
        if (totalRotation != 0.0f) {
            double rad;
            if (totalRotation == 90.0f) {
                at.translate(pageBoundary.height, 0.0);
            } else if (totalRotation == 180.0f) {
                at.translate(pageBoundary.width, pageBoundary.height);
            } else if (totalRotation == 270.0f) {
                at.translate(0.0, pageBoundary.width);
            } else if (totalRotation > 0.0f && totalRotation < 90.0f) {
                double xShift = (double)pageBoundary.height * Math.cos(Math.toRadians(90.0f - totalRotation));
                at.translate(xShift, 0.0);
            } else if (totalRotation > 90.0f && totalRotation < 180.0f) {
                rad = Math.toRadians(180.0f - totalRotation);
                double cosRad = Math.cos(rad);
                double sinRad = Math.sin(rad);
                double xShift = (double)pageBoundary.height * sinRad + (double)pageBoundary.width * cosRad;
                double yShift = (double)pageBoundary.height * cosRad;
                at.translate(xShift, yShift);
            } else if (totalRotation > 180.0f && totalRotation < 270.0f) {
                rad = Math.toRadians(totalRotation - 180.0f);
                double cosRad = Math.cos(rad);
                double sinRad = Math.sin(rad);
                double xShift = (double)pageBoundary.width * cosRad;
                double yShift = (double)pageBoundary.width * sinRad + (double)pageBoundary.height * cosRad;
                at.translate(xShift, yShift);
            } else if (totalRotation > 270.0f && totalRotation < 360.0f) {
                double yShift = (double)pageBoundary.width * Math.cos(Math.toRadians(totalRotation - 270.0f));
                at.translate(0.0, yShift);
            }
        }
        at.rotate((double)totalRotation * Math.PI / 180.0);
        float x = 0.0f - pageBoundary.x;
        float y = 0.0f - (pageBoundary.y - pageBoundary.height);
        at.translate(x, y);
        return at;
    }

    public Shape getPageShape(int boundary, float userRotation, float userZoom) {
        AffineTransform at = this.getPageTransform(boundary, userRotation, userZoom);
        PRectangle pageBoundary = this.getPageBoundary(boundary);
        float x = 0.0f - pageBoundary.x;
        float y = 0.0f - (pageBoundary.y - pageBoundary.height);
        Rectangle2D.Double rect = new Rectangle2D.Double(-x, -y, pageBoundary.width, pageBoundary.height);
        GeneralPath path = new GeneralPath(rect);
        return path.createTransformedShape(at);
    }

    public Annotation addAnnotation(Annotation newAnnotation) {
        if (!this.inited) {
            try {
                this.initPageAnnotations();
            }
            catch (InterruptedException e) {
                logger.warning("Annotation Initialization interrupted");
            }
        }
        StateManager stateManager = this.library.getStateManager();
        List annotations = this.library.getArray(this.entries, ANNOTS_KEY);
        boolean isAnnotAReference = this.library.isReference(this.entries, ANNOTS_KEY);
        if (!isAnnotAReference && annotations != null) {
            annotations.add(newAnnotation.getPObjectReference());
            stateManager.addChange(new PObject(this, this.getPObjectReference()));
        } else if (isAnnotAReference && annotations != null) {
            annotations.add(newAnnotation.getPObjectReference());
            stateManager.addChange(new PObject(annotations, this.library.getObjectReference(this.entries, ANNOTS_KEY)));
        } else {
            ArrayList<Reference> annotsVector = new ArrayList<Reference>(4);
            annotsVector.add(newAnnotation.getPObjectReference());
            PObject annotsPObject = new PObject(annotsVector, stateManager.getNewReferencNumber());
            this.entries.put(ANNOTS_KEY, annotsPObject.getReference());
            this.library.addObject(annotsVector, annotsPObject.getReference());
            stateManager.addChange(new PObject(this, this.getPObjectReference()));
            stateManager.addChange(annotsPObject);
            this.annotations = new ArrayList<Annotation>();
        }
        newAnnotation.getEntries().put(Annotation.PARENT_PAGE_KEY, this.getPObjectReference());
        this.annotations.add(newAnnotation);
        this.library.addObject(newAnnotation, newAnnotation.getPObjectReference());
        stateManager.addChange(new PObject(newAnnotation, newAnnotation.getPObjectReference()));
        return newAnnotation;
    }

    public void deleteAnnotation(Annotation annot) {
        if (!this.inited) {
            try {
                this.initPageAnnotations();
            }
            catch (InterruptedException e) {
                logger.warning("Annotation Initialization interupted");
            }
        }
        StateManager stateManager = this.library.getStateManager();
        Object annots = this.getObject(ANNOTS_KEY);
        boolean isAnnotAReference = this.library.isReference(this.entries, ANNOTS_KEY);
        annot.setDeleted(true);
        Stream nAp = annot.getAppearanceStream();
        if (nAp != null) {
            Resources resources;
            Font font;
            nAp.setDeleted(true);
            Object tmp = this.library.getObject(nAp.entries, RESOURCES_KEY);
            if (tmp instanceof Resources && (font = (resources = (Resources)tmp).getFont(FreeTextAnnotation.EMBEDDED_FONT_NAME)) != null) {
                font.setDeleted(true);
            }
        }
        if (!annot.isNew() && !isAnnotAReference) {
            stateManager.addChange(new PObject(this, this.getPObjectReference()));
        } else if (!annot.isNew() && isAnnotAReference) {
            stateManager.addChange(new PObject(annots, this.library.getObjectReference(this.entries, ANNOTS_KEY)));
        } else if (annot.isNew()) {
            stateManager.removeChange(new PObject(annot, annot.getPObjectReference()));
            if (nAp != null) {
                stateManager.removeChange(new PObject(nAp, nAp.getPObjectReference()));
                this.library.removeObject(nAp.getPObjectReference());
            }
        }
        if (annots instanceof List) {
            ((List)annots).remove(annot.getPObjectReference());
        }
        if (this.annotations != null) {
            this.annotations.remove(annot);
        }
        this.library.removeObject(annot.getPObjectReference());
    }

    public boolean updateAnnotation(Annotation annotation) {
        if (annotation == null) {
            return false;
        }
        if (!this.inited) {
            try {
                this.initPageAnnotations();
            }
            catch (InterruptedException e) {
                logger.warning("Annotation Initialization interrupted");
            }
        }
        StateManager stateManager = this.library.getStateManager();
        List annotations = (List)this.library.getObject(this.entries, ANNOTS_KEY);
        boolean found = false;
        for (Object ref : annotations) {
            if (!ref.equals(annotation.getPObjectReference())) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        if (stateManager.contains(annotation.getPObjectReference())) {
            stateManager.addChange(new PObject(annotation, annotation.getPObjectReference()));
            return true;
        }
        annotation.getEntries().put(Annotation.PARENT_PAGE_KEY, this.getPObjectReference());
        this.annotations.add(annotation);
        this.library.addObject(annotation, annotation.getPObjectReference());
        stateManager.addChange(new PObject(annotation, annotation.getPObjectReference()));
        return true;
    }

    protected Reference getParentReference() {
        return (Reference)this.entries.get(PARENT_KEY);
    }

    public PageTree getParent() {
        Object tmp = this.library.getObject(this.entries, PARENT_KEY);
        if (tmp instanceof PageTree) {
            return (PageTree)tmp;
        }
        if (tmp instanceof HashMap) {
            return new PageTree(this.library, (HashMap)tmp);
        }
        return null;
    }

    public PDimension getSize(float userRotation) {
        return this.getSize(2, userRotation, 1.0f);
    }

    public PDimension getSize(float userRotation, float userZoom) {
        return this.getSize(2, userRotation, userZoom);
    }

    public PDimension getSize(int boundary, float userRotation, float userZoom) {
        float totalRotation = this.getTotalRotation(userRotation);
        PRectangle pageBoundary = this.getPageBoundary(boundary);
        float width = pageBoundary.width * userZoom;
        float height = pageBoundary.height * userZoom;
        if (totalRotation != 0.0f && totalRotation != 180.0f) {
            if (totalRotation == 90.0f || totalRotation == 270.0f) {
                float temp = width;
                width = height;
                height = temp;
            } else {
                AffineTransform at = new AffineTransform();
                double radians = Math.toRadians(totalRotation);
                at.rotate(radians);
                Rectangle2D.Double boundingBox = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
                Point2D.Double src = new Point2D.Double();
                Point2D.Double dst = new Point2D.Double();
                src.setLocation(0.0, height);
                at.transform(src, dst);
                boundingBox.add(dst);
                src.setLocation(width, height);
                at.transform(src, dst);
                boundingBox.add(dst);
                src.setLocation(0.0, 0.0);
                at.transform(src, dst);
                boundingBox.add(dst);
                src.setLocation(width, 0.0);
                at.transform(src, dst);
                boundingBox.add(dst);
                width = (float)boundingBox.getWidth();
                height = (float)boundingBox.getHeight();
            }
        }
        return new PDimension(width, height);
    }

    public Rectangle2D.Double getBoundingBox(float userRotation) {
        return this.getBoundingBox(2, userRotation, 1.0f);
    }

    public Rectangle2D.Double getBoundingBox(float userRotation, float userZoom) {
        return this.getBoundingBox(2, userRotation, userZoom);
    }

    public Rectangle2D.Double getBoundingBox(int boundary, float userRotation, float userZoom) {
        float totalRotation = this.getTotalRotation(userRotation);
        PRectangle pageBoundary = this.getPageBoundary(boundary);
        float width = pageBoundary.width * userZoom;
        float height = pageBoundary.height * userZoom;
        AffineTransform at = new AffineTransform();
        double radians = Math.toRadians(totalRotation);
        at.rotate(radians);
        Rectangle2D.Double boundingBox = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        Point2D.Double src = new Point2D.Double();
        Point2D.Double dst = new Point2D.Double();
        src.setLocation(0.0, height);
        at.transform(src, dst);
        boundingBox.add(dst);
        src.setLocation(width, height);
        at.transform(src, dst);
        boundingBox.add(dst);
        src.setLocation(0.0, 0.0);
        at.transform(src, dst);
        boundingBox.add(dst);
        src.setLocation(width, 0.0);
        at.transform(src, dst);
        boundingBox.add(dst);
        return boundingBox;
    }

    public PRectangle getPageBoundary(int specifiedBox) {
        PRectangle userSpecifiedBox = specifiedBox == 1 ? (PRectangle)this.getMediaBox() : (specifiedBox == 2 ? (PRectangle)this.getCropBox() : (specifiedBox == 3 ? (PRectangle)this.getBleedBox() : (specifiedBox == 4 ? (PRectangle)this.getTrimBox() : (specifiedBox == 5 ? (PRectangle)this.getArtBox() : (PRectangle)this.getCropBox()))));
        if (userSpecifiedBox == null) {
            userSpecifiedBox = (PRectangle)this.getMediaBox();
        }
        return userSpecifiedBox;
    }

    @Override
    public String toString() {
        return "PAGE= " + this.entries.toString();
    }

    public float getTotalRotation(float userRotation) {
        float totalRotation = this.getPageRotation() + userRotation;
        if ((totalRotation %= 360.0f) < 0.0f) {
            totalRotation += 360.0f;
        }
        if (totalRotation >= -0.001f && totalRotation <= 0.001f) {
            return 0.0f;
        }
        if (totalRotation >= 89.99f && totalRotation <= 90.001f) {
            return 90.0f;
        }
        if (totalRotation >= 179.99f && totalRotation <= 180.001f) {
            return 180.0f;
        }
        if (totalRotation >= 269.99f && totalRotation <= 270.001f) {
            return 270.0f;
        }
        return totalRotation;
    }

    private float getPageRotation() {
        Object tmpRotation = this.library.getObject(this.entries, ROTATE_KEY);
        if (tmpRotation != null) {
            this.pageRotation = ((Number)tmpRotation).floatValue();
        } else {
            for (PageTree pageTree = this.getParent(); pageTree != null; pageTree = pageTree.getParent()) {
                if (!pageTree.isRotationFactor) continue;
                this.pageRotation = pageTree.rotationFactor;
                break;
            }
        }
        this.pageRotation = 360.0f - this.pageRotation;
        this.pageRotation %= 360.0f;
        return this.pageRotation;
    }

    public List<Annotation> getAnnotations() {
        if (!this.inited) {
            try {
                this.initPageAnnotations();
            }
            catch (InterruptedException e) {
                logger.finer("Interrupt exception getting annotations. ");
            }
        }
        return this.annotations;
    }

    public String[] getDecodedContentSteam() {
        try {
            this.initPageContents();
            if (this.contents == null) {
                return null;
            }
            String[] decodedContentStream = new String[this.contents.size()];
            int i = 0;
            for (Stream stream : this.contents) {
                String content;
                ByteArrayInputStream input = stream.getDecodedByteArrayInputStream();
                if (input instanceof SeekableInput) {
                    content = Utils.getContentFromSeekableInput((SeekableInput)((Object)input), false);
                } else {
                    InputStream[] inArray = new InputStream[]{input};
                    content = Utils.getContentAndReplaceInputStream(inArray, false);
                }
                decodedContentStream[i] = content;
                ((InputStream)input).close();
                ++i;
            }
            return decodedContentStream;
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "Error initializing page Contents.", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error closing content stream");
        }
        return null;
    }

    public Rectangle2D.Float getMediaBox() {
        if (this.mediaBox != null) {
            return this.mediaBox;
        }
        List boxDimensions = (List)this.library.getObject(this.entries, MEDIABOX_KEY);
        if (boxDimensions != null) {
            this.mediaBox = new PRectangle(boxDimensions);
        }
        if (this.mediaBox == null) {
            PageTree pageTree = this.getParent();
            while (pageTree != null && this.mediaBox == null) {
                this.mediaBox = pageTree.getMediaBox();
                if (this.mediaBox != null) continue;
                pageTree = pageTree.getParent();
            }
        }
        if (this.mediaBox == null) {
            this.mediaBox = new PRectangle(new Point2D.Float(0.0f, 0.0f), new Point2D.Float(612.0f, 792.0f));
        }
        return this.mediaBox;
    }

    public Rectangle2D.Float getCropBox() {
        if (this.cropBox != null) {
            return this.cropBox;
        }
        List boxDimensions = (List)this.library.getObject(this.entries, CROPBOX_KEY);
        if (boxDimensions != null) {
            this.cropBox = new PRectangle(boxDimensions);
        }
        boolean isParentCropBox = false;
        if (this.cropBox == null) {
            for (PageTree pageTree = this.getParent(); pageTree != null && this.cropBox == null && pageTree.getCropBox() != null; pageTree = pageTree.getParent()) {
                this.cropBox = pageTree.getCropBox();
                if (this.cropBox == null) continue;
                isParentCropBox = true;
            }
        }
        PRectangle mediaBox = (PRectangle)this.getMediaBox();
        if ((this.cropBox == null || isParentCropBox) && mediaBox != null) {
            this.cropBox = (PRectangle)mediaBox.clone();
        } else if (this.cropBox != null && mediaBox != null) {
            this.cropBox = mediaBox.createCartesianIntersection(this.cropBox);
        }
        return this.cropBox;
    }

    public Rectangle2D.Float getArtBox() {
        if (this.artBox != null) {
            return this.artBox;
        }
        List boxDimensions = (List)this.library.getObject(this.entries, ARTBOX_KEY);
        if (boxDimensions != null) {
            this.artBox = new PRectangle(boxDimensions);
        }
        if (this.artBox == null) {
            this.artBox = (PRectangle)this.getCropBox();
        }
        return this.artBox;
    }

    public Rectangle2D.Float getBleedBox() {
        if (this.bleedBox != null) {
            return this.bleedBox;
        }
        List boxDimensions = (List)this.library.getObject(this.entries, BLEEDBOX_KEY);
        if (boxDimensions != null) {
            this.bleedBox = new PRectangle(boxDimensions);
        }
        if (this.bleedBox == null) {
            this.bleedBox = (PRectangle)this.getCropBox();
        }
        return this.bleedBox;
    }

    public Rectangle2D.Float getTrimBox() {
        if (this.trimBox != null) {
            return this.trimBox;
        }
        List boxDimensions = (List)this.library.getObject(this.entries, TRIMBOX_KEY);
        if (boxDimensions != null) {
            this.trimBox = new PRectangle(boxDimensions);
        }
        if (this.trimBox == null) {
            this.trimBox = (PRectangle)this.getCropBox();
        }
        return this.trimBox;
    }

    public PageText getViewText() {
        if (!this.inited) {
            this.init();
        }
        if (this.shapes != null) {
            return this.shapes.getPageText();
        }
        return null;
    }

    public Shapes getShapes() {
        return this.shapes;
    }

    public synchronized PageText getText() throws InterruptedException {
        if (this.inited && this.shapes != null && this.shapes.getPageText() != null) {
            return this.shapes.getPageText();
        }
        Shapes textBlockShapes = new Shapes();
        if (this.contents == null) {
            this.initPageContents();
        }
        if (this.resources == null) {
            this.initPageResources();
        }
        if (this.contents != null) {
            try {
                ContentParser cp = ContentParserFactory.getInstance().getContentParser(this.library, this.resources);
                byte[][] streams = new byte[this.contents.size()][];
                int max = this.contents.size();
                for (int i = 0; i < max; ++i) {
                    streams[i] = this.contents.get(i).getDecodedStreamBytes();
                }
                textBlockShapes = cp.parseTextBlocks(streams);
                if (logger.isLoggable(Level.FINER)) {
                    Stack<Object> stack = cp.getStack();
                    while (!stack.isEmpty()) {
                        String tmp = stack.pop().toString();
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.fine("STACK=" + tmp);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Error getting page text.", e);
            }
        }
        if (textBlockShapes.getPageText() != null) {
            return textBlockShapes.getPageText();
        }
        return null;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getImageCount() {
        return this.imageCount;
    }

    public boolean isPageInitialized() {
        return this.pageInitialized;
    }

    public boolean isPagePainted() {
        return this.pagePainted;
    }

    protected void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public synchronized List<Image> getImages() {
        if (!this.inited) {
            this.init();
        }
        return this.shapes.getImages();
    }

    public Resources getResources() {
        return this.resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPaintPageListener(PaintPageListener listener) {
        List<PaintPageListener> list = this.paintPageListeners;
        synchronized (list) {
            if (!this.paintPageListeners.contains(listener)) {
                this.paintPageListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePaintPageListener(PaintPageListener listener) {
        List<PaintPageListener> list = this.paintPageListeners;
        synchronized (list) {
            if (this.paintPageListeners.contains(listener)) {
                this.paintPageListeners.remove(listener);
            }
        }
    }

    public List<PageLoadingListener> getPageLoadingListeners() {
        return this.pageLoadingListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPageProcessingListener(PageLoadingListener listener) {
        List<PageLoadingListener> list = this.pageLoadingListeners;
        synchronized (list) {
            if (!this.pageLoadingListeners.contains(listener)) {
                this.pageLoadingListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePageProcessingListener(PageLoadingListener listener) {
        List<PageLoadingListener> list = this.pageLoadingListeners;
        synchronized (list) {
            if (this.pageLoadingListeners.contains(listener)) {
                this.pageLoadingListeners.remove(listener);
            }
        }
    }

    private void notifyPageLoadingStarted(int contentCount, int imageCount) {
        PageLoadingEvent pageLoadingEvent = new PageLoadingEvent(this, contentCount, imageCount);
        for (int i = this.pageLoadingListeners.size() - 1; i >= 0; --i) {
            PageLoadingListener client = this.pageLoadingListeners.get(i);
            client.pageLoadingStarted(pageLoadingEvent);
        }
    }

    private void notifyPageInitializationStarted() {
        PageInitializingEvent pageLoadingEvent = new PageInitializingEvent(this, false);
        for (int i = this.pageLoadingListeners.size() - 1; i >= 0; --i) {
            PageLoadingListener client = this.pageLoadingListeners.get(i);
            client.pageInitializationStarted(pageLoadingEvent);
        }
    }

    private void notifyPagePaintingStarted(int shapesCount) {
        PagePaintingEvent pageLoadingEvent = new PagePaintingEvent(this, shapesCount);
        for (int i = this.pageLoadingListeners.size() - 1; i >= 0; --i) {
            PageLoadingListener client = this.pageLoadingListeners.get(i);
            client.pagePaintingStarted(pageLoadingEvent);
        }
    }

    private void notifyPagePaintingEnded(boolean interrupted) {
        this.pagePainted = true;
        PagePaintingEvent pageLoadingEvent = new PagePaintingEvent(this, interrupted);
        for (int i = this.pageLoadingListeners.size() - 1; i >= 0; --i) {
            PageLoadingListener client = this.pageLoadingListeners.get(i);
            client.pagePaintingEnded(pageLoadingEvent);
        }
    }

    private void notifyPageInitializationEnded(boolean interrupted) {
        this.pageInitialized = true;
        PageInitializingEvent pageLoadingEvent = new PageInitializingEvent(this, interrupted);
        for (int i = this.pageLoadingListeners.size() - 1; i >= 0; --i) {
            PageLoadingListener client = this.pageLoadingListeners.get(i);
            client.pageInitializationEnded(pageLoadingEvent);
        }
    }

    protected void notifyPageLoadingEnded() {
        PageLoadingEvent pageLoadingEvent = new PageLoadingEvent(this, this.inited);
        for (int i = this.pageLoadingListeners.size() - 1; i >= 0; --i) {
            PageLoadingListener client = this.pageLoadingListeners.get(i);
            client.pageLoadingEnded(pageLoadingEvent);
        }
    }

    public void notifyPaintPageListeners() {
        PaintPageEvent evt = new PaintPageEvent(this);
        for (int i = this.paintPageListeners.size() - 1; i >= 0; --i) {
            PaintPageListener client = this.paintPageListeners.get(i);
            client.paintPage(evt);
        }
    }

    static {
        block5: {
            int colorValue;
            String color;
            block4: {
                logger = Logger.getLogger(Page.class.toString());
                try {
                    color = Defs.sysProperty("org.icepdf.core.views.page.text.selectionColor", "#0077FF");
                    colorValue = ColorUtil.convertColor(color);
                    selectionColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("99c1da", 16));
                }
                catch (NumberFormatException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.warning("Error reading text selection colour");
                }
            }
            try {
                color = Defs.sysProperty("org.icepdf.core.views.page.text.highlightColor", "#CC00FF");
                colorValue = ColorUtil.convertColor(color);
                highlightColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("ff99ff", 16));
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.warning("Error reading text highlight colour");
            }
        }
        TYPE = new Name("Page");
        ANNOTS_KEY = new Name("Annots");
        CONTENTS_KEY = new Name("Contents");
        RESOURCES_KEY = new Name("Resources");
        THUMB_KEY = new Name("Thumb");
        PARENT_KEY = new Name("Parent");
        ROTATE_KEY = new Name("Rotate");
        MEDIABOX_KEY = new Name("MediaBox");
        CROPBOX_KEY = new Name("CropBox");
        ARTBOX_KEY = new Name("ArtBox");
        BLEEDBOX_KEY = new Name("BleedBox");
        TRIMBOX_KEY = new Name("TrimBox");
    }
}

