/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.OptionalContents;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.fonts.Font;
import org.icepdf.core.pobjects.fonts.FontFactory;
import org.icepdf.core.pobjects.graphics.ExtGState;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.Pattern;
import org.icepdf.core.pobjects.graphics.ShadingPattern;
import org.icepdf.core.pobjects.graphics.TilingPattern;
import org.icepdf.core.util.Library;

public class Resources
extends Dictionary {
    public static final Name COLORSPACE_KEY = new Name("ColorSpace");
    public static final Name FONT_KEY = new Name("Font");
    public static final Name XOBJECT_KEY = new Name("XObject");
    public static final Name PATTERN_KEY = new Name("Pattern");
    public static final Name SHADING_KEY = new Name("Shading");
    public static final Name EXTGSTATE_KEY = new Name("ExtGState");
    public static final Name PROPERTIES_KEY = new Name("Properties");
    private static int uniqueCounter = 0;
    private static final Logger logger = Logger.getLogger(Resources.class.toString());
    HashMap fonts;
    HashMap xobjects;
    HashMap colorspaces;
    HashMap patterns;
    HashMap shading;
    HashMap extGStates;
    HashMap properties;

    private static synchronized int getUniqueId() {
        return uniqueCounter++;
    }

    public Resources(Library l, HashMap h) {
        super(l, h);
        this.colorspaces = this.library.getDictionary(this.entries, COLORSPACE_KEY);
        this.fonts = this.library.getDictionary(this.entries, FONT_KEY);
        this.xobjects = this.library.getDictionary(this.entries, XOBJECT_KEY);
        this.patterns = this.library.getDictionary(this.entries, PATTERN_KEY);
        this.shading = this.library.getDictionary(this.entries, SHADING_KEY);
        this.extGStates = this.library.getDictionary(this.entries, EXTGSTATE_KEY);
        this.properties = this.library.getDictionary(this.entries, PROPERTIES_KEY);
    }

    public HashMap getFonts() {
        return this.fonts;
    }

    public PColorSpace getColorSpace(Object o) {
        if (o == null) {
            return null;
        }
        if (this.colorspaces != null && this.colorspaces.get(o) != null) {
            Object tmp = this.colorspaces.get(o);
            PColorSpace cs = PColorSpace.getColorSpace(this.library, tmp);
            if (cs != null) {
                cs.init();
            }
            return cs;
        }
        if (this.patterns != null && this.patterns.get(o) != null) {
            Object tmp = this.patterns.get(o);
            PColorSpace cs = PColorSpace.getColorSpace(this.library, tmp);
            if (cs != null) {
                cs.init();
            }
            return cs;
        }
        PColorSpace cs = PColorSpace.getColorSpace(this.library, o);
        if (cs != null) {
            cs.init();
        }
        return cs;
    }

    public Font getFont(Name s) {
        Font font = null;
        if (this.fonts != null) {
            Object ob = this.fonts.get(s);
            if (ob instanceof Font) {
                font = (Font)ob;
            } else if (ob instanceof HashMap) {
                font = FontFactory.getInstance().getFont(this.library, (HashMap)ob);
            } else if (ob instanceof Reference) {
                Reference ref = (Reference)ob;
                if ((ob = this.library.getObject((Reference)ob)) instanceof PObject) {
                    ob = ((PObject)ob).getObject();
                }
                if ((font = ob instanceof Font ? (Font)ob : FontFactory.getInstance().getFont(this.library, (HashMap)ob)) != null) {
                    this.library.addObject(font, ref);
                    font.setPObjectReference(ref);
                }
            }
            if (font == null) {
                for (Object tmp : this.fonts.values()) {
                    if (!(tmp instanceof Reference)) continue;
                    ob = this.library.getObject((Reference)tmp);
                    if (ob instanceof PObject) {
                        ob = ((PObject)ob).getObject();
                    }
                    if (!(ob instanceof Font)) continue;
                    font = (Font)ob;
                    String baseFont = font.getBaseFont();
                    if (s.getName().equals(baseFont) || baseFont.contains(s.getName())) {
                        this.library.addObject(font, (Reference)tmp);
                        font.setPObjectReference((Reference)tmp);
                        break;
                    }
                    font = null;
                }
            }
        }
        if (font != null) {
            try {
                font.setParentResource(this);
                font.init();
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "Error initializing font, falling back to font substitution.");
                }
                logger.log(Level.FINER, "Error initializing font, falling back to font substitution. " + font);
            }
        }
        return font;
    }

    public Image getImage(Name s, GraphicsState graphicsState) {
        ImageStream st = (ImageStream)this.library.getObject(this.xobjects, s);
        if (st == null) {
            return null;
        }
        if (!st.isImageSubtype()) {
            return null;
        }
        BufferedImage image = null;
        try {
            image = st.getImage(graphicsState, this);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error getting image by name: " + s, e);
        }
        return image;
    }

    public ImageStream getImageStream(Name s) {
        Object st = this.library.getObject(this.xobjects, s);
        if (st instanceof ImageStream) {
            return (ImageStream)st;
        }
        return null;
    }

    public Object getXObject(Name s) {
        return this.library.getObject(this.xobjects, s);
    }

    public int getImageCount() {
        int count = 0;
        if (this.xobjects != null) {
            for (Object tmp : this.xobjects.values()) {
                if (!(tmp instanceof Reference) || !((tmp = this.library.getObject((Reference)tmp)) instanceof ImageStream)) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean isForm(Name s) {
        Object o = this.library.getObject(this.xobjects, s);
        return o instanceof Form;
    }

    public Form getForm(Name nameReference) {
        Form formXObject = null;
        Object tempForm = this.library.getObject(this.xobjects, nameReference);
        if (tempForm instanceof Form) {
            formXObject = (Form)tempForm;
        }
        return formXObject;
    }

    public Pattern getPattern(Name name) {
        if (this.patterns != null) {
            Object attribute = this.library.getObject(this.patterns, name);
            if (attribute != null && attribute instanceof TilingPattern) {
                return (TilingPattern)attribute;
            }
            if (attribute != null && attribute instanceof Stream) {
                return new TilingPattern((Stream)attribute);
            }
            if (attribute != null && attribute instanceof HashMap) {
                return ShadingPattern.getShadingPattern(this.library, (HashMap)attribute);
            }
        }
        return null;
    }

    public ShadingPattern getShading(Name name) {
        Object shadingDictionary;
        if (this.shading != null && (shadingDictionary = this.library.getObject(this.shading, name)) != null && shadingDictionary instanceof HashMap) {
            return ShadingPattern.getShadingPattern(this.library, this.entries, (HashMap)shadingDictionary);
        }
        return null;
    }

    public ExtGState getExtGState(Name namedReference) {
        ExtGState gsState = null;
        if (this.extGStates != null) {
            Object attribute = this.library.getObject(this.extGStates, namedReference);
            if (attribute instanceof HashMap) {
                gsState = new ExtGState(this.library, (HashMap)attribute);
            } else if (attribute instanceof Reference) {
                gsState = new ExtGState(this.library, (HashMap)this.library.getObject((Reference)attribute));
            }
        }
        return gsState;
    }

    public OptionalContents getPropertyEntry(Name key) {
        Object object;
        if (this.properties != null && (object = this.library.getObject(this.properties.get(key))) instanceof OptionalContents) {
            return (OptionalContents)this.library.getObject(this.properties.get(key));
        }
        return null;
    }

    public boolean isShading() {
        return this.shading != null;
    }
}

