/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.acroform.FieldDictionaryFactory;
import org.icepdf.core.pobjects.acroform.signature.exceptions.SignatureIntegrityException;
import org.icepdf.core.pobjects.annotations.SignatureWidgetAnnotation;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractiveForm
extends Dictionary {
    public static final Name FIELDS_KEY = new Name("Fields");
    public static final Name NEEDS_APPEARANCES_KEY = new Name("NeedAppearances");
    public static final Name SIG_FLAGS_KEY = new Name("SigFlags");
    public static final Name CO_KEY = new Name("CO");
    public static final Name DR_KEY = new Name("DR");
    public static final Name DA_KEY = new Name("DA");
    public static final Name Q_KEY = new Name("Q");
    public static final int SIG_FLAGS_SIGNATURES_EXIST = 1;
    public static final int SIG_FLAGS_APPEND_ONLY = 2;
    private static final Logger logger = Logger.getLogger(InteractiveForm.class.toString());
    private ArrayList<Object> fields;
    private boolean needAppearances;
    private int sigFlags;
    private List<Reference> calculationOrder;
    private Resources resources;
    private String defaultVariableTextDAField;
    private int defaultVariableTextQField;

    public InteractiveForm(Library library, HashMap entries) {
        super(library, entries);
    }

    @Override
    public void init() {
        Object tmp = this.library.getObject(this.entries, NEEDS_APPEARANCES_KEY);
        if (tmp instanceof HashMap) {
            this.needAppearances = this.library.getBoolean(this.entries, NEEDS_APPEARANCES_KEY);
        }
        if ((tmp = this.library.getObject(this.entries, SIG_FLAGS_KEY)) instanceof HashMap) {
            this.sigFlags = this.library.getInt(this.entries, SIG_FLAGS_KEY);
        }
        if ((tmp = this.library.getObject(this.entries, DR_KEY)) instanceof HashMap) {
            this.resources = this.library.getResources(this.entries, DR_KEY);
        }
        if ((tmp = this.library.getObject(this.entries, SIG_FLAGS_KEY)) instanceof HashMap) {
            this.resources = this.library.getResources(this.entries, DR_KEY);
        }
        if ((tmp = this.library.getObject(this.entries, CO_KEY)) instanceof List) {
            this.calculationOrder = this.library.getArray(this.entries, CO_KEY);
        }
        if ((tmp = this.library.getObject(this.entries, Q_KEY)) instanceof List) {
            this.defaultVariableTextQField = this.library.getInt(this.entries, Q_KEY);
        }
        if ((tmp = this.library.getObject(this.entries, DA_KEY)) instanceof StringObject) {
            this.defaultVariableTextDAField = Utils.convertStringObject(this.library, (StringObject)tmp);
        }
        if ((tmp = this.library.getObject(this.entries, FIELDS_KEY)) instanceof List) {
            List tmpFields = (List)tmp;
            this.fields = new ArrayList(tmpFields.size());
            for (Object fieldRef : tmpFields) {
                if (!(fieldRef instanceof Reference)) continue;
                Object annotObj = this.library.getObject((Reference)fieldRef);
                if (annotObj instanceof HashMap) {
                    annotObj = FieldDictionaryFactory.buildField(this.library, (HashMap)annotObj);
                }
                if (annotObj == null) continue;
                this.fields.add(annotObj);
            }
        }
    }

    public ArrayList<Object> getFields() {
        return this.fields;
    }

    public ArrayList<SignatureWidgetAnnotation> getSignatureFields() {
        ArrayList<SignatureWidgetAnnotation> signatures = new ArrayList<SignatureWidgetAnnotation>();
        if (this.fields != null) {
            for (Object field : this.fields) {
                if (!(field instanceof SignatureWidgetAnnotation)) continue;
                signatures.add((SignatureWidgetAnnotation)field);
            }
        }
        return signatures;
    }

    public boolean isSignaturesCoverDocumentLength() {
        try {
            if (this.fields != null) {
                SignatureWidgetAnnotation signatureWidgetAnnotation;
                boolean isValidByteRange = false;
                for (Object field : this.fields) {
                    if (!(field instanceof SignatureWidgetAnnotation) || (signatureWidgetAnnotation = (SignatureWidgetAnnotation)field).getSignatureValidator() == null || !signatureWidgetAnnotation.getSignatureValidator().checkByteRange()) continue;
                    isValidByteRange = true;
                    break;
                }
                if (isValidByteRange) {
                    for (Object field : this.fields) {
                        if (!(field instanceof SignatureWidgetAnnotation)) continue;
                        signatureWidgetAnnotation = (SignatureWidgetAnnotation)field;
                        signatureWidgetAnnotation.getSignatureValidator().setSignaturesCoverDocumentLength(true);
                    }
                }
            }
        }
        catch (SignatureIntegrityException e) {
            logger.warning("Signature validation error has occurred");
        }
        return false;
    }

    public boolean isSignatureFields() {
        boolean foundSignature = false;
        ArrayList<Object> fields = this.getFields();
        if (fields != null) {
            for (Object field : fields) {
                if (!(field instanceof SignatureWidgetAnnotation)) continue;
                foundSignature = true;
                break;
            }
        }
        return foundSignature;
    }

    public boolean signatureExists() {
        return (this.sigFlags & 1) == 1;
    }

    public boolean signatureAppendOnly() {
        return (this.sigFlags & 2) == 2;
    }

    public boolean needAppearances() {
        return this.needAppearances;
    }

    public List<Reference> getCalculationOrder() {
        return this.calculationOrder;
    }

    public Resources getResources() {
        return this.resources;
    }

    public String getDefaultVariableTextDAField() {
        return this.defaultVariableTextDAField;
    }

    public int getDefaultVariableTextQField() {
        return this.defaultVariableTextQField;
    }
}

