/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.ExtGState;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.TextState;
import org.icepdf.core.pobjects.graphics.commands.ClipDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ColorDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.NoClipDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ShapeDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.StrokeDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.TransformDrawCmd;
import org.icepdf.core.util.Defs;

public class GraphicsState {
    private static final Logger logger = Logger.getLogger(GraphicsState.class.toString());
    public static final Name CA_STROKING_KEY = new Name("CA");
    public static final Name CA_NON_STROKING_KEY = new Name("ca");
    private static boolean enabledOverpaint = Defs.sysPropertyBoolean("org.icepdf.core.overpaint", true);
    private AffineTransform CTM;
    private static ClipDrawCmd clipDrawCmd = new ClipDrawCmd();
    private static NoClipDrawCmd noClipDrawCmd = new NoClipDrawCmd();
    private int lineCap;
    private float lineWidth;
    private int lineJoin;
    private float miterLimit;
    private float[] dashArray;
    private float dashPhase;
    private Color fillColor;
    private Color strokeColor;
    private float strokeAlpha;
    private float fillAlpha;
    private ExtGState extGState;
    private int alphaRule;
    private boolean transparencyGroup;
    private boolean isolated;
    private boolean knockOut;
    private PColorSpace fillColorSpace;
    private PColorSpace strokeColorSpace;
    private TextState textState;
    private GraphicsState parentGraphicState;
    private Shapes shapes;
    private Area clip;
    private boolean clipChange;
    private int overprintMode;
    private boolean overprintStroking;
    private boolean overprintOther;

    public GraphicsState(Shapes shapes) {
        this.shapes = shapes;
        this.CTM = new AffineTransform();
        this.lineCap = 0;
        this.lineWidth = 1.0f;
        this.lineJoin = 0;
        this.miterLimit = 10.0f;
        this.fillColor = Color.black;
        this.strokeColor = Color.black;
        this.strokeAlpha = 1.0f;
        this.fillAlpha = 1.0f;
        this.alphaRule = 3;
        this.fillColorSpace = new DeviceGray(null, null);
        this.strokeColorSpace = new DeviceGray(null, null);
        this.textState = new TextState();
    }

    public GraphicsState(GraphicsState parentGraphicsState) {
        this.CTM = new AffineTransform(parentGraphicsState.CTM);
        this.lineCap = parentGraphicsState.lineCap;
        this.lineWidth = parentGraphicsState.lineWidth;
        this.miterLimit = parentGraphicsState.miterLimit;
        this.lineJoin = parentGraphicsState.lineJoin;
        this.fillColor = new Color(parentGraphicsState.fillColor.getRGB(), true);
        this.strokeColor = new Color(parentGraphicsState.strokeColor.getRGB(), true);
        this.shapes = parentGraphicsState.shapes;
        if (parentGraphicsState.clip != null) {
            this.clip = (Area)parentGraphicsState.clip.clone();
        }
        this.fillColorSpace = parentGraphicsState.fillColorSpace;
        this.strokeColorSpace = parentGraphicsState.strokeColorSpace;
        this.textState = new TextState(parentGraphicsState.textState);
        this.dashPhase = parentGraphicsState.dashPhase;
        this.dashArray = parentGraphicsState.dashArray;
        this.overprintMode = parentGraphicsState.overprintMode;
        this.overprintOther = parentGraphicsState.overprintOther;
        this.overprintStroking = parentGraphicsState.overprintStroking;
        this.fillAlpha = parentGraphicsState.fillAlpha;
        this.strokeAlpha = parentGraphicsState.strokeAlpha;
        this.alphaRule = parentGraphicsState.alphaRule;
        if (parentGraphicsState.getExtGState() != null) {
            this.extGState = new ExtGState(parentGraphicsState.getExtGState().getLibrary(), parentGraphicsState.getExtGState().getEntries());
        }
        this.parentGraphicState = parentGraphicsState.parentGraphicState;
    }

    public void setShapes(Shapes shapes) {
        this.shapes = shapes;
    }

    public void translate(double x, double y) {
        this.CTM.translate(x, y);
        this.shapes.add(new TransformDrawCmd(new AffineTransform(this.CTM)));
    }

    public void scale(double x, double y) {
        this.CTM.scale(x, y);
        this.shapes.add(new TransformDrawCmd(new AffineTransform(this.CTM)));
    }

    public void set(AffineTransform af) {
        if (!this.CTM.equals(af)) {
            this.CTM = new AffineTransform(af);
        }
        this.shapes.add(new TransformDrawCmd(new AffineTransform(this.CTM)));
    }

    public GraphicsState save() {
        GraphicsState gs = new GraphicsState(this);
        gs.parentGraphicState = this;
        return gs;
    }

    public void concatenate(ExtGState extGState) {
        this.extGState = new ExtGState(extGState.getLibrary(), extGState.getEntries());
        if (extGState.getLineWidth() != null) {
            this.setLineWidth(extGState.getLineWidth().floatValue());
        }
        if (extGState.getLineCapStyle() != null) {
            this.setLineCap(extGState.getLineCapStyle().intValue());
        }
        if (extGState.getLineJoinStyle() != null) {
            this.setLineJoin(extGState.getLineJoinStyle().intValue());
        }
        if (extGState.getMiterLimit() != null) {
            this.setMiterLimit(extGState.getMiterLimit().floatValue());
        }
        if (extGState.getLineDashPattern() != null) {
            List dasshPattern = extGState.getLineDashPattern();
            try {
                this.setDashArray((float[])dasshPattern.get(0));
                this.setDashPhase(((Number)dasshPattern.get(1)).floatValue());
            }
            catch (ClassCastException e) {
                logger.log(Level.FINE, "Dash cast error: ", e);
            }
        }
        if (extGState.getNonStrokingAlphConstant() != -1.0f) {
            this.setFillAlpha(extGState.getNonStrokingAlphConstant());
        }
        if (extGState.getStrokingAlphConstant() != -1.0f) {
            this.setStrokeAlpha(extGState.getStrokingAlphConstant());
        }
        this.setOverprintMode(extGState.getOverprintMode());
        this.processOverPaint(extGState.getOverprint(), extGState.getOverprintFill());
    }

    private void processOverPaint(Boolean OP, Boolean op) {
        if (enabledOverpaint && OP != null && op == null && this.overprintMode == 1) {
            this.overprintOther = this.overprintStroking = OP.booleanValue();
        }
    }

    public GraphicsState restore() {
        if (this.parentGraphicState != null) {
            this.parentGraphicState.set(this.parentGraphicState.CTM);
            if (this.clipChange) {
                if (this.parentGraphicState.clip != null) {
                    if (!this.parentGraphicState.clip.equals(this.clip)) {
                        this.parentGraphicState.shapes.add(new ShapeDrawCmd(new Area(this.parentGraphicState.clip)));
                        this.parentGraphicState.shapes.add(clipDrawCmd);
                    }
                } else {
                    this.parentGraphicState.shapes.add(noClipDrawCmd);
                }
            }
            this.parentGraphicState.shapes.add(new StrokeDrawCmd(new BasicStroke(this.parentGraphicState.lineWidth, this.parentGraphicState.lineCap, this.parentGraphicState.lineJoin, this.parentGraphicState.miterLimit, this.parentGraphicState.dashArray, this.parentGraphicState.dashPhase)));
            this.parentGraphicState.shapes.add(new ColorDrawCmd(this.parentGraphicState.getFillColor()));
        }
        return this.parentGraphicState;
    }

    public void updateClipCM(AffineTransform af) {
        if (this.clip != null) {
            AffineTransform afInverse = new AffineTransform();
            try {
                afInverse = af.createInverse();
            }
            catch (Exception e) {
                logger.log(Level.FINER, "Error generating clip inverse.", e);
            }
            this.clip.transform(afInverse);
        }
    }

    public void setClip(Shape newClip) {
        if (newClip != null) {
            Area area = new Area(newClip);
            if (this.clip != null) {
                area.intersect(this.clip);
            }
            if (this.clip == null || !this.clip.equals(area)) {
                this.clip = new Area(area);
                this.shapes.add(new ShapeDrawCmd(area));
                this.shapes.add(clipDrawCmd);
                this.clipChange = true;
                if (this.parentGraphicState != null) {
                    this.parentGraphicState.clipChange = true;
                }
            } else {
                this.clip = new Area(area);
            }
        } else {
            this.clip = null;
            this.shapes.add(noClipDrawCmd);
            this.clipChange = true;
            if (this.parentGraphicState != null) {
                this.parentGraphicState.clipChange = true;
            }
        }
    }

    public Area getClip() {
        return this.clip;
    }

    public AffineTransform getCTM() {
        return this.CTM;
    }

    public void setCTM(AffineTransform ctm) {
        this.CTM = ctm;
    }

    public int getLineCap() {
        return this.lineCap;
    }

    public void setLineCap(int lineCap) {
        this.lineCap = lineCap;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth <= Float.MIN_VALUE || lineWidth >= Float.MAX_VALUE || lineWidth == 0.0f ? 0.001f : lineWidth;
    }

    public int getLineJoin() {
        return this.lineJoin;
    }

    public void setLineJoin(int lineJoin) {
        this.lineJoin = lineJoin;
    }

    public float[] getDashArray() {
        return this.dashArray;
    }

    public void setDashArray(float[] dashArray) {
        this.dashArray = dashArray;
    }

    public float getDashPhase() {
        return this.dashPhase;
    }

    public void setDashPhase(float dashPhase) {
        this.dashPhase = dashPhase;
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public void setMiterLimit(float miterLimit) {
        this.miterLimit = miterLimit;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeAlpha(float alpha) {
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        this.strokeAlpha = alpha;
    }

    public float getStrokeAlpha() {
        return this.strokeAlpha;
    }

    public void setFillAlpha(float alpha) {
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        this.fillAlpha = alpha;
    }

    public float getFillAlpha() {
        return this.fillAlpha;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public PColorSpace getFillColorSpace() {
        return this.fillColorSpace;
    }

    public void setFillColorSpace(PColorSpace fillColorSpace) {
        this.fillColorSpace = fillColorSpace;
    }

    public PColorSpace getStrokeColorSpace() {
        return this.strokeColorSpace;
    }

    public void setStrokeColorSpace(PColorSpace strokeColorSpace) {
        this.strokeColorSpace = strokeColorSpace;
    }

    public TextState getTextState() {
        return this.textState;
    }

    public void setTextState(TextState textState) {
        this.textState = textState;
    }

    public int getOverprintMode() {
        return this.overprintMode;
    }

    public boolean isOverprintStroking() {
        return this.overprintStroking;
    }

    public boolean isOverprintOther() {
        return this.overprintOther;
    }

    public void setOverprintMode(int overprintMode) {
        this.overprintMode = overprintMode;
    }

    public void setOverprintStroking(boolean overprintStroking) {
        this.overprintStroking = overprintStroking;
    }

    public void setOverprintOther(boolean overprintOther) {
        this.overprintOther = overprintOther;
    }

    public int getAlphaRule() {
        return this.alphaRule;
    }

    public void setAlphaRule(int alphaRule) {
        this.alphaRule = alphaRule;
    }

    public boolean isTransparencyGroup() {
        return this.transparencyGroup;
    }

    public void setTransparencyGroup(boolean transparencyGroup) {
        this.transparencyGroup = transparencyGroup;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    public boolean isKnockOut() {
        return this.knockOut;
    }

    public void setKnockOut(boolean knockOut) {
        this.knockOut = knockOut;
    }

    public ExtGState getExtGState() {
        return this.extGState;
    }
}

