/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.security.EncryptionDictionary;
import org.icepdf.core.util.Utils;

class StandardEncryption {
    private static final Logger logger = Logger.getLogger(StandardEncryption.class.toString());
    public static final String ENCRYPTION_TYPE_NONE = "None";
    public static final String ENCRYPTION_TYPE_V2 = "V2";
    public static final String ENCRYPTION_TYPE_V3 = "V3";
    public static final String ENCRYPTION_TYPE_AES_V2 = "AESV2";
    private static final byte[] PADDING = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    private static final byte[] AES_sAIT = new byte[]{115, 65, 108, 84};
    private static final int BLOCK_SIZE = 16;
    private EncryptionDictionary encryptionDictionary;
    private byte[] encryptionKey;
    private Reference objectReference;
    private byte[] rc4Key = null;
    private String userPassword = "";
    private String ownerPassword = "";

    public StandardEncryption(EncryptionDictionary encryptionDictionary) {
        this.encryptionDictionary = encryptionDictionary;
    }

    public byte[] generalEncryptionAlgorithm(Reference objectReference, byte[] encryptionKey, String algorithmType, byte[] inputData, boolean encrypt) {
        if (objectReference == null || encryptionKey == null || inputData == null) {
            return null;
        }
        if (this.encryptionDictionary.getVersion() < 5) {
            boolean isRc4 = algorithmType.equals(ENCRYPTION_TYPE_V2);
            if (this.rc4Key == null || this.encryptionKey != encryptionKey || this.objectReference != objectReference) {
                this.objectReference = objectReference;
                byte[] step3Bytes = this.resetObjectReference(objectReference, isRc4);
                int n = encryptionKey.length;
                this.rc4Key = new byte[Math.min(n + 5, 16)];
                System.arraycopy(step3Bytes, 0, this.rc4Key, 0, this.rc4Key.length);
            }
            int encryptionMode = encrypt ? 1 : 2;
            byte[] finalData = null;
            try {
                if (isRc4) {
                    SecretKeySpec key = new SecretKeySpec(this.rc4Key, "RC4");
                    Cipher rc4 = Cipher.getInstance("RC4");
                    rc4.init(encryptionMode, key);
                    finalData = rc4.doFinal(inputData);
                } else {
                    SecretKeySpec key = new SecretKeySpec(this.rc4Key, "AES");
                    Cipher aes = Cipher.getInstance("AES/CBC/PKCS5Padding");
                    if (encryptionMode == 2) {
                        byte[] initialisationVector = new byte[16];
                        if (inputData.length < 16) {
                            byte[] tmp = new byte[16];
                            System.arraycopy(inputData, 0, tmp, 0, inputData.length);
                            inputData = tmp;
                        }
                        System.arraycopy(inputData, 0, initialisationVector, 0, 16);
                        IvParameterSpec iVParameterSpec = new IvParameterSpec(initialisationVector);
                        byte[] intermData = new byte[inputData.length - 16];
                        System.arraycopy(inputData, 16, intermData, 0, intermData.length);
                        aes.init(encryptionMode, (Key)key, iVParameterSpec);
                        finalData = aes.doFinal(intermData);
                    } else {
                        IvParameterSpec iVParameterSpec = new IvParameterSpec(this.generateIv());
                        aes.init(encryptionMode, (Key)key, iVParameterSpec);
                        finalData = aes.doFinal(inputData);
                        byte[] output = new byte[iVParameterSpec.getIV().length + finalData.length];
                        System.arraycopy(iVParameterSpec.getIV(), 0, output, 0, 16);
                        System.arraycopy(finalData, 0, output, 16, finalData.length);
                        finalData = output;
                    }
                }
            }
            catch (NoSuchAlgorithmException ex) {
                logger.log(Level.FINE, "NoSuchAlgorithmException.", ex);
            }
            catch (IllegalBlockSizeException ex) {
                logger.log(Level.FINE, "IllegalBlockSizeException.", ex);
            }
            catch (BadPaddingException ex) {
                logger.log(Level.FINE, "BadPaddingException.", ex);
            }
            catch (NoSuchPaddingException ex) {
                logger.log(Level.FINE, "NoSuchPaddingException.", ex);
            }
            catch (InvalidKeyException ex) {
                logger.log(Level.FINE, "InvalidKeyException.", ex);
            }
            catch (InvalidAlgorithmParameterException ex) {
                logger.log(Level.FINE, "InvalidAlgorithmParameterException", ex);
            }
            return finalData;
        }
        if (this.encryptionDictionary.getVersion() == 5) {
            try {
                SecretKeySpec key = new SecretKeySpec(encryptionKey, "AES");
                Cipher aes = Cipher.getInstance("AES/CBC/PKCS5Padding");
                byte[] initialisationVector = new byte[16];
                System.arraycopy(inputData, 0, initialisationVector, 0, 16);
                byte[] intermData = new byte[inputData.length - 16];
                System.arraycopy(inputData, 16, intermData, 0, intermData.length);
                IvParameterSpec iVParameterSpec = new IvParameterSpec(initialisationVector);
                aes.init(2, (Key)key, iVParameterSpec);
                byte[] finalData = aes.doFinal(intermData);
                return finalData;
            }
            catch (NoSuchAlgorithmException ex) {
                logger.log(Level.FINE, "NoSuchAlgorithmException.", ex);
            }
            catch (IllegalBlockSizeException ex) {
                logger.log(Level.FINE, "IllegalBlockSizeException.", ex);
            }
            catch (BadPaddingException ex) {
                logger.log(Level.FINE, "BadPaddingException.", ex);
            }
            catch (NoSuchPaddingException ex) {
                logger.log(Level.FINE, "NoSuchPaddingException.", ex);
            }
            catch (InvalidKeyException ex) {
                logger.log(Level.FINE, "InvalidKeyException.", ex);
            }
            catch (InvalidAlgorithmParameterException ex) {
                logger.log(Level.FINE, "InvalidAlgorithmParameterException", ex);
            }
        }
        return null;
    }

    private byte[] generateIv() {
        SecureRandom random = new SecureRandom();
        byte[] ivBytes = new byte[16];
        random.nextBytes(ivBytes);
        return ivBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream generalEncryptionInputStream(Reference objectReference, byte[] encryptionKey, String algorithmType, InputStream input, boolean encrypt) {
        if (objectReference == null || encryptionKey == null || input == null) {
            return null;
        }
        if (this.encryptionDictionary.getVersion() < 5) {
            boolean isRc4 = algorithmType.equals(ENCRYPTION_TYPE_V2);
            if (this.rc4Key == null || this.encryptionKey != encryptionKey || this.objectReference != objectReference) {
                this.objectReference = objectReference;
                byte[] step3Bytes = this.resetObjectReference(objectReference, isRc4);
                int n = encryptionKey.length;
                this.rc4Key = new byte[Math.min(n + 5, 16)];
                System.arraycopy(step3Bytes, 0, this.rc4Key, 0, this.rc4Key.length);
            }
            int encryptionMode = encrypt ? 1 : 2;
            try {
                SecretKeySpec key = new SecretKeySpec(this.rc4Key, "AES");
                if (isRc4) {
                    Cipher rc4 = Cipher.getInstance("RC4");
                    rc4.init(2, key);
                    CipherInputStream cin = new CipherInputStream(input, rc4);
                    return cin;
                }
                Cipher aes = Cipher.getInstance("AES/CBC/PKCS5Padding");
                if (encryptionMode == 2) {
                    byte[] initialisationVector = new byte[16];
                    input.read(initialisationVector);
                    IvParameterSpec iVParameterSpec = new IvParameterSpec(initialisationVector);
                    aes.init(encryptionMode, (Key)key, iVParameterSpec);
                    CipherInputStream cin = new CipherInputStream(input, aes);
                    return cin;
                }
                IvParameterSpec iVParameterSpec = new IvParameterSpec(this.generateIv());
                aes.init(encryptionMode, (Key)key, iVParameterSpec);
                ByteArrayOutputStream outputByteArray = new ByteArrayOutputStream();
                CipherOutputStream cos = new CipherOutputStream(outputByteArray, aes);
                try {
                    int read;
                    byte[] data = new byte[4096];
                    while ((read = input.read(data)) != -1) {
                        cos.write(data, 0, read);
                    }
                }
                finally {
                    cos.close();
                    input.close();
                }
                byte[] finalData = outputByteArray.toByteArray();
                byte[] output = new byte[iVParameterSpec.getIV().length + finalData.length];
                System.arraycopy(iVParameterSpec.getIV(), 0, output, 0, 16);
                System.arraycopy(finalData, 0, output, 16, finalData.length);
                finalData = output;
                return new ByteArrayInputStream(finalData);
            }
            catch (NoSuchAlgorithmException ex) {
                logger.log(Level.FINE, "NoSuchAlgorithmException.", ex);
            }
            catch (NoSuchPaddingException ex) {
                logger.log(Level.FINE, "NoSuchPaddingException.", ex);
            }
            catch (InvalidKeyException ex) {
                logger.log(Level.FINE, "InvalidKeyException.", ex);
            }
            catch (InvalidAlgorithmParameterException ex) {
                logger.log(Level.FINE, "InvalidAlgorithmParameterException", ex);
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "InvalidAlgorithmParameterException", ex);
            }
        } else if (this.encryptionDictionary.getVersion() == 5) {
            try {
                SecretKeySpec key = new SecretKeySpec(encryptionKey, "AES");
                Cipher aes = Cipher.getInstance("AES/CBC/PKCS5Padding");
                byte[] initialisationVector = new byte[16];
                input.read(initialisationVector);
                IvParameterSpec iVParameterSpec = new IvParameterSpec(initialisationVector);
                aes.init(2, (Key)key, iVParameterSpec);
                CipherInputStream cin = new CipherInputStream(input, aes);
                return cin;
            }
            catch (NoSuchAlgorithmException ex) {
                logger.log(Level.FINE, "NoSuchAlgorithmException.", ex);
            }
            catch (NoSuchPaddingException ex) {
                logger.log(Level.FINE, "NoSuchPaddingException.", ex);
            }
            catch (InvalidKeyException ex) {
                logger.log(Level.FINE, "InvalidKeyException.", ex);
            }
            catch (InvalidAlgorithmParameterException ex) {
                logger.log(Level.FINE, "InvalidAlgorithmParameterException", ex);
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "InvalidAlgorithmParameterException", ex);
            }
        }
        return null;
    }

    public byte[] resetObjectReference(Reference objectReference, boolean isRc4) {
        int objectNumber = objectReference.getObjectNumber();
        int generationNumber = objectReference.getGenerationNumber();
        int n = 5;
        if (this.encryptionDictionary.getVersion() > 1) {
            n = this.encryptionDictionary.getKeyLength() / 8;
        }
        int paddingLength = 5;
        if (!isRc4) {
            paddingLength += 4;
        }
        byte[] step2Bytes = new byte[n + paddingLength];
        System.arraycopy(this.encryptionKey, 0, step2Bytes, 0, n);
        step2Bytes[n] = (byte)(objectNumber & 0xFF);
        step2Bytes[n + 1] = (byte)(objectNumber >> 8 & 0xFF);
        step2Bytes[n + 2] = (byte)(objectNumber >> 16 & 0xFF);
        step2Bytes[n + 3] = (byte)(generationNumber & 0xFF);
        step2Bytes[n + 4] = (byte)(generationNumber >> 8 & 0xFF);
        if (!isRc4) {
            step2Bytes[n + 5] = AES_sAIT[0];
            step2Bytes[n + 6] = AES_sAIT[1];
            step2Bytes[n + 7] = AES_sAIT[2];
            step2Bytes[n + 8] = AES_sAIT[3];
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException builtin) {
            // empty catch block
        }
        md5.update(step2Bytes);
        return md5.digest();
    }

    public byte[] encryptionKeyAlgorithm(String password, int keyLength) {
        if (this.encryptionDictionary.getRevisionNumber() < 5) {
            int keySize;
            byte[] paddedPassword = StandardEncryption.padPassword(password);
            MessageDigest md5 = null;
            try {
                md5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException ex) {
                logger.log(Level.FINE, "NoSuchAlgorithmException.", ex);
            }
            md5.update(paddedPassword);
            byte[] bigO = Utils.convertByteCharSequenceToByteArray(this.encryptionDictionary.getBigO());
            md5.update(bigO);
            int i = 0;
            int p = this.encryptionDictionary.getPermissions();
            while (i < 4) {
                md5.update((byte)(p & 0xFF));
                ++i;
                p >>= 8;
            }
            String firstFileID = ((StringObject)this.encryptionDictionary.getFileID().get(0)).getLiteralString();
            byte[] fileID = Utils.convertByteCharSequenceToByteArray(firstFileID);
            md5.update(fileID);
            if (this.encryptionDictionary.getRevisionNumber() >= 4 && !this.encryptionDictionary.isEncryptMetaData()) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    md5.update((byte)-1);
                }
            }
            paddedPassword = md5.digest();
            int n = keySize = this.encryptionDictionary.getRevisionNumber() == 2 ? 5 : keyLength / 8;
            if (keySize > paddedPassword.length) {
                keySize = paddedPassword.length;
            }
            byte[] out = new byte[keySize];
            try {
                if (this.encryptionDictionary.getRevisionNumber() >= 3) {
                    for (int i3 = 0; i3 < 50; ++i3) {
                        md5.update(paddedPassword, 0, keySize);
                        md5.digest(paddedPassword, 0, paddedPassword.length);
                    }
                }
            }
            catch (DigestException e) {
                logger.log(Level.WARNING, "Error creating MD5 digest.", e);
            }
            System.arraycopy(paddedPassword, 0, out, 0, keySize);
            this.encryptionKey = out;
            return out;
        }
        if (this.encryptionDictionary.getRevisionNumber() == 5) {
            try {
                byte[] passwordBytes = Utils.convertByteCharSequenceToByteArray(password);
                if (passwordBytes == null) {
                    passwordBytes = new byte[]{};
                }
                byte[] ownerPassword = Utils.convertByteCharSequenceToByteArray(this.encryptionDictionary.getBigO());
                byte[] userPassword = Utils.convertByteCharSequenceToByteArray(this.encryptionDictionary.getBigU());
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                md.update(passwordBytes, 0, Math.min(passwordBytes.length, 127));
                md.update(ownerPassword, 32, 8);
                md.update(userPassword, 0, 48);
                byte[] hash = md.digest();
                boolean isOwnerPassword = StandardEncryption.byteCompare(hash, ownerPassword, 32);
                this.encryptionDictionary.setAuthenticatedOwnerPassword(isOwnerPassword);
                if (isOwnerPassword) {
                    md.update(passwordBytes, 0, Math.min(passwordBytes.length, 127));
                    md.update(ownerPassword, 32, 8);
                    md.update(userPassword, 0, 48);
                    hash = md.digest();
                    byte[] oePassword = Utils.convertByteCharSequenceToByteArray(this.encryptionDictionary.getBigOE());
                    this.encryptionKey = StandardEncryption.AES256CBC(hash, oePassword);
                } else {
                    md.update(passwordBytes, 0, Math.min(passwordBytes.length, 127));
                    md.update(userPassword, 32, 8);
                    hash = md.digest();
                    boolean isUserPassword = StandardEncryption.byteCompare(hash, userPassword, 32);
                    this.encryptionDictionary.setAuthenticatedUserPassword(isUserPassword);
                    if (isUserPassword) {
                        md.update(passwordBytes, 0, Math.min(passwordBytes.length, 127));
                        md.update(userPassword, 40, 8);
                        hash = md.digest();
                        byte[] uePassword = Utils.convertByteCharSequenceToByteArray(this.encryptionDictionary.getBigUE());
                        this.encryptionKey = StandardEncryption.AES256CBC(hash, uePassword);
                    } else {
                        logger.warning("User password is incorrect. ");
                    }
                }
                byte[] perms = Utils.convertByteCharSequenceToByteArray(this.encryptionDictionary.getPerms());
                byte[] decryptedPerms = StandardEncryption.AES256CBC(this.encryptionKey, perms);
                if (decryptedPerms[9] != 97 || decryptedPerms[10] != 100 || decryptedPerms[11] != 98) {
                    logger.warning("User password is incorrect.");
                    return null;
                }
                int permissions = decryptedPerms[0] & 0xFF | (decryptedPerms[1] & 0xFF) << 8 | (decryptedPerms[2] & 0xFF) << 16 | (decryptedPerms[2] & 0xFF) << 24;
                int pPermissions = this.encryptionDictionary.getPermissions();
                if (pPermissions != permissions) {
                    logger.warning("Perms and P do not match");
                }
                return this.encryptionKey;
            }
            catch (NoSuchAlgorithmException e) {
                logger.warning("Error computing the the 3.2a Encryption key.");
            }
        } else {
            logger.warning("Adobe standard Encryption R = 6 is not supported.");
        }
        return null;
    }

    protected static byte[] padPassword(String password) {
        byte[] paddedPassword = new byte[32];
        if (password == null || "".equals(password)) {
            return PADDING;
        }
        int passwordLength = Math.min(password.length(), 32);
        byte[] bytePassword = Utils.convertByteCharSequenceToByteArray(password);
        System.arraycopy(bytePassword, 0, paddedPassword, 0, passwordLength);
        System.arraycopy(PADDING, 0, paddedPassword, passwordLength, 32 - passwordLength);
        return paddedPassword;
    }

    public byte[] calculateOwnerPassword(String ownerPassword, String userPassword, boolean isAuthentication) {
        if ("".equals(ownerPassword) && !"".equals(userPassword)) {
            ownerPassword = userPassword;
        }
        byte[] paddedOwnerPassword = StandardEncryption.padPassword(ownerPassword);
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.FINE, "Could not fint MD5 Digest", e);
        }
        paddedOwnerPassword = md5.digest(paddedOwnerPassword);
        if (this.encryptionDictionary.getRevisionNumber() >= 3) {
            for (int i = 0; i < 50; ++i) {
                paddedOwnerPassword = md5.digest(paddedOwnerPassword);
            }
        }
        int dataSize = 5;
        if (this.encryptionDictionary.getRevisionNumber() >= 3) {
            dataSize = this.encryptionDictionary.getKeyLength() / 8;
        }
        if (dataSize > paddedOwnerPassword.length) {
            dataSize = paddedOwnerPassword.length;
        }
        byte[] encryptionKey = new byte[dataSize];
        System.arraycopy(paddedOwnerPassword, 0, encryptionKey, 0, dataSize);
        if (isAuthentication) {
            return encryptionKey;
        }
        byte[] paddedUserPassword = StandardEncryption.padPassword(userPassword);
        byte[] finalData = null;
        try {
            SecretKeySpec key = new SecretKeySpec(encryptionKey, "RC4");
            Cipher rc4 = Cipher.getInstance("RC4");
            rc4.init(1, key);
            finalData = rc4.update(paddedUserPassword);
            if (this.encryptionDictionary.getRevisionNumber() >= 3) {
                byte[] indexedKey = new byte[encryptionKey.length];
                for (int i = 1; i <= 19; ++i) {
                    for (int j = 0; j < encryptionKey.length; ++j) {
                        indexedKey[j] = (byte)(encryptionKey[j] ^ i);
                    }
                    key = new SecretKeySpec(indexedKey, "RC4");
                    rc4.init(1, key);
                    finalData = rc4.update(finalData);
                }
            }
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.FINE, "NoSuchAlgorithmException.", ex);
        }
        catch (NoSuchPaddingException ex) {
            logger.log(Level.FINE, "NoSuchPaddingException.", ex);
        }
        catch (InvalidKeyException ex) {
            logger.log(Level.FINE, "InvalidKeyException.", ex);
        }
        return finalData;
    }

    public byte[] calculateUserPassword(String userPassword) {
        byte[] encryptionKey = this.encryptionKeyAlgorithm(userPassword, this.encryptionDictionary.getKeyLength());
        if (this.encryptionDictionary.getRevisionNumber() == 2) {
            byte[] paddedUserPassword = (byte[])PADDING.clone();
            byte[] finalData = null;
            try {
                SecretKeySpec key = new SecretKeySpec(encryptionKey, "RC4");
                Cipher rc4 = Cipher.getInstance("RC4");
                rc4.init(1, key);
                finalData = rc4.doFinal(paddedUserPassword);
            }
            catch (NoSuchAlgorithmException ex) {
                logger.log(Level.FINE, "NoSuchAlgorithmException.", ex);
            }
            catch (IllegalBlockSizeException ex) {
                logger.log(Level.FINE, "IllegalBlockSizeException.", ex);
            }
            catch (BadPaddingException ex) {
                logger.log(Level.FINE, "BadPaddingException.", ex);
            }
            catch (NoSuchPaddingException ex) {
                logger.log(Level.FINE, "NoSuchPaddingException.", ex);
            }
            catch (InvalidKeyException ex) {
                logger.log(Level.FINE, "InvalidKeyException.", ex);
            }
            return finalData;
        }
        if (this.encryptionDictionary.getRevisionNumber() >= 3 && this.encryptionDictionary.getRevisionNumber() < 5) {
            byte[] paddedUserPassword = (byte[])PADDING.clone();
            MessageDigest md5 = null;
            try {
                md5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                logger.log(Level.FINE, "MD5 digester could not be found", e);
            }
            md5.update(paddedUserPassword);
            String firstFileID = ((StringObject)this.encryptionDictionary.getFileID().get(0)).getLiteralString();
            byte[] fileID = Utils.convertByteCharSequenceToByteArray(firstFileID);
            byte[] encryptData = md5.digest(fileID);
            try {
                SecretKeySpec key = new SecretKeySpec(encryptionKey, "RC4");
                Cipher rc4 = Cipher.getInstance("RC4");
                rc4.init(1, key);
                encryptData = rc4.update(encryptData);
                byte[] indexedKey = new byte[encryptionKey.length];
                for (int i = 1; i <= 19; ++i) {
                    for (int j = 0; j < encryptionKey.length; ++j) {
                        indexedKey[j] = (byte)(encryptionKey[j] ^ (byte)i);
                    }
                    key = new SecretKeySpec(indexedKey, "RC4");
                    rc4.init(1, key);
                    encryptData = rc4.update(encryptData);
                }
            }
            catch (NoSuchAlgorithmException ex) {
                logger.log(Level.FINE, "NoSuchAlgorithmException.", ex);
            }
            catch (NoSuchPaddingException ex) {
                logger.log(Level.FINE, "NoSuchPaddingException.", ex);
            }
            catch (InvalidKeyException ex) {
                logger.log(Level.FINE, "InvalidKeyException.", ex);
            }
            byte[] finalData = new byte[32];
            System.arraycopy(encryptData, 0, finalData, 0, 16);
            System.arraycopy(PADDING, 0, finalData, 16, 16);
            return finalData;
        }
        return null;
    }

    public boolean authenticateUserPassword(String userPassword) {
        byte[] trunkUValue;
        byte[] tmpUValue = this.calculateUserPassword(userPassword);
        byte[] bigU = Utils.convertByteCharSequenceToByteArray(this.encryptionDictionary.getBigU());
        if (this.encryptionDictionary.getRevisionNumber() == 2) {
            trunkUValue = new byte[32];
            System.arraycopy(tmpUValue, 0, trunkUValue, 0, trunkUValue.length);
        } else if (this.encryptionDictionary.getRevisionNumber() >= 3 && this.encryptionDictionary.getRevisionNumber() < 5) {
            trunkUValue = new byte[16];
            System.arraycopy(tmpUValue, 0, trunkUValue, 0, trunkUValue.length);
        } else {
            return false;
        }
        boolean found = true;
        for (int i = 0; i < trunkUValue.length; ++i) {
            if (trunkUValue[i] == bigU[i]) continue;
            found = false;
            break;
        }
        return found;
    }

    public boolean authenticateOwnerPassword(String ownerPassword) {
        byte[] encryptionKey = this.calculateOwnerPassword(ownerPassword, "", true);
        byte[] decryptedO = null;
        try {
            byte[] bigO = Utils.convertByteCharSequenceToByteArray(this.encryptionDictionary.getBigO());
            if (this.encryptionDictionary.getRevisionNumber() == 2) {
                SecretKeySpec key = new SecretKeySpec(encryptionKey, "RC4");
                Cipher rc4 = Cipher.getInstance("RC4");
                rc4.init(2, key);
                decryptedO = rc4.doFinal(bigO);
            } else {
                byte[] indexedKey = new byte[encryptionKey.length];
                decryptedO = bigO;
                for (int i = 19; i >= 0; --i) {
                    for (int j = 0; j < indexedKey.length; ++j) {
                        indexedKey[j] = (byte)(encryptionKey[j] ^ (byte)i);
                    }
                    SecretKeySpec key = new SecretKeySpec(indexedKey, "RC4");
                    Cipher rc4 = Cipher.getInstance("RC4");
                    rc4.init(1, key);
                    decryptedO = rc4.update(decryptedO);
                }
            }
            String tmpUserPassword = Utils.convertByteArrayToByteString(decryptedO);
            boolean isValid = this.authenticateUserPassword(tmpUserPassword);
            if (isValid) {
                this.userPassword = tmpUserPassword;
                this.ownerPassword = ownerPassword;
            }
            return isValid;
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.FINE, "NoSuchAlgorithmException.", ex);
        }
        catch (IllegalBlockSizeException ex) {
            logger.log(Level.FINE, "IllegalBlockSizeException.", ex);
        }
        catch (BadPaddingException ex) {
            logger.log(Level.FINE, "BadPaddingException.", ex);
        }
        catch (NoSuchPaddingException ex) {
            logger.log(Level.FINE, "NoSuchPaddingException.", ex);
        }
        catch (InvalidKeyException ex) {
            logger.log(Level.FINE, "InvalidKeyException.", ex);
        }
        return false;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public String getOwnerPassword() {
        return this.ownerPassword;
    }

    private static byte[] AES256CBC(byte[] intermediateKey, byte[] encryptedString) {
        byte[] finalData = null;
        try {
            SecretKeySpec key = new SecretKeySpec(intermediateKey, "AES");
            Cipher aes = Cipher.getInstance("AES/CBC/NoPadding");
            IvParameterSpec iVParameterSpec = new IvParameterSpec(new byte[16]);
            aes.init(2, (Key)key, iVParameterSpec);
            finalData = aes.doFinal(encryptedString);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.FINE, "NoSuchAlgorithmException.", ex);
        }
        catch (IllegalBlockSizeException ex) {
            logger.log(Level.FINE, "IllegalBlockSizeException.", ex);
        }
        catch (BadPaddingException ex) {
            logger.log(Level.FINE, "BadPaddingException.", ex);
        }
        catch (NoSuchPaddingException ex) {
            logger.log(Level.FINE, "NoSuchPaddingException.", ex);
        }
        catch (InvalidKeyException ex) {
            logger.log(Level.FINE, "InvalidKeyException.", ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            logger.log(Level.FINE, "InvalidAlgorithmParameterException", ex);
        }
        return finalData;
    }

    private static boolean byteCompare(byte[] byteArray1, byte[] byteArray2, int range) {
        for (int i = 0; i < range; ++i) {
            if (byteArray1[i] == byteArray2[i]) continue;
            return false;
        }
        return true;
    }
}

