/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableByteArrayInputStream;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.fonts.ofont.Encoding;
import org.icepdf.core.util.Library;

public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.toString());
    private static long lastMemUsed = 0L;

    public static void setIntIntoByteArrayBE(int value, byte[] buffer, int offset) {
        buffer[offset] = (byte)(value >>> 24 & 0xFF);
        buffer[offset + 1] = (byte)(value >>> 16 & 0xFF);
        buffer[offset + 2] = (byte)(value >>> 8 & 0xFF);
        buffer[offset + 3] = (byte)(value & 0xFF);
    }

    public static void setShortIntoByteArrayBE(short value, byte[] buffer, int offset) {
        buffer[offset] = (byte)(value >>> 8 & 0xFF);
        buffer[offset + 1] = (byte)(value & 0xFF);
    }

    public static long readLongWithVaryingBytesBE(InputStream in, int numBytes) throws IOException {
        long val = 0L;
        for (int i = 0; i < numBytes; ++i) {
            int curr = in.read();
            if (curr < 0) {
                throw new EOFException();
            }
            val <<= 8;
            val |= (long)curr & 0xFFL;
        }
        return val;
    }

    public static int readIntWithVaryingBytesBE(InputStream in, int numBytes) throws IOException {
        int val = 0;
        for (int i = 0; i < numBytes; ++i) {
            int curr = in.read();
            if (curr < 0) {
                throw new EOFException();
            }
            val <<= 8;
            val |= curr & 0xFF;
        }
        return val;
    }

    public static void writeInteger(OutputStream in, int i) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(i);
        in.write(bb.array());
    }

    public static void writeLong(OutputStream in, long i) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(i);
        in.write(bb.array());
    }

    public static String convertByteArrayToHexString(byte[] buffer, boolean addSpaceSeparator) {
        return Utils.convertByteArrayToHexString(buffer, 0, buffer.length, addSpaceSeparator, -1, '\u0000');
    }

    public static String convertByteArrayToHexString(byte[] buffer, boolean addSpaceSeparator, int addDelimiterEverNBytes, char delimiter) {
        return Utils.convertByteArrayToHexString(buffer, 0, buffer.length, addSpaceSeparator, addDelimiterEverNBytes, delimiter);
    }

    public static String convertByteArrayToHexString(byte[] buffer, int offset, int length, boolean addSpaceSeparator, int addDelimiterEverNBytes, char delimiter) {
        int presize = length * (addSpaceSeparator ? 3 : 2);
        if (addDelimiterEverNBytes > 0) {
            presize += length / addDelimiterEverNBytes;
        }
        StringBuilder sb = new StringBuilder(presize);
        int delimiterCount = 0;
        int end = offset + length;
        for (int index = offset; index < end; ++index) {
            int currValue = 0;
            String s = Integer.toHexString(currValue |= 0xFF & buffer[index]);
            for (int i = s.length(); i < 2; ++i) {
                sb.append('0');
            }
            sb.append(s);
            if (addSpaceSeparator) {
                sb.append(' ');
            }
            if (addDelimiterEverNBytes <= 0 || ++delimiterCount != addDelimiterEverNBytes) continue;
            delimiterCount = 0;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static boolean reflectGraphicsEnvironmentISHeadlessInstance(Object graphicsEnvironment, boolean defaultReturnIfNoMethod) {
        try {
            Object ret;
            Class<?> clazz = graphicsEnvironment.getClass();
            Method isHeadlessInstanceMethod = clazz.getMethod("isHeadlessInstance", new Class[0]);
            if (isHeadlessInstanceMethod != null && (ret = isHeadlessInstanceMethod.invoke(graphicsEnvironment, new Object[0])) instanceof Boolean) {
                return (Boolean)ret;
            }
        }
        catch (Throwable t) {
            logger.log(Level.FINE, "ImageCache: Java 1.4 Headless support not found.");
        }
        return defaultReturnIfNoMethod;
    }

    public static String getContentAndReplaceInputStream(InputStream[] inArray, boolean convertToHex) {
        String content = null;
        try {
            int read;
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            InputStream in = inArray[0];
            byte[] buf = new byte[1024];
            while ((read = in.read(buf, 0, buf.length)) >= 0) {
                out.write(buf, 0, read);
            }
            if (!(in instanceof SeekableInput)) {
                in.close();
            }
            out.flush();
            out.close();
            byte[] data = out.toByteArray();
            inArray[0] = new ByteArrayInputStream(data);
            content = convertToHex ? Utils.convertByteArrayToHexString(data, true) : new String(data);
        }
        catch (IOException ioe) {
            logger.log(Level.FINE, "Problem getting debug string", ioe);
        }
        catch (Throwable e) {
            logger.log(Level.FINE, "Problem getting content stream, skipping");
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentFromSeekableInput(SeekableInput in, boolean convertToHex) {
        String content = null;
        try {
            int read;
            in.beginThreadAccess();
            long position = in.getAbsolutePosition();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((read = in.getInputStream().read()) >= 0) {
                out.write(read);
            }
            in.seekAbsolute(position);
            out.flush();
            out.close();
            byte[] data = out.toByteArray();
            content = convertToHex ? Utils.convertByteArrayToHexString(data, true) : new String(data);
        }
        catch (IOException ioe) {
            logger.log(Level.FINE, "Problem getting debug string");
        }
        finally {
            in.endThreadAccess();
        }
        return content;
    }

    public static SeekableInput replaceInputStreamWithSeekableInput(InputStream in) {
        if (in instanceof SeekableInput) {
            return (SeekableInput)((Object)in);
        }
        SeekableByteArrayInputStream sin = null;
        try {
            int read;
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            while ((read = in.read()) >= 0) {
                out.write(read);
            }
            in.close();
            out.flush();
            out.close();
            byte[] data = out.toByteArray();
            sin = new SeekableByteArrayInputStream(data);
        }
        catch (IOException ioe) {
            logger.log(Level.FINE, "Problem getting debug string");
        }
        return sin;
    }

    public static void printMemory(String str) {
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        long used = total - free;
        System.out.println("MEM  " + str + "    used: " + used / 1024L + " KB    delta: " + (used - lastMemUsed) / 1024L + " KB");
        lastMemUsed = used;
    }

    public static int numBytesToHoldBits(int numBits) {
        int numBytes = numBits / 8;
        if (numBits % 8 > 0) {
            ++numBytes;
        }
        return numBytes;
    }

    public static byte[] convertByteCharSequenceToByteArray(CharSequence string) {
        int max = string.length();
        byte[] bytes = new byte[max];
        for (int i = 0; i < max; ++i) {
            bytes[i] = (byte)string.charAt(i);
        }
        return bytes;
    }

    public static String convertByteArrayToByteString(byte[] bytes) {
        int max = bytes.length;
        StringBuilder sb = new StringBuilder(max);
        for (byte aByte : bytes) {
            int b = aByte & 0xFF;
            sb.append((char)b);
        }
        return sb.toString();
    }

    public static String convertStringObject(Library library, StringObject stringObject) {
        String convertedStringObject = null;
        String titleText = stringObject.getDecryptedLiteralString(library.getSecurityManager());
        if (titleText != null && titleText.length() >= 2 && titleText.charAt(0) == '\u00fe' && titleText.charAt(1) == '\u00ff') {
            StringBuilder sb1 = new StringBuilder();
            for (int i = 2; i < titleText.length(); i += 2) {
                try {
                    int b1 = (titleText.charAt(i) & 0xFF) << 8 | titleText.charAt(i + 1) & 0xFF;
                    sb1.append((char)b1);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            convertedStringObject = sb1.toString();
        } else if (titleText != null) {
            StringBuilder sb = new StringBuilder();
            Encoding enc = Encoding.getPDFDoc();
            for (int i = 0; i < titleText.length(); ++i) {
                sb.append(titleText.charAt(i));
            }
            convertedStringObject = sb.toString();
        }
        return convertedStringObject;
    }
}

