/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class LazyMenuArrowImageIcon
implements Icon {
    private String leftToRightName = null;
    private String rightToLefttName = null;
    private Icon leftToRightIcon = null;
    private Icon rightToLeftIcon = null;

    public LazyMenuArrowImageIcon(String leftToRightName, String rightToLefttName) {
        this.leftToRightName = leftToRightName;
        this.rightToLefttName = rightToLefttName;
    }

    private Icon getLeftToRightIcon() {
        if (this.leftToRightIcon == null) {
            try {
                this.leftToRightIcon = new ImageIcon(LazyMenuArrowImageIcon.class.getResource(this.leftToRightName));
            }
            catch (Throwable t) {
                System.out.println("ERROR: loading image " + this.leftToRightName + " failed!");
            }
        }
        return this.leftToRightIcon;
    }

    private Icon getRightToLeftIcon() {
        if (this.rightToLeftIcon == null) {
            try {
                this.rightToLeftIcon = new ImageIcon(LazyMenuArrowImageIcon.class.getResource(this.rightToLefttName));
            }
            catch (Throwable t) {
                System.out.println("ERROR: loading image " + this.rightToLefttName + " failed!");
            }
        }
        return this.rightToLeftIcon;
    }

    private Icon getIcon(Component c) {
        if (JTattooUtilities.isLeftToRight(c)) {
            return this.getLeftToRightIcon();
        }
        return this.getRightToLeftIcon();
    }

    @Override
    public int getIconHeight() {
        Icon ico = this.getIcon(null);
        if (ico != null) {
            return ico.getIconHeight();
        }
        return 16;
    }

    @Override
    public int getIconWidth() {
        Icon ico = this.getIcon(null);
        if (ico != null) {
            return ico.getIconWidth();
        }
        return 16;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon ico = this.getIcon(c);
        if (ico != null) {
            ico.paintIcon(c, g, x, y);
        } else {
            g.setColor(Color.red);
            g.fillRect(x, y, 16, 16);
            g.setColor(Color.white);
            g.drawLine(x, y, x + 15, y + 15);
            g.drawLine(x + 15, y, x, y + 15);
        }
    }
}

