/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.apputil;

import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.ToolData;
import ch.steph.reputil.PatientUtil;
import ch.steph.util.Constants;
import ch.steph.util.FileProcedures;
import ch.steph.util.GetDataFile;
import ch.steph.util.IconUtil;
import ch.steph.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InfoBox
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton okButton;
    private JCheckBox logLevel;
    private String[] text = new String[]{StringResource.getString("progInfo_1"), StringResource.getString("progInfo_2") + Constants.getFullVersion(), StringResource.getString("progInfo_3"), StringResource.getString("progInfo_4"), StringResource.getString("progInfo_5"), StringResource.getString("progInfo_6"), "Signal / Telegram / WhatsApp: 0173 / 82 30 505"};

    public InfoBox(JFrame jFrame) {
        super((Frame)jFrame, true);
        JComponent jComponent;
        Object object;
        JLabel jLabel;
        JLabel jLabel2;
        Log.write(4, this.getClass().getName(), "start");
        this.setTitle(StringResource.getString("progInfo_title"));
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                InfoBox.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.getContentPane().addKeyListener(keyListener);
        this.addKeyListener(keyListener);
        this.getContentPane().setLayout(new BorderLayout());
        ImageIcon imageIcon = IconUtil.getImageIcon(this, "icon/prog1.jpg");
        if (imageIcon != null) {
            jLabel2 = new JLabel(imageIcon);
            jLabel2.setBorder(BorderFactory.createLoweredBevelBorder());
            this.getContentPane().add((Component)jLabel2, "West");
        }
        if ((imageIcon = IconUtil.getImageIcon(this, "icon/prog3.jpg")) != null) {
            jLabel2 = new JLabel(imageIcon);
            jLabel2.setBorder(BorderFactory.createLoweredBevelBorder());
            this.getContentPane().add((Component)jLabel2, "East");
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        imageIcon = IconUtil.getImageIcon(this, "icon/prog4.jpg");
        if (imageIcon != null) {
            jLabel = new JLabel(" ", 0);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            object = new JPanel();
            jLabel2 = new JLabel(imageIcon);
            jLabel2.setBorder(BorderFactory.createLoweredBevelBorder());
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            ((Container)object).add(jLabel2);
            jPanel.add((Component)object);
        }
        jLabel = new JLabel(" ", 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        for (String string : this.text) {
            jComponent = new JLabel(string, 0);
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            jPanel.add(jComponent);
        }
        jLabel2 = new JLabel(" ", 0);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        imageIcon = IconUtil.getImageIcon(this, "icon/prog2.jpg");
        if (imageIcon != null) {
            object = new JPanel();
            jLabel2 = new JLabel(imageIcon);
            jLabel2.setBorder(BorderFactory.createLoweredBevelBorder());
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            ((Container)object).add(jLabel2);
            jPanel.add((Component)object);
            jLabel2 = new JLabel(" ", 0);
            gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
            jPanel.add(jLabel2);
        }
        Runtime.getRuntime().gc();
        long l = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
        long l2 = Runtime.getRuntime().totalMemory() / 1024L;
        jLabel2 = new JLabel("Memory: " + l / 1000L + " von " + l2 / 1000L + " MByte, max: " + Runtime.getRuntime().maxMemory() / 1024L / 1000L + " MByte", 0);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        jLabel2 = new JLabel("OS: " + System.getProperty("os.name") + ", Arch.: " + System.getProperty("os.arch") + ", Version: " + System.getProperty("os.version"), 0);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        jLabel2 = new JLabel("Java: " + System.getProperty("java.version") + ", " + System.getProperty("java.home"), 0);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        jLabel2 = new JLabel("User: " + System.getProperty("user.name") + ", Home: " + System.getProperty("user.home") + ", Dir: " + System.getProperty("user.dir"), 0);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        jLabel2 = new JLabel(" ", 0);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        jComponent = new JPanel();
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        JButton jButton = new JButton(StringResource.getString("progInfo_button"));
        jButton.addActionListener(actionEvent -> this.infoAction());
        jButton.addKeyListener(keyListener);
        jComponent.add(jButton);
        this.logLevel = new JCheckBox("Log to jRepLog");
        int n = User.instance().getProperty("LogSeverity", 0);
        if (n < 0) {
            n = 0;
        }
        if (n > 5) {
            n = 5;
        }
        if (n == 5) {
            this.logLevel.setSelected(true);
        } else {
            this.logLevel.setSelected(false);
        }
        gridBagLayout.setConstraints(this.logLevel, gridBagConstraints);
        jComponent.add(this.logLevel);
        jPanel.add(jComponent);
        this.logLevel.addKeyListener(keyListener);
        jLabel = new JLabel(" ", 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.getContentPane().add((Component)jPanel, "Center");
        jComponent = new JPanel();
        this.okButton = new JButton(StringResource.getString("button_ok"));
        this.okButton.addActionListener(actionEvent -> this.buttonOkAction());
        jComponent.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.getCursor();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.getContentPane().add((Component)jComponent, "South");
        this.okButton.addKeyListener(keyListener);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                InfoBox.this.closeAction();
            }
        });
        Rectangle rectangle = this.getParent().getBounds();
        Rectangle rectangle2 = this.getBounds();
        rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
        rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
        if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
            rectangle2.x = rectangle.x + rectangle.width - rectangle2.width;
        }
        if (rectangle2.x < 0) {
            rectangle2.x = 0;
        }
        if (rectangle2.y < 0) {
            rectangle2.y = 0;
        }
        this.setBounds(rectangle2);
    }

    protected void mainKeyPressed(KeyEvent keyEvent) {
        try {
            if (!keyEvent.isConsumed()) {
                char c = keyEvent.getKeyChar();
                if (c == '\u001b') {
                    keyEvent.consume();
                    this.closeAction();
                }
                if (c == '\n') {
                    keyEvent.consume();
                    this.closeAction();
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey", exception);
        }
    }

    protected void buttonOkAction() {
        if (this.logLevel != null) {
            if (this.logLevel.isSelected()) {
                Log.setMaxSeverity(5);
                Log.setPath(FileProcedures.addDirName(GetDataFile.getDataPath(), "jRepLog"));
            } else {
                Log.stopLogging();
            }
        }
        this.closeAction();
    }

    protected void infoAction() {
        String string = ToolData.getTestKey();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Name     :'").append(User.instance().getUserName()).append("'");
        stringBuilder.append("\nVersion  : ").append(Constants.getFullVersion()).append(" - ").append(new SimpleDateFormat("dd.MM.yyyy").format(Constants.getBuildTime()));
        stringBuilder.append("\nCode     : ").append(string);
        stringBuilder.append("\nRep-Key 1:'").append(User.instance().getProperty("Key", "")).append("'");
        stringBuilder.append("\nMM-Key 1 :'").append(User.instance().getProperty("Key2", "")).append("'");
        stringBuilder.append("\nRep-Key 2:'").append(User.instance().getProperty("Key3", "")).append("'");
        stringBuilder.append("\nMM-Key 2 :'").append(User.instance().getProperty("Key4", "")).append("'");
        stringBuilder.append("\nRep-Key 3:'").append(User.instance().getProperty("Key6", "")).append("'");
        stringBuilder.append("\nMM-Key 3 :'").append(User.instance().getProperty("Key7", "")).append("'");
        stringBuilder.append("\nRep-Key 4:'").append(User.instance().getProperty("Key8", "")).append("'");
        stringBuilder.append("\nMM-Key 4 :'").append(User.instance().getProperty("Key9", "")).append("'");
        stringBuilder.append("\nYear Key :'").append(User.instance().getProperty("Key5", "")).append("'");
        stringBuilder.append("\nRep-Key 5:'").append(User.instance().getProperty("KeyA", "")).append("'");
        stringBuilder.append("\nMM-Key 5 :'").append(User.instance().getProperty("KeyB", "")).append("'");
        stringBuilder.append("\nAbo      : ").append(User.instance().getProperty("LicFromNet", false));
        stringBuilder.append("\nOS Name  : ").append(System.getProperty("os.name"));
        stringBuilder.append("\nOS Arch. : ").append(System.getProperty("os.arch"));
        stringBuilder.append("\nOS Vers. : ").append(System.getProperty("os.version"));
        stringBuilder.append("\nProc.    : ").append(Runtime.getRuntime().availableProcessors());
        stringBuilder.append("\nJ-Vendor : ").append(System.getProperty("java.vendor"));
        stringBuilder.append("\nJ-Vers.  : ").append(System.getProperty("java.version"));
        stringBuilder.append("\nJ-Home   : ").append(System.getProperty("java.home"));
        stringBuilder.append("\nUser-Name: ").append(System.getProperty("user.name"));
        stringBuilder.append("\nUser-Home: ").append(System.getProperty("user.home"));
        stringBuilder.append("\nUser-Dir : ").append(System.getProperty("user.dir"));
        stringBuilder.append("\njRep-Data: ").append(GetDataFile.getDataPath());
        stringBuilder.append("\nTotal Mem: ").append(Runtime.getRuntime().totalMemory() / 1024L / 1024L).append("MByte");
        stringBuilder.append("\nFree Mem : ").append(Runtime.getRuntime().freeMemory() / 1024L / 1024L).append("MByte");
        stringBuilder.append("\nMax. Mem : ").append(Runtime.getRuntime().maxMemory() / 1024L / 1024L).append("MByte");
        stringBuilder.append("\nDesign   : ").append(User.instance().getProperty("LookFeel", "default"));
        String[] stringArray = PatientUtil.getPatButtons(false);
        for (int i = 0; i < 4; ++i) {
            if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
            stringBuilder.append("\nPat.Dir ").append(i).append(": ").append(stringArray[i]).append(" - ").append(PatientUtil.getPatDir(stringArray[i]));
        }
        stringBuilder.append("\nDatum    : ").append(new SimpleDateFormat("dd.MM.yyyy HH:mm").format(new Date()));
        stringBuilder.append("\nSuch Einstellung            : ").append(User.instance().getProperty("ShowHierarchic", false) ? "hierarchisch" : "normal");
        stringBuilder.append("\nExterne Daten aktiv         : ").append(User.instance().getProperty("externalRubric", true) ? "ja" : "nein");
        stringBuilder.append("\nPolaritaetenanalyse         : ").append(User.instance().getProperty("withPolar", true) ? "ja" : "nein");
        stringBuilder.append("\nSortierung sekundaer alpha. : ").append(User.instance().getProperty("alphabticalSort", false) ? "ja" : "nein");
        stringBuilder.append("\nPolare Sortierung einfach   : ").append(User.instance().getProperty("sortPolarSimple", false) ? "ja" : "nein");
        String string2 = "Nein";
        if (User.instance().getProperty("PolarFactor", 10) > 1) {
            switch (User.instance().getProperty("PolarFactorFrom", 4)) {
                default: {
                    string2 = "4";
                    break;
                }
                case 3: {
                    string2 = "3";
                    break;
                }
                case 2: {
                    string2 = "2";
                }
            }
        }
        stringBuilder.append("\nKontraindikationen ab       : ").append(string2);
        stringBuilder.append("\nRelative Kontraindikationen : ").append(User.instance().getProperty("polarRelative", true) ? "ja" : "nein");
        stringBuilder.append("\nSynchronisation             : ").append(User.instance().getProperty("DataBackup", ""));
        stringBuilder.append("\n");
        StringSelection stringSelection = new StringSelection(stringBuilder.toString());
        this.getToolkit().getSystemClipboard().setContents(stringSelection, null);
    }

    protected void closeAction() {
        this.setVisible(false);
        Log.write(4, this.getClass().getName(), "end");
    }
}

