/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.apputil;

import ch.steph.apputil.MdiModalFrame;
import ch.steph.apputil.MdiNormalFrame;
import ch.steph.apputil.ScreenUtil;
import ch.steph.apputil.StartBox;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.repui.RepMainFrame;
import ch.steph.reputil.FontUtil;
import ch.steph.util.AppIcon;
import ch.steph.util.Constants;
import ch.steph.util.Log;
import ch.steph.util.StartRtfProcessor;
import ch.steph.util.TimeProbe;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class MdiMainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final int TOP_WINDOWS = 3;
    private static final String CLASS_NAME = "ch.steph.repui.MdiMainFrame";
    private static MdiMainFrame instance;
    private long endTime;
    private Rectangle start = new Rectangle(0, 0, 0, 0);
    private JMenu lookAndFeelMenu;
    private String actLook;
    private StartBox startInfo = null;
    private MdiMainFrame mainFrame;
    private JDesktopPane desktop;
    private Timer desktopTimer;
    private MdiModalFrame mdiModalFrame = null;
    private JInternalFrame mainTopWindow;
    private JInternalFrame[] lastTopWindow = new JInternalFrame[3];
    private boolean firstLoadDone = false;
    private TimeProbe timeProbe = new TimeProbe();
    ArrayList<JInternalFrame> allClosableFrames;
    private int arrangeTick;
    private Thread arrangeThread;

    /*
     * WARNING - void declaration
     */
    public MdiMainFrame() {
        Object object;
        this.setDefaultCloseOperation(0);
        this.allClosableFrames = new ArrayList();
        this.endTime = System.currentTimeMillis() + 3000L;
        String string = System.getProperty("os.name");
        Log.write(4, "jRep", "OS " + string);
        ArrayList<UIManager.LookAndFeelInfo> arrayList = this.getLookAndFeels();
        if (arrayList != null && arrayList.size() > 1) {
            object = "";
            String string2 = UIManager.getCrossPlatformLookAndFeelClassName();
            for (UIManager.LookAndFeelInfo object2 : arrayList) {
                if (!object2.getClassName().equals(string2)) continue;
                object = object2.getName();
            }
            this.actLook = User.instance().getProperty("LookFeel", (String)object);
            boolean bl = false;
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : arrayList) {
                if (!lookAndFeelInfo.getName().equals(this.actLook)) continue;
                try {
                    UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                    bl = true;
                    Log.write(5, CLASS_NAME, "setLook " + lookAndFeelInfo.getName() + " " + lookAndFeelInfo.getClassName());
                }
                catch (Exception exception) {
                    Log.write(2, CLASS_NAME, "init laf set ", exception);
                }
            }
            if (!bl) {
                void var6_11;
                this.actLook = arrayList.get(0).getName();
                User.instance().setProperty("LookFeel", this.actLook);
                boolean exception = false;
                while (var6_11 < this.getLookAndFeelMenu().getItemCount()) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.getLookAndFeelMenu().getItem((int)var6_11);
                    jCheckBoxMenuItem.setState(jCheckBoxMenuItem.getText().equals(this.actLook));
                    ++var6_11;
                }
                try {
                    UIManager.setLookAndFeel(arrayList.get(0).getClassName());
                    Log.write(5, CLASS_NAME, "setLook default: " + arrayList.get(0).getName() + " " + arrayList.get(0).getClassName());
                }
                catch (Exception exception2) {
                    Log.write(2, CLASS_NAME, "init laf set ", exception2);
                }
            }
        }
        this.setTitle("jRep");
        this.setName("jRep");
        this.setIconImage(AppIcon.getIconImage(this));
        Log.write(5, CLASS_NAME, "start Desktop");
        this.desktop = new JDesktopPane();
        this.desktop.setBackground(UIManager.getColor("window"));
        this.mainFrame = this;
        instance = this;
        if (!User.instance().getProperty("HelpShowed", false) || User.instance().getUserName().length() < 5) {
            Log.write(5, CLASS_NAME, "show Help");
            this.start = ScreenUtil.getFrameJWindowSize(this.getToolkit().getScreenSize(), this);
        } else {
            Log.write(5, CLASS_NAME, "show StartInfo");
            this.startInfo = new StartBox(this);
            this.startInfo.setVisible(true);
            this.start = ScreenUtil.getFrameJWindowSize(this.getToolkit().getScreenSize(), null);
        }
        this.start.x = User.instance().getProperty("FrameX", this.start.x);
        this.start.y = User.instance().getProperty("FrameY", this.start.y);
        this.start.width = User.instance().getProperty("FrameW", this.start.width);
        this.start.height = User.instance().getProperty("FrameH", this.start.height);
        object = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.start.x + this.start.width > ((Dimension)object).width) {
            this.start.x = ((Dimension)object).width - this.start.width;
            if (this.start.x < 0) {
                this.start.x = 0;
                this.start.width = ((Dimension)object).width;
            }
        }
        if (this.start.y + this.start.height > ((Dimension)object).height) {
            this.start.y = ((Dimension)object).height - this.start.height;
            if (this.start.y < 0) {
                this.start.y = 0;
                this.start.height = ((Dimension)object).height;
            }
        }
        this.setBounds(this.start);
        this.setContentPane(this.desktop);
        FontUtil.setProgFont(this.desktop.getFont());
        FontUtil.setMonoFontDiff(User.instance().getProperty("ResultCharSizeDiff", 2) - User.instance().getProperty("fontDeltaNormal2", 3) + 2, User.instance().getProperty("MedicaCharSizeDiff", 1) - User.instance().getProperty("fontDeltaNormal2", 3) + 2);
        if (arrayList != null && arrayList.size() > 1) {
            this.setLookAndFeelMenu(new JMenu(StringResource.getString("menu_look")));
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : arrayList) {
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(lookAndFeelInfo.getName());
                jCheckBoxMenuItem.setActionCommand(lookAndFeelInfo.getName());
                jCheckBoxMenuItem.setState(lookAndFeelInfo.getName().equals(this.actLook));
                jCheckBoxMenuItem.addActionListener(this::lookAction);
                this.getLookAndFeelMenu().add(jCheckBoxMenuItem);
            }
        }
        this.desktopTimer = new Timer(101, actionEvent -> this.desktopTimerTick());
        this.desktopTimer.stop();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MdiMainFrame.this.exitAction();
            }
        });
        Log.write(5, CLASS_NAME, "Constructor done");
    }

    public static MdiMainFrame getInstance() {
        return instance;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            Log.write(5, CLASS_NAME, "setVisible");
            ScreenUtil.setDesktopSize(this.desktop.getSize());
            this.desktop.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    MdiMainFrame.this.checkForNullFocus();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                }
            });
            this.getContentPane().addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    MdiMainFrame.this.checkForNullFocus();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    MdiMainFrame.this.checkForNullFocus();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                }
            });
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    MdiMainFrame.this.doneResizeLayout();
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                }

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                }
            });
        }
        if (User.instance().getProperty("FrameMaximized", false)) {
            this.setExtendedState(6);
        } else {
            this.setState(0);
            this.setExtendedState(0);
        }
        String string = Constants.getVersion();
        this.mainFrame.setTitle("jRep " + string);
        Log.write(5, CLASS_NAME, "setVisible done");
    }

    protected void checkForNullFocus() {
        if (this.mainFrame.isFocused() && this.mainFrame.getFocusOwner() == null) {
            this.selectLastTopWindow();
            Log.write(5, CLASS_NAME, "FocusOwner was null");
        }
    }

    public void setMainTopWindow(JInternalFrame jInternalFrame) {
        this.mainTopWindow = jInternalFrame;
    }

    public void closeMdiModalFrame() {
        if (this.mdiModalFrame != null && this.mdiModalFrame.isFocusable() && !this.mdiModalFrame.isClosed()) {
            this.mdiModalFrame.closeAction();
        }
    }

    public void selectLastTopWindow() {
        try {
            if (this.mdiModalFrame != null && this.mdiModalFrame.isFocusable() && !this.mdiModalFrame.isClosed()) {
                this.mdiModalFrame.setSelected(true);
                Log.write(5, CLASS_NAME, "Focus on ModalFrame");
                return;
            }
            for (int i = 0; i < 3; ++i) {
                if (this.lastTopWindow[i] == null || !this.lastTopWindow[i].isFocusable() || this.lastTopWindow[i].isClosed()) continue;
                this.lastTopWindow[i].setSelected(true);
                this.lastTopWindow[i].requestFocus();
                Log.write(5, CLASS_NAME, "Focus on " + i + ", " + this.lastTopWindow[i].getClass().getName());
                return;
            }
            if (this.mainTopWindow != null && this.mainTopWindow.isFocusable() && !this.mainTopWindow.isClosed()) {
                this.mainTopWindow.setSelected(true);
                this.mainTopWindow.requestFocus();
                Log.write(5, CLASS_NAME, "Focus on mainTopWindow");
            } else {
                this.mainFrame.requestFocus();
                Log.write(4, CLASS_NAME, "Focus in MainFrame");
            }
        }
        catch (Exception exception) {
            Log.write(4, CLASS_NAME, "Not Focused");
        }
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    public void add(JInternalFrame jInternalFrame) {
        jInternalFrame.setVisible(true);
        this.desktop.add(jInternalFrame);
        if (jInternalFrame.isClosable()) {
            this.allClosableFrames.add(jInternalFrame);
        }
    }

    public void closeAllClosableFrames() {
        for (JInternalFrame jInternalFrame : this.allClosableFrames) {
            try {
                this.remove(jInternalFrame);
                jInternalFrame.dispose();
            }
            catch (Exception exception) {}
        }
        this.allClosableFrames.clear();
    }

    public void remove(JInternalFrame jInternalFrame) {
        jInternalFrame.setVisible(false);
        this.desktop.remove(jInternalFrame);
    }

    public void addAndSelect(JInternalFrame jInternalFrame) {
        try {
            this.add(jInternalFrame);
            jInternalFrame.moveToFront();
            jInternalFrame.setSelected(true);
            this.setIsSelected(jInternalFrame);
        }
        catch (Exception exception) {
            Log.write(5, CLASS_NAME, "addAndSelect: ", exception);
        }
    }

    public void selectFrame(JInternalFrame jInternalFrame) {
        if (this.mdiModalFrame == null && this.startInfo == null) {
            try {
                jInternalFrame.moveToFront();
                jInternalFrame.setSelected(true);
                this.setIsSelected(jInternalFrame);
            }
            catch (Exception exception) {
                Log.write(5, CLASS_NAME, "selectFrame: ", exception);
            }
        }
    }

    public void setIsSelected(JInternalFrame jInternalFrame) {
        if (jInternalFrame != this.lastTopWindow[0]) {
            Log.write(5, CLASS_NAME, "setIsSelected " + jInternalFrame.getClass().getName());
            System.arraycopy(this.lastTopWindow, 0, this.lastTopWindow, 1, 2);
            this.lastTopWindow[0] = jInternalFrame;
        }
    }

    public boolean addAndSelectModal(MdiModalFrame mdiModalFrame) {
        try {
            if (this.mdiModalFrame == null) {
                this.mdiModalFrame = mdiModalFrame;
                mdiModalFrame.setVisible(true);
                this.desktop.add(mdiModalFrame);
                mdiModalFrame.setSelected(true);
                this.desktopTimer.start();
                return true;
            }
        }
        catch (Exception exception) {
            Log.write(5, CLASS_NAME, "addAndSelectModal ", exception);
        }
        return false;
    }

    public void removeModal() {
        try {
            this.desktopTimer.stop();
            if (this.mdiModalFrame != null) {
                this.mdiModalFrame.setVisible(false);
                this.desktop.remove(this.mdiModalFrame);
                this.mdiModalFrame = null;
                this.selectLastTopWindow();
            }
        }
        catch (Exception exception) {
            Log.write(5, CLASS_NAME, "removeModal ", exception);
        }
    }

    protected void desktopTimerTick() {
        try {
            if (this.startInfo != null) {
                if (System.currentTimeMillis() > this.getEndTime() && this.firstLoadDone) {
                    this.startInfo.setVisible(false);
                    this.desktop.remove(this.startInfo);
                    this.startInfo = null;
                    this.desktopTimer.stop();
                    this.additionalLoadAction();
                    if (User.instance().getProperty("startWithPatWindow", false)) {
                        RepMainFrame.getRepInstance().patientAction();
                    } else {
                        SwingUtilities.invokeLater(() -> {
                            if (this.mainTopWindow != null) {
                                this.setIsSelected(this.mainTopWindow);
                                this.selectLastTopWindow();
                                this.mainTopWindow.requestFocus();
                            }
                        });
                    }
                    Log.write(5, CLASS_NAME, "starter End");
                }
            } else if (this.mdiModalFrame != null) {
                if (!this.mdiModalFrame.isSelected()) {
                    this.mdiModalFrame.moveToFront();
                }
            } else {
                this.desktopTimer.stop();
            }
        }
        catch (Exception exception) {
            Log.write(5, CLASS_NAME, "desktopTimerTick ", exception);
        }
    }

    public void endLoadAction() {
        Log.write(5, CLASS_NAME, "endLoadAction ");
    }

    public void additionalLoadAction() {
        Log.write(5, CLASS_NAME, "additionalLoadAction ");
    }

    public void additionalExitAction() {
        Log.write(5, CLASS_NAME, "additionalExitAction ");
    }

    public void exitAction() {
        try {
            this.additionalExitAction();
            Log.write(4, CLASS_NAME, "exitAction");
            if (this.mainFrame.getExtendedState() == 6) {
                User.instance().setProperty("FrameMaximized", true);
            } else {
                User.instance().setProperty("FrameMaximized", false);
                Rectangle rectangle = this.mainFrame.getBounds();
                if (rectangle.x != this.mainFrame.start.x) {
                    User.instance().setProperty("FrameX", rectangle.x);
                }
                if (rectangle.y != this.mainFrame.start.y) {
                    User.instance().setProperty("FrameY", rectangle.y);
                }
                if (rectangle.width != this.mainFrame.start.width) {
                    User.instance().setProperty("FrameW", rectangle.width);
                }
                if (rectangle.height != this.mainFrame.start.height) {
                    User.instance().setProperty("FrameH", rectangle.height);
                }
            }
            RepMainFrame.getRepInstance().checkCaseShowChanged();
            this.closeMdiModalFrame();
            StartRtfProcessor.closeAllRtfUI();
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "trouble in exitAction", exception);
        }
    }

    public void lookAction(ActionEvent actionEvent) {
        try {
            this.actLook = actionEvent.getActionCommand();
            User.instance().setProperty("LookFeel", this.actLook);
            for (int i = 0; i < this.getLookAndFeelMenu().getItemCount(); ++i) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.getLookAndFeelMenu().getItem(i);
                jCheckBoxMenuItem.setState(jCheckBoxMenuItem.getText().equals(this.actLook));
            }
            ArrayList<UIManager.LookAndFeelInfo> arrayList = this.getLookAndFeels();
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : arrayList) {
                if (!lookAndFeelInfo.getName().equals(this.actLook)) continue;
                try {
                    UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                    this.desktop.setBackground(UIManager.getColor("window"));
                    SwingUtilities.updateComponentTreeUI(this);
                }
                catch (Exception exception) {
                    Log.write(2, CLASS_NAME, "lookAction set ", exception);
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "lookAction ", exception);
        }
    }

    public void arrangeAction() {
        try {
            ScreenUtil.writeDefaultBounds();
            Component[] componentArray = this.desktop.getComponents();
            ScreenUtil.setDesktopSize(this.desktop.getSize());
            for (Component component : componentArray) {
                if (!(component instanceof MdiNormalFrame)) continue;
                ((MdiNormalFrame)component).setDefaultBounds();
                if (!((MdiNormalFrame)component).isClosable()) continue;
                ((JInternalFrame)component).toFront();
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "arrangeAction ", exception);
        }
    }

    public void startEndTimer(long l) {
        this.endTime = l;
        this.desktopTimer.start();
        this.endLoadAction();
        Log.write(5, CLASS_NAME, "startEndTimer");
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setLookAndFeelMenu(JMenu jMenu) {
        this.lookAndFeelMenu = jMenu;
    }

    public JMenu getLookAndFeelMenu() {
        return this.lookAndFeelMenu;
    }

    public void setFirstLoadDone() {
        this.firstLoadDone = true;
    }

    public void startIsOver() {
        if (this.timeProbe != null) {
            User.instance().setProperty("sStart", this.timeProbe.getTimeSinceStart());
            this.timeProbe = null;
        }
    }

    public void doneResizeLayout() {
        ScreenUtil.setDesktopSize(this.desktop.getSize());
        this.arrangeTick = 5;
        if (this.arrangeThread == null && this.timeProbe == null) {
            this.arrangeThread = new Thread(){

                @Override
                public void run() {
                    while (MdiMainFrame.this.arrangeTick > 0) {
                        --MdiMainFrame.this.arrangeTick;
                        try {
                            Thread.sleep(24L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    MdiMainFrame.this.arrangeAction();
                    MdiMainFrame.this.arrangeThread = null;
                }
            };
            this.arrangeThread.start();
        }
    }

    private ArrayList<UIManager.LookAndFeelInfo> getLookAndFeels() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        ArrayList<UIManager.LookAndFeelInfo> arrayList = new ArrayList<UIManager.LookAndFeelInfo>(Arrays.asList(lookAndFeelInfoArray));
        try {
            Class.forName("com.jtattoo.plaf.acryl.AcrylLookAndFeel");
            arrayList.add(new UIManager.LookAndFeelInfo("Acryl", "com.jtattoo.plaf.acryl.AcrylLookAndFeel"));
            arrayList.add(new UIManager.LookAndFeelInfo("Aero", "com.jtattoo.plaf.aero.AeroLookAndFeel"));
            arrayList.add(new UIManager.LookAndFeelInfo("Aluminium", "com.jtattoo.plaf.aluminium.AluminiumLookAndFeel"));
            arrayList.add(new UIManager.LookAndFeelInfo("Bernstein", "com.jtattoo.plaf.bernstein.BernsteinLookAndFeel"));
            arrayList.add(new UIManager.LookAndFeelInfo("Fast", "com.jtattoo.plaf.fast.FastLookAndFeel"));
            arrayList.add(new UIManager.LookAndFeelInfo("Graphite", "com.jtattoo.plaf.graphite.GraphiteLookAndFeel"));
            arrayList.add(new UIManager.LookAndFeelInfo("HiFi", "com.jtattoo.plaf.hifi.HiFiLookAndFeel"));
            arrayList.add(new UIManager.LookAndFeelInfo("Luna", "com.jtattoo.plaf.luna.LunaLookAndFeel"));
            arrayList.add(new UIManager.LookAndFeelInfo("McWin", "com.jtattoo.plaf.mcwin.McWinLookAndFeel"));
            arrayList.add(new UIManager.LookAndFeelInfo("Mint", "com.jtattoo.plaf.mint.MintLookAndFeel"));
            arrayList.add(new UIManager.LookAndFeelInfo("Noire", "com.jtattoo.plaf.noire.NoireLookAndFeel"));
            arrayList.add(new UIManager.LookAndFeelInfo("Smart", "com.jtattoo.plaf.smart.SmartLookAndFeel"));
            arrayList.add(new UIManager.LookAndFeelInfo("Texture", "com.jtattoo.plaf.texture.TextureLookAndFeel"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.write(3, CLASS_NAME, "Additional Look and Feel not found");
        }
        return arrayList;
    }
}

