/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.apputil;

import ch.steph.apputil.MdiMainFrame;
import ch.steph.apputil.ScreenUtil;
import ch.steph.apputil.User;
import ch.steph.util.ImageTransferable;
import ch.steph.util.Log;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public abstract class MdiNormalFrame
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private MdiNormalFrame thisFrame;
    private int frameType;
    private String frameStr;
    private Rectangle actRect = new Rectangle(0, 0, 0, 0);

    public MdiNormalFrame(boolean bl, String string, int n, String string2) {
        super(string, true, bl, true, false);
        this.thisFrame = this;
        this.frameType = n;
        this.frameStr = string2;
        Log.write(4, this.getClass().getName(), "start " + n + ", " + string2);
        this.actRect = ScreenUtil.getWindowSize(n, string2);
        this.actRect.x = User.instance().getProperty(string2 + "X", this.actRect.x);
        this.actRect.y = User.instance().getProperty(string2 + "Y", this.actRect.y);
        this.actRect.width = User.instance().getProperty(string2 + "W", this.actRect.width);
        this.actRect.height = User.instance().getProperty(string2 + "H", this.actRect.height);
        this.setBounds(this.actRect);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MdiNormalFrame.this.doneResizeLayout();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                MdiNormalFrame.this.doneResizeLayout();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                MdiNormalFrame.this.doneResizeLayout();
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                MdiNormalFrame.this.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                MdiNormalFrame.this.activatedAction();
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
                MdiNormalFrame.this.closedAction();
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                MdiNormalFrame.this.closeAction();
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
            }
        });
        this.addPropertyChangeListener(propertyChangeEvent -> {
            if ("maximum".equalsIgnoreCase(propertyChangeEvent.getPropertyName())) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    this.maximizedAction();
                } else {
                    this.normalizedAction();
                }
            }
        });
        Log.write(5, this.getClass().getName(), "started " + n + ", " + string2 + "," + this.actRect.x + "," + this.actRect.y + "," + this.actRect.width + "," + this.actRect.height);
    }

    public void doneResizeLayout() {
        this.actRect = this.getNormalBounds();
        User.instance().setProperty(this.frameStr + "X", this.actRect.x);
        User.instance().setProperty(this.frameStr + "Y", this.actRect.y);
        User.instance().setProperty(this.frameStr + "W", this.actRect.width);
        User.instance().setProperty(this.frameStr + "H", this.actRect.height);
        Log.write(5, this.getClass().getName(), "doneResizeLayout for " + this.frameStr + "," + this.actRect.x + "," + this.actRect.y + "," + this.actRect.width + "," + this.actRect.height);
    }

    public Rectangle getStartRect() {
        return this.actRect;
    }

    public void activatedAction() {
        MdiMainFrame.getInstance().setIsSelected(this.thisFrame);
        this.requestFocus();
    }

    public void maximizedAction() {
    }

    public void normalizedAction() {
    }

    public void closeAction() {
        Log.write(4, this.getClass().getName(), "close");
        MdiMainFrame.getInstance().remove(this);
        this.dispose();
    }

    public void closedAction() {
        MdiMainFrame.getInstance().selectLastTopWindow();
        Log.write(5, this.getClass().getName(), "closed");
    }

    public void setDefaultBounds() {
        this.actRect = ScreenUtil.getWindowSize(this.frameType, this.frameStr);
        this.setBounds(this.actRect);
        User.instance().setProperty(this.frameStr + "X", this.actRect.x);
        User.instance().setProperty(this.frameStr + "Y", this.actRect.y);
        User.instance().setProperty(this.frameStr + "W", this.actRect.width);
        User.instance().setProperty(this.frameStr + "H", this.actRect.height);
        Log.write(5, this.getClass().getName(), "setDefaultBounds for " + this.frameType + ", " + this.frameStr + "," + this.actRect.x + "," + this.actRect.y + "," + this.actRect.width + "," + this.actRect.height);
    }

    public void copyFrameToClipboard() {
        try {
            this.getToolkit().getSystemClipboard().setContents(this.getFrameImage(), null);
            SwingUtilities.invokeLater(() -> {
                try {
                    Thread.sleep(10L);
                    String string = (String)this.getToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                    if (string != null && string.length() > 0 && !User.instance().isSuperUser() && string.length() >= 1000) {
                        StringSelection stringSelection = new StringSelection(string.substring(0, 1000) + "...");
                        this.getToolkit().getSystemClipboard().setContents(stringSelection, null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ImageTransferable getFrameImage() {
        Rectangle rectangle = this.getBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        this.paint(bufferedImage.getGraphics());
        return new ImageTransferable(bufferedImage);
    }
}

