/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.apputil;

import ch.steph.apputil.User;
import ch.steph.rep.MasterProp;
import ch.steph.repui.FirstIni;
import ch.steph.util.Log;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JFrame;

public class ScreenUtil {
    public static final int TYPE_MAIN = 1;
    public static final int TYPE_INPUT = 2;
    public static final int TYPE_INPUT2 = 3;
    public static final int TYPE_INPUT3 = 4;
    public static final int TYPE_RUBRIC = 5;
    public static final int TYPE_CASE = 6;
    public static final int TYPE_MULTI_MM = 7;
    public static final int TYPE_HELP = 8;
    public static final int TYPE_MED = 9;
    public static final int TYPE_CHANGE = 10;
    public static final int TYPE_INPUT4 = 11;
    public static final int TYPE_CR_AUTHOR = 12;
    public static final int TYPE_CONSULT = 13;
    public static final int TYPE_TABLE_EDIT = 14;
    private static final int TASK_LIST_HEIGHT = 40;
    private static final int MAX_WITH = 1280;
    private static final int MAX_WITH_HELP = 960;
    private static int firstMain = 26;
    private static int firstCase = 26;
    private static int firstMM = 48;
    private static boolean is3WinHigh = false;
    private static boolean is2WinHigh = false;
    private static boolean is2WinWidth = false;
    private static int maxHeight = 0;
    private static int maxWidth = 0;
    private static final int NEXT_DIFFX = 20;
    private static final int NEXT_DIFFY = 10;

    public static Rectangle getWindowSize(int n, String string) {
        Rectangle rectangle = new Rectangle(0, 0, 100, 100);
        switch (n) {
            default: {
                rectangle = new Rectangle(0, 0, maxWidth, maxHeight);
                break;
            }
            case 2: {
                rectangle = ScreenUtil.getInputWindowSize();
                break;
            }
            case 3: {
                rectangle = ScreenUtil.getInput2WindowSize();
                break;
            }
            case 4: {
                rectangle = ScreenUtil.getInput3WindowSize();
                break;
            }
            case 5: {
                rectangle = ScreenUtil.getRubricWindowSize();
                break;
            }
            case 6: {
                rectangle = ScreenUtil.getCaseShowWindowSize();
                break;
            }
            case 7: {
                rectangle = ScreenUtil.getMultiMMWindowSize();
                break;
            }
            case 8: {
                rectangle = ScreenUtil.getHelpWindowSize();
                break;
            }
            case 9: {
                rectangle = ScreenUtil.getMMWindowSize();
                break;
            }
            case 10: {
                rectangle = ScreenUtil.getChangeWindowSize();
                break;
            }
            case 11: {
                rectangle = ScreenUtil.getInput4WindowSize();
                break;
            }
            case 12: {
                rectangle = ScreenUtil.getChangeWindowSize();
                break;
            }
            case 13: {
                rectangle = ScreenUtil.getConsultWindowSize();
                break;
            }
            case 14: {
                rectangle = ScreenUtil.getTableEditWindowSize();
            }
        }
        rectangle.x = MasterProp.instance().getInteger(string + "X", rectangle.x);
        rectangle.y = MasterProp.instance().getInteger(string + "Y", rectangle.y);
        rectangle.width = MasterProp.instance().getInteger(string + "W", rectangle.width);
        rectangle.height = MasterProp.instance().getInteger(string + "H", rectangle.height);
        return rectangle;
    }

    public static Rectangle getFrameJWindowSize(Dimension dimension, JFrame jFrame) {
        is3WinHigh = true;
        is2WinHigh = true;
        is2WinWidth = true;
        if (jFrame != null) {
            new FirstIni(jFrame);
        }
        if ((firstMM = 100 - (firstMain = User.instance().getProperty("firstMain", 26)) - (firstCase = User.instance().getProperty("firstCase", 26))) < 0) {
            firstMM = 0;
        }
        maxHeight = dimension.height - 40;
        maxWidth = dimension.width;
        if (maxWidth > 1280) {
            maxWidth = 1280;
        }
        return new Rectangle(0, 0, maxWidth, maxHeight);
    }

    public static void setDesktopSize(Dimension dimension) {
        maxHeight = dimension.height;
        maxWidth = dimension.width;
    }

    public static boolean hasOpenMM() {
        if (maxHeight <= 0) {
            Log.write(3, "Constants", "hasOpenMM: no maxHeight");
        }
        return is3WinHigh;
    }

    public static boolean hasOpenRubric() {
        if (maxHeight <= 0) {
            Log.write(3, "Constants", "hasOpenRubric: no maxHeight");
        }
        return is2WinWidth;
    }

    private static Rectangle getInputWindowSize() {
        Rectangle rectangle = new Rectangle(0, 0, 320, 120);
        if (maxHeight <= 0) {
            Log.write(3, "Constants", "getInputWindow: no maxHeight");
        } else {
            if (is3WinHigh) {
                rectangle.y = 0;
                rectangle.height = maxHeight * firstMain / 100;
            } else if (is2WinHigh) {
                rectangle.y = 0;
                rectangle.height = maxHeight / 2;
            } else {
                rectangle.y = 0;
                rectangle.height = maxHeight;
            }
            rectangle.x = 0;
            rectangle.width = maxWidth;
            if (is2WinWidth) {
                rectangle.width = maxWidth / 2;
            }
        }
        return rectangle;
    }

    private static Rectangle getInput2WindowSize() {
        Rectangle rectangle = ScreenUtil.getInputWindowSize();
        rectangle.x += 20;
        rectangle.y += 10;
        return rectangle;
    }

    private static Rectangle getInput3WindowSize() {
        Rectangle rectangle = ScreenUtil.getInputWindowSize();
        rectangle.x += 40;
        rectangle.y += 20;
        return rectangle;
    }

    private static Rectangle getInput4WindowSize() {
        Rectangle rectangle = ScreenUtil.getInputWindowSize();
        rectangle.x += 60;
        rectangle.y += 30;
        return rectangle;
    }

    private static Rectangle getRubricWindowSize() {
        Rectangle rectangle = new Rectangle(50, 50, 320, 70);
        if (maxHeight <= 0) {
            Log.write(3, "Constants", "getRubricWindowSize: no maxHeight");
        } else {
            if (is3WinHigh) {
                rectangle.y = 0;
                rectangle.height = maxHeight * firstMain / 100;
            } else if (is2WinHigh) {
                rectangle.y = 0;
                rectangle.height = maxHeight / 2;
            } else {
                rectangle.y = 0;
                rectangle.height = maxHeight;
            }
            rectangle.x = 0;
            rectangle.width = maxWidth;
            if (is2WinWidth) {
                rectangle.x = maxWidth / 2;
                rectangle.width = maxWidth - rectangle.x;
            }
        }
        return rectangle;
    }

    private static Rectangle getConsultWindowSize() {
        Rectangle rectangle = new Rectangle(60, 60, 320, 60);
        if (maxHeight <= 0) {
            Log.write(3, "Constants", "getConsultWindowSize: no maxHeight");
        } else {
            if (is3WinHigh) {
                rectangle.y = 20;
                rectangle.height = maxHeight * firstMain / 100;
            } else if (is2WinHigh) {
                rectangle.y = 20;
                rectangle.height = maxHeight / 2;
            } else {
                rectangle.y = 0;
                rectangle.height = maxHeight;
            }
            rectangle.x = 0;
            rectangle.width = maxWidth;
            if (is2WinWidth) {
                rectangle.x = maxWidth * 48 / 100;
                rectangle.width = maxWidth / 2;
            }
        }
        return rectangle;
    }

    private static Rectangle getTableEditWindowSize() {
        Rectangle rectangle = ScreenUtil.getCaseShowWindowSize();
        rectangle.x += 20;
        rectangle.y = 0;
        rectangle.width -= 20;
        return rectangle;
    }

    private static Rectangle getCaseShowWindowSize() {
        Rectangle rectangle = new Rectangle(0, 120, 320, 120);
        if (maxHeight <= 0) {
            Log.write(3, "Constants", "getCaseShowWindowSize: no maxHeight");
        } else {
            rectangle.width = maxWidth;
            if (is3WinHigh) {
                rectangle.y = maxHeight * firstMain / 100;
                rectangle.height = maxHeight * firstCase / 100;
            } else if (is2WinHigh) {
                rectangle.y = maxHeight / 2;
                rectangle.height = maxHeight / 2;
            } else {
                rectangle.y = 0;
                rectangle.height = maxHeight;
            }
            rectangle.x = 0;
        }
        return rectangle;
    }

    private static Rectangle getMultiMMWindowSize() {
        Rectangle rectangle = new Rectangle(0, 240, 320, 120);
        if (maxHeight <= 0) {
            Log.write(3, "Constants", "getMultiMMWindowSize: no maxHeight");
        } else {
            rectangle.width = maxWidth;
            if (is3WinHigh) {
                rectangle.y = maxHeight * firstMain / 100 + maxHeight * firstCase / 100;
                rectangle.height = maxHeight * firstMM / 100 + 2;
            } else {
                rectangle.y = 0;
                rectangle.height = maxHeight;
            }
            rectangle.x = 0;
        }
        return rectangle;
    }

    private static Rectangle getHelpWindowSize() {
        Rectangle rectangle = ScreenUtil.getCaseShowWindowSize();
        rectangle.x += 20;
        rectangle.width -= 20;
        rectangle.y += 10;
        rectangle.height -= 10;
        if (is3WinHigh) {
            Rectangle rectangle2 = ScreenUtil.getMultiMMWindowSize();
            rectangle.height += rectangle2.height;
        }
        if (rectangle.width > 960) {
            rectangle.width = 960;
        }
        return rectangle;
    }

    private static Rectangle getMMWindowSize() {
        Rectangle rectangle = ScreenUtil.getMultiMMWindowSize();
        rectangle.y -= 10;
        rectangle.height += 10;
        if (is2WinWidth) {
            rectangle.x += rectangle.width / 2;
            rectangle.width /= 2;
        } else {
            rectangle.x += 20;
            rectangle.width -= 20;
        }
        return rectangle;
    }

    private static Rectangle getChangeWindowSize() {
        Rectangle rectangle = ScreenUtil.getHelpWindowSize();
        Rectangle rectangle2 = ScreenUtil.getCaseShowWindowSize();
        rectangle.x += rectangle2.x + 20;
        rectangle.width = rectangle2.width - 60;
        rectangle.y = 0;
        return rectangle;
    }

    public static Rectangle getCaseNoteWindowSize(Dimension dimension) {
        return new Rectangle(dimension.width / 2, 0, dimension.width / 2, dimension.height - 40);
    }

    public static Rectangle getConsultWindowSize(Dimension dimension) {
        return new Rectangle(dimension.width / 2 - 20, 20, dimension.width / 2 + 20, dimension.height - 40 - 20);
    }

    public static Rectangle getPatientWindowSize() {
        return new Rectangle(0, 0, maxWidth, maxHeight);
    }

    public static void writeDefaultBounds() {
        Rectangle rectangle = ScreenUtil.getInput2WindowSize();
        User.instance().setProperty("inp2X", rectangle.x);
        User.instance().setProperty("inp2Y", rectangle.y);
        User.instance().setProperty("inp2W", rectangle.width);
        User.instance().setProperty("inp2H", rectangle.height);
        rectangle = ScreenUtil.getInput3WindowSize();
        User.instance().setProperty("compX", rectangle.x);
        User.instance().setProperty("compY", rectangle.y);
        User.instance().setProperty("compW", rectangle.width);
        User.instance().setProperty("compH", rectangle.height);
        rectangle = ScreenUtil.getRubricWindowSize();
        User.instance().setProperty("rubricX", rectangle.x);
        User.instance().setProperty("rubricY", rectangle.y);
        User.instance().setProperty("rubricW", rectangle.width);
        User.instance().setProperty("rubricH", rectangle.height);
        rectangle = ScreenUtil.getCaseShowWindowSize();
        User.instance().setProperty("resX", rectangle.x);
        User.instance().setProperty("resY", rectangle.y);
        User.instance().setProperty("resW", rectangle.width);
        User.instance().setProperty("resH", rectangle.height);
        rectangle = ScreenUtil.getMultiMMWindowSize();
        User.instance().setProperty("multiX", rectangle.x);
        User.instance().setProperty("multiY", rectangle.y);
        User.instance().setProperty("multiW", rectangle.width);
        User.instance().setProperty("multiH", rectangle.height);
        rectangle = ScreenUtil.getHelpWindowSize();
        User.instance().setProperty("helpX", rectangle.x);
        User.instance().setProperty("helpY", rectangle.y);
        User.instance().setProperty("helpW", rectangle.width);
        User.instance().setProperty("helpH", rectangle.height);
        rectangle = ScreenUtil.getMMWindowSize();
        User.instance().setProperty("medX", rectangle.x);
        User.instance().setProperty("medY", rectangle.y);
        User.instance().setProperty("medW", rectangle.width);
        User.instance().setProperty("medH", rectangle.height);
        rectangle = ScreenUtil.getChangeWindowSize();
        User.instance().setProperty("changeX", rectangle.x);
        User.instance().setProperty("changeY", rectangle.y);
        User.instance().setProperty("changeW", rectangle.width);
        User.instance().setProperty("changeH", rectangle.height);
    }

    public static void copyBoundsToMaster() {
        Rectangle rectangle = ScreenUtil.getInputWindowSize();
        MasterProp.instance().setInteger("MainX", User.instance().getProperty("MainX", rectangle.x));
        MasterProp.instance().setInteger("MainY", User.instance().getProperty("MainY", rectangle.y));
        MasterProp.instance().setInteger("MainW", User.instance().getProperty("MainW", rectangle.width));
        MasterProp.instance().setInteger("MainH", User.instance().getProperty("MainH", rectangle.height));
        rectangle = ScreenUtil.getInput2WindowSize();
        MasterProp.instance().setInteger("inp2X", User.instance().getProperty("inp2X", rectangle.x));
        MasterProp.instance().setInteger("inp2Y", User.instance().getProperty("inp2Y", rectangle.y));
        MasterProp.instance().setInteger("inp2W", User.instance().getProperty("inp2W", rectangle.width));
        MasterProp.instance().setInteger("inp2H", User.instance().getProperty("inp2H", rectangle.height));
        rectangle = ScreenUtil.getRubricWindowSize();
        MasterProp.instance().setInteger("rubricX", User.instance().getProperty("rubricX", rectangle.x));
        MasterProp.instance().setInteger("rubricY", User.instance().getProperty("rubricY", rectangle.y));
        MasterProp.instance().setInteger("rubricW", User.instance().getProperty("rubricW", rectangle.width));
        MasterProp.instance().setInteger("rubricH", User.instance().getProperty("rubricH", rectangle.height));
        rectangle = ScreenUtil.getCaseShowWindowSize();
        MasterProp.instance().setInteger("resX", User.instance().getProperty("resX", rectangle.x));
        MasterProp.instance().setInteger("resY", User.instance().getProperty("resY", rectangle.y));
        MasterProp.instance().setInteger("resW", User.instance().getProperty("resW", rectangle.width));
        MasterProp.instance().setInteger("resH", User.instance().getProperty("resH", rectangle.height));
        rectangle = ScreenUtil.getMultiMMWindowSize();
        MasterProp.instance().setInteger("multiX", User.instance().getProperty("multiX", rectangle.x));
        MasterProp.instance().setInteger("multiY", User.instance().getProperty("multiY", rectangle.y));
        MasterProp.instance().setInteger("multiW", User.instance().getProperty("multiW", rectangle.width));
        MasterProp.instance().setInteger("multiH", User.instance().getProperty("multiH", rectangle.height));
        rectangle = ScreenUtil.getHelpWindowSize();
        MasterProp.instance().setInteger("helpX", User.instance().getProperty("helpX", rectangle.x));
        MasterProp.instance().setInteger("helpY", User.instance().getProperty("helpY", rectangle.y));
        MasterProp.instance().setInteger("helpW", User.instance().getProperty("helpW", rectangle.width));
        MasterProp.instance().setInteger("helpH", User.instance().getProperty("helpH", rectangle.height));
        rectangle = ScreenUtil.getMMWindowSize();
        MasterProp.instance().setInteger("medX", User.instance().getProperty("medX", rectangle.x));
        MasterProp.instance().setInteger("medY", User.instance().getProperty("medY", rectangle.y));
        MasterProp.instance().setInteger("medW", User.instance().getProperty("medW", rectangle.width));
        MasterProp.instance().setInteger("medH", User.instance().getProperty("medH", rectangle.height));
        rectangle = ScreenUtil.getInput3WindowSize();
        MasterProp.instance().setInteger("compX", User.instance().getProperty("compX", rectangle.x));
        MasterProp.instance().setInteger("compY", User.instance().getProperty("compY", rectangle.y));
        MasterProp.instance().setInteger("compW", User.instance().getProperty("compW", rectangle.width));
        MasterProp.instance().setInteger("compH", User.instance().getProperty("compH", rectangle.height));
        rectangle = ScreenUtil.getChangeWindowSize();
        MasterProp.instance().setInteger("changeX", User.instance().getProperty("changeX", rectangle.x));
        MasterProp.instance().setInteger("changeY", User.instance().getProperty("changeY", rectangle.y));
        MasterProp.instance().setInteger("changeW", User.instance().getProperty("changeW", rectangle.width));
        MasterProp.instance().setInteger("changeH", User.instance().getProperty("changeH", rectangle.height));
    }
}

