/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.apputil;

import ch.steph.apputil.StringResource;
import ch.steph.reputil.FontUtil;
import ch.steph.util.IconUtil;
import ch.steph.util.Log;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class StartBox
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Timer timer;
    private String[] text = new String[]{StringResource.getString("startInfo_1"), StringResource.getString("startInfo_2"), StringResource.getString("startInfo_3")};

    public StartBox(JFrame jFrame) {
        super((Frame)jFrame, false);
        Log.write(5, this.getClass().getName(), "start");
        this.setTitle(StringResource.getString("startInfo_title"));
        this.setFont(FontUtil.getChangedFont());
        this.setUndecorated(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder()));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(IconUtil.getImageIcon(this, "icon/start.jpg"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        for (String string : this.text) {
            JLabel jLabel2 = new JLabel(string, 0);
            gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
            jLabel2.setFont(FontUtil.getChangedFont());
            jPanel.add(jLabel2);
        }
        this.getContentPane().add(jPanel);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0 + (dimension.width - rectangle.width) / 2;
        rectangle.y = 0 + (dimension.height - rectangle.height) / 2;
        this.setBounds(rectangle);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                StartBox.this.closeAction();
            }
        });
        this.timer = new Timer(100, actionEvent -> this.timerTick());
    }

    protected void closeAction() {
        this.timer.stop();
        this.setVisible(false);
        Log.write(4, this.getClass().getName(), "end");
    }

    protected void timerTick() {
        this.toFront();
    }
}

