/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.apputil;

import ch.steph.apputil.User;
import ch.steph.util.Log;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringResource {
    private static final String BUNDLE_NAME = "ch.steph.apputil.StringResource";
    private static ResourceBundle resourceBundle = null;

    private StringResource() {
    }

    private static void init() {
        if (resourceBundle == null) {
            String string = User.instance().getProperty("Language", Locale.getDefault().getLanguage());
            Locale locale = new Locale(string);
            locale = locale.equals(Locale.ENGLISH) ? Locale.ENGLISH : Locale.GERMAN;
            Locale.setDefault(locale);
            resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }
    }

    public static String getString(String string) {
        try {
            StringResource.init();
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            Log.write(3, "StringResource", "String not found: " + string);
            return "!" + string + "!";
        }
    }
}

