/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.apputil;

import ch.steph.rep.CaseResult;
import ch.steph.rep.MultiTxtSetter;
import ch.steph.rep.SearchThread;
import ch.steph.rep.ToolData;
import ch.steph.reputil.MmUtil;
import ch.steph.reputil.RepUtil;
import ch.steph.util.GetDataFile;
import ch.steph.util.IniBase;

public class User {
    private static User user;
    private IniBase ini = new IniBase(GetDataFile.getPropertyFile());
    private IniBase addonProps = null;
    private SearchThread inputSearchThread;
    private SearchThread valueSearchThread;
    private SearchThread compareSearchThread;
    private CaseResult caseResult;
    private int actRepIndex;
    private String[] mmTitles = null;

    private User() {
        String string = GetDataFile.getAddonPropertyFile();
        if (string != null && string.length() > 0) {
            this.addonProps = new IniBase(string);
        }
    }

    public static User instance() {
        if (user == null) {
            user = new User();
        }
        return user;
    }

    public String getUserName() {
        return this.getProperty("Name", "");
    }

    public boolean isSuperUser() {
        return this.getUserName().contains("SuperUser") && ToolData.checkOk(1, 0);
    }

    public boolean getProperty(String string, boolean bl) {
        boolean bl2 = this.ini.getBoolean(string, bl);
        if (this.addonProps != null && bl2 == bl) {
            bl2 = this.addonProps.getBoolean(string, bl);
        }
        return bl2;
    }

    public void setProperty(String string, boolean bl) {
        this.ini.setBoolean(string, bl);
    }

    public int getProperty(String string, int n) {
        int n2 = this.ini.getInteger(string, n);
        if (this.addonProps != null && n2 == n) {
            n2 = this.addonProps.getInteger(string, n);
        }
        return n2;
    }

    public void setProperty(String string, int n) {
        this.ini.setInteger(string, n);
    }

    public long getProperty(String string, long l) {
        long l2 = this.ini.getLong(string, l);
        if (this.addonProps != null && l2 == l) {
            l2 = this.addonProps.getLong(string, l);
        }
        return l2;
    }

    public void setProperty(String string, long l) {
        this.ini.setLong(string, l);
    }

    public String getProperty(String string, String string2) {
        String string3 = this.ini.getString(string, string2);
        if (this.addonProps != null && string3 != null && string3.equals(string2)) {
            string3 = this.addonProps.getString(string, string2);
        }
        return string3;
    }

    public void setProperty(String string, String string2) {
        this.ini.setString(string, string2);
    }

    public void reloadProperties() {
        this.ini = null;
        this.ini = new IniBase(GetDataFile.getPropertyFile());
    }

    public SearchThread getNewInputSearchThread(int n) {
        this.actRepIndex = n;
        if (this.inputSearchThread != null) {
            this.inputSearchThread.stopThreads();
            this.inputSearchThread = null;
        }
        this.inputSearchThread = new SearchThread(n);
        return this.inputSearchThread;
    }

    public SearchThread getInputSearchThread() {
        return this.inputSearchThread;
    }

    public SearchThread resetInputSearchThread() {
        if (this.inputSearchThread != null) {
            this.inputSearchThread.stopThreads();
        }
        return this.inputSearchThread;
    }

    public SearchThread getNewValueSearchThread(int n) {
        this.actRepIndex = n;
        if (this.valueSearchThread != null) {
            this.valueSearchThread.stopThreads();
            this.valueSearchThread = null;
        }
        this.valueSearchThread = new SearchThread(n);
        return this.valueSearchThread;
    }

    public SearchThread getValueSearchThread() {
        return this.valueSearchThread;
    }

    public SearchThread getNewCompareSearchThread(int n) {
        if (this.compareSearchThread != null) {
            this.compareSearchThread.stopThreads();
            this.compareSearchThread = null;
        }
        this.compareSearchThread = new SearchThread(n);
        return this.compareSearchThread;
    }

    public SearchThread getCompareSearchThread() {
        return this.compareSearchThread;
    }

    public int getCaseResultLength() {
        if (this.caseResult == null) {
            return 0;
        }
        return this.caseResult.getResultCount();
    }

    public CaseResult getNewCaseResult(MultiTxtSetter multiTxtSetter) {
        this.caseResult = new CaseResult(multiTxtSetter);
        return this.caseResult;
    }

    public CaseResult getCaseResult() {
        return this.caseResult;
    }

    public int getActRepIndex() {
        return this.actRepIndex;
    }

    public void setActRepIndex(int n) {
        User.instance().setProperty("RepNr", n);
        this.actRepIndex = n;
    }

    public String[] getRepTitles(boolean bl) {
        String[] stringArray = RepUtil.getRepTitles();
        for (int i = 1; i < 62; ++i) {
            if (stringArray[i].length() <= 0) continue;
            if (!ToolData.checkOk(1, i)) {
                stringArray[i] = "";
            } else if (this.isTitleYearNotOk(stringArray[i])) {
                stringArray[i] = "";
            }
            if (bl) continue;
            boolean bl2 = true;
            if (i < 3) {
                bl2 = false;
            }
            if (this.getProperty("useRep" + i, bl2)) continue;
            stringArray[i] = "";
        }
        return stringArray;
    }

    public String[] getMmTitles() {
        if (this.mmTitles == null) {
            String[] stringArray = MmUtil.getMmTitles();
            this.mmTitles = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.mmTitles[i] = stringArray[i];
                if (this.mmTitles[i].length() <= 0) continue;
                if (!ToolData.checkOk(2, i)) {
                    this.mmTitles[i] = "";
                    continue;
                }
                if (!this.isTitleYearNotOk(this.mmTitles[i])) continue;
                this.mmTitles[i] = "";
            }
        }
        return this.mmTitles;
    }

    private boolean isTitleYearNotOk(String string) {
        int n;
        if (string == null) {
            return false;
        }
        if ((string = RepUtil.stripFxFromTitle(string)).length() < 4) {
            return false;
        }
        String string2 = string.substring(string.length() - 4);
        if (string2.charAt(0) != '2') {
            return false;
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            n = 0;
        }
        return n > ToolData.getAppYear();
    }
}

