/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.apputil;

import ch.steph.apputil.LicStat;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.Rep;
import ch.steph.util.Constants;
import ch.steph.util.DesktopUtils;
import ch.steph.util.FileLn;
import ch.steph.util.GetDataFile;
import ch.steph.util.IconUtil;
import ch.steph.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VersionHint {
    public VersionHint(JFrame jFrame) {
        if (User.instance().getProperty("checkVersion", true)) {
            Rep.getExecutor().execute(() -> {
                try {
                    String string = "Version " + Constants.getVersion();
                    URL uRL = new URL("https://" + StringResource.getString("www_app_adr") + "/version.txt");
                    FileLn fileLn = GetDataFile.getDataFileRd(uRL);
                    if (fileLn.isOpenRead()) {
                        String string2;
                        for (string2 = fileLn.readLn(); string2 != null && string2.length() > 0 && !Character.isLetter(string2.charAt(0)); string2 = string2.substring(1)) {
                        }
                        String string3 = User.instance().getProperty("committedVersion", string);
                        if (string2 != null && !string2.equals(string3)) {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            String string4 = fileLn.readLn();
                            while (string4 != null) {
                                arrayList.add(string4);
                                string4 = fileLn.readLn();
                            }
                            fileLn.close();
                            new VersionHintBox(jFrame, string2, arrayList.toArray(new String[0])).setVisible(true);
                        } else {
                            Log.write(4, this.getClass().getName(), "Version hint not necessary for " + string2);
                            fileLn.close();
                        }
                    }
                }
                catch (Exception exception) {
                    Log.write(3, this.getClass().getName(), "Exception retrieving version ", exception);
                }
            });
        }
        this.sendStat();
    }

    public void sendStat() {
        int n;
        if (User.instance().getProperty("cCheck", "0000").equals(new SimpleDateFormat("ddMM").format(new Date())) && (n = User.instance().getProperty("cCCount", 0)) < 20) {
            User.instance().setProperty("cCCount", n + 1);
            return;
        }
        Rep.getExecutor().execute(() -> {
            try {
                Thread.sleep(16000L);
                String string = User.instance().getProperty("validatedName", "");
                if (string == null || string.length() == 0) {
                    string = User.instance().getUserName();
                }
                LicStat.sendGetStat("stat", string);
                User.instance().setProperty("cCheck", new SimpleDateFormat("ddMM").format(new Date()));
                User.instance().setProperty("cCCount", 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private class VersionHintBox
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private JButton okButton;
        private JCheckBox hintCheckbox;
        private String newVersion;

        public VersionHintBox(JFrame jFrame, String string, String[] stringArray) {
            JComponent jComponent;
            JLabel jLabel;
            JLabel jLabel2;
            super((Frame)jFrame, true);
            this.newVersion = string;
            Log.write(4, this.getClass().getName(), "start");
            this.setTitle("Update-Information");
            KeyListener keyListener = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    Log.write(5, this.getClass().getName(), keyEvent.paramString());
                    VersionHintBox.this.mainKeyPressed(keyEvent);
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                }
            };
            this.getContentPane().addKeyListener(keyListener);
            this.addKeyListener(keyListener);
            this.getContentPane().setLayout(new BorderLayout());
            ImageIcon imageIcon = IconUtil.getImageIcon(this, "icon/prog1.jpg");
            if (imageIcon != null) {
                jLabel2 = new JLabel(imageIcon);
                jLabel2.setBorder(BorderFactory.createLoweredBevelBorder());
                this.getContentPane().add((Component)jLabel2, "West");
            }
            if ((imageIcon = IconUtil.getImageIcon(this, "icon/prog3.jpg")) != null) {
                jLabel2 = new JLabel(imageIcon);
                jLabel2.setBorder(BorderFactory.createLoweredBevelBorder());
                this.getContentPane().add((Component)jLabel2, "East");
            }
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(gridBagLayout);
            imageIcon = IconUtil.getImageIcon(this, "icon/prog4.jpg");
            if (imageIcon != null) {
                jLabel = new JLabel(" ", 0);
                gridBagLayout.setConstraints(jLabel, gridBagConstraints);
                jPanel.add(jLabel);
                jComponent = new JPanel();
                jLabel2 = new JLabel(imageIcon);
                jLabel2.setBorder(BorderFactory.createLoweredBevelBorder());
                gridBagLayout.setConstraints(jComponent, gridBagConstraints);
                jComponent.add(jLabel2);
                jPanel.add(jComponent);
            }
            jLabel = new JLabel(" ", 0);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            jComponent = new JLabel("Eine neue jRep-" + string + " ist zum Download bereit auf " + StringResource.getString("www_app_adr"), 0);
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            jPanel.add(jComponent);
            jLabel = new JLabel(" ", 0);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            for (String object2 : stringArray) {
                JLabel jLabel3 = new JLabel(" " + object2 + " ", 2);
                gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
                jPanel.add(jLabel3);
            }
            jLabel2 = new JLabel(" ", 0);
            gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
            jPanel.add(jLabel2);
            this.hintCheckbox = new JCheckBox("Diesen Hinweis nicht mehr anzeigen");
            gridBagLayout.setConstraints(this.hintCheckbox, gridBagConstraints);
            jPanel.add(this.hintCheckbox);
            this.hintCheckbox.addKeyListener(keyListener);
            this.hintCheckbox.setSelected(false);
            jLabel = new JLabel(" ", 0);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            this.getContentPane().add((Component)jPanel, "Center");
            JPanel jPanel2 = new JPanel();
            jLabel = new JLabel(" ", 0);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
            this.okButton = new JButton(StringResource.getString("button_ok"));
            this.okButton.addActionListener(actionEvent -> this.buttonOkAction());
            jPanel2.add(this.okButton);
            jPanel2.add(new JLabel(StringResource.getString("button_between_middle")));
            JButton jButton = new JButton("Download");
            jButton.addActionListener(actionEvent -> {
                String string = "https://jrep.de/index.htm#download";
                DesktopUtils.callSystemBrowserAvailable(string);
            });
            jPanel2.add(jButton);
            this.getRootPane().setDefaultButton(this.okButton);
            this.okButton.getCursor();
            this.getContentPane().add((Component)jPanel2, "South");
            this.okButton.addKeyListener(keyListener);
            this.pack();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    VersionHintBox.this.closeAction();
                }
            });
            Rectangle rectangle = this.getParent().getBounds();
            Rectangle rectangle2 = this.getBounds();
            rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
            rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
            if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
                rectangle2.x = rectangle.x + rectangle.width - rectangle2.width;
            }
            if (rectangle2.x < 0) {
                rectangle2.x = 0;
            }
            if (rectangle2.y < 0) {
                rectangle2.y = 0;
            }
            this.setBounds(rectangle2);
        }

        protected void mainKeyPressed(KeyEvent keyEvent) {
            try {
                if (!keyEvent.isConsumed()) {
                    char c = keyEvent.getKeyChar();
                    if (c == '\u001b') {
                        keyEvent.consume();
                        this.closeAction();
                    }
                    if (c == '\n') {
                        keyEvent.consume();
                        this.closeAction();
                    }
                }
            }
            catch (Exception exception) {
                Log.write(2, this.getClass().getName(), "mainKey", exception);
            }
        }

        protected void buttonOkAction() {
            if (this.hintCheckbox != null && this.hintCheckbox.isSelected()) {
                User.instance().setProperty("committedVersion", this.newVersion);
            }
            this.closeAction();
        }

        protected void closeAction() {
            this.setVisible(false);
            Log.write(4, this.getClass().getName(), "end");
        }
    }
}

