/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.rep;

import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.MultiTxtSetter;
import ch.steph.repdata.CaseRubric;
import ch.steph.repdata.CaseVector;
import ch.steph.repdata.RepDataPool;
import ch.steph.repdata.Rubric;
import ch.steph.reputil.FilterUtil;
import ch.steph.reputil.RepUtil;
import ch.steph.reputil.RubricUtil;
import ch.steph.util.FileCsv;
import ch.steph.util.FileCsvKey;
import ch.steph.util.FileLn;
import ch.steph.util.Log;
import ch.steph.util.TimeProbe;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;

public class CaseResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MEDI_NOT_USED = -1;
    private static final int FILTER_START_VALUE = 0;
    public static final int FILTER_MEDI = 0;
    private int maxResultLen;
    private String[] columnTitle;
    private String[] columnFilter;
    private String[] mediPlusData;
    private int[] columnRating;
    private int[] columnHits;
    private int[] columnPos;
    private int[] columnDiff;
    private boolean[] columnSetNull;
    private CaseVector allResults = new CaseVector();
    private int polarCount;
    private CaseRubric caseRubricToAdd;
    private boolean showInWindow;
    private boolean buildRating;
    private int[] resultIndices;
    private int maxResultIndex;
    private int resultCountForShow;
    private boolean sortByRubric = false;
    private int[] sortByRubricArray;
    private String filterString = "";
    private int filterType = 0;
    private transient MultiTxtSetter multiTxtSetter;
    private boolean showSortByRubric;
    private boolean showSortByPolar;
    private boolean showColoredFamily = true;
    private boolean showColoredMiasma = true;
    private boolean changed = false;
    private String caseName = null;
    private String patName = null;

    public CaseResult(MultiTxtSetter multiTxtSetter) {
        Log.write(5, this.getClass().getName(), "start");
        this.columnTitle = new String[1];
        this.columnFilter = new String[1];
        this.mediPlusData = null;
        this.multiTxtSetter = multiTxtSetter;
        this.setResultArrays();
        this.maxResultLen = User.instance().getProperty("MaxResultLen", 2000) + 1;
        this.resultIndices = new int[this.maxResultLen];
        if (multiTxtSetter != null) {
            multiTxtSetter.setNewMedica(null, null, null, null, 0, null, null, 0);
        }
    }

    public String[] getFilterText() {
        String[] stringArray = new String[]{StringResource.getString("filter_med"), StringResource.getString("filter_fam"), StringResource.getString("filter_stop")};
        if (this.columnFilter == null) {
            stringArray = new String[]{StringResource.getString("filter_med")};
        }
        return stringArray;
    }

    private void setResultArrays() {
        this.columnRating = new int[this.columnTitle.length];
        this.columnHits = new int[this.columnTitle.length];
        this.columnPos = new int[this.columnTitle.length];
        this.columnDiff = new int[this.columnTitle.length];
        this.columnSetNull = new boolean[this.columnTitle.length];
    }

    public int getResultCount() {
        if (this.allResults == null) {
            return 0;
        }
        return this.allResults.size() - this.polarCount;
    }

    private int[] checkForAllMedis(String[] stringArray, int[] nArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n;
            int[] nArray2 = new int[stringArray.length];
            Vector<String> vector = new Vector<String>();
            int n2 = 0;
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < stringArray.length; ++n) {
                nArray2[n] = -1;
                if (stringArray[n] == null || nArray != null && (n >= nArray.length || nArray[n] <= 0)) continue;
                for (int i = 1; i < this.columnTitle.length && nArray2[n] == -1; ++i) {
                    if (this.columnTitle[i] == null || !this.columnTitle[i].equalsIgnoreCase(stringArray[n])) continue;
                    nArray2[n] = i - 1;
                }
                if (nArray2[n] != -1) continue;
                vector.addElement(stringArray[n]);
                nArray2[n] = this.columnTitle.length + n2 - 1;
                ++n2;
                stringBuilder.append(stringArray[n]).append(", ");
            }
            if (stringBuilder.length() > 0) {
                Log.write(5, this.getClass().getName(), "load case, new medis: " + String.valueOf(stringBuilder));
            }
            if (vector.size() > 0) {
                int n3;
                n = User.instance().getActRepIndex();
                String[] stringArray2 = this.columnTitle;
                String[] stringArray3 = this.columnFilter;
                String[] stringArray4 = RepDataPool.getInstance().getRepHeader(n).getMediPlusData();
                if (stringArray4 != null && this.mediPlusData == null) {
                    this.mediPlusData = new String[this.columnTitle.length];
                    this.mediPlusData[0] = stringArray4[0];
                }
                String[] stringArray5 = this.mediPlusData;
                this.columnTitle = new String[this.columnTitle.length + vector.size()];
                this.columnFilter = new String[this.columnTitle.length + vector.size()];
                if (this.mediPlusData != null) {
                    this.mediPlusData = new String[this.columnTitle.length + vector.size()];
                }
                for (n3 = 0; n3 < stringArray2.length; ++n3) {
                    this.columnTitle[n3] = stringArray2[n3];
                    this.columnFilter[n3] = stringArray3[n3];
                    if (this.mediPlusData == null) continue;
                    this.mediPlusData[n3] = stringArray5[n3];
                }
                for (n3 = 0; n3 < vector.size(); ++n3) {
                    this.columnTitle[n3 + stringArray2.length] = (String)vector.elementAt(n3);
                    this.columnFilter[n3 + stringArray2.length] = FilterUtil.getFilterOfMedi(this.columnTitle[n3 + stringArray2.length]);
                    if (this.mediPlusData == null) continue;
                    this.mediPlusData[n3 + stringArray2.length] = RepDataPool.getInstance().getRepHeader(n).getMediPlusData(this.columnTitle[n3 + stringArray2.length]);
                }
                this.setResultArrays();
            }
            return nArray2;
        }
        return null;
    }

    public boolean addLineThenBuild(Rubric rubric, boolean bl, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        User.instance().setProperty("cAdded", User.instance().getProperty("cAdded", 0) + 1);
        if (rubric != null && rubric.hasValues()) {
            this.checkForAllMedis(rubric.getMedis(), rubric.getValues());
            rubric = rubric.getCopy(this.columnTitle);
            this.caseRubricToAdd = new CaseRubric(rubric, null);
            if (bl) {
                this.caseRubricToAdd.subOneFactor();
            }
            this.caseRubricToAdd.setRemarkMedis(stringArray);
            this.caseRubricToAdd.setRemarkArray(stringArray2);
            this.caseRubricToAdd.setRemarkDates(stringArray3);
            this.showInWindow = true;
            this.buildRating = true;
            this.changed = true;
            return true;
        }
        return false;
    }

    public boolean addLineThenBuild(String[] stringArray, String string, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5) {
        User.instance().setProperty("cAdded", User.instance().getProperty("cAdded", 0) + 1);
        int[] nArray = this.getRubricValues(stringArray2);
        int[] nArray2 = this.checkForAllMedis(stringArray, nArray);
        this.caseRubricToAdd = new CaseRubric(string, nArray, nArray2, this.columnTitle);
        this.caseRubricToAdd.setRemarkMedis(stringArray3);
        this.caseRubricToAdd.setRemarkArray(stringArray4);
        this.caseRubricToAdd.setRemarkDates(stringArray5);
        this.showInWindow = true;
        this.buildRating = true;
        this.changed = true;
        return true;
    }

    public boolean addLineAndBuild(Rubric rubric, boolean bl) {
        User.instance().setProperty("cAdded", User.instance().getProperty("cAdded", 0) + 1);
        if (rubric != null && rubric.hasValues()) {
            this.checkForAllMedis(rubric.getMedis(), rubric.getValues());
            rubric = rubric.getCopy(this.columnTitle);
            this.caseRubricToAdd = new CaseRubric(rubric, null);
            if (bl) {
                this.showInWindow = true;
                this.buildRating = true;
            } else {
                this.showInWindow = false;
                this.buildRating = false;
            }
            this.changed = true;
            this.buildResult();
            return true;
        }
        return false;
    }

    private int[] getRubricValues(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        Arrays.fill(nArray, 0);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = 0;
            String string = stringArray[i];
            if (string != null && string.length() > 0) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            nArray[i] = n;
        }
        return nArray;
    }

    private String[] getAddonString(String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string.substring(string.indexOf(58) + 1));
        arrayList.addAll(Arrays.asList(stringArray));
        return arrayList.toArray(new String[0]);
    }

    public boolean sortAgainThenBuild() {
        this.caseRubricToAdd = null;
        this.showInWindow = true;
        this.buildRating = false;
        return true;
    }

    public boolean sortByRubricIdent() {
        this.allResults.sort();
        this.caseRubricToAdd = null;
        this.showInWindow = true;
        this.buildRating = false;
        return true;
    }

    public boolean sortByRubricCount() {
        this.allResults.sortByCount();
        this.caseRubricToAdd = null;
        this.showInWindow = true;
        this.buildRating = false;
        return true;
    }

    public void changeActRep(int n) {
        for (int i = 1; i < this.columnTitle.length; ++i) {
            this.columnTitle[i] = RepDataPool.getInstance().getRepHeader(n).getMediStringOfRep(this.columnTitle[i]);
        }
        String[] stringArray = RepDataPool.getInstance().getRepHeader(n).getMediPlusData();
        if (stringArray == null) {
            this.mediPlusData = null;
        } else {
            this.mediPlusData = new String[this.columnTitle.length];
            this.mediPlusData[0] = stringArray[0];
            for (int i = 1; i < this.columnTitle.length; ++i) {
                this.mediPlusData[i] = RepDataPool.getInstance().getRepHeader(n).getMediPlusData(this.columnTitle[i]);
            }
        }
        this.caseRubricToAdd = null;
        this.showInWindow = true;
        this.buildRating = false;
    }

    public boolean buildRatingAndSortAgainThenBuild() {
        this.caseRubricToAdd = null;
        this.showInWindow = true;
        this.buildRating = true;
        return true;
    }

    public boolean sortByRubricThenBuild(int n) {
        if (n >= this.titleSize() && this.allResults != null && this.allResults.size() >= n - this.titleSize()) {
            this.showSortByRubric = true;
            this.showSortByPolar = false;
            this.sortByRubric = true;
            CaseRubric caseRubric = this.allResults.elementAt(n - this.titleSize());
            this.sortByRubricArray = caseRubric.getValues();
            this.caseRubricToAdd = null;
            this.showInWindow = true;
            this.buildRating = false;
            return true;
        }
        return false;
    }

    public boolean sortByPolarThenBuild() {
        if (this.allResults != null && this.columnDiff != null) {
            this.showSortByPolar = true;
            this.showSortByRubric = false;
            this.sortByRubric = true;
            this.sortByRubricArray = new int[this.columnDiff.length];
            if (User.instance().getProperty("sortPolarSimple", false)) {
                for (int i = 0; i < this.columnDiff.length && i < this.columnRating.length; ++i) {
                    this.sortByRubricArray[i] = this.columnDiff[i];
                }
            } else if (User.instance().getProperty("SortByRating", false)) {
                for (int i = 0; i < this.columnDiff.length && i < this.columnRating.length; ++i) {
                    this.sortByRubricArray[i] = this.columnDiff[i] + this.columnRating[i] * User.instance().getProperty("PolarHitFactor", 100);
                    if (this.columnDiff[i] >= -9) continue;
                    this.sortByRubricArray[i] = 0;
                }
            } else {
                for (int i = 0; i < this.columnDiff.length && i < this.columnHits.length; ++i) {
                    this.sortByRubricArray[i] = this.columnDiff[i] + this.columnHits[i] * User.instance().getProperty("PolarHitFactor", 100);
                    if (this.columnDiff[i] >= -9) continue;
                    this.sortByRubricArray[i] = 0;
                }
            }
            this.caseRubricToAdd = null;
            this.showInWindow = true;
            this.buildRating = false;
            return true;
        }
        return false;
    }

    public boolean deleteRowThenBuild(int n) {
        if (n >= this.titleSize() && this.allResults != null && this.allResults.size() > n - this.titleSize()) {
            this.allResults.removeElementAt(n - this.titleSize());
            this.caseRubricToAdd = null;
            this.showInWindow = true;
            this.buildRating = true;
            this.changed = true;
            return true;
        }
        return false;
    }

    public int moveRowUpThenBuild(int n) {
        int n2;
        int n3;
        if (n >= this.titleSize() && this.allResults != null && (n3 = n - this.titleSize()) != (n2 = this.allResults.moveElementUp(n3))) {
            this.caseRubricToAdd = null;
            this.showInWindow = true;
            this.buildRating = false;
            this.changed = true;
            return n2 + this.titleSize();
        }
        return n;
    }

    public void reorderRubric(int n, int n2) {
        this.allResults.moveRubric(n, n2);
        this.changed = true;
    }

    public int moveRowDownThenBuild(int n) {
        int n2;
        int n3;
        if (n >= this.titleSize() && this.allResults != null && (n3 = n - this.titleSize()) != (n2 = this.allResults.moveElementDown(n3))) {
            this.caseRubricToAdd = null;
            this.showInWindow = true;
            this.buildRating = false;
            this.changed = true;
            return n2 + this.titleSize();
        }
        return n;
    }

    public boolean setFilterTextThenBuild(String string, int n) {
        string = n != 0 && string.length() > 1 ? string.substring(0, 1) : string.trim();
        if (!this.filterString.equals(string) || this.filterType != n || string.length() == 0) {
            this.filterString = string;
            this.filterType = n;
            this.caseRubricToAdd = null;
            this.showInWindow = true;
            this.buildRating = true;
            return true;
        }
        return false;
    }

    public boolean loadCaseThenBuild(FileCsvKey fileCsvKey) {
        String string;
        FileCsv fileCsv;
        String[] stringArray;
        int[] nArray;
        User.instance().setProperty("cLoaded", User.instance().getProperty("cLoaded", 0) + 1);
        this.allResults.removeAllElements();
        this.columnTitle = new String[1];
        this.columnFilter = new String[1];
        String string2 = fileCsvKey.readNextGetKey();
        if (string2 != null && string2.length() > 0 && string2.length() < 5 && string2.charAt(0) == 'V' && (nArray = this.checkForAllMedis(stringArray = (fileCsv = new FileCsv()).changeCSVtoArray(string = fileCsvKey.getRemaining()), null)) != null) {
            string2 = fileCsvKey.readNextGetKey();
            while (string2 != null) {
                Object object;
                String[] stringArray2;
                if (string2.length() <= 0) continue;
                if (!string2.startsWith("#")) {
                    stringArray2 = fileCsv.changeCSVtoArray(fileCsvKey.getRemaining());
                    object = this.getRubricValues(stringArray2);
                    this.caseRubricToAdd = new CaseRubric(string2, (int[])object, nArray, this.columnTitle);
                    this.showInWindow = false;
                    this.buildRating = false;
                    this.buildResult();
                } else {
                    stringArray2 = this.getAddonString(string2, fileCsv.changeCSVtoArray(fileCsvKey.getRemaining()));
                    object = this.allResults.getRubric(stringArray2[0]);
                    if (object != null) {
                        if (string2.startsWith("#a")) {
                            ((CaseRubric)object).setRemarkMedis(stringArray2);
                        }
                        if (string2.startsWith("#c")) {
                            ((CaseRubric)object).setRemarkArray(stringArray2);
                        }
                        if (string2.startsWith("#d")) {
                            ((CaseRubric)object).setRemarkDates(stringArray2);
                        }
                    }
                }
                string2 = fileCsvKey.readNextGetKey();
            }
        }
        this.caseRubricToAdd = null;
        this.changeActRep(User.instance().getActRepIndex());
        this.showInWindow = true;
        this.buildRating = true;
        return true;
    }

    public void saveCase(FileLn fileLn) {
        CaseRubric caseRubric;
        int n;
        User.instance().setProperty("cSaved", User.instance().getProperty("cSaved", 0) + 1);
        StringBuilder stringBuilder = new StringBuilder("V03");
        for (n = 1; n < this.maxResultIndex; ++n) {
            stringBuilder.append(";").append(this.columnTitle[this.resultIndices[n]]);
        }
        fileLn.writeLn(stringBuilder.toString());
        for (n = 0; n < this.allResults.size(); ++n) {
            caseRubric = this.allResults.elementAt(n);
            if (caseRubric.isPolar()) continue;
            stringBuilder = new StringBuilder(caseRubric.getCaseSaveRubric());
            for (int i = 1; i < this.maxResultIndex; ++i) {
                stringBuilder.append(";").append(caseRubric.getOriginalValue(this.resultIndices[i]));
            }
            fileLn.writeLn(stringBuilder.toString());
        }
        for (n = 0; n < this.allResults.size(); ++n) {
            caseRubric = this.allResults.elementAt(n);
            if (caseRubric.isPolar() || caseRubric.getRemarkMedis() == null) continue;
            StringBuilder stringBuilder2 = new StringBuilder("#a:" + caseRubric.getRubric().getRubricKey());
            StringBuilder stringBuilder3 = new StringBuilder("#c:" + caseRubric.getRubric().getRubricKey());
            StringBuilder stringBuilder4 = new StringBuilder("#d:" + caseRubric.getRubric().getRubricKey());
            for (int i = 1; i < caseRubric.getRemarkMedis().length; ++i) {
                if (caseRubric.getRemarkMedis()[i] == null || caseRubric.getRemarkMedis()[i].length() <= 0) continue;
                stringBuilder2.append(";").append(caseRubric.getRemarkMedis()[i]);
                stringBuilder3.append(";").append(caseRubric.getRemarkArray()[i]);
                stringBuilder4.append(";").append(caseRubric.getRemarkDates()[i]);
            }
            fileLn.writeLn(stringBuilder2.toString());
            fileLn.writeLn(stringBuilder3.toString());
            fileLn.writeLn(stringBuilder4.toString());
        }
        this.changed = false;
    }

    public boolean containsRubric(Rubric rubric) {
        CaseRubric caseRubric = new CaseRubric(rubric, null);
        return this.allResults.contains(caseRubric);
    }

    private boolean addOneLine() {
        if (this.caseRubricToAdd != null) {
            if (!this.allResults.contains(this.caseRubricToAdd)) {
                this.allResults.addElement(this.caseRubricToAdd);
            } else {
                int n = this.allResults.indexOf(this.caseRubricToAdd);
                this.caseRubricToAdd = this.allResults.elementAt(n);
                this.caseRubricToAdd.addOneFactor();
            }
            return true;
        }
        return false;
    }

    public boolean doubleRubricThenBuild(int n) {
        CaseRubric caseRubric;
        if (n >= this.titleSize() && (caseRubric = this.allResults.elementAt(n - this.titleSize())).addOneFactor()) {
            this.caseRubricToAdd = null;
            this.showInWindow = true;
            this.buildRating = true;
            this.changed = true;
            return true;
        }
        return false;
    }

    public boolean divRubricThenBuild(int n) {
        CaseRubric caseRubric;
        if (n >= this.titleSize() && (caseRubric = this.allResults.elementAt(n - this.titleSize())).subOneFactor()) {
            this.caseRubricToAdd = null;
            this.showInWindow = true;
            this.buildRating = true;
            this.changed = true;
            return true;
        }
        return false;
    }

    public boolean doubleAllBelowThenBuild(int n) {
        this.changed = false;
        if (n >= this.titleSize()) {
            for (int i = n; i < this.allResults.size() + this.titleSize(); ++i) {
                CaseRubric caseRubric = this.allResults.elementAt(i - this.titleSize());
                if (!caseRubric.addOneFactor()) continue;
                this.changed = true;
            }
            if (this.changed) {
                this.caseRubricToAdd = null;
                this.showInWindow = true;
                this.buildRating = true;
            }
        }
        return this.changed;
    }

    public boolean divAllBelowThenBuild(int n) {
        this.changed = false;
        if (n >= this.titleSize()) {
            for (int i = n; i < this.allResults.size() + this.titleSize(); ++i) {
                CaseRubric caseRubric = this.allResults.elementAt(i - this.titleSize());
                if (!caseRubric.subOneFactor()) continue;
                this.changed = true;
            }
            if (this.changed) {
                this.caseRubricToAdd = null;
                this.showInWindow = true;
                this.buildRating = true;
            }
        }
        return this.changed;
    }

    public CaseRubric getCaseRubric(int n) {
        if (n >= this.titleSize()) {
            return this.allResults.elementAt(n - this.titleSize());
        }
        return null;
    }

    public String[] getMedisForRubric() {
        return this.columnTitle;
    }

    public String[] getMedisSorted() {
        String[] stringArray = new String[this.getColumnCount()];
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray[i] = this.getValueAt(0, i);
        }
        return stringArray;
    }

    public boolean combineRubricsThenBuild(Vector<CaseRubric> vector, String string, RubricUtil.CombineType combineType, boolean bl) {
        if (vector.size() >= 2) {
            Vector<Rubric> vector2 = new Vector<Rubric>();
            for (CaseRubric objectArray : vector) {
                vector2.add(objectArray.getRubric());
            }
            Rubric rubric = RubricUtil.combineRubrics(vector2, string, combineType);
            if (rubric != null) {
                this.caseRubricToAdd = new CaseRubric(rubric, null);
                if (combineType == RubricUtil.CombineType.COUNT || combineType == RubricUtil.CombineType.COUNT4) {
                    this.caseRubricToAdd.setRemarkMedis(this.columnTitle);
                    Object[] objectArray = new String[this.columnTitle.length];
                    Arrays.fill(objectArray, "");
                    this.caseRubricToAdd.setRemarkArray((String[])objectArray);
                    Object[] objectArray2 = new String[this.columnTitle.length];
                    Arrays.fill(objectArray2, "");
                    this.caseRubricToAdd.setRemarkDates((String[])objectArray2);
                    for (CaseRubric caseRubric2 : vector) {
                        for (int i = 1; i < this.columnTitle.length; ++i) {
                            String string2 = this.columnTitle[i];
                            if (!caseRubric2.getRubric().containsMedi(string2)) continue;
                            Object object = caseRubric2.getRubric().getRubricTextOnly();
                            try {
                                String[] stringArray = caseRubric2.getRubric().getLevelRubricWithOwnRubric();
                                Object object2 = stringArray[stringArray.length - 2];
                                if (Character.isAlphabetic(((String)object2).charAt(((String)object2).length() - 1))) {
                                    object2 = (String)object2 + ":";
                                }
                                object = "<font color=#c0c0c0>" + (String)object2;
                                String string3 = stringArray[stringArray.length - 1];
                                int n = string3.indexOf(32);
                                object = n > 1 ? (String)object + string3.substring(0, n) + "</font>" + string3.substring(n) : (String)object + "</font>" + string3;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (((String)objectArray[i]).length() == 0) {
                                objectArray[i] = object;
                                continue;
                            }
                            int n = i;
                            objectArray[n] = (String)objectArray[n] + "<br>" + (String)object;
                        }
                    }
                }
                for (CaseRubric caseRubric : vector) {
                    if (!bl) {
                        caseRubric.subOneFactor();
                        continue;
                    }
                    for (int i = 0; i < this.allResults.size(); ++i) {
                        CaseRubric caseRubric2;
                        caseRubric2 = this.allResults.elementAt(i);
                        if (!caseRubric2.equals(caseRubric)) continue;
                        this.allResults.removeElementAt(i);
                        i = this.allResults.size();
                    }
                }
                this.showInWindow = true;
                this.buildRating = true;
                this.changed = true;
                return true;
            }
        }
        return false;
    }

    public int titleSize() {
        int n = 4;
        if (this.polarCount > 0) {
            ++n;
        }
        if (this.mediPlusData != null) {
            ++n;
        }
        return n;
    }

    private void buildResults() {
        int n;
        int n2;
        for (n2 = 1; n2 < this.columnRating.length; ++n2) {
            this.columnRating[n2] = 0;
            this.columnHits[n2] = 0;
            this.columnDiff[n2] = 0;
            this.columnSetNull[n2] = false;
        }
        this.polarCount = 0;
        n2 = !User.instance().getProperty("count1inResult", true) ? 1 : 0;
        boolean bl = !User.instance().getProperty("count2inResult", true);
        for (n = 0; n < this.allResults.size(); ++n) {
            int n3;
            int n4;
            int n5;
            CaseRubric caseRubric = this.allResults.elementAt(n);
            int n6 = caseRubric.getFactor();
            if (n6 > 0) {
                for (n5 = 1; n5 < this.columnRating.length; ++n5) {
                    n4 = 1;
                    n3 = caseRubric.getValue(n5);
                    if (n3 == 1 && n2 != 0) {
                        n4 = 0;
                        this.columnSetNull[n5] = true;
                    }
                    if (n3 == 2 && bl) {
                        n4 = 0;
                        this.columnSetNull[n5] = true;
                    }
                    if (n4 == 0) continue;
                    int n7 = n5;
                    this.columnRating[n7] = this.columnRating[n7] + n3 * n6;
                    if (n3 <= 0) continue;
                    int n8 = n5;
                    this.columnHits[n8] = this.columnHits[n8] + n6;
                }
                continue;
            }
            if (caseRubric.isPolar()) {
                ++this.polarCount;
                CaseRubric caseRubric2 = caseRubric.getOriginalRubric();
                n4 = caseRubric2.getFactor();
                for (n3 = 1; n3 < this.columnDiff.length; ++n3) {
                    int n9 = n3;
                    this.columnDiff[n9] = this.columnDiff[n9] + (caseRubric2.getValue(n3) - caseRubric.getValue(n3)) * n4;
                    if (caseRubric.getValue(n3) <= 0) continue;
                    this.columnSetNull[n3] = true;
                }
                continue;
            }
            for (n5 = 1; n5 < this.columnDiff.length; ++n5) {
                if (caseRubric.getValue(n5) <= 0) continue;
                this.columnSetNull[n5] = true;
            }
        }
        if (this.polarCount == 0) {
            for (n = 1; n < this.columnRating.length; ++n) {
                this.columnDiff[n] = 99999;
            }
        }
        for (n = 1; n < this.columnSetNull.length; ++n) {
            if (!this.isFiltered(n)) continue;
            this.columnRating[n] = 0;
            this.columnHits[n] = 0;
            this.columnSetNull[n] = false;
        }
    }

    private boolean isFiltered(int n) {
        String string = this.filterString.toUpperCase();
        String[] stringArray = new String[]{string};
        int n2 = this.columnRating.length + 1;
        if (this.filterString.length() > 0) {
            if (string.contains("/")) {
                stringArray = string.split("/");
            }
            if (string.contains(" ")) {
                stringArray = string.split(" ");
            }
            n2 = this.findLastIntegerIndex(stringArray, this.columnRating.length + 1);
        }
        if (this.filterString.length() > 0) {
            String string2 = this.columnTitle[n].toUpperCase();
            switch (this.filterType) {
                default: {
                    int n3 = stringArray.length;
                    for (String string3 : stringArray) {
                        boolean bl = true;
                        if (this.columnPos[n] < n2 && this.columnPos[n] != this.getInteger(string3)) {
                            if (string3.length() == 1) {
                                if (!string2.startsWith(string3)) {
                                    bl = false;
                                }
                            } else if (!string2.contains(string3)) {
                                bl = false;
                            }
                        }
                        if (bl) continue;
                        --n3;
                    }
                    if (n3 != 0) break;
                    return true;
                }
                case 2: {
                    if (this.columnFilter.length <= n || this.columnFilter[n].length() <= 0 || string.charAt(0) == this.columnFilter[n].toUpperCase().charAt(0)) break;
                    return true;
                }
                case 1: {
                    if (this.columnFilter.length <= n || this.columnFilter[n].length() <= 1 || string.charAt(0) == this.columnFilter[n].toUpperCase().charAt(1)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private int findLastIntegerIndex(String[] stringArray, int n) {
        int n2 = n;
        for (String string : stringArray) {
            try {
                int n3 = Integer.parseInt(string);
                if (n3 >= n || n2 != n && n3 <= n2) continue;
                n2 = n3;
            }
            catch (Exception exception) {
                return n;
            }
        }
        return n2;
    }

    private int getInteger(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private void sortByArrays(int[] nArray) {
        this.sortByArrays(nArray, null, null, null);
    }

    private void sortByArrays(int[] nArray, int[] nArray2) {
        this.sortByArrays(nArray, nArray2, null, null);
    }

    private void sortByArrays(int[] nArray, int[] nArray2, int[] nArray3) {
        this.sortByArrays(nArray, nArray2, null, nArray3);
    }

    private void sortByArrays(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n;
        for (int i = 1; i < this.resultIndices.length; ++i) {
            this.resultIndices[i] = 0;
        }
        ArrayList<SortIndex> arrayList = new ArrayList<SortIndex>();
        arrayList.add(new SortIndex(0, 0, ""));
        for (n = 1; n < nArray.length; ++n) {
            int n2 = 0;
            StringBuilder stringBuilder = new StringBuilder();
            n2 += this.addSortValue(n, stringBuilder, nArray);
            n2 += this.addSortValue(n, stringBuilder, nArray2);
            n2 += this.addSortValue(n, stringBuilder, nArray3);
            this.addSortValue(n, stringBuilder, nArray4);
            if (this.columnSetNull != null) {
                if (this.columnSetNull.length > n && this.columnSetNull[n]) {
                    stringBuilder.append(Integer.toString(0));
                    ++n2;
                } else {
                    stringBuilder.append(Integer.toString(1));
                }
            }
            stringBuilder.append(this.columnTitle[n].toUpperCase());
            arrayList.add(new SortIndex(n, n2, stringBuilder.toString()));
        }
        Collections.sort(arrayList);
        this.maxResultIndex = 1;
        for (n = 1; n < nArray.length && this.maxResultIndex < this.maxResultLen; ++n) {
            SortIndex sortIndex = (SortIndex)arrayList.get(n);
            this.resultIndices[n] = sortIndex.index;
            if (sortIndex.sorter <= 0) continue;
            ++this.maxResultIndex;
        }
        if (this.filterString.length() == 0) {
            this.resultCountForShow = this.maxResultIndex;
            for (n = 0; n < this.maxResultIndex; ++n) {
                this.columnPos[this.resultIndices[n]] = n;
            }
        }
    }

    private int addSortValue(int n, StringBuilder stringBuilder, int[] nArray) {
        int n2 = 0;
        if (nArray != null) {
            if (nArray.length > n && nArray[n] != 99999 && nArray[n] < 9000) {
                n2 = nArray[n];
            }
            stringBuilder.append(Integer.toString(9000 - n2));
        }
        return n2;
    }

    public void buildResult() {
        try {
            Rubric rubric;
            TimeProbe timeProbe = new TimeProbe();
            CaseRubric caseRubric = this.caseRubricToAdd;
            boolean bl = this.addOneLine();
            if (caseRubric != null && bl && User.instance().getProperty("withPolar", true) && (rubric = RepUtil.getPolarRubric(caseRubric.getRubric())) != null) {
                rubric = rubric.getCopy(this.columnTitle);
                this.caseRubricToAdd = new CaseRubric(rubric, caseRubric);
                this.addOneLine();
            }
            timeProbe.partEnds(10, "add");
            this.caseRubricToAdd = null;
            if (this.buildRating) {
                this.buildResults();
            }
            timeProbe.partEnds(20, "build");
            this.showColoredFamily = User.instance().getProperty("ColorForFamily", true);
            this.showColoredMiasma = User.instance().getProperty("ColorForMiasma", false);
            if (this.showInWindow) {
                if (this.sortByRubric) {
                    if (User.instance().getProperty("alphabticalSort", false)) {
                        if (User.instance().getProperty("SortByRating", false)) {
                            this.sortByArrays(this.sortByRubricArray, this.columnRating);
                        } else {
                            this.sortByArrays(this.sortByRubricArray, this.columnHits);
                        }
                    } else if (User.instance().getProperty("SortByRating", false)) {
                        this.sortByArrays(this.sortByRubricArray, this.columnRating, this.columnHits, this.columnDiff);
                    } else {
                        this.sortByArrays(this.sortByRubricArray, this.columnHits, this.columnRating, this.columnDiff);
                    }
                    this.sortByRubric = false;
                    this.sortByRubricArray = null;
                } else {
                    this.showSortByPolar = false;
                    this.showSortByRubric = false;
                    if (User.instance().getProperty("alphabticalSort", false)) {
                        if (User.instance().getProperty("SortByRating", false)) {
                            this.sortByArrays(this.columnRating);
                        } else {
                            this.sortByArrays(this.columnHits);
                        }
                    } else if (User.instance().getProperty("SortByRating", false)) {
                        this.sortByArrays(this.columnRating, this.columnHits, this.columnDiff);
                    } else {
                        this.sortByArrays(this.columnHits, this.columnRating, this.columnDiff);
                    }
                }
                timeProbe.partEnds(30, "sort");
                Log.write(5, this.getClass().getName(), timeProbe.getLogString());
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "run", exception);
        }
    }

    public void multiTxtSetterAction() {
        if (this.multiTxtSetter != null) {
            String[] stringArray = new String[this.maxResultIndex];
            String[] stringArray2 = new String[this.maxResultIndex];
            int[] nArray = new int[this.maxResultIndex];
            int[] nArray2 = new int[this.maxResultIndex];
            int[] nArray3 = new int[this.maxResultIndex];
            int[] nArray4 = new int[this.maxResultIndex];
            for (int i = 0; i < this.maxResultIndex - 1; ++i) {
                stringArray[i] = this.columnTitle[this.resultIndices[i + 1]];
                stringArray2[i] = this.showColoredFamily || this.showColoredMiasma ? " " + this.columnFilter[this.resultIndices[i + 1]] : " ";
                nArray[i] = this.columnHits[this.resultIndices[i + 1]];
                nArray2[i] = this.columnRating[this.resultIndices[i + 1]];
                nArray3[i] = this.columnPos[this.resultIndices[i + 1]];
                nArray4[i] = this.columnDiff[this.resultIndices[i + 1]];
            }
            this.multiTxtSetter.setNewMedica(stringArray, stringArray2, nArray, nArray2, this.getResultCount(), nArray3, nArray4, 1);
        }
    }

    public int getRowCount() {
        if (this.allResults.size() == 0) {
            return 0;
        }
        return this.titleSize() + this.allResults.size();
    }

    public int getColumnCount() {
        if (this.allResults.size() == 0) {
            return 0;
        }
        return this.maxResultIndex;
    }

    public String getValueAt(int n, int n2) {
        int n3 = this.resultIndices[n2];
        switch (n) {
            case 0: {
                if (n2 == 0) {
                    StringBuilder stringBuilder = new StringBuilder().append(this.getResultCount()).append(StringResource.getString("result_c0_r0"));
                    stringBuilder.append(" [");
                    if (User.instance().getProperty("SortByRating", false)) {
                        stringBuilder.append(StringResource.getString("case_by_grade"));
                    } else {
                        stringBuilder.append(StringResource.getString("case_by_hit"));
                    }
                    if (!User.instance().getProperty("count2inResult", true)) {
                        stringBuilder.append(",B");
                    }
                    if (!User.instance().getProperty("count1inResult", true)) {
                        stringBuilder.append(",1");
                    }
                    if (this.polarCount > 0 && User.instance().getProperty("sortPolarSimple", false)) {
                        stringBuilder.append(",E");
                    }
                    if (User.instance().getProperty("alphabticalSort", false)) {
                        stringBuilder.append(",A");
                    }
                    if (this.polarCount > 0 && User.instance().getProperty("PolarFactor", 10) > 1) {
                        if (User.instance().getProperty("PolarFactorFrom", 4) == 4) {
                            stringBuilder.append(",4");
                        }
                        if (User.instance().getProperty("PolarFactorFrom", 4) == 3) {
                            stringBuilder.append(",3");
                        }
                        if (User.instance().getProperty("PolarFactorFrom", 4) == 2) {
                            stringBuilder.append(",2");
                        }
                    }
                    if (this.showSortByPolar) {
                        stringBuilder.append(",P");
                    }
                    if (this.showSortByRubric) {
                        stringBuilder.append(",R");
                    }
                    stringBuilder.append("]");
                    if (this.maxResultIndex != this.resultCountForShow) {
                        stringBuilder.append(" ").append(this.maxResultIndex - 1).append("/").append(this.resultCountForShow - 1);
                    } else {
                        stringBuilder.append(" ").append(this.resultCountForShow - 1);
                    }
                    return stringBuilder.toString();
                }
                if (n2 <= 0 || n2 >= this.maxResultIndex) break;
                return this.columnTitle[n3];
            }
            case 1: {
                if (n2 == 0) {
                    return StringResource.getString("result_c0_r1");
                }
                if (n2 <= 0 || n2 >= this.maxResultIndex) break;
                return Integer.toString(this.columnPos[n3]);
            }
            case 2: {
                if (User.instance().getProperty("SortByRating", false)) {
                    if (n2 == 0) {
                        return StringResource.getString("result_c0_r3");
                    }
                    if (n2 <= 0 || n2 >= this.maxResultIndex) break;
                    return Integer.toString(this.columnRating[n3]);
                }
                if (n2 == 0) {
                    return StringResource.getString("result_c0_r2");
                }
                if (n2 <= 0 || n2 >= this.maxResultIndex) break;
                return Integer.toString(this.columnHits[n3]);
            }
            case 3: {
                if (User.instance().getProperty("SortByRating", false)) {
                    if (n2 == 0) {
                        return StringResource.getString("result_c0_r2");
                    }
                    if (n2 <= 0 || n2 >= this.maxResultIndex) break;
                    return Integer.toString(this.columnHits[n3]);
                }
                if (n2 == 0) {
                    return StringResource.getString("result_c0_r3");
                }
                if (n2 <= 0 || n2 >= this.maxResultIndex) break;
                return Integer.toString(this.columnRating[n3]);
            }
            default: {
                if (n < this.titleSize()) {
                    boolean bl = false;
                    boolean bl2 = false;
                    if (n == 4) {
                        if (this.polarCount > 0) {
                            bl = true;
                        } else {
                            bl2 = true;
                        }
                    }
                    if (n == 5) {
                        bl2 = true;
                    }
                    if (bl) {
                        if (n2 == 0) {
                            return StringResource.getString("result_c0_r4");
                        }
                        return Integer.toString(this.columnDiff[n3]);
                    }
                    if (!bl2) break;
                    if (n2 == 0) {
                        return this.mediPlusData[0];
                    }
                    if (this.mediPlusData.length <= n3 || this.mediPlusData[n3] == null) break;
                    return this.mediPlusData[n3];
                }
                CaseRubric caseRubric = this.allResults.elementAt(n - this.titleSize());
                if (caseRubric == null) break;
                int n4 = caseRubric.getFactor();
                if (n2 == 0) {
                    return caseRubric.getCaseRubric();
                }
                if (n2 <= 0 || n2 >= this.maxResultIndex) break;
                int n5 = caseRubric.getValue(n3);
                if (n5 == 0) {
                    return "-";
                }
                if (n4 == 0) {
                    if (caseRubric.isPolar()) {
                        return "{ " + n5 + " }";
                    }
                    return "( " + n5 + " )";
                }
                if (n5 == 1) {
                    if (User.instance().getProperty("count1inResult", true)) {
                        return Integer.toString(n5 * n4);
                    }
                    return "[ " + n5 * n4 + " ]";
                }
                if (n5 == 2) {
                    if (User.instance().getProperty("count2inResult", true)) {
                        return Integer.toString(n5 * n4);
                    }
                    return "[ " + n5 * n4 + " ]";
                }
                return Integer.toString(n5 * n4);
            }
        }
        return " ";
    }

    public String getFilterForHeaderAt(int n) {
        if (n > 0 && n < this.maxResultIndex) {
            int n2 = this.resultIndices[n];
            if (this.columnFilter != null && n2 < this.columnFilter.length) {
                return this.columnFilter[n2];
            }
        }
        return " ";
    }

    public String getFilterAt(int n) {
        Object object = "";
        if (n == 0) {
            return " " + StringResource.getString("result_c0_r1filter");
        }
        if (n > 0 && n < this.maxResultIndex && (this.showColoredFamily || this.showColoredMiasma)) {
            int n2 = this.resultIndices[n];
            if (this.columnFilter != null && this.columnFilter.length > n2 && this.columnFilter[n2] != null) {
                boolean bl = User.instance().getProperty("ColorForFamily", true);
                boolean bl2 = User.instance().getProperty("ColorForMiasma", false);
                if (this.columnFilter[n2].length() >= 2 && (bl || bl2)) {
                    object = " ";
                    object = bl2 ? (String)object + this.columnFilter[n2].charAt(0) : (String)object + " ";
                    object = bl ? (String)object + this.columnFilter[n2].charAt(1) : (String)object + " ";
                }
            }
        }
        return object;
    }

    public CaseRubric getRubricAt(int n) {
        if (n >= this.titleSize()) {
            return this.allResults.elementAt(n - this.titleSize());
        }
        return null;
    }

    public CaseRubric[] getAllRubric() {
        CaseRubric[] caseRubricArray;
        int n;
        Vector<CaseRubric[]> vector = new Vector<CaseRubric[]>();
        for (n = 0; n < this.allResults.size(); ++n) {
            caseRubricArray = this.allResults.elementAt(n);
            if (caseRubricArray.isPolar()) continue;
            vector.addElement(caseRubricArray);
        }
        n = vector.size();
        caseRubricArray = new CaseRubric[n];
        for (int i = 0; i < n; ++i) {
            caseRubricArray[i] = (CaseRubric)vector.elementAt(i);
        }
        return caseRubricArray;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public String getPatName() {
        return this.patName;
    }

    public void setPatName(String string) {
        this.patName = string;
    }

    public String getCaseName() {
        return this.caseName;
    }

    public void setCaseName(String string) {
        this.caseName = string;
    }

    public String getCaseString(String string) {
        int n;
        User.instance().setProperty("cSaved", User.instance().getProperty("cSaved", 0) + 1);
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("\nV03");
        for (n = 1; n < this.maxResultIndex; ++n) {
            stringBuilder.append(";").append(this.columnTitle[this.resultIndices[n]]);
        }
        stringBuilder.append('\n');
        for (n = 0; n < this.allResults.size(); ++n) {
            CaseRubric caseRubric = this.allResults.elementAt(n);
            if (caseRubric.isPolar()) continue;
            stringBuilder.append(caseRubric.getCaseSaveRubric());
            for (int i = 1; i < this.maxResultIndex; ++i) {
                stringBuilder.append(";").append(caseRubric.getValue(this.resultIndices[i]));
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    class SortIndex
    implements Comparable<SortIndex> {
        int index;
        int sorter;
        String sortString;

        SortIndex(int n, int n2, String string) {
            this.index = n;
            this.sorter = n2;
            this.sortString = string;
        }

        @Override
        public int compareTo(SortIndex sortIndex) {
            return this.sortString.compareTo(sortIndex.sortString);
        }
    }
}

