/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.rep;

import ch.steph.repdata.Rubric;
import ch.steph.reputil.SearchParam;
import java.io.Serializable;
import java.util.ArrayList;

public class SearchResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int notLoaded = 0;
    private ArrayList<Rubric> data = new ArrayList();
    private SearchParam searchParam;

    public SearchResult(SearchParam searchParam) {
        this.searchParam = searchParam;
    }

    public SearchParam getSearchParam() {
        return this.searchParam;
    }

    public Rubric getByRubricIndex(int n) {
        if (n < 0) {
            return null;
        }
        if (n >= this.data.size()) {
            return null;
        }
        return this.data.get(n);
    }

    public int size() {
        return this.data.size() + this.notLoaded;
    }

    public boolean isPartial() {
        return this.notLoaded > 0;
    }

    public void add(Rubric rubric) {
        if (this.data.size() < 250000) {
            this.data.add(rubric);
        } else {
            ++this.notLoaded;
        }
    }

    public void addWithoutLimit(Rubric rubric) {
        this.data.add(rubric);
    }

    public void addSearchResult(SearchResult searchResult) {
        if (searchResult == null) {
            return;
        }
        this.searchParam = searchResult.searchParam;
        for (int i = 0; i < searchResult.data.size(); ++i) {
            Rubric rubric = searchResult.getByRubricIndex(i);
            this.add(rubric);
        }
    }
}

