/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.rep;

import ch.steph.rep.SearchResult;
import ch.steph.rep.SearcherInterface;
import ch.steph.rep.SearcherPlain;
import ch.steph.rep.SearcherTree;
import ch.steph.repdata.RepData;
import ch.steph.repdata.RepDataPool;
import ch.steph.repdata.Rubric;
import ch.steph.reputil.RubricChangeFile;
import ch.steph.util.Log;
import java.io.Serializable;
import java.util.Vector;

public class SearchThread
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String repTitle = "";
    private boolean hierarchic;
    private String[] hierarchicLevels;
    private String[] mediPlusData;
    private int repIndex;
    private String repIdent;
    private SearcherInterface searcher;

    public SearchThread(int n) {
        Log.write(5, this.getClass().getName(), "start");
        this.repIndex = n;
    }

    public boolean getRepHeader() {
        this.repTitle = "";
        this.repIdent = "";
        this.stopThreads();
        RepData repData = RepDataPool.getInstance().getRepHeader(this.repIndex);
        RubricChangeFile.checkFileChanged(this.repIndex, repData.getRepMedis());
        this.repTitle = repData.getRepTitle();
        this.mediPlusData = repData.getMediPlusData();
        this.hierarchic = repData.isHierarchic();
        this.hierarchicLevels = repData.getHierarchicLevels();
        this.repIdent = repData.getRepId();
        if (this.repTitle != null && this.repTitle.length() > 0) {
            Log.write(4, this.getClass().getName(), "working with: " + this.repTitle);
            return true;
        }
        return false;
    }

    public RepData getRepFile() {
        return RepDataPool.getInstance().getRepFile(this.repIndex);
    }

    public String getRepTitle() {
        return this.repTitle;
    }

    public String[] getMediPlusData() {
        return this.mediPlusData;
    }

    public String getRepIdentifier() {
        return this.repIdent;
    }

    public boolean isHierarchic() {
        return this.hierarchic;
    }

    public String[] getHierarchicLevels() {
        return this.hierarchicLevels;
    }

    public synchronized boolean searchWithString(String string) {
        if (this.searcher == null || !(this.searcher instanceof SearcherPlain)) {
            this.searcher = new SearcherPlain(this.repIndex);
        }
        return this.searcher.searchWithString(string);
    }

    public synchronized boolean searchWithString(int n, String string, Rubric rubric) {
        if (this.searcher == null || !(this.searcher instanceof SearcherTree)) {
            this.searcher = new SearcherTree(this.repIndex, this.hierarchicLevels.length);
        }
        return this.searcher.searchWithString(n, string, rubric);
    }

    public synchronized boolean loadWithValue(String string, char c, String string2, String[] stringArray) {
        this.searcher = new SearcherPlain(this.repIndex);
        return this.searcher.loadWithValue(stringArray, string, c, string2);
    }

    public boolean changeSearchString(String string) {
        if (this.searcher == null) {
            return false;
        }
        return this.searcher.changeSearchString(string);
    }

    public void stopThreads() {
        if (this.searcher != null) {
            this.searcher.stopThreads();
            this.searcher = null;
        }
    }

    public Vector<Rubric> getHierarchicWithChildren(Rubric rubric) {
        if (rubric.hasHierarchic() && this.searcher instanceof SearcherTree) {
            return this.searcher.getHierarchicWithChildren(rubric);
        }
        return null;
    }

    public boolean isRunning() {
        if (this.searcher == null) {
            return false;
        }
        return this.searcher.isRunning();
    }

    public int getRunCount() {
        if (this.searcher == null) {
            return -1;
        }
        return this.searcher.getRunCount();
    }

    public String getRunText() {
        if (this.searcher == null) {
            return null;
        }
        return this.searcher.getRunText();
    }

    public SearchResult getSearchResult() {
        if (this.searcher == null) {
            return null;
        }
        return this.searcher.getSearchResult();
    }

    public Rubric getRubricFromResult(String string) {
        if (this.searcher == null) {
            return null;
        }
        return this.searcher.getRubricFromResult(string);
    }
}

