/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.rep;

import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.SearchResult;
import ch.steph.rep.SearcherInterface;
import ch.steph.repdata.RepData;
import ch.steph.repdata.RepDataPool;
import ch.steph.repdata.Rubric;
import ch.steph.reputil.SearchParam;
import ch.steph.reputil.SearchUtil;
import ch.steph.util.Log;
import ch.steph.util.TimeProbe;
import java.io.Serializable;
import java.util.Vector;

public class SearcherPlain
implements SearcherInterface,
Serializable {
    private static final long serialVersionUID = 1L;
    private int repIndex;
    private boolean running;
    private int runCount;
    private String runText;
    private SearchResult results;
    private SearchResult loadValueResults;
    private SearchParam searchParam;
    private boolean searchParamChanged = false;
    private boolean firstDone;
    private boolean loadWithString;
    private int loadValue;
    private int loadIndex;

    public SearcherPlain(int n) {
        Log.write(5, this.getClass().getName(), "start");
        this.repIndex = n;
        this.running = false;
        this.loadWithString = true;
        this.searchParam = null;
        this.runCount = -1;
        this.runText = null;
        this.firstDone = false;
        this.results = new SearchResult(null);
        this.loadValueResults = null;
    }

    @Override
    public SearchParam getSearchParam() {
        return this.searchParam;
    }

    @Override
    public void stopThreads() {
        if (this.running) {
            this.running = false;
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.loadValueResults != null && this.loadValueResults.size() > 0) {
            this.results = this.loadValueResults;
            this.runCount = this.results.size();
            this.runText = StringResource.getString("search_ok");
            this.firstDone = true;
        } else {
            this.searchParam = null;
            this.runCount = -1;
            this.runText = null;
            this.firstDone = false;
            if (this.results == null || this.results.size() > 0) {
                this.results = new SearchResult(this.searchParam);
            }
        }
    }

    @Override
    public boolean searchWithString(String string) {
        TimeProbe timeProbe = new TimeProbe();
        Log.write(4, this.getClass().getName(), "searchWithString '" + string + "'");
        if (string != null) {
            SearchParam searchParam = SearchUtil.getSearchStrings(string, false);
            if (!searchParam.hasData()) {
                this.stopThreads();
                return true;
            }
            if (searchParam.isNewSearch(this.searchParam) || this.results.isPartial()) {
                this.stopThreads();
            }
            if (searchParam.isAdditionalSearch(this.searchParam)) {
                this.searchParam = searchParam;
                this.searchParamChanged = true;
                if (!this.running) {
                    this.running = true;
                    this.searchValues();
                    this.running = false;
                    Log.write(4, this.getClass().getName(), "end searchWithString, results: " + this.results.size() + ", time: " + timeProbe.getLogString());
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean searchWithString(int n, String string, Rubric rubric) {
        Log.write(2, this.getClass().getName(), "Tree searchWithString NOT supported in hierarchical search");
        return false;
    }

    @Override
    public boolean loadWithValue(String[] stringArray, String string, char c, String string2) {
        TimeProbe timeProbe = new TimeProbe();
        Log.write(4, this.getClass().getName(), "loadWithValue '" + string + "', string '" + string2 + "'");
        if (!this.running) {
            SearchParam searchParam;
            this.loadValue = c - 48;
            this.loadIndex = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || !string.equalsIgnoreCase(stringArray[i])) continue;
                this.loadIndex = i;
                i = stringArray.length;
            }
            if (this.loadIndex == -1) {
                return false;
            }
            this.loadWithString = false;
            this.running = true;
            this.searchValues();
            this.running = false;
            if (string2 != null && !"  ".equals(string2) && this.results.size() > 0 && (searchParam = SearchUtil.getSearchStrings(string2, false)).hasData() && searchParam.isAdditionalSearch(this.searchParam)) {
                this.searchParam = searchParam;
                this.searchParamChanged = true;
                if (!this.running) {
                    this.running = true;
                    this.searchValues();
                    this.running = false;
                    Log.write(4, this.getClass().getName(), "end loadWithValue, results: " + this.results.size() + ", time: " + timeProbe.getLogString());
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean changeSearchString(String string) {
        if (!this.loadWithString) {
            return false;
        }
        if (!this.running) {
            return false;
        }
        if (this.searchParam == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        SearchParam searchParam = SearchUtil.getSearchStrings(string, false);
        if (!searchParam.hasData()) {
            return false;
        }
        if (searchParam.isNewSearch(this.searchParam)) {
            return false;
        }
        if (searchParam.isAdditionalSearch(this.searchParam)) {
            if (!this.running) {
                return false;
            }
            this.searchParam = searchParam;
            this.searchParamChanged = true;
        }
        return true;
    }

    private void searchValues() {
        try {
            if (!this.firstDone) {
                try {
                    this.searchParamChanged = false;
                    this.runFirst();
                }
                catch (Exception exception) {
                    Log.write(2, this.getClass().getName(), "search thread first: " + this.searchParam.userSearchString + ". results: " + this.results.size(), exception);
                }
            }
            while (this.running) {
                if (!this.searchParamChanged) {
                    return;
                }
                this.searchParamChanged = false;
                try {
                    this.runWhile();
                }
                catch (Exception exception) {
                    Log.write(2, this.getClass().getName(), "search thread while: " + this.searchParam.userSearchString + ". results: " + this.results.size(), exception);
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "searchValues", exception);
        }
    }

    private void runFirst() {
        this.results = new SearchResult(this.searchParam);
        this.runCount = 0;
        RepData repData = RepDataPool.getInstance().getRepFile(this.repIndex);
        boolean bl = User.instance().getProperty("UseChangedRep", true);
        if (repData.resetGetNextRubric()) {
            if (this.loadWithString) {
                Log.write(4, this.getClass().getName(), "loading with: '" + this.searchParam.userSearchString + "'");
                Rubric rubric = repData.getNextRubric();
                this.runText = StringResource.getString("search_load");
                while (rubric != null && this.running) {
                    if (this.searchParam.matches(true, rubric)) {
                        rubric.setLoadValue(0);
                        if (bl || !rubric.isChanged()) {
                            this.results.add(rubric);
                            this.runCount = this.results.size();
                        }
                    }
                    rubric = repData.getNextRubric();
                }
            } else {
                Log.write(4, this.getClass().getName(), "loading with value at index: " + this.loadIndex);
                Rubric rubric = repData.getNextRubric();
                this.runText = StringResource.getString("search_med");
                while (rubric != null && this.running) {
                    if (rubric.getValue(this.loadIndex) >= this.loadValue) {
                        rubric = rubric.getCopy(null);
                        rubric.setLoadValue(rubric.getValue(this.loadIndex));
                        this.results.addWithoutLimit(rubric);
                        this.runCount = this.results.size();
                    }
                    rubric = repData.getNextRubric();
                }
                this.loadValueResults = this.results;
            }
            this.runCount = this.results.size();
            this.runText = StringResource.getString("search_ok");
        }
        this.firstDone = true;
    }

    private void runWhile() {
        SearchResult searchResult = new SearchResult(this.searchParam);
        Log.write(4, this.getClass().getName(), "removing with: '" + this.searchParam.userSearchString + "'");
        for (int i = 0; i < this.results.size() && this.running; ++i) {
            Rubric rubric = this.results.getByRubricIndex(i);
            if (!this.searchParam.matches(true, rubric)) continue;
            searchResult.add(rubric);
            this.runCount = this.results.size() - i + searchResult.size();
            this.runText = StringResource.getString("search_search");
        }
        if (this.running) {
            this.results = searchResult;
            this.runCount = this.results.size();
            this.runText = StringResource.getString("search_ok");
        }
    }

    @Override
    public Vector<Rubric> getHierarchicWithChildren(Rubric rubric) {
        Log.write(3, this.getClass().getName(), "getHierarchicWithChildren NOT possible");
        return null;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public int getRunCount() {
        if (this.runCount <= 0) {
            return 0;
        }
        return this.runCount;
    }

    @Override
    public String getRunText() {
        return this.runText;
    }

    @Override
    public SearchResult getSearchResult() {
        return this.results;
    }

    @Override
    public Rubric getRubricFromResult(String string) {
        if (this.results != null) {
            for (int i = 0; i < this.results.size(); ++i) {
                Rubric rubric = this.results.getByRubricIndex(i);
                if (rubric == null || !rubric.getRubricKeyWithChangedExtension().equals(string)) continue;
                return rubric;
            }
        }
        return null;
    }
}

