/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repdata;

import ch.steph.apputil.User;
import ch.steph.repdata.Rubric;
import ch.steph.reputil.RepUtil;
import ch.steph.reputil.RubricUtil;
import java.io.Serializable;

public class CaseRubric
implements Serializable,
Comparable<CaseRubric> {
    private static final long serialVersionUID = 1L;
    private static final String POLAR_STR = "-P";
    private static final char TRENN_CHAR = '*';
    private static final char REP_CHAR = '{';
    private Rubric rubric = null;
    private CaseRubric orgRubric = null;
    private int factor = 1;
    private String[] remarkArray;
    private String[] remarkMedis;
    private String[] remarkDates;

    public CaseRubric(Rubric rubric, CaseRubric caseRubric) {
        if (caseRubric != null) {
            this.factor = 0;
            this.orgRubric = caseRubric;
        }
        this.rubric = rubric.getCopy(null);
    }

    public CaseRubric(String string, int[] nArray, int[] nArray2, String[] stringArray) {
        int n;
        int n2 = 0;
        for (int n3 : nArray2) {
            if (n2 >= n3) continue;
            n2 = n3;
        }
        int[] nArray3 = new int[n2 + 2];
        for (n = 0; n < nArray.length; ++n) {
            if (nArray2[n] < 0 || nArray[n] <= 0) continue;
            nArray3[nArray2[n] + 1] = nArray[n];
        }
        n = 0;
        if (string != null) {
            int n4 = string.indexOf(42);
            if (n4 > 0 && n4 <= 3) {
                try {
                    this.factor = Integer.parseInt(string.substring(0, n4));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string = string.substring(n4 + 1);
            }
            if ((n4 = string.lastIndexOf(123)) > 0 && n4 > string.length() - 5) {
                try {
                    n = Integer.parseInt(string.substring(n4 + 1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string = string.substring(0, n4);
            }
            if ((n4 = string.indexOf(" ")) >= 2) {
                String string2 = string.substring(0, n4);
                n = RepUtil.getRepIndex(string2, n);
            }
            this.rubric = new Rubric(n, string, nArray3, stringArray);
        }
    }

    public String[] getRemarkArray() {
        return this.remarkArray;
    }

    public void setRemarkArray(String[] stringArray) {
        this.remarkArray = stringArray;
    }

    public String[] getRemarkMedis() {
        return this.remarkMedis;
    }

    public void setRemarkMedis(String[] stringArray) {
        this.remarkMedis = stringArray;
    }

    public String[] getRemarkDates() {
        return this.remarkDates;
    }

    public void setRemarkDates(String[] stringArray) {
        this.remarkDates = stringArray;
    }

    public String getCaseShowRemarks() {
        if (this.remarkMedis != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 1; i < this.remarkMedis.length; ++i) {
                stringBuilder.append(this.remarkMedis[i]);
                stringBuilder.append(": ");
                if (i < this.remarkArray.length) {
                    stringBuilder.append(this.remarkArray[i]);
                }
                stringBuilder.append("\\n");
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public String getCaseRubric() {
        Object object = "";
        if (this.factor > 1 || this.factor == 0 && this.orgRubric == null) {
            object = Integer.toString(this.factor) + "*";
        }
        String string = "";
        if (this.orgRubric != null) {
            string = POLAR_STR;
        }
        if (User.instance().getProperty("repId", false)) {
            return " " + (String)object + this.rubric.getRepIdent() + " " + this.rubric.getRubrIdent() + this.rubric.getRubrPostfix() + string + "  " + this.rubric.getFullRubric();
        }
        return " " + (String)object + this.rubric.getRepIdent() + this.rubric.getRubrPostfix() + string + "  " + this.rubric.getFullRubric();
    }

    public void setNoPolar() {
        this.rubric.setRubrPostfix("~P");
    }

    public boolean isNewRubric() {
        if (this.factor > 0 && !this.isPolar()) {
            if (RubricUtil.isKombiText(this.rubric.getRepIdent())) {
                return true;
            }
            if (RubricUtil.isKombiText(this.rubric.getSimpleRubric())) {
                return true;
            }
            return this.rubric.isChanged();
        }
        return false;
    }

    public String getCaseSaveRubric() {
        String string = this.rubric.getRepIdent() + " " + this.rubric.getRubrIdent() + this.rubric.getRubrPostfix() + "  " + this.rubric.getFullRubric();
        if (this.factor > 1 || this.factor == 0) {
            string = Integer.toString(this.factor) + "*" + string;
        }
        if (this.rubric.getRepIndex() > 0) {
            string = string + "{" + this.rubric.getRepIndex();
        }
        return string;
    }

    public CaseRubric getOriginalRubric() {
        return this.orgRubric;
    }

    public int getFactor() {
        return this.factor;
    }

    public boolean isPolar() {
        return this.orgRubric != null;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof CaseRubric) {
            return this.rubric.equals(((CaseRubric)object).getRubric()) && this.isPolar() == ((CaseRubric)object).isPolar();
        }
        return false;
    }

    public int hashCode() {
        return this.rubric.hashCode() + 12345;
    }

    public Rubric getRubric() {
        return this.rubric;
    }

    public int getOrgRep() {
        if (this.rubric != null) {
            return this.rubric.getRepIndex();
        }
        return 0;
    }

    public int[] getValues() {
        if (this.rubric != null) {
            return this.rubric.getValues();
        }
        return null;
    }

    public int getValue(int n) {
        if (this.rubric != null) {
            int n2 = this.rubric.getValue(n);
            if (n2 > 1 && User.instance().getProperty("Graph1Minus", false)) {
                --n2;
            }
            if (n2 > 0 && this.isPolar()) {
                int n3 = User.instance().getProperty("PolarFactor", 10);
                int n4 = User.instance().getProperty("PolarFactorFrom", 4);
                if (n3 > 1 && this.orgRubric.getValue(n) < n2 && n2 >= n4 && (User.instance().getProperty("polarRelative", true) || this.orgRubric.getValue(n) < 4)) {
                    n2 *= n3;
                }
            }
            return n2;
        }
        return 0;
    }

    public int getOriginalValue(int n) {
        if (this.rubric != null) {
            return this.rubric.getValue(n);
        }
        return 0;
    }

    public boolean addOneFactor() {
        if (this.factor < 10 && this.orgRubric == null) {
            ++this.factor;
            return true;
        }
        return false;
    }

    public boolean subOneFactor() {
        if (this.factor > 0 && this.orgRubric == null) {
            --this.factor;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(CaseRubric caseRubric) {
        if (caseRubric == null) {
            return -1;
        }
        return this.rubric.getRubricKey().compareTo(caseRubric.rubric.getRubricKey());
    }

    public String toString() {
        return "CaseRubric [factor=" + this.factor + ", rubric=" + String.valueOf(this.rubric) + "]";
    }
}

