/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repdata;

import ch.steph.apputil.User;
import ch.steph.rep.Rep;
import ch.steph.repui.RepMainFrame;
import ch.steph.reputil.PatientUtil;
import ch.steph.util.FileProcedures;
import ch.steph.util.FileSyncher;
import ch.steph.util.GetDataFile;
import ch.steph.util.Log;
import java.util.ArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class FileSynch {
    private static FileSynch instance;
    private FileSyncher fileSyncher;

    public static FileSynch instance() {
        if (instance == null) {
            instance = new FileSynch();
        }
        return instance;
    }

    private FileSynch() {
        String string = User.instance().getProperty("DataBackup", "");
        if (string.length() > 2) {
            FileProcedures.makeDir(string);
            Log.write(4, this.getClass().getName(), "FileSynch to " + string);
            if (FileProcedures.exists(string)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(GetDataFile.getDataPath());
                arrayList.add(FileProcedures.addDirName(string, "DataPath"));
                for (int i = 0; i < 4; ++i) {
                    if (PatientUtil.getPatDir(i) == null || PatientUtil.getPatDir(i).length() <= 0) continue;
                    arrayList.add(PatientUtil.getPatDir(i));
                    arrayList.add(FileProcedures.addDirName(string, "PatientDir" + i));
                }
                String[] stringArray = arrayList.toArray(new String[0]);
                this.fileSyncher = new FileSyncher(false, true, stringArray, null);
            } else {
                Log.write(4, this.getClass().getName(), "FileSynch not possible. " + string + " does not exist");
            }
        }
    }

    public boolean isActive() {
        return this.fileSyncher != null;
    }

    public void synchronizeNow() {
        if (this.fileSyncher == null) {
            RepMainFrame.getRepInstance().setWaitingEnd();
            return;
        }
        ScheduledFuture<?> scheduledFuture = Rep.getScheduledExecutor().scheduleWithFixedDelay(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Thread.currentThread().setPriority(1);
                try {
                    int n = FileSynch.this.fileSyncher.getSynchDirCount();
                    int n2 = FileSynch.this.fileSyncher.getSynchFileCount();
                    if (!RepMainFrame.getRepInstance().setWaitingTextDoExit("Synch Dir " + n + ", File " + n2)) return;
                }
                catch (Exception exception) {
                    Log.write(3, this.getClass().getName(), "Problem while synch show", exception);
                }
            }
        }, 432L, 432L, TimeUnit.MILLISECONDS);
        Rep.getExecutor().execute(() -> {
            try {
                Thread.currentThread().setPriority(1);
                this.fileSyncher.synchronize();
            }
            catch (Exception exception) {
                Log.write(3, this.getClass().getName(), "Problem while file synch ", exception);
            }
            finally {
                int n = this.fileSyncher.getSynchDirCount();
                int n2 = this.fileSyncher.getSynchFileCount();
                Log.write(5, this.getClass().getName(), "File synch done.  Dir " + n + ", File " + n2);
                RepMainFrame.getRepInstance().setWaitingEnd();
                scheduledFuture.cancel(true);
            }
        });
    }

    public void checkFile(String string) {
        if (this.fileSyncher == null) {
            return;
        }
        this.fileSyncher.checkFile(FileProcedures.nameToUrl(string));
    }

    public void checkDeleteFile(String string) {
        if (this.fileSyncher == null) {
            return;
        }
        this.fileSyncher.checkDeleteFile(string);
    }
}

