/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repdata;

import ch.steph.apputil.User;
import ch.steph.repdata.Rubric;
import ch.steph.reputil.complete.ReadCompleteRubrics;
import ch.steph.util.FileCsvKey;
import ch.steph.util.GetDataFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RepData
implements Serializable {
    private static final long serialVersionUID = 5045693790315577638L;
    private int repIndex;
    private String repTitle;
    private boolean hierarchic;
    private boolean editAlwaysExtern;
    private String crDirectory;
    private boolean crCountNormal;
    private boolean cutRubricPossible;
    private String[] hierarchicLevels;
    private String[] mediPlusData;
    private String[] repMedis;
    private String[] repMedisSorted;
    private String repId;
    private boolean isLoadingInRepDataLoader;
    private boolean memoryException;
    public ArrayList<String> repHeaderLines;
    private ReadCompleteRubrics readCompleteRubrics;
    private int fileIterator;
    private List<Rubric> fileRubrics;
    private Map<String, Rubric> rubricMap = null;

    public RepData(int n) {
        this.repIndex = n;
        this.fileIterator = 0;
        this.fileRubrics = null;
        this.repId = null;
        this.crDirectory = null;
        this.memoryException = false;
        this.editAlwaysExtern = false;
        this.isLoadingInRepDataLoader = false;
        this.repHeaderLines = new ArrayList();
        this.crCountNormal = false;
        this.cutRubricPossible = false;
    }

    public boolean isLoadingInRepDataLoader() {
        return this.isLoadingInRepDataLoader;
    }

    public void setLoadingInRepDataLoader(boolean bl) {
        this.isLoadingInRepDataLoader = bl;
    }

    public boolean isMemoryException() {
        return this.memoryException;
    }

    public void setMemoryException(boolean bl) {
        this.memoryException = bl;
    }

    public boolean isEditExtern() {
        if (this.editAlwaysExtern) {
            return true;
        }
        return this.repIndex <= 41;
    }

    public void setEditAlwaysExtern(boolean bl) {
        this.editAlwaysExtern = bl;
    }

    public boolean isOk() {
        return this.repId != null && this.repIndex >= 0 && this.fileRubrics != null;
    }

    protected boolean isTitleOk() {
        return this.repId != null && this.repIndex >= 0;
    }

    public int getRepNumber() {
        return this.repIndex;
    }

    public void setRepNumber(int n) {
        this.repIndex = n;
    }

    public String getRepTitle() {
        return this.repTitle;
    }

    public void setRepTitle(String string) {
        this.repTitle = string;
    }

    public boolean isHierarchic() {
        return this.hierarchic;
    }

    public void setHierarchic(boolean bl) {
        this.hierarchic = bl;
    }

    public String[] getHierarchicLevels() {
        return this.hierarchicLevels;
    }

    public void setHierarchicLevels(String[] stringArray) {
        this.hierarchicLevels = stringArray;
    }

    public String[] getMediPlusData() {
        if (!User.instance().getProperty("ShowMedplus", true)) {
            return null;
        }
        return this.mediPlusData;
    }

    public String getMediStringOfRep(String string) {
        if (string == null) {
            return "";
        }
        if (this.repMedis != null) {
            for (String string2 : this.repMedis) {
                if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
                return string2;
            }
        }
        return string;
    }

    public String getMediPlusData(String string) {
        if (!User.instance().getProperty("ShowMedplus", true)) {
            return null;
        }
        if (this.mediPlusData != null && this.repMedis != null) {
            for (int i = 0; i < this.repMedis.length; ++i) {
                if (this.repMedis[i] == null || !this.repMedis[i].equals(string) || i >= this.mediPlusData.length) continue;
                return this.mediPlusData[i];
            }
            return " ";
        }
        return null;
    }

    public void setMediPlusData(String[] stringArray) {
        this.mediPlusData = stringArray;
    }

    public String[] getRepMedis() {
        return this.repMedis;
    }

    public String[] getRepMedisSorted() {
        if (this.repMedis != null && this.repMedisSorted == null) {
            ArrayList<String> arrayList = new ArrayList<String>(this.repMedis.length);
            for (String string : this.repMedis) {
                if (string == null || string.length() <= 0) continue;
                arrayList.add(string);
            }
            arrayList.sort(String::compareToIgnoreCase);
            this.repMedisSorted = arrayList.toArray(new String[0]);
        }
        return this.repMedisSorted;
    }

    public void setRepMedis(String[] stringArray) {
        this.repMedis = stringArray;
        FileCsvKey fileCsvKey = GetDataFile.getRubricPrivateRd(this.getRepNumber(), "ExtensionMedi");
        if (fileCsvKey.isOpenRead()) {
            String[] stringArray2 = fileCsvKey.readCSVLine();
            if (stringArray2 != null && stringArray2.length > 1) {
                this.repMedis = stringArray2;
            }
            fileCsvKey.close();
        }
        this.repMedisSorted = null;
    }

    public String getRepId() {
        return this.repId;
    }

    public void setRepId(String string) {
        this.repId = string;
    }

    public void setFileRubrics(List<Rubric> list) {
        this.fileRubrics = list;
    }

    public void setRubricMap(Map<String, Rubric> map) {
        this.rubricMap = map;
    }

    public Rubric getRubricWithKey(String string) {
        String string2 = string.trim().toLowerCase();
        return this.rubricMap.get(string2);
    }

    public boolean resetGetNextRubric() {
        while (!this.isOk()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fileIterator = 0;
        return this.fileRubrics.size() > this.fileIterator;
    }

    public Rubric getNextRubric() {
        if (this.fileRubrics.size() > this.fileIterator) {
            ++this.fileIterator;
            return this.fileRubrics.get(this.fileIterator - 1);
        }
        return null;
    }

    private Rubric readNextGetRubricFromLevel(int n) {
        Rubric rubric = this.getNextRubric();
        while (rubric != null && rubric.getLevel() > n) {
            rubric = this.getNextRubric();
        }
        return rubric;
    }

    public Rubric readNextGetOriginalRubricFromLevel(int n, Rubric rubric) {
        if (n == 0) {
            return this.readNextGetRubricFromLevel(n);
        }
        if (rubric == null) {
            return null;
        }
        Rubric rubric2 = this.readNextGetRubricFromLevel(n);
        while (!(rubric2 == null || rubric2.getLevel() == n && rubric.isInRootOf(rubric2))) {
            rubric2 = this.readNextGetRubricFromLevel(n);
        }
        return rubric2;
    }

    public void addRepHeaderLine(String string) {
        this.repHeaderLines.add(string);
    }

    public boolean isCrFormat() {
        return this.crDirectory != null && this.repId != null;
    }

    public String getCrDirectory() {
        return this.crDirectory;
    }

    public void setCrDirectory(String string) {
        this.crDirectory = string;
    }

    public ReadCompleteRubrics getReadCompleteRubrics() {
        return this.readCompleteRubrics;
    }

    public void setReadCompleteRubrics(ReadCompleteRubrics readCompleteRubrics) {
        this.readCompleteRubrics = readCompleteRubrics;
        this.setRepMedis(readCompleteRubrics.getMediArray());
    }

    public boolean isCrCountNormal() {
        return this.crCountNormal;
    }

    public void setCrCountNormal(boolean bl) {
        this.crCountNormal = bl;
    }

    public boolean isCutRubricPossible() {
        return this.cutRubricPossible;
    }

    public void setCutRubricPossible(boolean bl) {
        this.cutRubricPossible = bl;
    }
}

