/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repdata;

import ch.steph.apputil.User;
import ch.steph.repdata.RepData;
import ch.steph.repdata.Rubric;
import ch.steph.reputil.ReadFileRubrics;
import ch.steph.reputil.RepUtil;
import ch.steph.reputil.RubricChangeFile;
import ch.steph.reputil.complete.ReadCompleteRubrics;
import ch.steph.util.FileCsvKey;
import ch.steph.util.Log;
import ch.steph.util.TimeProbe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RepDataLoader {
    private int inPos;
    private String inString;
    private RepData repData;
    private FileCsvKey repFile;
    public static int RepCount = 0;
    public static int RubricOverAllCount = 0;
    private int actLevel = -1;
    private String[] levelRubric = null;
    private String[] levelIdent = null;
    private Rubric previousRubric = null;

    public RepDataLoader(RepData repData) {
        this.repData = repData;
        this.getRepTitles();
    }

    private boolean getRepTitles() {
        if (this.repData.isTitleOk()) {
            Log.write(5, this.getClass().getName(), "Header is loaded: " + this.repData.getRepTitle());
            return true;
        }
        Log.write(5, this.getClass().getName(), "Header start loading rep nr: " + this.repData.getRepNumber());
        this.repFile = RepUtil.openRepFile(this.repData.getRepNumber());
        if (this.repFile.isOpenRead()) {
            int n;
            Object object;
            String[] stringArray = this.repFile.readCSVLine();
            if (stringArray != null) {
                this.repData.setRepTitle(stringArray[0]);
                object = new String[stringArray.length];
                for (n = 1; n < stringArray.length; ++n) {
                    int n2 = stringArray[n].indexOf(32);
                    object[n] = n2 > 0 ? stringArray[n].substring(0, n2) : stringArray[n];
                }
                this.repData.setRepMedis((String[])object);
            }
            this.inString = this.repFile.readLn();
            while (this.inString != null && this.repData.getRepId() == null) {
                this.inPos = this.inString.indexOf(";");
                if (this.inString.length() < 2) {
                    this.inString = this.repFile.readLn();
                    continue;
                }
                if (this.inString.charAt(0) == '#') {
                    this.repData.addRepHeaderLine(this.inString);
                    if (this.inString.toLowerCase().startsWith("#!hierarchic")) {
                        this.repData.setHierarchic(true);
                        int n3 = this.inString.indexOf(";");
                        this.repData.setHierarchicLevels(this.repFile.changeCSVtoArray(this.inString.substring(n3 + 1)));
                    }
                    if (this.inString.toLowerCase().startsWith("#loadcr")) {
                        object = this.repFile.changeCSVtoArray(this.inString);
                        this.repData.setCrDirectory((String)object[1]);
                        this.repData.setRepId((String)object[2]);
                        if (((Object)object).length > 3) {
                            this.repData.setCrCountNormal("normal".equals(object[3]));
                        }
                    }
                    if (this.inString.toLowerCase().startsWith("#!medplus")) {
                        object = this.repFile.changeCSVtoArray(this.inString);
                        for (n = 0; n < ((Object)object).length; ++n) {
                            if (object[n] != null && ((String)object[n]).length() != 0) continue;
                            object[n] = " ";
                        }
                        object[0] = this.repData.getRepTitle();
                        this.repData.setMediPlusData((String[])object);
                    }
                    if (this.inString.toLowerCase().startsWith("#!complete")) {
                        this.repData.setEditAlwaysExtern(true);
                    }
                    if (this.inString.toLowerCase().startsWith("#!cutrubrics")) {
                        this.repData.setCutRubricPossible(true);
                    }
                    this.inString = this.repFile.readLn();
                    continue;
                }
                if (this.inPos < 0) {
                    this.inPos = this.inString.length();
                }
                if ((n = ((String)(object = this.inString.substring(0, this.inPos).trim())).indexOf(" ")) <= 0) continue;
                this.repData.setRepId(((String)object).substring(0, n));
                RepUtil.setRepId(this.repData.getRepNumber(), this.repData.getRepId());
            }
            this.repFile.close();
        }
        ++RepCount;
        Log.write(5, this.getClass().getName(), "Header end loading: " + this.repData.getRepTitle());
        return this.repData.isTitleOk();
    }

    /*
     * WARNING - void declaration
     */
    boolean loadRepData(TimeProbe timeProbe) {
        Rubric rubric;
        Object object2;
        boolean bl = false;
        if (timeProbe != null) {
            bl = true;
            timeProbe.partEnds(5, "start in loader");
        }
        if (this.repData.isOk()) {
            Log.write(5, this.getClass().getName(), "Data is loaded: " + this.repData.getRepTitle());
            return false;
        }
        if (this.repData.isLoadingInRepDataLoader()) {
            Log.write(5, this.getClass().getName(), "Data, wait while loading: " + this.repData.getRepTitle());
            while (this.repData.isLoadingInRepDataLoader()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Log.write(5, this.getClass().getName(), "Data now loaded: " + this.repData.getRepTitle());
            return false;
        }
        this.repData.setLoadingInRepDataLoader(true);
        if (this.repData.getHierarchicLevels() != null) {
            this.levelRubric = new String[this.repData.getHierarchicLevels().length];
            this.levelIdent = new String[this.repData.getHierarchicLevels().length];
            for (int i = 0; i < this.levelRubric.length; ++i) {
                this.levelRubric[i] = "";
                this.levelIdent[i] = "";
            }
        }
        ArrayList<Rubric> arrayList = new ArrayList<Rubric>();
        HashMap<String, Rubric> hashMap = new HashMap<String, Rubric>();
        boolean bl2 = this.repData.isHierarchic();
        if (!bl2) {
            this.repFile = RubricChangeFile.openPrivateRepFile(this.repData.getRepNumber());
            if (this.repFile.isOpenRead()) {
                this.repFile.readLn();
                int n = this.repData.getRepNumber();
                this.inString = this.repFile.readLn();
                try {
                    while (this.inString != null) {
                        this.inPos = this.inString.indexOf(";");
                        if (this.inString.length() >= 2 && this.inString.charAt(0) != '#') {
                            void object3;
                            if (this.inPos < 0) {
                                this.inPos = this.inString.length();
                            }
                            object2 = this.inString.substring(0, this.inPos).trim();
                            String string = "";
                            if (this.inString.length() > this.inPos + 1) {
                                String string2 = this.inString.substring(this.inPos + 1);
                            }
                            rubric = new Rubric(n, (String)object2, (String)object3, this.repData.getRepMedis());
                            arrayList.add(rubric);
                            hashMap.put(rubric.getRubricKeyWithChangedExtension().toLowerCase(), rubric);
                        }
                        this.inString = this.repFile.readLn();
                    }
                }
                catch (Exception exception) {
                    Log.write(3, this.getClass().getName(), "problem loading " + this.inString, exception);
                }
                this.repFile.close();
            }
            if (bl) {
                timeProbe.partEnds(10, "hierarchic before");
            }
        }
        try {
            List<Rubric> list;
            if (this.repData.isCrFormat()) {
                object2 = new ReadCompleteRubrics(this.repData.getRepId(), this.repData.getCrDirectory(), this.repData.getRepNumber(), this.repData.isCrCountNormal(), bl, timeProbe);
                this.repData.setReadCompleteRubrics((ReadCompleteRubrics)object2);
                list = ((ReadCompleteRubrics)object2).getRepEntries();
            } else {
                object2 = new ReadFileRubrics(this.repData.getRepNumber(), this.repData.getRepMedis(), bl, timeProbe);
                list = object2.getRepEntries();
            }
            for (Rubric rubric2 : list) {
                if (bl2) {
                    this.computeLevelsAndFlatRubric(rubric2);
                }
                arrayList.add(rubric2);
                hashMap.put(rubric2.getRubricKeyWithChangedExtension().toLowerCase(), rubric2);
                if (!bl) continue;
                timeProbe.partEnds(39, "added rubric");
            }
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "problem loading " + this.inString, exception);
        }
        if (bl2) {
            this.repFile = RubricChangeFile.openPrivateRepFile(this.repData.getRepNumber());
            if (this.repFile.isOpenRead()) {
                this.repFile.readLn();
                int n = this.repData.getRepNumber();
                this.inString = this.repFile.readLn();
                try {
                    while (this.inString != null) {
                        this.inPos = this.inString.indexOf(";");
                        if (this.inString.length() >= 2 && this.inString.charAt(0) != '#') {
                            void var8_25;
                            if (this.inPos < 0) {
                                this.inPos = this.inString.length();
                            }
                            object2 = this.inString.substring(0, this.inPos).trim();
                            String string = "";
                            if (this.inString.length() > this.inPos + 1) {
                                String string3 = this.inString.substring(this.inPos + 1);
                            }
                            rubric = new Rubric(n, (String)object2, (String)var8_25, this.repData.getRepMedis());
                            this.addOneHierarchicRubric(arrayList, rubric);
                            hashMap.put(rubric.getRubricKeyWithChangedExtension().toLowerCase(), rubric);
                        }
                        this.inString = this.repFile.readLn();
                    }
                }
                catch (Exception exception) {
                    Log.write(3, this.getClass().getName(), "problem loading " + this.inString, exception);
                }
                this.repFile.close();
            }
            if (bl) {
                timeProbe.partEnds(80, "hierarchic after");
            }
        }
        this.repData.setFileRubrics(arrayList);
        this.repData.setRubricMap(hashMap);
        this.repData.resetGetNextRubric();
        boolean bl3 = true;
        if (!this.repData.isHierarchic()) {
            bl3 = false;
        }
        try {
            if (!User.instance().getProperty("ShowHierarchic", false)) {
                bl3 = false;
            }
        }
        catch (Exception exception) {
            bl3 = false;
        }
        object2 = this.repData.getNextRubric();
        while (object2 != null) {
            if (bl3) {
                ((Rubric)object2).getSearchRubric(false, false);
                if (bl) {
                    timeProbe.partEnds(82, "prepare hierarchic search");
                }
            } else {
                ((Rubric)object2).getSearchRubric(true, false);
                if (bl) {
                    timeProbe.partEnds(81, "prepare linear search");
                }
            }
            object2 = this.repData.getNextRubric();
        }
        RubricOverAllCount += arrayList.size();
        this.repData.setLoadingInRepDataLoader(false);
        Log.write(5, this.getClass().getName(), "Data end loading: " + this.repData.getRepTitle());
        return true;
    }

    private void computeLevelsAndFlatRubric(Rubric rubric) {
        String string = rubric.getRubricTextOnly();
        if (this.actLevel < 0 || rubric.getRubrIdent().startsWith(this.levelIdent[this.actLevel])) {
            if (this.actLevel < 0 || !rubric.getRubrIdent().equals(this.levelIdent[this.actLevel])) {
                if (this.previousRubric != null) {
                    this.previousRubric.setHasHierarchic(true);
                }
                ++this.actLevel;
                if (this.actLevel >= this.levelIdent.length) {
                    Log.write(3, this.getClass().getName(), "max Level reachaed with " + rubric.getRubrIdent());
                }
                this.levelIdent[this.actLevel] = rubric.getRubrIdent();
                this.levelRubric[this.actLevel] = string;
            }
        } else if (this.actLevel > 0 && rubric.getRubrIdent().startsWith(this.levelIdent[this.actLevel - 1])) {
            this.levelIdent[this.actLevel] = rubric.getRubrIdent();
            this.levelRubric[this.actLevel] = string;
        } else {
            while (this.actLevel >= 0 && !rubric.getRubrIdent().startsWith(this.levelIdent[this.actLevel])) {
                this.levelRubric[this.actLevel] = "";
                this.levelIdent[this.actLevel] = "";
                --this.actLevel;
            }
            if (this.actLevel < this.levelIdent.length - 1) {
                ++this.actLevel;
            }
            this.levelIdent[this.actLevel] = rubric.getRubrIdent();
            this.levelRubric[this.actLevel] = string;
        }
        this.fillInHierarchicAddons(rubric);
        this.previousRubric = rubric;
    }

    private void fillInHierarchicAddons(Rubric rubric) {
        rubric.setLevel(this.actLevel);
        rubric.setLevelRubric(this.actLevel, this.levelRubric);
    }

    private void addOneHierarchicRubric(List<Rubric> list, Rubric rubric) {
        String string;
        Rubric rubric2;
        int n;
        int n2 = 0;
        Rubric rubric3 = null;
        String string2 = rubric.getRubrIdent();
        for (n = 0; n < list.size(); ++n) {
            rubric2 = list.get(n);
            string = rubric2.getRubrIdent();
            if (string2.equals(string)) {
                n2 = n;
                continue;
            }
            if (!string2.startsWith(string)) continue;
            n2 = n + 1;
            rubric3 = rubric2;
        }
        if (rubric3 != null) {
            rubric3.setHasHierarchic(true);
            n = rubric3.getLevel() + 1;
            rubric.setLevel(n);
            rubric.setLevelRubric(n, rubric3.getLevelRubricWithOwnRubric());
            rubric2 = null;
            if (n2 < list.size()) {
                rubric2 = list.get(n2);
            }
            while (rubric2 != null) {
                string = rubric2.getRubrIdent();
                if (string2.compareTo(string) > 0) {
                    rubric2 = null;
                    if (++n2 >= list.size()) continue;
                    rubric2 = list.get(n2);
                    continue;
                }
                rubric2 = null;
            }
        } else {
            rubric.setLevel(0);
            if (n2 == 0) {
                for (n = 0; n < list.size(); ++n) {
                    rubric2 = list.get(n);
                    string = rubric2.getRubrIdent();
                    if (string2.compareTo(string) <= 0) continue;
                    n2 = n + 1;
                }
            }
        }
        list.add(n2, rubric);
        if (list.size() % 10000 == 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

