/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repdata;

import ch.steph.apputil.User;
import ch.steph.rep.Rep;
import ch.steph.repdata.RepData;
import ch.steph.repdata.RepDataLoader;
import ch.steph.repui.InputAll;
import ch.steph.repui.RepMainFrame;
import ch.steph.reputil.RepUtil;
import ch.steph.util.Log;
import ch.steph.util.MemCache;
import ch.steph.util.TimeProbe;

public class RepDataPool {
    private static RepDataPool instance;
    private boolean allRepLoaded = false;
    private MemCache repCache = MemCache.getInstance(MemCache.CacheType.REP);
    private int lastRepIndex = -179;
    private RepData lastRepData = null;

    private RepDataPool() {
    }

    public static RepDataPool getInstance() {
        if (instance == null) {
            instance = new RepDataPool();
        }
        return instance;
    }

    public RepData getRepHeader(int n) {
        String string = Integer.toString(n);
        RepData repData = null;
        if (n == this.lastRepIndex) {
            repData = this.lastRepData;
        }
        if (repData == null) {
            try {
                repData = (RepData)this.repCache.get(string);
                if (repData != null) {
                    this.lastRepData = repData;
                    this.lastRepIndex = n;
                }
            }
            catch (Exception exception) {
                Log.write(2, this.getClass().getName(), "getRepHeader " + n);
            }
        }
        if (repData == null) {
            try {
                repData = new RepData(n);
                new RepDataLoader(repData);
                this.repCache.put(string, repData);
                this.lastRepData = repData;
                this.lastRepIndex = n;
            }
            catch (Exception exception) {
                Log.write(2, this.getClass().getName(), "getRepHeader " + n);
            }
        }
        return repData;
    }

    public RepData getRepFile(int n) {
        return this.getRepFile(n, null);
    }

    private RepData getRepFile(int n, TimeProbe timeProbe) {
        TimeProbe timeProbe2 = null;
        String string = Integer.toString(n);
        RepData repData = null;
        if (n == this.lastRepIndex && (repData = this.lastRepData).isOk()) {
            return repData;
        }
        if (repData == null) {
            try {
                repData = (RepData)this.repCache.get(string);
                if (repData != null) {
                    this.lastRepData = repData;
                    this.lastRepIndex = n;
                    if (repData.isOk()) {
                        return repData;
                    }
                }
            }
            catch (Exception exception) {
                Log.write(2, this.getClass().getName(), "getRepFile load all " + n, exception);
            }
        }
        if (repData == null) {
            try {
                repData = new RepData(n);
                this.lastRepIndex = -173;
                this.lastRepData = null;
                RepDataLoader repDataLoader = new RepDataLoader(repData);
                if (timeProbe != null) {
                    timeProbe.partEnds(1, "Load start ");
                }
                repDataLoader.loadRepData(null);
                if (timeProbe != null) {
                    timeProbe.partEnds(1000, "Load full ");
                }
                this.repCache.put(string, repData);
                this.lastRepData = repData;
                this.lastRepIndex = n;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                repData.setFileRubrics(null);
                repData.setLoadingInRepDataLoader(false);
                repData.setMemoryException(true);
                repData.setReadCompleteRubrics(null);
                try {
                    this.repCache.put(string, repData);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Log.write(2, this.getClass().getName(), "Memory exception while loading: " + repData.getRepTitle());
            }
            catch (Exception exception) {
                Log.write(2, this.getClass().getName(), "getRepFile load all " + n, exception);
            }
        } else {
            if (repData.isMemoryException()) {
                return repData;
            }
            if (repData.isOk()) {
                return repData;
            }
            this.lastRepIndex = -173;
            this.lastRepData = null;
            RepDataLoader repDataLoader = new RepDataLoader(repData);
            try {
                if (timeProbe != null) {
                    timeProbe.partEnds(1, "Load start ");
                }
                if (repDataLoader.loadRepData(timeProbe2)) {
                    if (timeProbe != null) {
                        timeProbe.partEnds(1000, "Load body ");
                    }
                    this.repCache.put(string, repData);
                    this.lastRepData = repData;
                    this.lastRepIndex = n;
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                repData.setFileRubrics(null);
                repData.setLoadingInRepDataLoader(false);
                repData.setMemoryException(true);
                try {
                    this.repCache.put(string, repData);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Log.write(2, this.getClass().getName(), "Memory exception while loading: " + repData.getRepTitle());
            }
            catch (Exception exception) {
                Log.write(2, this.getClass().getName(), "getRepFile load data " + n, exception);
            }
        }
        return repData;
    }

    public void removeRepFile(int n) {
        String string = Integer.toString(n);
        if (this.repCache.containsKey(string)) {
            Log.write(4, this.getClass().getName(), "remove rep " + n);
            this.repCache.delete(string);
        }
        if (this.lastRepIndex == n) {
            this.lastRepIndex = -173;
            this.lastRepData = null;
        }
    }

    public void reloadRepFile(int n) {
        this.removeRepFile(n);
        this.getRepFile(n);
    }

    public void checkMemory() {
        this.repCache.checkMemory();
    }

    public void loadAllRep(InputAll inputAll) {
        if (this.allRepLoaded) {
            RepMainFrame.getRepInstance().setWaitingEnd();
            if (inputAll != null) {
                inputAll.repLoadDone();
            }
            return;
        }
        Rep.getExecutor().execute(() -> {
            try {
                TimeProbe timeProbe = new TimeProbe();
                String[] stringArray = User.instance().getRepTitles(false);
                for (int i = 1; i < 62; ++i) {
                    if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
                    if (RepMainFrame.getRepInstance().setWaitingTextDoExit("Lade - " + RepUtil.stripFxFromTitle(stringArray[i]))) break;
                    this.getRepFile(i, timeProbe);
                }
                this.allRepLoaded = true;
                Log.write(5, this.getClass().getName(), "All Repertories done" + timeProbe.getLogString());
            }
            catch (Exception exception) {
                Log.write(3, this.getClass().getName(), "Problem while loading Repertories", exception);
            }
            finally {
                RepMainFrame.getRepInstance().repLoadDone();
                if (inputAll != null) {
                    inputAll.repLoadDone();
                }
            }
        });
    }
}

