/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repdata;

import ch.steph.apputil.User;
import ch.steph.repdata.MediValues;
import ch.steph.repdata.RepDataPool;
import ch.steph.reputil.SearchUtil;
import ch.steph.util.Log;
import java.io.Serializable;
import java.util.Arrays;

public class Rubric
implements Comparable<Rubric>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String LOAD_VALUE_START_CHAR = "{";
    private static final String LOAD_VALUE_END_STR = "} ";
    private String repIdent;
    private String rubrIdent;
    private String rubric;
    private String rubrPostfix;
    private byte repIndex;
    private byte loadValue;
    private boolean withValue;
    private byte[] values;
    private String[] medis;
    private boolean hasHierarchic;
    private byte level;
    private String[] levelRubric;
    private String showString;
    private byte showLoadValue;
    private boolean showRubrId;
    private boolean showFullRubric;
    private boolean showWithValue;
    private boolean cuttedAllRubrics;
    private String searchRubricNormal;
    private String searchRubricFull;
    private long crDbMainEntryIndex;
    private MediValues mediValues;

    private Rubric() {
    }

    public Rubric(int n, String string, String string2, String[] stringArray) {
        this.breakRepRubric(n, string);
        this.medis = stringArray;
        this.values = null;
        if (string2.length() > 0) {
            int n2;
            int n3 = 2;
            int n4 = 0;
            for (n2 = 0; n2 < string2.length(); ++n2) {
                if (string2.charAt(n2) == ';') {
                    ++n3;
                    continue;
                }
                ++n4;
            }
            if (n4 * 3 + 20 > n3) {
                this.values = new byte[n3];
                n2 = 1;
                int n5 = 0;
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (c == ';') {
                        if (n5 != 0) {
                            this.values[n2] = n5;
                        }
                        n5 = 0;
                        ++n2;
                        continue;
                    }
                    if (c < '0' || c > '9') continue;
                    n5 = (byte)(n5 * 10 + (c - 48));
                }
                if (n5 > 0) {
                    this.values[n2] = n5;
                }
            } else {
                this.mediValues = new MediValues(n4);
                n2 = 1;
                int n6 = 0;
                int n7 = 0;
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (c == ';') {
                        if (n6 != 0) {
                            this.mediValues.setValue(n7, n6, n2);
                            ++n7;
                        }
                        n6 = 0;
                        ++n2;
                        continue;
                    }
                    if (c < '0' || c > '9') continue;
                    n6 = (byte)(n6 * 10 + (c - 48));
                }
                if (n6 > 0) {
                    this.mediValues.setValue(n7, n6, n2);
                }
            }
        }
        if (!this.isValid()) {
            Log.write(3, Rubric.class.getName(), "Rep" + this.repIndex + " invalid rubric: " + this.getShowRubric(false, false));
        }
    }

    public Rubric(int n, String string, int[] nArray, String[] stringArray) {
        this.breakRepRubric(n, string);
        this.repIndex = (byte)n;
        this.medis = stringArray;
        this.values = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.values[i] = (byte)nArray[i];
        }
        if (!this.isValid()) {
            Log.write(3, Rubric.class.getName(), "Rep" + this.repIndex + " invalid rubric: " + this.getShowRubric(false, false));
        }
    }

    public Rubric(long l, int n, String string, MediValues mediValues, String[] stringArray) {
        this.crDbMainEntryIndex = l;
        this.breakRepRubric(n, string);
        this.repIndex = (byte)n;
        this.medis = stringArray;
        this.mediValues = mediValues;
        if (!this.isValid()) {
            Log.write(3, Rubric.class.getName(), "Rep" + this.repIndex + " invalid rubric: " + this.getShowRubric(false, false));
        }
    }

    private void breakRepRubric(int n, String string) {
        string = string.trim();
        this.hasHierarchic = false;
        this.level = (byte)-1;
        this.values = null;
        this.withValue = true;
        this.repIdent = "";
        this.rubrIdent = "";
        this.rubric = string;
        this.rubrPostfix = "";
        this.repIndex = (byte)n;
        this.searchRubricNormal = null;
        this.searchRubricFull = null;
        this.loadValue = 0;
        this.showString = null;
        this.showWithValue = true;
        int n2 = string.indexOf(" ");
        if (n2 >= 2) {
            int n3 = string.indexOf("  ", n2 + 1);
            if (n3 > n2) {
                this.repIdent = string.substring(0, n2);
                this.rubrIdent = string.substring(n2 + " ".length(), n3);
                this.rubric = string.substring(n3 + "  ".length());
                char c = string.charAt(n3 - 2);
                if (c == '+' || c == '*' || c == '~') {
                    this.rubrPostfix = string.substring(n3 - 2, n3);
                    this.rubrIdent = this.rubrIdent.substring(0, this.rubrIdent.length() - 2);
                }
            } else {
                this.repIdent = string.substring(0, n2);
                this.rubric = string.substring(n2 + " ".length());
                char c = string.charAt(n2 - 2);
                char c2 = string.charAt(n2 - 1);
                if (c2 != ':' && (c == '+' || c == '*' || c == '~')) {
                    this.rubrPostfix = string.substring(n2 - 2, n2);
                    this.repIdent = this.repIdent.substring(0, this.repIdent.length() - 2);
                }
            }
        }
    }

    public boolean isShowRubrId() {
        return this.showRubrId;
    }

    public Rubric getCopy(String[] stringArray) {
        Rubric rubric = new Rubric();
        rubric.repIdent = this.repIdent;
        rubric.rubrIdent = this.rubrIdent;
        rubric.rubric = this.rubric;
        rubric.rubrPostfix = this.rubrPostfix;
        rubric.repIndex = this.repIndex;
        rubric.loadValue = this.loadValue;
        rubric.withValue = this.withValue;
        rubric.hasHierarchic = this.hasHierarchic;
        rubric.level = this.level;
        rubric.levelRubric = this.levelRubric;
        rubric.showString = this.showString;
        rubric.showLoadValue = this.showLoadValue;
        rubric.showRubrId = this.showRubrId;
        rubric.showFullRubric = this.showFullRubric;
        rubric.showWithValue = this.showWithValue;
        rubric.cuttedAllRubrics = this.cuttedAllRubrics;
        rubric.searchRubricNormal = this.searchRubricNormal;
        rubric.searchRubricFull = this.searchRubricFull;
        rubric.crDbMainEntryIndex = this.crDbMainEntryIndex;
        boolean bl = false;
        if (this.values == null && this.mediValues != null) {
            bl = true;
            this.values = new byte[this.medis.length];
            for (int i = 0; i < this.mediValues.size(); ++i) {
                this.values[this.mediValues.getPos((int)i)] = (byte)this.mediValues.getValue(i);
            }
        }
        if (stringArray != null) {
            rubric.medis = this.medis;
            rubric.values = this.values;
            rubric.shiftValues(stringArray);
        } else {
            rubric.medis = this.medis;
            if (this.values != null) {
                rubric.values = new byte[this.values.length];
                System.arraycopy(this.values, 0, rubric.values, 0, this.values.length);
            }
        }
        if (bl) {
            this.values = null;
        }
        return rubric;
    }

    public String getShowRubric(boolean bl) {
        return this.getShowRubric(bl, true);
    }

    public String getShowRubric(boolean bl, boolean bl2) {
        boolean bl3 = User.instance().getProperty("repId", false);
        if (this.showString == null || this.showRubrId != bl3 || this.showLoadValue != this.loadValue || bl != this.showFullRubric || this.showWithValue != bl2 || this.doCutAllRubrics() != this.cuttedAllRubrics) {
            this.showRubrId = bl3;
            this.showLoadValue = this.loadValue;
            this.showFullRubric = bl;
            this.showWithValue = bl2;
            this.cuttedAllRubrics = this.doCutAllRubrics();
            String string = "";
            if (!bl) {
                string = "   ";
                if (this.hasHierarchic) {
                    string = "+ ";
                }
            }
            Object object = "";
            if (bl2 && this.loadValue > 0) {
                object = LOAD_VALUE_START_CHAR + this.loadValue + LOAD_VALUE_END_STR;
            }
            String string2 = this.rubric;
            if (bl) {
                string2 = this.getFullRubric();
            }
            this.showString = bl3 ? (this.rubrIdent.length() > 0 ? (String)object + this.repIdent + " " + this.rubrIdent + this.rubrPostfix + "  " + string + string2 : (String)object + this.repIdent + this.rubrPostfix + "  " + string + string2) : (String)object + this.repIdent + this.rubrPostfix + "  " + string + string2;
        }
        return this.showString;
    }

    public String getRepIdent() {
        return this.repIdent;
    }

    public String getRubrIdent() {
        return this.rubrIdent;
    }

    public String getFullRubric() {
        StringBuilder stringBuilder = new StringBuilder("");
        if (this.levelRubric != null) {
            for (String string : this.levelRubric) {
                int n = string.indexOf(" \u00a6 ");
                if (n > 0) {
                    stringBuilder.append(string, 0, n).append(" - ");
                    continue;
                }
                stringBuilder.append(string).append(" - ");
            }
        }
        if (this.doCutAllRubrics()) {
            int n = this.rubric.indexOf(" \u00a6 ");
            if (n >= 0) {
                stringBuilder.append(this.rubric, 0, n);
            } else {
                stringBuilder.append(this.rubric);
            }
        } else {
            stringBuilder.append(this.rubric);
        }
        return stringBuilder.toString();
    }

    private boolean doCutAllRubrics() {
        return User.instance().getProperty("CutAllRubrics", true) && RepDataPool.getInstance().getRepHeader(this.repIndex).isCutRubricPossible();
    }

    public String getFullRubricLong() {
        if (this.levelRubric == null) {
            return this.rubric;
        }
        StringBuilder stringBuilder = new StringBuilder("");
        for (String string : this.levelRubric) {
            stringBuilder.append(string).append(" - ");
        }
        stringBuilder.append(this.rubric);
        return stringBuilder.toString();
    }

    public String getSimpleRubric() {
        return this.rubric;
    }

    public boolean isValid() {
        return this.repIdent.length() > 0 && this.rubrIdent.length() > 0 && this.rubric.length() > 0;
    }

    public String[] getLevelRubricWithOwnRubric() {
        if (this.levelRubric == null) {
            String[] stringArray = new String[]{this.getRubricTextOnly()};
            return stringArray;
        }
        String[] stringArray = new String[this.levelRubric.length + 1];
        System.arraycopy(this.levelRubric, 0, stringArray, 0, this.levelRubric.length);
        stringArray[this.levelRubric.length] = this.getRubricTextOnly();
        return stringArray;
    }

    public String getRubrPostfix() {
        return this.rubrPostfix;
    }

    public void setLevelRubric(int n, String[] stringArray) {
        if (n > 0) {
            this.levelRubric = new String[n];
            System.arraycopy(stringArray, 0, this.levelRubric, 0, n);
        }
    }

    public int getLoadValue() {
        return this.loadValue;
    }

    public void setLoadValue(int n) {
        this.loadValue = (byte)n;
    }

    public String getRubricTextOnly() {
        String string = this.rubric;
        int n = this.rubric.lastIndexOf(91);
        if (n >= 0) {
            string = this.rubric.substring(0, n).trim();
        }
        return string;
    }

    public boolean isChanged() {
        return this.repIdent.startsWith("++");
    }

    public boolean hasValues() {
        return this.values != null && this.values.length > 0 || this.mediValues != null && this.mediValues.size() > 0;
    }

    public void setHasHierarchic(boolean bl) {
        this.hasHierarchic = bl;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = (byte)n;
    }

    public String getRubricKey() {
        Object object = this.repIdent;
        if (((String)object).startsWith("++")) {
            object = this.repIdent.substring("++".length());
        }
        object = (String)object + " " + this.rubrIdent + this.rubrPostfix;
        return object;
    }

    private String getRepIdentNoChangedExtension() {
        String string = this.repIdent;
        if (string.startsWith("++")) {
            string = this.repIdent.substring("++".length());
        }
        return string;
    }

    public String getRubricKeyWithChangedExtension() {
        return this.repIdent + " " + this.rubrIdent + this.rubrPostfix;
    }

    public int getRepIndex() {
        return this.repIndex;
    }

    public String getSearchRubric(boolean bl, boolean bl2) {
        if (bl2) {
            if (bl) {
                StringBuilder stringBuilder = new StringBuilder(this.getRubricKeyWithChangedExtension());
                stringBuilder.append("  ");
                if (this.levelRubric != null) {
                    for (String string : this.levelRubric) {
                        stringBuilder.append(string);
                        stringBuilder.append(" - ");
                    }
                }
                stringBuilder.append(this.rubric);
                return stringBuilder.toString();
            }
            return this.getRubricKey() + "  " + this.rubric;
        }
        if (bl) {
            if (this.searchRubricFull == null) {
                StringBuilder stringBuilder = new StringBuilder(this.getRubricKeyWithChangedExtension());
                stringBuilder.append("  ");
                if (this.levelRubric != null) {
                    for (String string : this.levelRubric) {
                        stringBuilder.append(string);
                        stringBuilder.append(" - ");
                    }
                }
                stringBuilder.append(this.rubric);
                this.searchRubricFull = SearchUtil.getSearchKey(stringBuilder.toString());
            }
            return this.searchRubricFull;
        }
        if (this.searchRubricNormal == null) {
            this.searchRubricNormal = SearchUtil.getSearchKey(this.getRubricKey() + "  " + this.rubric);
        }
        return this.searchRubricNormal;
    }

    public boolean hasHierarchic() {
        return this.hasHierarchic;
    }

    private void shiftValues(String[] stringArray) {
        int n;
        int n2;
        int[] nArray = new int[stringArray.length];
        Arrays.fill(nArray, 0);
        for (n2 = 0; n2 < this.medis.length; ++n2) {
            if (this.medis[n2] == null || (n = this.getValue(n2)) == 0) continue;
            String string = this.medis[n2];
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || !stringArray[i].equalsIgnoreCase(string)) continue;
                nArray[i] = n;
                i = stringArray.length;
            }
        }
        this.values = null;
        n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0) continue;
            n2 = n;
        }
        if (n2 > 0) {
            this.values = new byte[n2 + 1];
            for (n = 0; n < this.values.length; ++n) {
                this.values[n] = (byte)nArray[n];
            }
        }
        this.medis = stringArray;
    }

    public String[] getMedis() {
        return this.medis;
    }

    public boolean containsMedi(String string) {
        if (string != null) {
            for (int i = 1; i < this.medis.length; ++i) {
                if (!string.equalsIgnoreCase(this.medis[i])) continue;
                return this.getValue(i) > 0;
            }
        }
        return false;
    }

    public int[] getValues() {
        if (this.values == null && this.mediValues != null) {
            int[] nArray = new int[this.medis.length];
            for (int i = 0; i < this.mediValues.size(); ++i) {
                nArray[this.mediValues.getPos((int)i)] = this.mediValues.getValue(i);
            }
            return nArray;
        }
        if (this.values != null) {
            int[] nArray = new int[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                nArray[i] = this.values[i];
            }
            return nArray;
        }
        return new int[0];
    }

    public int getValue(int n) {
        if (this.values != null && n < this.values.length) {
            return this.values[n];
        }
        if (this.mediValues != null) {
            for (int i = 0; i < this.mediValues.size(); ++i) {
                if (this.mediValues.getPos(i) != n) continue;
                return this.mediValues.getValue(i);
            }
        }
        return 0;
    }

    public boolean isInRootOf(Rubric rubric) {
        if (rubric == null) {
            return false;
        }
        if (!rubric.getRubrIdent().startsWith(this.getRubrIdent())) {
            return false;
        }
        return rubric.getRepIdentNoChangedExtension().equals(this.getRepIdentNoChangedExtension());
    }

    public void setRubrPostfix(String string) {
        if (string == null) {
            string = "";
        }
        this.rubrPostfix = string;
    }

    public long getCrDbMainEntryIndex() {
        return this.crDbMainEntryIndex;
    }

    public int getValueCount() {
        int n = 0;
        if (this.mediValues != null) {
            return this.mediValues.size();
        }
        if (this.values != null) {
            for (byte by : this.values) {
                if (by <= 0) continue;
                ++n;
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof Rubric) {
            String string = this.getRubricKeyWithChangedExtension();
            String string2 = ((Rubric)object).getRubricKeyWithChangedExtension();
            return string.equals(string2);
        }
        return false;
    }

    @Override
    public int compareTo(Rubric rubric) {
        if (rubric != null) {
            String string = this.getSearchRubric(true, false).replace('_', ' ');
            String string2 = rubric.getSearchRubric(true, false).replace('_', ' ');
            return string.compareTo(string2);
        }
        return -1;
    }

    public String toString() {
        return this.getRubricKeyWithChangedExtension();
    }

    public int hashCode() {
        return this.getSearchRubric(true, false).hashCode();
    }

    public String getRubricAndValuesIn3Lines() {
        StringBuilder stringBuilder = new StringBuilder(this.getFullRubricLong() + "\n");
        for (String string : this.medis) {
            stringBuilder.append(string).append(";");
        }
        stringBuilder.append("\n");
        for (byte by : this.values) {
            stringBuilder.append(by).append(";");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

