/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repform;

import ch.steph.apputil.MdiMainFrame;
import ch.steph.apputil.MdiModalFrame;
import ch.steph.apputil.ScreenUtil;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.CaseResult;
import ch.steph.rep.PanelKeyListener;
import ch.steph.repdata.CaseRubric;
import ch.steph.repdata.Rubric;
import ch.steph.repform.FormLine;
import ch.steph.repform.FormUtil;
import ch.steph.repform.LineListModel;
import ch.steph.repmodel.SortedListModel;
import ch.steph.repui.RepMainFrame;
import ch.steph.repui.SimpleShowPanel;
import ch.steph.reputil.PatientUtil;
import ch.steph.util.FileCsvKey;
import ch.steph.util.FileProcedures;
import ch.steph.util.GetDataFile;
import ch.steph.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class BuildForm
extends MdiModalFrame
implements PanelKeyListener {
    private static final long serialVersionUID = 1L;
    private JButton formNewButton;
    private JButton formDelButton;
    private SortedListModel formListModel;
    private JList<String> formList;
    private JSplitPane formSplitPane;
    private JSplitPane rubricSplitPane;
    private JButton titleNewButton;
    private JButton textNewButton;
    private JButton loadCase;
    private JButton loadRepFile;
    private JButton lineDelButton;
    private LineListModel rubricListModel;
    private JList<String> rubricList;
    private JCheckBox usePolar;
    private JCheckBox nextInsteadPolar;
    SimpleShowPanel showPanel;
    FormLine actSelectedLine;
    String showedForm = "";
    JLabel titleLabel;
    JTextField textField;
    JTextField rubricField;
    JTextField rubricRemark;
    JTextField polarField;
    JTextField polarRemark;
    JButton acceptButton;

    public BuildForm() {
        super(StringResource.getString("form_title"));
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                BuildForm.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.getContentPane().addKeyListener(keyListener);
        this.getContentPane().setLayout(new BorderLayout());
        Rectangle rectangle = ScreenUtil.getPatientWindowSize();
        this.setBounds(rectangle);
        JPanel jPanel = new JPanel(new GridLayout(1, 7));
        this.getContentPane().add((Component)jPanel, "South");
        this.formNewButton = new JButton(StringResource.getString("form_button_new_form"));
        this.formNewButton.addKeyListener(keyListener);
        this.formNewButton.addActionListener(actionEvent -> {
            String string = JOptionPane.showInternalInputDialog(this.getContentPane(), StringResource.getString("form_button_new_form"));
            this.addNewForm(string);
        });
        this.formNewButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add(this.formNewButton);
        this.formDelButton = new JButton(StringResource.getString("form_button_del_form"));
        this.formDelButton.addKeyListener(keyListener);
        this.formDelButton.addActionListener(actionEvent -> {
            if (0 == JOptionPane.showConfirmDialog(null, StringResource.getString("form_delconfirm1") + FormUtil.getActFormName() + StringResource.getString("form_delconfirm2"), StringResource.getString("form_button_del_form"), 0)) {
                this.deleteActForm();
            }
        });
        this.formDelButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add(this.formDelButton);
        this.titleNewButton = new JButton(StringResource.getString("form_button_new_title"));
        this.titleNewButton.setEnabled(false);
        this.titleNewButton.addKeyListener(keyListener);
        this.titleNewButton.addActionListener(actionEvent -> this.newTitleLine());
        this.titleNewButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add(this.titleNewButton);
        this.textNewButton = new JButton(StringResource.getString("form_button_new_text"));
        this.textNewButton.setEnabled(false);
        this.textNewButton.addKeyListener(keyListener);
        this.textNewButton.addActionListener(actionEvent -> this.newTextLine());
        this.textNewButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add(this.textNewButton);
        this.loadCase = new JButton(StringResource.getString("form_button_loadcase"));
        this.loadCase.setEnabled(false);
        this.loadCase.addKeyListener(keyListener);
        this.loadCase.addActionListener(actionEvent -> this.loadCase());
        jPanel.add(this.loadCase);
        this.loadRepFile = new JButton(StringResource.getString("form_button_loadfile"));
        this.loadRepFile.setEnabled(false);
        this.loadRepFile.addKeyListener(keyListener);
        this.loadRepFile.addActionListener(actionEvent -> this.loadRepFile());
        jPanel.add(this.loadRepFile);
        this.lineDelButton = new JButton(StringResource.getString("form_button_delline"));
        this.lineDelButton.setEnabled(false);
        this.lineDelButton.addKeyListener(keyListener);
        this.lineDelButton.addActionListener(actionEvent -> this.deleteLine());
        this.lineDelButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add(this.lineDelButton);
        JButton jButton = new JButton(StringResource.getString("button_close"));
        jButton.addKeyListener(keyListener);
        jButton.addActionListener(actionEvent -> this.closeAction());
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.formListModel = new SortedListModel(FormUtil.getActualizedFormList());
        this.formList = new JList<String>(this.formListModel);
        this.formList.addKeyListener(keyListener);
        jScrollPane.getViewport().add(this.formList);
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.formSplitPane = new JSplitPane(1, jPanel2, jPanel3);
        this.formSplitPane.setContinuousLayout(true);
        this.getContentPane().add(this.formSplitPane);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        JScrollPane jScrollPane2 = new JScrollPane();
        this.rubricListModel = new LineListModel(FormUtil.getActualizedLineList());
        this.rubricList = new JList<String>(this.rubricListModel);
        this.rubricList.addKeyListener(keyListener);
        jScrollPane2.getViewport().add(this.rubricList);
        jPanel4.add((Component)jScrollPane2, "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        this.rubricSplitPane = new JSplitPane(1, jPanel4, jPanel5);
        this.rubricSplitPane.setContinuousLayout(true);
        jPanel3.add(this.rubricSplitPane);
        this.showPanel = new SimpleShowPanel(null);
        jPanel5.add(this.showPanel);
        JPanel jPanel6 = new JPanel();
        JScrollPane jScrollPane3 = new JScrollPane();
        jScrollPane3.setVerticalScrollBarPolicy(21);
        jScrollPane3.addKeyListener(keyListener);
        jScrollPane3.getViewport().add(jPanel6);
        jPanel5.add((Component)jScrollPane3, "North");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        jPanel6.setLayout(gridBagLayout);
        this.titleLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.titleLabel, gridBagConstraints);
        jPanel6.add(this.titleLabel);
        JLabel jLabel = new JLabel(StringResource.getString("form_label_text") + "  ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel6.add(jLabel);
        this.textField = new JTextField("", 40);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.textField, gridBagConstraints);
        jPanel6.add(this.textField);
        gridBagConstraints.gridwidth = 1;
        jLabel = new JLabel(StringResource.getString("form_label_rubric") + "  ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel6.add(jLabel);
        this.rubricRemark = new JTextField("", 25);
        this.rubricRemark.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.rubricRemark, gridBagConstraints);
        jPanel6.add(this.rubricRemark);
        this.rubricField = new JTextField("", 15);
        this.rubricField.setEditable(false);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.rubricField, gridBagConstraints);
        jPanel6.add(this.rubricField);
        jLabel = new JLabel(StringResource.getString("form_label_polar") + "  ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel6.add(jLabel);
        this.polarRemark = new JTextField("", 25);
        this.polarRemark.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.polarRemark, gridBagConstraints);
        jPanel6.add(this.polarRemark);
        this.polarField = new JTextField("", 15);
        this.polarField.setEditable(false);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.polarField, gridBagConstraints);
        jPanel6.add(this.polarField);
        this.acceptButton = new JButton("  " + StringResource.getString("form_accept") + "  ");
        this.acceptButton.setMargin(new Insets(1, 5, 1, 5));
        this.acceptButton.setEnabled(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.acceptButton, gridBagConstraints);
        this.acceptButton.addActionListener(actionEvent -> this.acceptButtonAction());
        jPanel6.add(this.acceptButton);
        gridBagConstraints.fill = 2;
        this.nextInsteadPolar = new JCheckBox(StringResource.getString("form_next_polar"));
        this.nextInsteadPolar.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.nextInsteadPolar, gridBagConstraints);
        jPanel6.add(this.nextInsteadPolar);
        this.usePolar = new JCheckBox(StringResource.getString("form_check_polar"));
        this.usePolar.setSelected(User.instance().getProperty("FormUsePolar", true));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.usePolar, gridBagConstraints);
        jPanel6.add(this.usePolar);
        this.formList.addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.formSelectionChanged();
            }
        });
        this.formList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseClicked: " + mouseEvent.paramString());
                if (mouseEvent.getClickCount() >= 2) {
                    BuildForm.this.selectForm();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mousePressed: " + mouseEvent.paramString());
                int n = BuildForm.this.formList.locationToIndex(mouseEvent.getPoint());
                BuildForm.this.formList.setSelectedIndex(n);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseReleased: " + mouseEvent.paramString());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.rubricList.addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.rubricSelectionChanged();
            }
        });
        this.rubricList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseClicked: " + mouseEvent.paramString());
                if (mouseEvent.getClickCount() >= 2) {
                    // empty if block
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mousePressed: " + mouseEvent.paramString());
                int n = BuildForm.this.rubricList.locationToIndex(mouseEvent.getPoint());
                BuildForm.this.rubricList.setSelectedIndex(n);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseReleased: " + mouseEvent.paramString());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.usePolar.addActionListener(actionEvent -> this.generateAndShowHtml(true));
        this.setTitleText();
        this.formList.setSelectedIndex(this.formListModel.getSelectedIndex(FormUtil.getActFormName()));
        try {
            int n = User.instance().getProperty("FormDivider", 0);
            if (n == 0) {
                this.formSplitPane.setDividerLocation(0.25);
            } else {
                this.formSplitPane.setDividerLocation(n);
            }
            n = User.instance().getProperty("FormRubrDivider", 0);
            if (n == 0) {
                this.rubricSplitPane.setDividerLocation(0.25);
            } else {
                this.rubricSplitPane.setDividerLocation(n);
            }
            this.formList.setSelectedIndex(this.formListModel.getSelectedIndex(FormUtil.getActFormName()));
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "setDividerLocation ", exception);
        }
    }

    @Override
    public void requestFocus() {
        if (this.formList != null) {
            this.formList.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void setTitleText() {
        SwingUtilities.invokeLater(() -> {
            String string = FormUtil.getActFormName();
            if (string != null) {
                this.setTitle(StringResource.getString("form_title") + " : " + string);
            } else {
                this.setTitle(StringResource.getString("form_title"));
            }
        });
    }

    @Override
    public void closeAction() {
        User.instance().setProperty("FormDivider", this.formSplitPane.getDividerLocation());
        User.instance().setProperty("FormRubrDivider", this.rubricSplitPane.getDividerLocation());
        super.closeAction();
    }

    @Override
    public void mainKeyPressed(KeyEvent keyEvent) {
        try {
            char c = keyEvent.getKeyChar();
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
                if (c == '\n') {
                    keyEvent.consume();
                    if (this.formList.hasFocus()) {
                        this.selectForm();
                    } else if (this.rubricList.hasFocus()) {
                        // empty if block
                    }
                } else if (c == '\u001b') {
                    keyEvent.consume();
                    this.closeAction();
                } else if (keyEvent.getKeyCode() == 112) {
                    keyEvent.consume();
                    RepMainFrame.getRepInstance().helpContextAction("Formular");
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey", exception);
        }
    }

    @Override
    public void mainKeyTyped(KeyEvent keyEvent) {
    }

    protected void formSelectionChanged() {
        String string;
        int n = this.formList.getSelectedIndex();
        if (n >= 0 && !(string = this.formListModel.getElementAt(n)).equals(this.showedForm)) {
            this.showedForm = string;
            FormUtil.setActFormName(string);
            this.setTitleText();
            this.rubricList.clearSelection();
            this.rubricListModel.setNewList(FormUtil.getActualizedLineList());
            this.rubricList.setSelectedIndex(0);
            this.generateAndShowHtml(false);
        }
    }

    private void generateAndShowHtml(boolean bl) {
        try {
            if (bl) {
                this.showPanel.initPanel(this, null);
            }
            User.instance().setProperty("FormUsePolar", this.usePolar.isSelected());
            FormUtil.generateHtmlFromActForm(this.usePolar.isSelected(), 1);
            URL uRL = FormUtil.getActHtmlFormUrl();
            this.showPanel.initPanel(this, uRL);
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "generateAndShowHtml failed", exception);
        }
    }

    protected void selectForm() {
        int n = this.formList.getSelectedIndex();
        if (n >= 0) {
            this.rubricList.setSelectedIndex(0);
            this.rubricList.requestFocus();
        }
    }

    protected void addNewForm(String string) {
        if ((string = FormUtil.addForm(string)) != null && string.length() > 0) {
            Log.write(4, this.getClass().getName(), "addNewForm " + string);
            this.formList.clearSelection();
            this.formListModel.setNewList(FormUtil.getActualizedFormList());
            this.formList.setSelectedIndex(this.formListModel.getSelectedIndex(FormUtil.getActFormName()));
            this.setTitleText();
            this.rubricListModel.setNewList(FormUtil.getActualizedLineList());
            this.rubricList.setSelectedIndex(0);
            this.rubricList.requestFocus();
        }
    }

    protected void deleteActForm() {
        int n = this.formList.getSelectedIndex();
        if (n >= 0) {
            Log.write(4, this.getClass().getName(), "deleteActForm" + n);
            FormUtil.deleteActForm();
            this.showPanel.initPanel(this, null);
            this.formList.clearSelection();
            this.formListModel.setNewList(FormUtil.getActualizedFormList());
            if (n < this.formListModel.getSize()) {
                FormUtil.setActFormName(this.formListModel.getElementAt(n));
            } else {
                FormUtil.setActFormName(this.formListModel.getElementAt(0));
            }
            this.formList.setSelectedIndex(this.formListModel.getSelectedIndex(FormUtil.getActFormName()));
        }
    }

    protected void newTitleLine() {
        int n = this.rubricList.getSelectedIndex();
        if (n >= 0) {
            int n2 = FormUtil.addLine(n, "SectionTitle");
            this.saveLineChange(n2);
        }
    }

    protected void newTextLine() {
        int n = this.rubricList.getSelectedIndex();
        if (n >= 0) {
            int n2 = FormUtil.addLine(n, "SectionText");
            this.saveLineChange(n2);
        }
    }

    protected void deleteLine() {
        int n = this.rubricList.getSelectedIndex();
        if (n >= 0) {
            this.rubricList.clearSelection();
            FormUtil.deleteLine(n);
            this.saveLineChange(n);
        }
    }

    protected void loadCase() {
        int n;
        Log.write(4, this.getClass().getName(), "loadCase ");
        int n2 = n = this.rubricList.getSelectedIndex();
        if (n >= 0) {
            CaseRubric[] caseRubricArray;
            for (CaseRubric caseRubric : caseRubricArray = User.instance().getCaseResult().getAllRubric()) {
                if (caseRubric.isPolar()) continue;
                Rubric rubric = caseRubric.getRubric();
                n2 = FormUtil.addRubric(n2, rubric);
            }
            this.saveLineChange(n2);
        }
    }

    protected void loadRepFile() {
        int n;
        CaseResult caseResult = new CaseResult(null);
        JFileChooser jFileChooser = new JFileChooser(PatientUtil.getActPatDir());
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().toLowerCase().endsWith(".rep");
            }

            @Override
            public String getDescription() {
                return "jRep   *.rep";
            }
        });
        jFileChooser.setDialogTitle(StringResource.getString("load_case"));
        int n2 = jFileChooser.showOpenDialog(MdiMainFrame.getInstance().getDesktop());
        if (n2 == 0) {
            PatientUtil.setActPatDir(jFileChooser.getSelectedFile().getParent());
            String string = jFileChooser.getSelectedFile().getName();
            Log.write(4, this.getClass().getName(), "loadRepFile: " + string);
            FileCsvKey fileCsvKey = GetDataFile.getCaseDataRd(FileProcedures.addDirName(PatientUtil.getActPatDir(), string));
            if (fileCsvKey.isOpenRead()) {
                if (caseResult.loadCaseThenBuild(fileCsvKey)) {
                    caseResult.buildResult();
                }
                fileCsvKey.close();
            }
            Log.write(4, this.getClass().getName(), "loadCase: " + PatientUtil.getActPatDir() + ", " + string);
        }
        int n3 = n = this.rubricList.getSelectedIndex();
        if (n >= 0) {
            CaseRubric[] caseRubricArray;
            for (CaseRubric caseRubric : caseRubricArray = caseResult.getAllRubric()) {
                if (caseRubric.isPolar()) continue;
                Rubric rubric = caseRubric.getRubric();
                n3 = FormUtil.addRubric(n3, rubric);
            }
            this.saveLineChange(n3);
        }
    }

    public void rubricSelectionChanged() {
        if (this.rubricList.getSelectedIndex() >= 0) {
            this.textNewButton.setEnabled(true);
            this.lineDelButton.setEnabled(true);
            FormLine formLine = null;
            if (this.rubricList.getSelectedIndex() >= 1) {
                formLine = this.rubricListModel.getFormLineAt(this.rubricList.getSelectedIndex() - 1);
            }
            this.actSelectedLine = this.rubricListModel.getFormLineAt(this.rubricList.getSelectedIndex());
            if (this.actSelectedLine.getFormElement() != null) {
                this.titleLabel.setText(this.actSelectedLine.getFormElement().getGuiValue());
                this.textField.setText(this.actSelectedLine.getText());
                this.textField.setEditable(true);
                this.lineDelButton.setEnabled(true);
                this.acceptButton.setEnabled(true);
            } else {
                this.titleLabel.setText("-");
                this.textField.setText("");
                this.textField.setEditable(false);
                this.lineDelButton.setEnabled(false);
                this.acceptButton.setEnabled(false);
            }
            if (this.actSelectedLine.getRubric() != null && this.actSelectedLine.getRubric().length() > 0) {
                this.rubricField.setText(this.actSelectedLine.getRubric());
                this.rubricRemark.setText(this.actSelectedLine.getRemarkRubric());
                if (formLine == null || !formLine.isNextInsteadPolar()) {
                    this.rubricRemark.setEditable(true);
                    this.nextInsteadPolar.setEnabled(true);
                    this.nextInsteadPolar.setSelected(this.actSelectedLine.isNextInsteadPolar());
                } else {
                    this.rubricRemark.setEditable(false);
                    this.nextInsteadPolar.setEnabled(false);
                    this.nextInsteadPolar.setSelected(false);
                }
            } else {
                this.rubricField.setText("");
                this.rubricRemark.setText("");
                this.rubricRemark.setEditable(false);
                this.nextInsteadPolar.setEnabled(false);
                this.nextInsteadPolar.setSelected(false);
            }
            if (this.actSelectedLine.getPolar() != null && this.actSelectedLine.getPolar().length() > 0) {
                this.polarField.setText(this.actSelectedLine.getPolar());
                this.polarRemark.setText(this.actSelectedLine.getRemarkPolar());
                this.polarRemark.setEditable(true);
                this.nextInsteadPolar.setEnabled(false);
                this.nextInsteadPolar.setSelected(false);
            } else {
                this.polarField.setText("");
                this.polarRemark.setText("");
                this.polarRemark.setEditable(false);
            }
            this.titleNewButton.setEnabled(true);
            this.textNewButton.setEnabled(true);
            this.loadCase.setEnabled(User.instance().getCaseResultLength() > 0);
            this.loadRepFile.setEnabled(true);
        } else {
            this.titleNewButton.setEnabled(false);
            this.textNewButton.setEnabled(false);
            this.loadCase.setEnabled(false);
            this.loadRepFile.setEnabled(false);
            this.lineDelButton.setEnabled(false);
            this.titleLabel.setText("");
            this.textField.setText("");
            this.rubricField.setText("");
            this.rubricRemark.setText("");
            this.rubricRemark.setEditable(false);
            this.polarField.setText("");
            this.polarRemark.setText("");
            this.polarRemark.setEditable(false);
            this.nextInsteadPolar.setEnabled(false);
            this.nextInsteadPolar.setSelected(false);
            this.actSelectedLine = null;
            this.acceptButton.setEnabled(false);
        }
    }

    protected void acceptButtonAction() {
        if (this.actSelectedLine != null) {
            int n = this.rubricList.getSelectedIndex();
            this.actSelectedLine.setText(this.textField.getText());
            this.actSelectedLine.setRemarkRubric(this.rubricRemark.getText());
            this.actSelectedLine.setRemarkPolar(this.polarRemark.getText());
            this.actSelectedLine.setNextInsteadPolar(this.nextInsteadPolar.isSelected());
            this.saveLineChange(n);
        }
    }

    private void saveLineChange(int n) {
        FormUtil.writeActFormToFile();
        this.rubricListModel.setNewList(FormUtil.getActualizedLineList());
        this.generateAndShowHtml(true);
        this.showPanel.doPgEnd(false);
        if (n >= this.rubricListModel.getSize()) {
            n = this.rubricListModel.getSize() - 1;
        }
        if (n < 0) {
            n = 0;
        }
        this.rubricList.setSelectedIndex(n);
        this.actSelectedLine = this.rubricListModel.getFormLineAt(this.rubricList.getSelectedIndex());
    }

    @Override
    public void historyChanged(Object object, int n) {
    }

    @Override
    public void copyToClipboard() {
    }
}

