/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repform;

import ch.steph.apputil.User;
import ch.steph.repdata.Rubric;
import ch.steph.repform.FormElement;
import ch.steph.repform.FormLine;
import ch.steph.reputil.RepUtil;
import ch.steph.util.FileCsv;
import ch.steph.util.FileLn;
import ch.steph.util.FileProcSync;
import ch.steph.util.FileProcedures;
import ch.steph.util.GetDataFile;
import ch.steph.util.Log;
import ch.steph.util.StrProc;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class FormUtil {
    private static String formDir = "";
    private static String actFormName = "";
    private static final String CLASS_NAME = "FormUtil";
    private static final String ELEMENT_FILE_NAME = "FormElements.csv";
    private static final String TEMPLATE_FILE_NAME = "FormTemplate.htm";
    private static final String FORM_NEW_NAME = "FormNew.jform";
    private static Hashtable<String, FormElement> formElements = null;
    private static Hashtable<String, String> replaceToCellElements = null;
    private static Vector<FormLine> actLineList;

    private FormUtil() {
    }

    public static String getFormDir() {
        String string;
        if (formDir.length() < 3 && (string = GetDataFile.getDataPath()) != null) {
            String string2 = FileProcedures.addDirName(string, "Formulare");
            if (FileProcedures.exists(string2)) {
                formDir = string2;
            } else {
                FileProcSync.makeDir(string2);
                if (FileProcedures.exists(string2)) {
                    formDir = string2;
                }
            }
            Log.write(4, CLASS_NAME, "formDir: " + formDir);
        }
        return formDir;
    }

    public static String getActFormName() {
        if (actFormName.length() == 0) {
            actFormName = User.instance().getProperty("ActFormName", "");
        }
        if (actFormName.length() == 0) {
            actFormName = "";
        }
        return actFormName;
    }

    public static void setActFormName(String string) {
        if (string.length() > 0) {
            User.instance().setProperty("ActFormName", string);
            actFormName = string;
        }
    }

    public static String addForm(String string) {
        if (string != null && string.length() > 0) {
            FormUtil.setActFormName(string);
            FileCsv fileCsv = GetDataFile.getCsvFileRd(FileProcedures.systemResourceToUrl("jrepdata/FormNew.jform"));
            if (fileCsv.isOpenRead()) {
                FormUtil.setActFormName(string);
                FileCsv fileCsv2 = GetDataFile.getFormFileWr(FileProcedures.addDirName(FormUtil.getFormDir(), FormUtil.getActFormName() + ".jform"));
                if (fileCsv2.isOpenWrite()) {
                    String[] stringArray = fileCsv.readCSVLine();
                    while (stringArray != null) {
                        if (stringArray.length > 1 && stringArray[1] != null) {
                            stringArray[1] = StrProc.replaceAll(stringArray[1], "{NAME}", string);
                        }
                        fileCsv2.writeCSVLine(stringArray);
                        stringArray = fileCsv.readCSVLine();
                    }
                    fileCsv2.close();
                }
                fileCsv.close();
                return FormUtil.getActFormName();
            }
        }
        return null;
    }

    public static void deleteActForm() {
        if (FormUtil.getActFormName() != null && FormUtil.getActFormName().length() > 0) {
            actLineList = null;
            FileProcSync.delete(FormUtil.getFormDir(), FormUtil.getActFormName() + ".jform");
            FileProcSync.delete(FormUtil.getFormDir(), FormUtil.getActFormName() + ".htm");
            actFormName = null;
        }
    }

    public static Vector<String> getActualizedFormList() {
        Vector<String> vector = new Vector<String>();
        if (FormUtil.getFormDir() != null && FormUtil.getFormDir().length() > 0) {
            File file = FileProcedures.getFile(FormUtil.getFormDir());
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    String string = file2.getName().toLowerCase();
                    if (file2.isDirectory() || !string.endsWith(".jform".toLowerCase())) continue;
                    vector.addElement(file2.getName().substring(0, file2.getName().length() - ".jform".length()));
                }
            }
            vector.sort(String.CASE_INSENSITIVE_ORDER);
        }
        return vector;
    }

    public static boolean hasFormsDefined() {
        File file;
        File[] fileArray;
        if (FormUtil.getFormDir() != null && FormUtil.getFormDir().length() > 0 && (fileArray = (file = FileProcedures.getFile(FormUtil.getFormDir())).listFiles()) != null) {
            for (File file2 : fileArray) {
                String string = file2.getName().toLowerCase();
                if (file2.isDirectory() || !string.endsWith(".htm".toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private static Hashtable<String, FormElement> getFormElements() {
        if (formElements == null) {
            formElements = new Hashtable();
            replaceToCellElements = new Hashtable();
            FileCsv fileCsv = GetDataFile.getCsvFileRd(FileProcedures.systemResourceToUrl("jrepdata/FormElements.csv"));
            if (fileCsv.isOpenRead()) {
                String[] stringArray = fileCsv.readCSVLine();
                while (stringArray != null) {
                    if (stringArray.length > 1) {
                        try {
                            if ("ReplaceToCell".equals(stringArray[0])) {
                                replaceToCellElements.put(stringArray[1], stringArray[2]);
                            } else {
                                formElements.put(stringArray[0], new FormElement(stringArray));
                            }
                        }
                        catch (Exception exception) {
                            Log.write(3, CLASS_NAME, "getFormElements error reading line", exception);
                        }
                    }
                    stringArray = fileCsv.readCSVLine();
                }
            }
        }
        return formElements;
    }

    public static Vector<FormLine> getActualizedLineList() {
        FileCsv fileCsv;
        actLineList = new Vector();
        if (actFormName.length() > 0 && (fileCsv = GetDataFile.getFormFileRd(FileProcedures.addDirName(FormUtil.getFormDir(), actFormName + ".jform"))).isOpenRead()) {
            String[] stringArray = fileCsv.readCSVLine();
            while (stringArray != null) {
                try {
                    FormElement formElement = FormUtil.getFormElements().get(stringArray[0]);
                    if (formElement != null) {
                        FormLine formLine = new FormLine(formElement, stringArray);
                        actLineList.add(formLine);
                    }
                }
                catch (Exception exception) {
                    Log.write(3, CLASS_NAME, "getActualizedLineList error reading line in: " + actFormName, exception);
                }
                stringArray = fileCsv.readCSVLine();
            }
            fileCsv.close();
            stringArray = new FormLine(null, null);
            actLineList.add((FormLine)stringArray);
        }
        return actLineList;
    }

    private static Vector<FormLine> getLineList() {
        return actLineList;
    }

    public static int addLine(int n, String string) {
        Log.write(4, CLASS_NAME, "addLine: " + n + ", " + string);
        FormElement formElement = FormUtil.getFormElements().get(string);
        if (formElement != null) {
            String[] stringArray = new String[]{formElement.getName(), formElement.getGuiValue()};
            FormLine formLine = new FormLine(formElement, stringArray);
            actLineList.insertElementAt(formLine, n);
            return actLineList.indexOf(formLine) + 1;
        }
        return -1;
    }

    public static int addRubric(int n, Rubric rubric) {
        if (rubric != null) {
            Object object;
            String string = rubric.getRubricKeyWithChangedExtension();
            Rubric rubric2 = RepUtil.getPolarRubric(rubric);
            FormElement formElement = FormUtil.getFormElements().get("Rubric");
            String[] stringArray = new String[6];
            stringArray[0] = formElement.getName();
            stringArray[1] = rubric.getRubricTextOnly();
            stringArray[2] = string;
            stringArray[4] = "";
            if (rubric2 != null) {
                object = stringArray[1];
                stringArray[1] = FormUtil.getRubric((String)object);
                stringArray[4] = FormUtil.getRemark((String)object);
                stringArray[3] = rubric2.getRubricKeyWithChangedExtension();
                object = rubric2.getRubricTextOnly();
                stringArray[5] = FormUtil.getRemark((String)object);
                if (stringArray[5].length() == 0) {
                    stringArray[5] = object;
                }
            }
            object = new FormLine(formElement, stringArray);
            actLineList.insertElementAt((FormLine)object, n);
            return actLineList.indexOf(object) + 1;
        }
        return -1;
    }

    private static String getRemark(String string) {
        for (String string2 : replaceToCellElements.keySet()) {
            String string3 = " " + string2;
            if (!string.contains(string3)) continue;
            return replaceToCellElements.get(string2);
        }
        return "";
    }

    private static String getRubric(String string) {
        for (String string2 : replaceToCellElements.keySet()) {
            String string3 = " " + string2;
            int n = string.indexOf(string3);
            if (n < 0) continue;
            return StrProc.replaceAll(string, string3, "").trim();
        }
        return string;
    }

    public static void deleteLine(int n) {
        Log.write(4, CLASS_NAME, "deleteLine: " + n);
        actLineList.removeElementAt(n);
    }

    private static String getActHtmlFormName() {
        return FileProcedures.addDirName(FormUtil.getFormDir(), FormUtil.getActFormName() + ".htm");
    }

    public static URL getActHtmlFormUrl() {
        return FileProcedures.nameToUrl(FormUtil.getActHtmlFormName());
    }

    public static URL getHtmlFormName(String string) {
        return FileProcedures.nameToUrl(FileProcedures.addDirName(FormUtil.getFormDir(), string + ".htm"));
    }

    private static String getActFormFileName() {
        return FileProcedures.addDirName(FormUtil.getFormDir(), FormUtil.getActFormName() + ".jform");
    }

    public static void writeActFormToFile() {
        Log.write(4, CLASS_NAME, "writeActFormToFile: " + actFormName);
        FileCsv fileCsv = GetDataFile.getFormFileWr(FormUtil.getActFormFileName());
        if (fileCsv.isOpenWrite()) {
            for (FormLine formLine : actLineList) {
                if (formLine.getFormElement() == null) continue;
                fileCsv.writeCSVLine(formLine.getLineToSave());
            }
            fileCsv.close();
        }
    }

    public static void generateHtmlFromActForm(boolean bl, int n) {
        String string;
        Object object;
        Object object2;
        URL uRL = FormUtil.getActHtmlFormUrl();
        if (uRL == null && ((FileLn)(object2 = GetDataFile.getDataFileRd(FileProcedures.systemResourceToUrl("jrepdata/FormTemplate.htm")))).isOpenRead()) {
            FileCsv fileCsv = GetDataFile.getFormFileWr(FormUtil.getActHtmlFormName());
            if (fileCsv.isOpenWrite()) {
                object = ((FileLn)object2).readLn();
                while (object != null) {
                    fileCsv.setUtf8(((FileLn)object2).isUtf8());
                    fileCsv.writeLn((String)object);
                    object = ((FileLn)object2).readLn();
                }
                fileCsv.close();
            }
            ((FileLn)object2).close();
        }
        uRL = FormUtil.getActHtmlFormUrl();
        object2 = null;
        boolean bl2 = true;
        if (uRL != null) {
            Log.write(4, CLASS_NAME, "generateHtmlFromActForm: " + actFormName);
            object2 = new Vector();
            object = GetDataFile.getDataFileRd(uRL);
            if (((FileLn)object).isOpenRead()) {
                boolean bl3 = false;
                string = ((FileLn)object).readLn();
                while (string != null) {
                    if (string.contains("8859-1") && string.toLowerCase().contains("charset")) {
                        ((FileLn)object).setUtf8(false);
                    }
                    if (string.contains("<!-- jRepTag: ")) {
                        ((Vector)object2).add(string);
                        bl3 = true;
                    } else if (string.contains("<!-- jRepEnd")) {
                        ((Vector)object2).add(string);
                        bl3 = false;
                    } else if (!bl3) {
                        ((Vector)object2).add(string);
                    }
                    string = ((FileLn)object).readLn();
                }
                bl2 = ((FileLn)object).isUtf8();
                ((FileLn)object).close();
            }
        }
        if (((FileLn)(object = GetDataFile.getFormFileWr(FormUtil.getActHtmlFormName()))).isOpenWrite() && object2 != null && FormUtil.getLineList() != null) {
            ((FileLn)object).setUtf8(bl2);
            Iterator iterator = ((Vector)object2).iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                ((FileLn)object).writeLn(string);
                if (!string.contains("<!-- jRepTag: ")) continue;
                FormUtil.writeTag((FileLn)object, string, bl, n);
            }
            ((FileLn)object).close();
        }
    }

    private static void writeTag(FileLn fileLn, String string, boolean bl, int n) {
        String string2 = string.substring(string.indexOf("<!-- jRepTag: ") + 14, string.indexOf(" ", string.indexOf("<!-- jRepTag: ") + 15));
        if ("FormTitle".equals(string2) || "HeaderTitle".equals(string2) || "HeaderText".equals(string2)) {
            FormUtil.writeFormOnce(string2, fileLn);
        }
        if ("Body".equals(string2)) {
            FormUtil.writeFormBody(fileLn, bl, n);
        }
    }

    private static void writeFormOnce(String string, FileLn fileLn) {
        for (FormLine formLine : actLineList) {
            if (!formLine.getFormElement().getName().equals(string)) continue;
            fileLn.writeLn("  " + formLine.getFormElement().getStartTag() + formLine.getText() + formLine.getFormElement().getEndTag());
            return;
        }
    }

    private static void writeFormBody(FileLn fileLn, boolean bl, int n) {
        FormElement formElement = FormUtil.getFormElements().get("Cell");
        int n2 = 0;
        for (int i = 0; i < actLineList.size(); ++i) {
            FormLine formLine = actLineList.get(i);
            if (formLine.getFormElement() == null) continue;
            if ("SectionTitle".equals(formLine.getFormElement().getName()) || "SectionText".equals(formLine.getFormElement().getName())) {
                if (n2 > 0) {
                    fileLn.writeLn("    </tr>");
                    n2 = 0;
                }
                if (bl) {
                    fileLn.writeLn("    <tr>\n      <td colspan='" + n * 7 + "'>");
                } else {
                    fileLn.writeLn("    <tr>\n      <td colspan='" + n * 4 + "'>");
                }
                fileLn.writeLn("        " + formLine.getFormElement().getStartTag() + formLine.getText() + formLine.getFormElement().getEndTag());
                fileLn.writeLn("      </td>\n    </tr>");
            }
            if (!"Rubric".equals(formLine.getFormElement().getName())) continue;
            if (n2 == 0) {
                fileLn.writeLn("    <tr>");
            }
            fileLn.writeLn("      " + formLine.getFormElement().getStartTag() + formLine.getText() + formLine.getFormElement().getEndTag());
            fileLn.writeLn("      " + formElement.getStartTag() + formLine.getRemarkRubric() + formElement.getEndTag());
            fileLn.writeLn("      " + formElement.getStartTag() + "<input type='checkbox' name='in-" + formLine.getRubric() + "' checked> " + formElement.getEndTag());
            fileLn.writeLn("      " + formElement.getStartTag() + "<input type='checkbox' name='do-" + formLine.getRubric() + "' checked> " + formElement.getEndTag());
            if (bl) {
                if (formLine.getPolar().length() > 0) {
                    fileLn.writeLn("      " + formElement.getStartTag() + formLine.getRemarkPolar() + formElement.getEndTag());
                    fileLn.writeLn("      " + formElement.getStartTag() + "<input type='checkbox' name='in-" + formLine.getPolar() + "' checked> " + formElement.getEndTag());
                    fileLn.writeLn("      " + formElement.getStartTag() + "<input type='checkbox' name='do-" + formLine.getPolar() + "' checked> " + formElement.getEndTag());
                } else if (!formLine.isNextInsteadPolar()) {
                    fileLn.writeLn("      <td> </td>");
                    fileLn.writeLn("      <td> </td>");
                    fileLn.writeLn("      <td> </td>");
                } else if ((formLine = actLineList.get(++i)) != null && "Rubric".equals(formLine.getFormElement().getName())) {
                    fileLn.writeLn("      " + formElement.getStartTag() + formLine.getText() + formElement.getEndTag());
                    fileLn.writeLn("      " + formElement.getStartTag() + "<input type='checkbox' name='in-" + formLine.getRubric() + "' checked> " + formElement.getEndTag());
                    fileLn.writeLn("      " + formElement.getStartTag() + "<input type='checkbox' name='do-" + formLine.getRubric() + "' checked> " + formElement.getEndTag());
                }
            }
            if (++n2 < n) continue;
            fileLn.writeLn("    </tr>");
            n2 = 0;
        }
    }
}

