/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repmodel;

import ch.steph.apputil.StringResource;
import ch.steph.repdata.RepDataPool;
import ch.steph.repui.CrAuthorSelect;
import ch.steph.reputil.complete.AuthorEntry;
import ch.steph.util.FileLn;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class CrAuthorTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private CrAuthorSelect crAuthorSelect;
    private List<AuthorEntry> authorList;
    private Vector<Integer> filteredIndex = null;
    private int repIndex;
    private String lastFilter = "";

    public CrAuthorTableModel(int n, CrAuthorSelect crAuthorSelect) {
        this.repIndex = n;
        this.crAuthorSelect = crAuthorSelect;
        this.authorList = RepDataPool.getInstance().getRepFile(n).getReadCompleteRubrics().getAuthorsList();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.filteredIndex != null && n < this.filteredIndex.size()) {
            n = this.filteredIndex.get(n);
        }
        if (this.authorList == null || n >= this.authorList.size()) {
            return "";
        }
        switch (n2) {
            default: {
                return "not defined";
            }
            case 0: {
                return this.authorList.get(n).getCheckBox();
            }
            case 1: {
                return this.authorList.get(n).getName();
            }
            case 2: 
        }
        return this.authorList.get(n).getDates();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.filteredIndex != null) {
            n = this.filteredIndex.get(n);
        }
        if (n2 == 0) {
            boolean bl = (Boolean)object;
            this.authorList.get(n).setCheckBox(bl);
            this.crAuthorSelect.setStatus();
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        if (this.filteredIndex != null) {
            return this.filteredIndex.size();
        }
        return this.authorList.size();
    }

    public int getCheckedCount() {
        int n = 0;
        for (AuthorEntry authorEntry : this.authorList) {
            if (!authorEntry.getCheckBox().booleanValue()) continue;
            ++n;
        }
        return n;
    }

    public int getAllCount() {
        return this.authorList.size();
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            default: {
                return "not defined";
            }
            case 0: {
                return "";
            }
            case 1: {
                return StringResource.getString("author_name");
            }
            case 2: 
        }
        return StringResource.getString("author_date");
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    public void setAllCheckBoxes(boolean bl) {
        for (AuthorEntry authorEntry : this.authorList) {
            if (bl) {
                authorEntry.setCheckBox(true);
                continue;
            }
            authorEntry.setCheckBox(authorEntry.isAccepted());
        }
    }

    public boolean okAction() {
        boolean bl = false;
        for (AuthorEntry object : this.authorList) {
            if (object.getCheckBox().booleanValue() == object.isAccepted()) continue;
            bl = true;
        }
        if (bl) {
            FileLn fileLn = RepDataPool.getInstance().getRepFile(this.repIndex).getReadCompleteRubrics().getExternalAuthorFile();
            if (fileLn.isOpenWrite()) {
                for (AuthorEntry authorEntry : this.authorList) {
                    if (authorEntry.getCheckBox().booleanValue()) {
                        fileLn.writeLn(authorEntry.getId() + "\t" + authorEntry.getName() + "\t" + authorEntry.getDates());
                        continue;
                    }
                    fileLn.writeLn("#" + authorEntry.getId() + "\t" + authorEntry.getName() + "\t" + authorEntry.getDates());
                }
            }
            return true;
        }
        return false;
    }

    public void filterMedis(String string) {
        if (string == null || string.length() == 0) {
            if (this.filteredIndex != null) {
                this.filteredIndex = null;
                this.fireTableDataChanged();
            }
            this.lastFilter = "";
        } else if (!string.equals(this.lastFilter)) {
            this.lastFilter = string;
            string = string.toLowerCase();
            this.filteredIndex = new Vector();
            for (int i = 0; i < this.authorList.size(); ++i) {
                if (!this.authorList.get(i).getName().toLowerCase().startsWith(string)) continue;
                this.filteredIndex.add(i);
            }
            this.fireTableDataChanged();
        }
    }
}

