/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repmodel;

import ch.steph.util.Constants;
import ch.steph.util.FileLn;
import ch.steph.util.FileLnProcedures;
import ch.steph.util.FsetJEditorPane;
import ch.steph.util.Log;
import ch.steph.util.WaitMonitor;
import java.net.URL;
import javax.swing.text.Document;

public class GetDocumentText {
    private boolean loadingPage = false;
    private WaitMonitor waitMonitor = new WaitMonitor();
    private FsetJEditorPane fsetPane = null;
    private String resultText = "";

    public GetDocumentText(URL uRL) {
        if (uRL == null) {
            Log.write(5, this.getClass().getName(), "url is null");
            return;
        }
        String string = uRL.getFile();
        if (Constants.isKnownHtmFile(string) || Constants.isKnownRtfFile(string)) {
            this.fsetPane = new FsetJEditorPane();
            this.fsetPane.setEditable(false);
            this.fsetPane.addPropertyChangeListener("page", propertyChangeEvent -> this.documentLoaded());
            try {
                this.loadingPage = true;
                this.fsetPane.setFsetPage(uRL);
            }
            catch (Exception exception) {
                Log.write(5, this.getClass().getName(), "Not Loaded: " + String.valueOf(uRL), exception);
                this.loadingPage = false;
            }
        } else if (string.endsWith(".rep")) {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                FileLn fileLn = FileLnProcedures.getDiskFileRd(uRL);
                String string2 = fileLn.readLn();
                if (string2 != null) {
                    string2 = fileLn.readLn();
                    while (string2 != null) {
                        int n = string2.indexOf(59);
                        if (n > 0) {
                            string2 = string2.substring(0, n);
                        }
                        stringBuilder.append(string2);
                        stringBuilder.append('\n');
                        string2 = fileLn.readLn();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.resultText = stringBuilder.toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                FileLn fileLn = FileLnProcedures.getDiskFileRd(uRL);
                String string3 = fileLn.readLn();
                while (string3 != null) {
                    stringBuilder.append(string3);
                    stringBuilder.append('\n');
                    string3 = fileLn.readLn();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.resultText = stringBuilder.toString();
        }
    }

    private void documentLoaded() {
        this.loadingPage = false;
        this.waitMonitor.doNotifyNow();
    }

    public String getDocumentText() {
        Document document;
        if (this.loadingPage) {
            this.waitMonitor.doWaitNow();
        }
        if (this.fsetPane != null && (document = this.fsetPane.getDocument()) != null) {
            try {
                return document.getText(0, document.getLength());
            }
            catch (Exception exception) {
                Log.write(5, this.getClass().getName(), "searchInActDocument ", exception);
            }
        }
        return this.resultText;
    }
}

