/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repmodel;

import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.SearchResult;
import ch.steph.rep.SearchThread;
import ch.steph.repdata.RepDataPool;
import ch.steph.repdata.Rubric;
import ch.steph.util.Log;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;

public class MediCompareTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private SearchResult searchResult1;
    private SearchResult searchResult2;
    private String[] medis;
    protected OneResult[] resultList = new OneResult[0];
    private String actMedi1 = "";
    private String actMedi2 = "";
    private int actWert = 0;
    private boolean waitFor1 = false;
    private boolean waitFor2 = false;
    private boolean waitForMerge = false;

    public MediCompareTableModel(int n) {
        this.setNewRep(n);
    }

    public void setNewRep(int n) {
        User.instance().getNewCompareSearchThread(n).getRepHeader();
        this.medis = RepDataPool.getInstance().getRepHeader(n).getRepMedis();
        this.actMedi1 = "";
        this.actMedi2 = "";
        this.actWert = 0;
        this.waitFor1 = false;
        this.waitFor2 = false;
        this.waitForMerge = false;
    }

    public SearchThread getSearch() {
        return User.instance().getCompareSearchThread();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        OneResult oneResult = this.resultList[n];
        switch (n2) {
            default: {
                return oneResult.rubric.getShowRubric(true, false);
            }
            case 0: {
                if (oneResult.count1 > 0) {
                    return "" + oneResult.count1;
                }
                return "";
            }
            case 1: 
        }
        if (oneResult.count2 > 0) {
            return "" + oneResult.count2;
        }
        return "";
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.resultList.length;
    }

    @Override
    public String getColumnName(int n) {
        return null;
    }

    public Rubric getRubricAt(int n) {
        Rubric rubric = null;
        if (n >= 0 && this.resultList != null && n < this.resultList.length) {
            rubric = this.resultList[n].rubric;
        }
        return rubric;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void resetMedis() {
        this.waitWhileRunning();
        this.actMedi1 = "";
        this.actMedi2 = "";
        this.searchResult1 = null;
        this.searchResult2 = null;
        Log.write(5, this.getClass().getName(), "resetMedis");
        this.mergeResults();
    }

    public void setMedi1(String string) {
        if (!this.actMedi1.equals(string)) {
            this.waitWhileRunning();
            this.actMedi1 = string;
            if (string.length() == 0) {
                Log.write(5, this.getClass().getName(), "setNoMedi2");
                this.searchResult1 = null;
            } else {
                this.waitFor1 = true;
                Log.write(5, this.getClass().getName(), "setMedi1");
            }
        }
    }

    public void setMedi2(String string) {
        if (!this.actMedi2.equals(string)) {
            this.waitWhileRunning();
            this.actMedi2 = string;
            if (this.actMedi2.length() == 0) {
                Log.write(5, this.getClass().getName(), "setNoMedi2");
                this.searchResult2 = null;
            } else {
                this.waitFor2 = true;
                Log.write(5, this.getClass().getName(), "setMedi2");
            }
        }
    }

    public void setWert(String string) {
        int n = 0;
        if (string.length() > 0) {
            n = string.charAt(0) - 48;
        }
        if (n != this.actWert) {
            this.waitWhileRunning();
            this.actWert = n;
            Log.write(5, this.getClass().getName(), "setWert");
        }
    }

    public String getRunString() {
        if (this.waitFor1) {
            int n = User.instance().getCompareSearchThread().getRunCount();
            String string = User.instance().getCompareSearchThread().getRunText();
            if (this.searchResult2 != null) {
                n += this.searchResult2.size();
            }
            return n + " " + string;
        }
        if (this.waitFor2) {
            int n = User.instance().getCompareSearchThread().getRunCount();
            String string = User.instance().getCompareSearchThread().getRunText();
            if (this.searchResult1 != null) {
                n += this.searchResult1.size();
            }
            return n + " " + string;
        }
        if (this.waitForMerge) {
            int n = 0;
            int n2 = 0;
            if (this.searchResult1 != null) {
                n = this.searchResult1.size();
            }
            if (this.searchResult2 != null) {
                n2 = this.searchResult2.size();
            }
            return n + n2 + " " + StringResource.getString("medicomp_text1");
        }
        if (this.resultList != null && this.resultList.length > 0) {
            return this.resultList.length + " " + StringResource.getString("search_ok");
        }
        return "-";
    }

    public void searchNow() {
        if (this.waitFor1) {
            this.getSearch().loadWithValue(this.actMedi1, '1', null, this.medis);
            this.searchResult1 = this.getSearch().getSearchResult();
            this.waitFor1 = false;
        }
        if (this.waitFor2) {
            this.getSearch().loadWithValue(this.actMedi2, '1', null, this.medis);
            this.searchResult2 = this.getSearch().getSearchResult();
            this.waitFor2 = false;
        }
        this.mergeResults();
    }

    private void waitWhileRunning() {
        Log.write(5, this.getClass().getName(), "waitWhileRunning " + this.waitFor1 + " " + this.waitFor2);
        int n = 0;
        while ((this.waitFor1 || this.waitFor2 || this.waitForMerge) && n < 99) {
            Log.write(5, this.getClass().getName(), "waitWhileRunning " + this.waitFor1 + " " + this.waitFor2 + " " + ++n);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    private void mergeResults() {
        Iterator iterator;
        int n;
        this.waitForMerge = true;
        TreeSet treeSet = new TreeSet();
        if (this.searchResult1 != null) {
            for (n = 0; n < this.searchResult1.size(); ++n) {
                iterator = new OneResult();
                ((OneResult)((Object)iterator)).rubric = this.searchResult1.getByRubricIndex(n);
                ((OneResult)((Object)iterator)).count1 = ((OneResult)((Object)iterator)).rubric.getLoadValue();
                treeSet.add(iterator);
            }
        }
        if (this.searchResult2 != null) {
            for (n = 0; n < this.searchResult2.size(); ++n) {
                iterator = new OneResult();
                ((OneResult)((Object)iterator)).rubric = this.searchResult2.getByRubricIndex(n);
                ((OneResult)((Object)iterator)).count2 = ((OneResult)((Object)iterator)).rubric.getLoadValue();
                if (treeSet.contains(iterator)) {
                    void object;
                    Iterator n2 = treeSet.iterator();
                    while (object != null && object.hasNext()) {
                        OneResult oneResult = (OneResult)object.next();
                        if (!oneResult.equals(iterator)) continue;
                        oneResult.count2 = ((OneResult)((Object)iterator)).count2;
                        Object var4_7 = null;
                    }
                    continue;
                }
                treeSet.add(iterator);
            }
        }
        ArrayList<OneResult> arrayList = new ArrayList<OneResult>();
        for (OneResult oneResult : treeSet) {
            if (oneResult.count1 < this.actWert && oneResult.count2 < this.actWert) continue;
            arrayList.add(oneResult);
        }
        iterator = arrayList.iterator();
        this.resultList = new OneResult[arrayList.size()];
        boolean bl = false;
        while (iterator.hasNext()) {
            void var4_11;
            this.resultList[var4_11] = (OneResult)iterator.next();
            ++var4_11;
        }
        this.waitForMerge = false;
        super.fireTableDataChanged();
    }

    protected static class OneResult
    implements Comparable<OneResult> {
        int count1 = 0;
        int count2 = 0;
        Rubric rubric = null;

        @Override
        public int compareTo(OneResult oneResult) {
            return this.rubric.compareTo(oneResult.rubric);
        }

        public boolean equals(Object object) {
            if (object instanceof OneResult) {
                OneResult oneResult = (OneResult)object;
                return this.rubric.equals(oneResult.rubric);
            }
            return false;
        }
    }
}

