/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repmodel;

import ch.steph.reputil.MmUtil;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;

public class MmMediListModel
extends AbstractListModel<String> {
    private static final long serialVersionUID = 1L;
    private String[] inputMedis;
    private String[] medisAndAddons;
    private String[] showMedis;
    private Vector<Integer> filteredIndex = null;
    private int[] actResultCount;
    private int lastMm = -1;
    private final Object filterLock = new Object();

    public MmMediListModel(String[] stringArray) {
        int n;
        this.inputMedis = stringArray;
        String[] stringArray2 = MmUtil.getMmAddon();
        this.medisAndAddons = new String[stringArray.length + stringArray2.length];
        for (n = 0; n < stringArray.length; ++n) {
            this.medisAndAddons[n] = stringArray[n];
        }
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.medisAndAddons[n] = stringArray2[n2];
            ++n2;
            ++n;
        }
        this.actResultCount = new int[this.getSize()];
    }

    @Override
    public String getElementAt(int n) {
        Object object = null;
        if (this.getSize() > 0) {
            object = this.getMediByIndex(n);
            if (this.actResultCount[n] > 0) {
                object = (String)object + " {" + this.actResultCount[n] + "}";
            }
        }
        return object;
    }

    public String getMediByIndex(int n) {
        if (this.lastMm != 0) {
            if (n == 0) {
                return "MM-Info";
            }
            --n;
        }
        if (this.filteredIndex != null && n >= 0 && n < this.filteredIndex.size()) {
            n = this.filteredIndex.get(n);
        }
        if (this.medisAndAddons != null && n >= 0 && n < this.medisAndAddons.length) {
            return this.medisAndAddons[n];
        }
        return null;
    }

    public int getIndexByMedi(String string) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.getMediByIndex(i).equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getSize() {
        int n = 1;
        if (this.lastMm == 0) {
            n = 0;
        }
        if (this.filteredIndex != null) {
            return this.filteredIndex.size() + n;
        }
        if (this.medisAndAddons != null) {
            return this.medisAndAddons.length + n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int filterMedisByMm(int n) {
        Object object = this.filterLock;
        synchronized (object) {
            if (n != this.lastMm) {
                this.lastMm = n;
                this.showMedis = n == 0 ? this.inputMedis : this.medisAndAddons;
                this.filteredIndex = new Vector();
                for (int i = 0; i < this.showMedis.length; ++i) {
                    if (this.showMedis[i] == null || this.showMedis[i].length() <= 0) continue;
                    String string = this.showMedis[i].toLowerCase();
                    if (n == 0) {
                        if (!MmUtil.hasNomedInfo(string)) continue;
                        this.filteredIndex.add(i);
                        continue;
                    }
                    if (MmUtil.getUrlHtmMed(n, string, false) == null) continue;
                    this.filteredIndex.add(i);
                }
                this.actResultCount = new int[this.getSize()];
                this.fireContentsChanged(this, 0, this.getSize() - 1);
            }
        }
        return this.getSize();
    }

    public void resetResultCounter() {
        this.actResultCount = new int[this.getSize()];
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public void incrementResultCount(final int n) {
        int n2 = n;
        this.actResultCount[n2] = this.actResultCount[n2] + 1;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MmMediListModel.this.fireContentsChanged(this, n, n);
            }
        });
    }

    public String[] getMediArray() {
        String[] stringArray = new String[this.getSize() - 1];
        for (int i = 1; i < this.getSize(); ++i) {
            stringArray[i - 1] = this.getMediByIndex(i);
        }
        return stringArray;
    }

    public int[] getSearchResultForMediArray() {
        int[] nArray = new int[this.getSize() - 1];
        System.arraycopy(this.actResultCount, 1, nArray, 0, this.getSize() - 1);
        return nArray;
    }
}

