/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repmodel;

import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.repdata.CaseRubric;
import ch.steph.repdata.RepDataPool;
import ch.steph.repdata.RubricChangeValues;
import ch.steph.repui.CaseShow;
import ch.steph.reputil.RubricChangeFile;
import ch.steph.reputil.RubricOwnFile;
import ch.steph.reputil.RubricPublicFile;
import ch.steph.reputil.RubricUtil;
import ch.steph.reputil.SearchUtil;
import ch.steph.util.Log;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class RubricChangeTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private ArrayList<RubricChangeValues> valArray;
    private Vector<Integer> filteredIndex = null;
    private boolean isExtRep;
    private CaseShow caseShow;
    private CaseRubric caseRubricToChange;
    private String lastFilter = "";

    public RubricChangeTableModel(boolean bl, CaseShow caseShow, CaseRubric caseRubric, ArrayList<RubricChangeValues> arrayList) {
        this.isExtRep = bl;
        this.caseShow = caseShow;
        this.caseRubricToChange = caseRubric;
        this.valArray = arrayList;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.filteredIndex != null && n < this.filteredIndex.size()) {
            n = this.filteredIndex.get(n);
        }
        if (this.valArray == null || n >= this.valArray.size()) {
            return "";
        }
        switch (n2) {
            default: {
                return "not defined";
            }
            case 0: {
                return n + 1 + " ";
            }
            case 1: {
                return this.valArray.get(n).getMedi();
            }
            case 2: {
                return this.valArray.get(n).getOrgValue();
            }
            case 3: {
                return this.valArray.get(n).getNewValue();
            }
            case 4: {
                return this.valArray.get(n).getNewRemark();
            }
            case 5: 
        }
        return this.valArray.get(n).getNewDate();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.filteredIndex != null) {
            n = this.filteredIndex.get(n);
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                int n3 = -1;
                try {
                    if (((String)object).equals("|") || ((String)object).equalsIgnoreCase("i")) {
                        object = "2";
                    } else if (((String)object).equals("?")) {
                        object = "1";
                    }
                    n3 = Integer.parseInt((String)object);
                    if (n3 > 9) {
                        n3 = 9;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n4 = -1;
                try {
                    n4 = Integer.parseInt(this.valArray.get(n).getOrgValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n3 >= 0) {
                    this.valArray.get(n).setNewValue("" + n3);
                } else {
                    this.valArray.get(n).setNewValue("");
                }
                if (n3 != n4) {
                    if (this.valArray.get(n).getNewRemark().length() == 0 && this.valArray.get(n).getNewDate().length() == 0) {
                        this.valArray.get(n).setNewRemark("*" + this.valArray.get(n).getNewRemark());
                        this.fireTableCellUpdated(n, n2 + 1);
                    }
                    if (this.valArray.get(n).getNewDate().length() != 0) break;
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
                    String string = User.instance().getUserName();
                    if (string.length() == 0) {
                        string = StringResource.getString("regpop_not_reg").trim();
                    }
                    this.valArray.get(n).setNewDate(simpleDateFormat.format(new Date()) + ", " + string);
                    this.fireTableCellUpdated(n, n2 + 2);
                    break;
                }
                while (this.valArray.get(n).getNewRemark().startsWith("*")) {
                    this.valArray.get(n).setNewRemark(this.valArray.get(n).getNewRemark().substring(1, this.valArray.get(n).getNewRemark().length()));
                    this.fireTableCellUpdated(n, n2 + 1);
                }
                if (this.valArray.get(n).getNewDate().length() < 0) break;
                this.valArray.get(n).setNewDate("");
                this.fireTableCellUpdated(n, n2 + 2);
                break;
            }
            case 4: {
                String string = this.replaceForbiddenCharacters((String)object);
                this.valArray.get(n).setNewRemark(string);
                break;
            }
            case 5: {
                String string = this.replaceForbiddenCharacters((String)object);
                this.valArray.get(n).setNewDate(string);
            }
        }
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getRowCount() {
        if (this.filteredIndex != null) {
            return this.filteredIndex.size();
        }
        return this.valArray.size();
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            default: {
                return "not defined";
            }
            case 0: {
                return "Nr";
            }
            case 1: {
                return StringResource.getString("rep_change_title_medi");
            }
            case 2: {
                return StringResource.getString("rep_change_title_original");
            }
            case 3: {
                return StringResource.getString("rep_change_title_value");
            }
            case 4: {
                return StringResource.getString("rep_change_title_remark");
            }
            case 5: 
        }
        return StringResource.getString("rep_change_title_date");
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 >= 3;
    }

    private boolean hasValue(RubricChangeValues rubricChangeValues) {
        return rubricChangeValues.getNewValue().length() > 0;
    }

    private boolean hasChangedValue(RubricChangeValues rubricChangeValues) {
        if (rubricChangeValues.getNewValue().length() == 0) {
            return false;
        }
        return !rubricChangeValues.getNewValue().equals(rubricChangeValues.getOrgValue()) || rubricChangeValues.getNewRemark().length() != 0 || rubricChangeValues.getNewDate().length() != 0;
    }

    private String replaceForbiddenCharacters(String string) {
        string = string.replace(';', ',');
        string = string.replace('[', '(');
        string = string.replace(']', ')');
        string = string.replace('{', '(');
        string = string.replace('}', ')');
        string = string.replace('\"', '\'');
        string = string.replace('$', 'S');
        string = string.replace('~', '-');
        string = string.replace('#', '+');
        return string;
    }

    public void okAction(int n, String string, String string2, boolean bl) {
        Log.write(4, this.getClass().getName(), "rubric change: " + string);
        Collections.sort(this.valArray);
        string = this.replaceForbiddenCharacters(string);
        string2 = this.replaceForbiddenCharacters(string2);
        if (string.length() > 0 && string2.length() > 0) {
            int n2 = 0;
            for (RubricChangeValues stringArray2 : this.valArray) {
                if (!this.hasValue(stringArray2)) continue;
                ++n2;
            }
            String[] stringArray3 = new String[n2 + 1];
            String[] stringArray = new String[n2 + 1];
            String[] stringArray2 = new String[n2 + 1];
            String[] stringArray4 = new String[n2 + 1];
            stringArray3[0] = string;
            stringArray[0] = string2.startsWith(StringResource.getString("case_rubric_new2")) ? string + "  " + string2 : string + "  " + string2 + RubricUtil.getMediCountString(n2);
            stringArray2[0] = string;
            stringArray4[0] = string;
            n2 = 1;
            for (RubricChangeValues rubricChangeValues : this.valArray) {
                if (!this.hasValue(rubricChangeValues)) continue;
                stringArray3[n2] = rubricChangeValues.getMedi();
                stringArray[n2] = rubricChangeValues.getNewValue();
                ++n2;
            }
            if (this.caseShow != null) {
                n2 = 0;
                for (RubricChangeValues rubricChangeValues : this.valArray) {
                    if (!this.hasChangedValue(rubricChangeValues)) continue;
                    ++n2;
                }
                String[] bl2 = new String[n2 + 1];
                stringArray2 = new String[n2 + 1];
                stringArray4 = new String[n2 + 1];
                n2 = 1;
                for (RubricChangeValues rubricChangeValues : this.valArray) {
                    if (!this.hasChangedValue(rubricChangeValues)) continue;
                    bl2[n2] = rubricChangeValues.getMedi();
                    stringArray2[n2] = rubricChangeValues.getNewRemark();
                    stringArray4[n2] = rubricChangeValues.getNewDate();
                    ++n2;
                }
                if (this.caseRubricToChange != null) {
                    this.caseShow.deleteRubric(this.caseRubricToChange);
                }
                this.caseShow.addLine(stringArray3, "++" + stringArray[0] + "{" + n, stringArray, bl2, stringArray2, stringArray4);
            } else {
                n2 = 1;
                for (RubricChangeValues rubricChangeValues : this.valArray) {
                    if (!this.hasValue(rubricChangeValues)) continue;
                    stringArray2[n2] = rubricChangeValues.getNewRemark();
                    stringArray4[n2] = rubricChangeValues.getNewDate();
                    ++n2;
                }
                boolean bl2 = RepDataPool.getInstance().getRepHeader(n).isHierarchic();
                if (this.isExtRep) {
                    RubricPublicFile.changePublicFile(n, string, stringArray3, stringArray, stringArray2, stringArray4, bl2);
                    RubricOwnFile.addReplaceRubric(n, string, stringArray3, stringArray);
                } else {
                    RubricPublicFile.changePublicFile(n, string, stringArray3, stringArray, stringArray2, stringArray4, bl2);
                }
                if (bl) {
                    RubricChangeFile.checkFileChanged(n, stringArray3);
                    RepDataPool.getInstance().reloadRepFile(n);
                }
            }
        }
    }

    public void filterMedis(String string) {
        if (string == null || string.length() == 0) {
            if (this.filteredIndex != null) {
                this.filteredIndex = null;
                this.fireTableDataChanged();
            }
            this.lastFilter = "";
        } else if (!string.equals(this.lastFilter)) {
            this.lastFilter = string;
            this.filteredIndex = new Vector();
            for (int i = 0; i < this.valArray.size(); ++i) {
                if (!this.valArray.get(i).getSearchMedi().contains(SearchUtil.getSearchKey(string.toLowerCase()))) continue;
                this.filteredIndex.add(i);
            }
            this.fireTableDataChanged();
        }
    }

    public void setNewValueForMedi(String string, String string2) {
        for (RubricChangeValues rubricChangeValues : this.valArray) {
            if (!rubricChangeValues.getMedi().equalsIgnoreCase(string)) continue;
            rubricChangeValues.setNewValue(string2);
            return;
        }
    }
}

