/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repmodel;

import ch.steph.rep.Rep;
import ch.steph.repdata.SearchMmOneResult;
import ch.steph.repmodel.GetDocumentText;
import ch.steph.repmodel.MmMediListModel;
import ch.steph.repmodel.SearchMmThreadListener;
import ch.steph.reputil.MmUtil;
import ch.steph.reputil.SearchHighlighter;
import ch.steph.reputil.SearchParam;
import ch.steph.reputil.SearchUtil;
import ch.steph.util.Log;
import ch.steph.util.TimeProbe;
import java.net.URL;
import java.util.List;

public class SearchMmThread
implements Runnable {
    private boolean runThread;
    private int actMm;
    private int actMedi;
    private SearchMmThreadListener listener;
    private MmMediListModel mediList;
    private SearchParam searchParam;

    public SearchMmThread(int n, int n2, MmMediListModel mmMediListModel, String string, SearchMmThreadListener searchMmThreadListener) {
        Log.write(5, this.getClass().getName(), "start searching: " + string);
        this.actMm = n;
        this.actMedi = n2;
        this.mediList = mmMediListModel;
        this.searchParam = SearchUtil.getSearchStrings(string, true);
        this.listener = searchMmThreadListener;
        this.runThread = true;
        Rep.getExecutor().execute(this);
    }

    public void stopSearch() {
        this.runThread = false;
    }

    @Override
    public void run() {
        int n = -1;
        TimeProbe timeProbe = new TimeProbe();
        try {
            while (n != this.actMedi && this.runThread) {
                if (n < 0) {
                    n = this.actMedi;
                }
                URL uRL = MmUtil.getUrlHtmMed(this.actMm, this.mediList.getMediByIndex(n), false);
                timeProbe.partEnds(10, "get URL");
                GetDocumentText getDocumentText = null;
                if (!uRL.getFile().endsWith(".pdf")) {
                    getDocumentText = new GetDocumentText(uRL);
                    String string = getDocumentText.getDocumentText().toLowerCase();
                    this.searchInActDocument(string, this.mediList.getMediByIndex(n), this.searchParam);
                }
                timeProbe.partEnds(20, "search done");
                this.listener.searchInMedi(n);
                if (++n < this.mediList.getSize()) continue;
                n = 0;
            }
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "Problem while searching: " + String.valueOf(this.searchParam), exception);
        }
        this.runThread = false;
        this.listener.searchDone();
        Log.write(5, this.getClass().getName(), "search done " + timeProbe.getLogString());
    }

    private void searchInActDocument(String string, String string2, SearchParam searchParam) {
        if (string != null && string.length() > 0) {
            try {
                List<SearchHighlighter.HighLight> list = searchParam.getAllHighLights(string);
                for (SearchHighlighter.HighLight highLight : list) {
                    this.listener.searchResult(new SearchMmOneResult(string2, highLight.getStart(), highLight.getEnd() - highLight.getStart(), list));
                }
            }
            catch (Exception exception) {
                Log.write(5, this.getClass().getName(), "searchInActDocument ", exception);
            }
        }
    }
}

