/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repmodel;

import java.util.List;
import javax.swing.AbstractListModel;

public class SortedListModel
extends AbstractListModel<String> {
    private static final long serialVersionUID = 1L;
    private List<String> listVector;
    private List<Integer> filteredIndex = null;

    public SortedListModel(List<String> list) {
        this.listVector = list;
        if (list != null && list.size() > 1) {
            this.listVector.sort((string, string2) -> {
                if (string == null) {
                    return 0;
                }
                return string.compareToIgnoreCase((String)string2);
            });
        }
    }

    public SortedListModel(List<String> list, boolean bl) {
        this.listVector = list;
        if (list != null && list.size() > 1) {
            this.listVector.sort((string, string2) -> {
                if (bl) {
                    if (string2 == null) {
                        return 0;
                    }
                    return string2.compareToIgnoreCase((String)string);
                }
                if (string == null) {
                    return 0;
                }
                return string.compareToIgnoreCase((String)string2);
            });
        }
    }

    @Override
    public String getElementAt(int n) {
        if (n < this.listVector.size()) {
            if (this.filteredIndex != null && n >= 0 && n < this.filteredIndex.size()) {
                n = this.filteredIndex.get(n);
            }
            return this.listVector.get(n);
        }
        return null;
    }

    @Override
    public int getSize() {
        if (this.filteredIndex != null) {
            return this.filteredIndex.size();
        }
        if (this.listVector != null) {
            return this.listVector.size();
        }
        return 0;
    }

    public int getSelectedIndex(String string) {
        if (this.filteredIndex != null) {
            return this.filteredIndex.size();
        }
        if (this.listVector != null && string != null) {
            return this.listVector.indexOf(string);
        }
        return 0;
    }

    public void setNewList(List<String> list) {
        this.setNewList(list, false);
    }

    public void setNewList(List<String> list, boolean bl) {
        this.listVector = list;
        this.listVector.sort((string, string2) -> {
            if (bl) {
                if (string2 == null) {
                    return 0;
                }
                return string2.compareToIgnoreCase((String)string);
            }
            if (string == null) {
                return 0;
            }
            return string.compareToIgnoreCase((String)string2);
        });
        this.fireContentsChanged(this, 0, this.listVector.size() - 1);
    }
}

