/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repmodel;

import ch.steph.repmodel.GetDocumentText;
import ch.steph.util.FileProcedures;
import ch.steph.util.Log;
import ch.steph.util.ShowListEntry;
import ch.steph.util.TimeProbe;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;

public class SortedShowEntryModel
extends AbstractListModel<ShowListEntry> {
    private static final long serialVersionUID = 1L;
    private List<ShowListEntry> listVector;
    private List<Integer> filteredIndex = null;
    private String searchedText = "";
    private final Object filterLock = new Object();

    public SortedShowEntryModel(List<ShowListEntry> list) {
        this.listVector = list;
        if (list != null && list.size() > 1) {
            this.listVector.sort((showListEntry, showListEntry2) -> {
                if (showListEntry == null) {
                    return 0;
                }
                return showListEntry.getShowname().compareToIgnoreCase(showListEntry2.getShowname());
            });
        }
    }

    public SortedShowEntryModel(List<ShowListEntry> list, boolean bl) {
        this.listVector = list;
        if (list != null && list.size() > 1) {
            this.listVector.sort((showListEntry, showListEntry2) -> {
                if (bl) {
                    if (showListEntry2 == null) {
                        return 0;
                    }
                    return showListEntry2.getShowname().compareToIgnoreCase(showListEntry.getShowname());
                }
                if (showListEntry == null) {
                    return 0;
                }
                return showListEntry.getShowname().compareToIgnoreCase(showListEntry2.getShowname());
            });
        }
    }

    @Override
    public ShowListEntry getElementAt(int n) {
        if (n < this.listVector.size()) {
            if (this.filteredIndex != null && n >= 0 && n < this.filteredIndex.size()) {
                n = this.filteredIndex.get(n);
            }
            return this.listVector.get(n);
        }
        return null;
    }

    @Override
    public int getSize() {
        if (this.filteredIndex != null) {
            return this.filteredIndex.size();
        }
        if (this.listVector != null) {
            return this.listVector.size();
        }
        return 0;
    }

    public int getSelectedIndex(ShowListEntry showListEntry) {
        if (this.filteredIndex != null) {
            return this.filteredIndex.size();
        }
        if (this.listVector != null && showListEntry != null) {
            return this.listVector.indexOf(showListEntry);
        }
        return 0;
    }

    public void setNewList(List<ShowListEntry> list) {
        this.listVector = list;
        this.filteredIndex = null;
        String string = this.searchedText;
        this.searchedText = "";
        this.listVector.sort((showListEntry, showListEntry2) -> {
            if (showListEntry == null || showListEntry2 == null) {
                return 0;
            }
            return showListEntry.getSortString().compareToIgnoreCase(showListEntry2.getSortString());
        });
        if (string.length() > 0) {
            this.filterEntriesBySearch(string);
        } else {
            this.updateListAsynch();
        }
    }

    public List<ShowListEntry> getList() {
        return this.listVector;
    }

    public void resetFilter() {
        if (this.filteredIndex != null) {
            this.filteredIndex = null;
            this.searchedText = "";
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int filterEntriesBySearch(String string) {
        String string2 = string;
        Object object = this.filterLock;
        synchronized (object) {
            if (!string2.equals(this.searchedText)) {
                Object object2;
                TimeProbe timeProbe = new TimeProbe();
                for (ShowListEntry showListEntry : this.listVector) {
                    timeProbe.partEnds(10, "check file");
                    if (showListEntry.getSearchtext() != null) continue;
                    object2 = FileProcedures.nameToUrl(showListEntry.getUrlString());
                    GetDocumentText getDocumentText = new GetDocumentText((URL)object2);
                    String[] stringArray = getDocumentText.getDocumentText().toLowerCase();
                    String string3 = showListEntry.getFilenameNoExtension().toLowerCase();
                    showListEntry.setSearchtext(string3 + " " + (String)stringArray);
                    timeProbe.partEnds(20, "search text loaded");
                }
                this.searchedText = string2;
                if (this.searchedText.length() >= 2) {
                    int n;
                    this.filteredIndex = new Vector<Integer>();
                    String[] stringArray = this.searchedText.toLowerCase().split(" ");
                    for (n = 0; n < stringArray.length; ++n) {
                        stringArray[n] = stringArray[n].replace("_", " ");
                    }
                    for (n = 0; n < this.listVector.size(); ++n) {
                        object2 = this.listVector.get(n).getSearchtext();
                        if (this.listVector.get(n) == null || object2 == null) continue;
                        boolean bl = true;
                        for (String string4 : stringArray) {
                            if (((String)object2).contains(string4)) continue;
                            bl = false;
                        }
                        if (!bl) continue;
                        this.filteredIndex.add(n);
                    }
                    timeProbe.partEnds(30, "search done");
                    SwingUtilities.invokeLater(this::updateListAsynch);
                } else {
                    this.resetFilter();
                    timeProbe.partEnds(30, "reset done");
                }
                Log.write(5, this.getClass().getName(), "search end " + timeProbe.getLogString());
            }
        }
        return this.getSize();
    }

    private void updateListAsynch() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }
}

