/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.MdiNormalFrame;
import ch.steph.apputil.StringResource;
import ch.steph.rep.CaseResult;
import ch.steph.rep.Rep;
import ch.steph.repdata.CaseRubric;
import ch.steph.repmodel.CaseShowTableModel;
import ch.steph.repui.CaseShowTable;
import ch.steph.repui.RepMainFrame;
import ch.steph.repui.RepMainMenu;
import ch.steph.reputil.PatientUtil;
import ch.steph.reputil.RubricChangeFile;
import ch.steph.reputil.RubricShowUtil;
import ch.steph.util.FileCsvKey;
import ch.steph.util.FileProcedures;
import ch.steph.util.GetDataFile;
import ch.steph.util.IconUtil;
import ch.steph.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableModel;

public class CaseReadOnly
extends MdiNormalFrame {
    private static final long serialVersionUID = 1L;
    private CaseShowTableModel caseShowTableModel;
    protected CaseShowTable caseShowTable;
    private JScrollPane jScrollPane;
    private String caseFileName = null;
    private KeyListener mainKeyListener;
    private CaseResult caseResult;
    private static int secondCounter = 1;

    public CaseReadOnly(int n) {
        super(true, "", 6, "res");
        this.setFrameIcon(IconUtil.getImageIcon(this, "icon/3-2.gif"));
        this.setCaseShowTitle(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.caseResult = new CaseResult(null);
        Rectangle rectangle = this.getStartRect();
        if (++secondCounter > 5) {
            secondCounter = 1;
        }
        rectangle.x += (secondCounter - 1) * 10;
        rectangle.width -= (secondCounter - 1) * 10;
        if (rectangle.x < 0) {
            rectangle.x = 0;
        }
        rectangle.y = rectangle.y + secondCounter * 10 + rectangle.height - rectangle.height / 5;
        this.setBounds(rectangle);
        this.mainKeyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                CaseReadOnly.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.addKeyListener(this.mainKeyListener);
        this.getContentPane().addKeyListener(this.mainKeyListener);
        this.jScrollPane = new JScrollPane();
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        try {
            this.jScrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "UI-Manager problem");
        }
        this.jScrollPane.addKeyListener(this.mainKeyListener);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.jScrollPane != null) {
            this.jScrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        }
        if (this.caseResult != null) {
            this.buildNow();
        }
    }

    @Override
    public void requestFocus() {
        Log.write(5, this.getClass().getName(), "requestFocus ");
        if (this.caseShowTable != null) {
            this.caseShowTable.requestFocus();
            if (this.caseShowTable.getRowCount() > 0 && this.caseShowTable.getSelectedRow() < 0) {
                this.caseShowTable.setRowSelectionInterval(this.caseShowTable.getRowCount() - 1, this.caseShowTable.getRowCount() - 1);
            }
        } else {
            super.requestFocus();
        }
    }

    protected void mainKeyPressed(KeyEvent keyEvent) {
        try {
            char c;
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
                c = Character.toUpperCase(keyEvent.getKeyChar());
                if (c == '\u001b') {
                    keyEvent.consume();
                    this.closeAction();
                } else if (c == ' ') {
                    int n;
                    keyEvent.consume();
                    if (this.caseResult.getResultCount() > 0 && this.caseShowTable != null && (n = this.caseShowTable.getSelectedRow()) >= 0) {
                        this.selectRubric(n, null);
                    }
                }
            }
            if ((c = RepMainMenu.mainMenuGetCtrlChar(keyEvent)) > '\u0000') {
                if (c == 'C') {
                    keyEvent.consume();
                    this.copyFrameToClipboard();
                } else {
                    RepMainMenu.mainMenuActionDone(keyEvent, c);
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey", exception);
        }
    }

    @Override
    public void doneResizeLayout() {
        if (this.caseShowTable != null && this.caseResult.getResultCount() > 0) {
            Rectangle rectangle = this.getBounds();
            this.caseShowTable.setFirstColumnSize(rectangle.width / 2);
        }
    }

    private void selectRubric(int n, String string) {
        if (this.caseResult.getResultCount() > 0) {
            CaseRubric caseRubric = this.caseResult.getRubricAt(n + this.caseResult.titleSize());
            String string2 = RubricChangeFile.getRubricRemarks(caseRubric.getRubric());
            String[] stringArray = RubricShowUtil.makeRubricHtml(caseRubric.getRubric(), string2);
            RepMainFrame.getRepInstance().newRubricWindowAction(caseRubric.getRubric(), stringArray, string);
        }
    }

    private void setCaseShowTitle(String string) {
        int n;
        this.caseFileName = string;
        if (string != null && (n = this.caseFileName.lastIndexOf(46)) > 0) {
            this.caseFileName = string.substring(0, n);
        }
        if (this.caseFileName != null) {
            if (PatientUtil.getPatientName() == null) {
                this.setTitle("jRep" + StringResource.getString("result_win_title_of") + this.caseFileName);
            } else {
                this.setTitle("jRep" + StringResource.getString("result_win_title_of") + PatientUtil.getPatientName() + " : " + this.caseFileName);
            }
        } else {
            this.setTitle("jRep" + StringResource.getString("result_win_title_of") + PatientUtil.getPatientName());
        }
    }

    public boolean loadFile(String string) {
        FileCsvKey fileCsvKey = GetDataFile.getCaseDataRd(string);
        if (fileCsvKey.isOpenRead()) {
            PatientUtil.setActPatDir(FileProcedures.getParentPath(string));
            this.setCaseShowTitle(FileProcedures.getFileName(string));
            if (this.caseResult.loadCaseThenBuild(fileCsvKey)) {
                this.buildNow();
            }
            fileCsvKey.close();
            return true;
        }
        return false;
    }

    private void buildNow() {
        Rep.getExecutor().execute(() -> {
            this.caseResult.buildResult();
            SwingUtilities.invokeLater(() -> this.setNewResult());
        });
    }

    private void setNewResult() {
        this.jScrollPane.setViewportView(null);
        Rectangle rectangle = this.getBounds();
        this.caseShowTableModel = new CaseShowTableModel(this.caseResult);
        this.caseShowTable = new CaseShowTable((TableModel)this.caseShowTableModel, this.caseResult, rectangle.width / 2);
        this.jScrollPane.setViewportView(this.caseShowTable);
        this.jScrollPane.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                CaseReadOnly.this.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.jScrollPane.getVerticalScrollBar().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                CaseReadOnly.this.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.jScrollPane.getHorizontalScrollBar().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                CaseReadOnly.this.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.caseShowTable.addKeyListener(this.mainKeyListener);
        this.caseShowTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseClicked: " + mouseEvent.paramString());
                if (mouseEvent.getClickCount() >= 2) {
                    int n = CaseReadOnly.this.caseShowTable.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                    int n2 = CaseReadOnly.this.caseShowTable.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                    String string = CaseReadOnly.this.caseResult.getValueAt(0, n2);
                    CaseReadOnly.this.selectRubric(n, string);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        RepMainFrame.getRepInstance().selectFrame(this);
        this.caseShowTable.requestFocus();
    }
}

