/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.repmodel.CaseShowTableModel;
import ch.steph.repui.CaseShowTable;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataHandler;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;

public class CaseRowTransferHandler
extends TransferHandler {
    private final DataFlavor localObjectFlavor = new ActivationDataFlavor(Integer.class, "application/x-java-Integer;class=java.lang.Integer", "Integer Row Index");
    private CaseShowTable table = null;

    public CaseRowTransferHandler(CaseShowTable caseShowTable) {
        this.table = caseShowTable;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        assert (jComponent == this.table);
        return new DataHandler((Object)this.table.getSelectedRow(), this.localObjectFlavor.getMimeType());
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        boolean bl = transferSupport.getComponent() == this.table && transferSupport.isDrop() && transferSupport.isDataFlavorSupported(this.localObjectFlavor);
        this.table.setCursor(bl ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
        return bl;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        CaseShowTable caseShowTable = (CaseShowTable)transferSupport.getComponent();
        JTable.DropLocation dropLocation = (JTable.DropLocation)transferSupport.getDropLocation();
        int n = dropLocation.getRow();
        int n2 = this.table.getModel().getRowCount();
        if (n < 0 || n > n2) {
            n = n2;
        }
        caseShowTable.setCursor(Cursor.getPredefinedCursor(0));
        try {
            Integer n3 = (Integer)transferSupport.getTransferable().getTransferData(this.localObjectFlavor);
            if (n3 != -1 && n3 != n) {
                ((CaseShowTableModel)this.table.getModel()).reorder(n3, n);
                if (n > n3) {
                    --n;
                }
                caseShowTable.getSelectionModel().addSelectionInterval(n, n);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (n == 2 || n == 0) {
            this.table.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

