/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.MdiMainFrame;
import ch.steph.apputil.MdiNormalFrame;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.CaseResult;
import ch.steph.rep.CaseResultTabList;
import ch.steph.rep.CaseResultTextList;
import ch.steph.rep.CaseUInterface;
import ch.steph.rep.Rep;
import ch.steph.repdata.CaseRubric;
import ch.steph.repdata.RepDataPool;
import ch.steph.repdata.Rubric;
import ch.steph.repmodel.CaseShowTableModel;
import ch.steph.repui.CaseShowTable;
import ch.steph.repui.FilterBox;
import ch.steph.repui.JoinBox;
import ch.steph.repui.PrintResult;
import ch.steph.repui.RepMainFrame;
import ch.steph.repui.RepMainMenu;
import ch.steph.repui.RubricChange;
import ch.steph.repui.SelectColumn;
import ch.steph.reputil.PatientUtil;
import ch.steph.reputil.RubricChangeFile;
import ch.steph.reputil.RubricShowUtil;
import ch.steph.reputil.RubricUtil;
import ch.steph.tableview.TableEditWindow;
import ch.steph.util.ConstStr;
import ch.steph.util.FileCsv;
import ch.steph.util.FileCsvKey;
import ch.steph.util.FileLn;
import ch.steph.util.FileProcOld;
import ch.steph.util.FileProcedures;
import ch.steph.util.GetDataFile;
import ch.steph.util.HttpJsonSendGet;
import ch.steph.util.IconUtil;
import ch.steph.util.ImageTransferable;
import ch.steph.util.Log;
import ch.steph.util.MenuHint;
import ch.steph.util.WaitMonitor;
import ch.steph.util.transfer.ExtAppData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;

public class CaseShow
extends MdiNormalFrame
implements CaseUInterface {
    private static final long serialVersionUID = 1L;
    private CaseShowTableModel caseShowTableModel;
    protected CaseShowTable caseShowTable;
    protected JPopupMenu caseShowPopupMenu;
    protected JPopupMenu caseTitlePopupMenu;
    private JScrollPane jScrollPane;
    private WaitMonitor searchMonitor;
    protected FilterBox filterBox = null;
    protected JoinBox joinBox = null;
    protected int leftW;
    private int savedSelectedIndex;
    private boolean autoselectLast = false;
    private boolean getFocusAnyway = false;
    private KeyListener mainKeyListener;
    private JMenuItem rubricChangeMenuItem;
    private int tableHeaderLabelHeight = 0;
    private static FileFilter repFileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(".rep");
        }

        @Override
        public String getDescription() {
            return "jRep   *.rep";
        }
    };
    private static FileFilter csvFileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(".csv");
        }

        @Override
        public String getDescription() {
            return "jRep   *.csv";
        }
    };

    public CaseShow() {
        super(false, "", 6, "res");
        this.setFrameIcon(IconUtil.getImageIcon(this, "icon/3.gif"));
        this.setCaseShowTitle(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.savedSelectedIndex = -1;
        this.mainKeyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                CaseShow.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.addKeyListener(this.mainKeyListener);
        this.getContentPane().addKeyListener(this.mainKeyListener);
        this.jScrollPane = new JScrollPane();
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        try {
            this.jScrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "UI-Manager problem");
        }
        this.jScrollPane.addKeyListener(this.mainKeyListener);
        this.caseShowPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(StringResource.getString("menu_rubric_show"));
        jMenuItem.addActionListener(actionEvent -> this.rubricShowAction());
        this.caseShowPopupMenu.add(jMenuItem);
        this.caseShowPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_result_delete"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        jMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().caseShowDeleteRowAction());
        this.caseShowPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("case_rubric_change"));
        jMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().changeCaseRubric(false));
        this.caseShowPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("case_rubric_changeall"));
        jMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().changeCaseRubric(true));
        this.caseShowPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("case_rubric_new"));
        jMenuItem.addActionListener(actionEvent -> this.newCaseRubric(null, false));
        this.caseShowPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("case_rubric_newall"));
        jMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().newCaseRubricAll());
        this.caseShowPopupMenu.add(jMenuItem);
        this.caseShowPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_result_up"));
        jMenuItem.addActionListener(actionEvent -> this.moveRowUp());
        MenuHint.set('+', jMenuItem);
        this.caseShowPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_result_down"));
        jMenuItem.addActionListener(actionEvent -> this.moveRowDown());
        MenuHint.set('-', jMenuItem);
        this.caseShowPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_result_sort"));
        jMenuItem.addActionListener(actionEvent -> this.sortByRubricIdent());
        this.caseShowPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_result_sort2"));
        jMenuItem.addActionListener(actionEvent -> this.sortByRubricCount());
        this.caseShowPopupMenu.add(jMenuItem);
        this.caseShowPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_result_combine"));
        jMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().joinAction());
        MenuHint.set('&', jMenuItem);
        this.caseShowPopupMenu.add(jMenuItem);
        this.caseShowPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_result_div"));
        jMenuItem.addActionListener(actionEvent -> this.divRubric());
        MenuHint.set('/', jMenuItem);
        this.caseShowPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_result_div_all"));
        jMenuItem.addActionListener(actionEvent -> this.divAll());
        this.caseShowPopupMenu.add(jMenuItem);
        this.caseShowPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_result_mult"));
        jMenuItem.addActionListener(actionEvent -> this.doubleRubric());
        MenuHint.set('*', jMenuItem);
        this.caseShowPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_result_mult_all"));
        jMenuItem.addActionListener(actionEvent -> this.doubleAll());
        this.caseShowPopupMenu.add(jMenuItem);
        this.caseShowPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("1. " + StringResource.getString("case_rubric_new1"));
        jMenuItem.addActionListener(actionEvent -> this.newCaseRubric(StringResource.getString("case_rubric_new1").toUpperCase() + " (2=I 1=?)", false));
        this.caseShowPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("2. " + StringResource.getString("case_rubric_new2"));
        jMenuItem.addActionListener(actionEvent -> this.newCaseRubric(StringResource.getString("case_rubric_new2") + ": ", true));
        this.caseShowPopupMenu.add(jMenuItem);
        this.caseShowPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_result_copy"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        jMenuItem.addActionListener(actionEvent -> this.copyToClipboard());
        this.caseShowPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_result_tab"));
        jMenuItem.addActionListener(actionEvent -> this.copyTabsToClipboard());
        this.caseShowPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_result_table"));
        jMenuItem.addActionListener(actionEvent -> this.copyToTableEdit());
        this.caseShowPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_result_wordle"));
        jMenuItem.addActionListener(actionEvent -> this.copyForWordle());
        this.caseShowPopupMenu.add(jMenuItem);
        this.caseShowPopupMenu.addSeparator();
        this.rubricChangeMenuItem = new JMenuItem(StringResource.getString("rep_asnew"));
        this.rubricChangeMenuItem.setAccelerator(KeyStroke.getKeyStroke(75, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        this.rubricChangeMenuItem.addActionListener(actionEvent -> this.changeActRubric());
        this.rubricChangeMenuItem.setEnabled(false);
        this.caseShowPopupMenu.add(this.rubricChangeMenuItem);
        this.caseTitlePopupMenu = new JPopupMenu();
        jMenuItem = new JMenuItem(StringResource.getString("menu_sort") + " " + StringResource.getString("menu_sort_by_hit"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        jMenuItem.addActionListener(actionEvent -> RepMainMenu.sortByHitAction(false));
        this.caseTitlePopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_sort") + " " + StringResource.getString("menu_sort_by_rating"));
        jMenuItem.addActionListener(actionEvent -> RepMainMenu.sortByRatingAction(false));
        this.caseTitlePopupMenu.add(jMenuItem);
        this.caseTitlePopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_sort") + " " + StringResource.getString("menu_sort_by_rubric"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        jMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().sortByRubricAction());
        this.caseTitlePopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_sort") + " " + StringResource.getString("menu_sort_by_polar"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        jMenuItem.addActionListener(actionEvent -> RepMainMenu.sortByPolarAction(false));
        this.caseTitlePopupMenu.add(jMenuItem);
        this.caseTitlePopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_sort_filter"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        jMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().filterAction(""));
        this.caseTitlePopupMenu.add(jMenuItem);
        this.caseTitlePopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_change") + " " + StringResource.getString("filter_count2"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        jMenuItem.addActionListener(actionEvent -> RepMainMenu.sortCount2Action(true));
        this.caseTitlePopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_change") + " " + StringResource.getString("filter_count1"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        jMenuItem.addActionListener(actionEvent -> RepMainMenu.sortCount1Action(true));
        this.caseTitlePopupMenu.add(jMenuItem);
        this.caseTitlePopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_change") + " " + StringResource.getString("option_cut_all_rubrics"));
        jMenuItem.addActionListener(actionEvent -> {
            User.instance().setProperty("CutAllRubrics", !User.instance().getProperty("CutAllRubrics", true));
            this.sortAgain();
        });
        this.caseTitlePopupMenu.add(jMenuItem);
        this.caseTitlePopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_change") + " " + StringResource.getString("option_polarAtEnd"));
        jMenuItem.addActionListener(actionEvent -> {
            User.instance().setProperty("polarAtEnd", !User.instance().getProperty("polarAtEnd", false));
            this.sortAgain();
        });
        this.caseTitlePopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_change") + " " + StringResource.getString("option_polarSimple"));
        jMenuItem.addActionListener(actionEvent -> {
            User.instance().setProperty("sortPolarSimple", !User.instance().getProperty("sortPolarSimple", false));
            this.sortAgain();
        });
        this.caseTitlePopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_change") + " " + StringResource.getString("option_alphaSort"));
        jMenuItem.addActionListener(actionEvent -> {
            User.instance().setProperty("alphabticalSort", !User.instance().getProperty("alphabticalSort", false));
            this.sortAgain();
        });
        this.caseTitlePopupMenu.add(jMenuItem);
        this.caseTitlePopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_change") + " " + StringResource.getString("option_show_colorFamily"));
        jMenuItem.addActionListener(actionEvent -> {
            User.instance().setProperty("ColorForFamily", !User.instance().getProperty("ColorForFamily", true));
            this.sortAgain();
        });
        this.caseTitlePopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_change") + " " + StringResource.getString("option_show_colorMiasma"));
        jMenuItem.addActionListener(actionEvent -> {
            User.instance().setProperty("ColorForMiasma", !User.instance().getProperty("ColorForMiasma", false));
            this.sortAgain();
        });
        this.caseTitlePopupMenu.add(jMenuItem);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.jScrollPane != null) {
            this.jScrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        }
        this.buildNow();
    }

    @Override
    public void requestFocus() {
        Log.write(5, this.getClass().getName(), "requestFocus ");
        if (this.caseShowTable != null) {
            this.caseShowTable.requestFocus();
            if (this.caseShowTable.getRowCount() > 0 && this.caseShowTable.getSelectedRow() < 0) {
                this.caseShowTable.setColumnSelectionAllowed(false);
                this.caseShowTable.setRowSelectionAllowed(true);
                this.caseShowTable.setRowSelectionInterval(this.caseShowTable.getRowCount() - 1, this.caseShowTable.getRowCount() - 1);
            }
        } else {
            super.requestFocus();
        }
    }

    protected void checkAndGetFocusFromMain() {
        try {
            if (User.instance().getCaseResultLength() > 0) {
                MdiMainFrame.getInstance().selectFrame(this);
                if (User.instance().getProperty("CaseOpenMaximized", true)) {
                    this.setMaximum(true);
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "checkAndGetFocusAndEvtlMaximize", exception);
        }
    }

    @Override
    public void closeAction() {
        if (this.filterBox != null) {
            this.filterBox.closeAction();
            this.filterBox = null;
        }
        if (this.joinBox != null) {
            this.joinBox.closeAction();
            this.joinBox = null;
        }
        super.closeAction();
    }

    protected void focusToParent() {
        if (this.filterBox != null) {
            this.filterBox.closeAction();
            this.filterBox = null;
        }
        if (this.joinBox != null) {
            this.joinBox.closeAction();
            this.joinBox = null;
        }
        try {
            if (User.instance().getCaseResultLength() > 0 && User.instance().getProperty("CaseOpenMaximized", true)) {
                this.setMaximum(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        RepMainFrame.getRepInstance().checkAndGetFocus();
    }

    protected void mainKeyPressed(KeyEvent keyEvent) {
        try {
            char c;
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
                c = Character.toUpperCase(keyEvent.getKeyChar());
                switch (c) {
                    case '\u001b': {
                        keyEvent.consume();
                        this.focusToParent();
                        RepMainFrame.getRepInstance().newSearchAction();
                        break;
                    }
                    case '\t': {
                        keyEvent.consume();
                        this.focusToParent();
                        break;
                    }
                    case ' ': {
                        int n;
                        keyEvent.consume();
                        if (User.instance().getCaseResultLength() <= 0 || this.caseShowTable == null || (n = this.caseShowTable.getSelectedRow()) < 0) break;
                        this.selectRubric(n, null);
                        break;
                    }
                    case '\n': {
                        keyEvent.consume();
                        this.focusToParent();
                        break;
                    }
                    case '\b': {
                        keyEvent.consume();
                        this.deleteRow();
                        break;
                    }
                    case '\u007f': {
                        keyEvent.consume();
                        this.deleteRow();
                        break;
                    }
                    default: {
                        if (keyEvent.getKeyChar() == '+') {
                            keyEvent.consume();
                            this.moveRowUp();
                            break;
                        }
                        if (keyEvent.getKeyChar() == '-') {
                            keyEvent.consume();
                            this.moveRowDown();
                            break;
                        }
                        if (keyEvent.getKeyChar() == '*') {
                            keyEvent.consume();
                            this.doubleRubric();
                            break;
                        }
                        if (keyEvent.getKeyChar() == '/') {
                            keyEvent.consume();
                            this.divRubric();
                            break;
                        }
                        if (keyEvent.getKeyChar() == '&') {
                            keyEvent.consume();
                            RepMainFrame.getRepInstance().joinAction();
                            break;
                        }
                        if (keyEvent.getKeyChar() == '<') {
                            keyEvent.consume();
                            SwingUtilities.invokeLater(() -> {
                                KeyEvent keyEvent = new KeyEvent(this.caseShowTable, 401, System.currentTimeMillis(), 0, 36, '\uffff');
                                this.caseShowTable.dispatchEvent(keyEvent);
                            });
                            break;
                        }
                        if (keyEvent.getKeyChar() == '>') {
                            keyEvent.consume();
                            SwingUtilities.invokeLater(() -> {
                                KeyEvent keyEvent = new KeyEvent(this.caseShowTable, 401, System.currentTimeMillis(), 0, 35, '\uffff');
                                this.caseShowTable.dispatchEvent(keyEvent);
                            });
                            break;
                        }
                        if (keyEvent.getKeyCode() == 112) {
                            keyEvent.consume();
                            RepMainFrame.getRepInstance().helpContextAction("Auswertung");
                            break;
                        }
                        if ((c < 'A' || c > 'Z') && (c < '0' || c > '9')) break;
                        keyEvent.consume();
                        RepMainFrame.getRepInstance().filterAction("" + keyEvent.getKeyChar());
                    }
                }
            }
            if ((c = RepMainMenu.mainMenuGetCtrlChar(keyEvent)) > '\u0000') {
                if (c == 'C') {
                    keyEvent.consume();
                    this.copyToClipboard();
                } else if (c == 'K') {
                    keyEvent.consume();
                    this.changeActRubric();
                } else {
                    RepMainMenu.mainMenuActionDone(keyEvent, c);
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey", exception);
        }
    }

    @Override
    public String[] getFilterText() {
        return User.instance().getCaseResult().getFilterText();
    }

    @Override
    public CaseRubric getActRubric() {
        if (this.caseShowTable.getSelectedRow() >= 0) {
            CaseResult caseResult = User.instance().getCaseResult();
            return caseResult.getRubricAt(this.caseShowTable.getSelectedRow() + caseResult.titleSize());
        }
        return null;
    }

    @Override
    public CaseRubric[] getAllRubric() {
        return User.instance().getCaseResult().getAllRubric();
    }

    public void addLine(Rubric rubric, boolean bl) {
        if (User.instance().getCaseResult().containsRubric(rubric)) {
            RepMainFrame.getRepInstance().endAnalysing();
            SwingUtilities.invokeLater(() -> JOptionPane.showInternalMessageDialog(RepMainFrame.getRepInstance().getDesktop(), StringResource.getString("message_rubric_used"), "jRep", 2));
            return;
        }
        if (this.filterBox != null) {
            this.filterBox.closeAction();
            this.filterBox = null;
        }
        if (this.joinBox != null) {
            this.joinBox.closeAction();
            this.joinBox = null;
        }
        if (User.instance().getCaseResult().addLineThenBuild(rubric, bl, null, null, null)) {
            this.autoselectLast = true;
            this.buildNow();
        }
    }

    public void addCombinedLine(CaseRubric caseRubric) {
        if (User.instance().getCaseResult().addLineThenBuild(caseRubric.getRubric(), false, caseRubric.getRemarkMedis(), caseRubric.getRemarkArray(), caseRubric.getRemarkDates())) {
            this.autoselectLast = true;
            this.buildNow();
        }
    }

    public void addLine(String[] stringArray, String string, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5) {
        if (User.instance().getCaseResult().addLineThenBuild(stringArray, string, stringArray2, stringArray3, stringArray4, stringArray5)) {
            this.autoselectLast = true;
            this.buildNow();
        }
    }

    public void sortAgain() {
        this.savedSelectedIndex = this.caseShowTable.getSelectedRow();
        if (User.instance().getCaseResult().sortAgainThenBuild()) {
            this.buildNow();
        }
    }

    public void sortByRubricIdent() {
        this.savedSelectedIndex = this.caseShowTable.getSelectedRow();
        if (User.instance().getCaseResult().sortByRubricIdent()) {
            this.buildNow();
        }
    }

    public void sortByRubricCount() {
        this.savedSelectedIndex = this.caseShowTable.getSelectedRow();
        if (User.instance().getCaseResult().sortByRubricCount()) {
            this.buildNow();
        }
    }

    public void buildRatingAndSortAgain() {
        this.savedSelectedIndex = this.caseShowTable.getSelectedRow();
        if (User.instance().getCaseResult().buildRatingAndSortAgainThenBuild()) {
            this.buildNow();
        }
    }

    @Override
    public void doneResizeLayout() {
        if (this.caseShowTable != null && User.instance().getCaseResultLength() > 0) {
            Rectangle rectangle = this.getBounds();
            this.caseShowTable.setFirstColumnSize(rectangle.width / 2);
        }
        super.doneResizeLayout();
    }

    public void deleteRow() {
        if (User.instance().getCaseResultLength() > 0) {
            this.savedSelectedIndex = this.caseShowTable.getSelectedRow();
            CaseResult caseResult = User.instance().getCaseResult();
            int n = this.savedSelectedIndex + caseResult.titleSize();
            if (this.savedSelectedIndex >= caseResult.getRowCount() - caseResult.titleSize() - 1) {
                this.savedSelectedIndex = caseResult.getRowCount() - caseResult.titleSize() - 2;
            }
            if (caseResult.deleteRowThenBuild(n)) {
                this.buildNow();
            }
        }
    }

    public void deleteRubric(CaseRubric caseRubric) {
        if (User.instance().getCaseResultLength() > 0) {
            CaseResult caseResult = User.instance().getCaseResult();
            for (int i = caseResult.titleSize(); i < caseResult.getRowCount(); ++i) {
                CaseRubric caseRubric2 = caseResult.getRubricAt(i);
                if (!caseRubric2.equals(caseRubric) || !caseResult.deleteRowThenBuild(i)) continue;
                i = caseResult.getRowCount();
                if (this.savedSelectedIndex >= caseResult.getRowCount() - caseResult.titleSize() - 1) {
                    this.savedSelectedIndex = caseResult.getRowCount() - caseResult.titleSize() - 2;
                }
                this.buildNow();
            }
        }
    }

    public void moveRowUp() {
        if (User.instance().getCaseResultLength() > 1) {
            this.savedSelectedIndex = this.caseShowTable.getSelectedRow();
            CaseResult caseResult = User.instance().getCaseResult();
            int n = caseResult.moveRowUpThenBuild(this.savedSelectedIndex + caseResult.titleSize()) - caseResult.titleSize();
            if (n != this.savedSelectedIndex) {
                this.savedSelectedIndex = n;
                this.buildNow();
            }
        }
    }

    public void moveRowDown() {
        if (User.instance().getCaseResultLength() > 1) {
            this.savedSelectedIndex = this.caseShowTable.getSelectedRow();
            CaseResult caseResult = User.instance().getCaseResult();
            int n = caseResult.moveRowDownThenBuild(this.savedSelectedIndex + caseResult.titleSize()) - caseResult.titleSize();
            if (n != this.savedSelectedIndex) {
                this.savedSelectedIndex = n;
                this.buildNow();
            }
        }
    }

    public void doubleRubric() {
        if (User.instance().getCaseResultLength() > 0) {
            CaseResult caseResult = User.instance().getCaseResult();
            this.savedSelectedIndex = this.caseShowTable.getSelectedRow();
            if (caseResult.doubleRubricThenBuild(this.savedSelectedIndex + caseResult.titleSize())) {
                this.buildNow();
            }
        }
    }

    public void divRubric() {
        if (User.instance().getCaseResultLength() > 0) {
            this.savedSelectedIndex = this.caseShowTable.getSelectedRow();
            CaseResult caseResult = User.instance().getCaseResult();
            if (caseResult.divRubricThenBuild(this.savedSelectedIndex + caseResult.titleSize())) {
                this.buildNow();
            }
        }
    }

    public void doubleAll() {
        if (User.instance().getCaseResultLength() > 0) {
            CaseResult caseResult = User.instance().getCaseResult();
            this.savedSelectedIndex = this.caseShowTable.getSelectedRow();
            if (caseResult.doubleAllBelowThenBuild(this.savedSelectedIndex + caseResult.titleSize())) {
                this.buildNow();
            }
        }
    }

    public void divAll() {
        if (User.instance().getCaseResultLength() > 0) {
            this.savedSelectedIndex = this.caseShowTable.getSelectedRow();
            CaseResult caseResult = User.instance().getCaseResult();
            if (caseResult.divAllBelowThenBuild(this.savedSelectedIndex + caseResult.titleSize())) {
                this.buildNow();
            }
        }
    }

    void copyToClipboard() {
        int n = User.instance().getProperty("caseResultTyp", 0);
        if (n == 0) {
            this.copyFrameToClipboard();
        } else if (User.instance().getCaseResultLength() > 0) {
            CaseResult caseResult = User.instance().getCaseResult();
            CaseResultTextList caseResultTextList = new CaseResultTextList(caseResult);
            StringBuilder stringBuilder = new StringBuilder(CaseResultTextList.getClipBoardHeader(PatientUtil.getPatientName(), caseResult.getCaseName()));
            if (n == 1) {
                stringBuilder.append(caseResultTextList.getClipBoardBody());
            } else {
                stringBuilder.append(caseResultTextList.getClipBoardBodyNoValues(caseResult.titleSize()));
            }
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            this.getToolkit().getSystemClipboard().setContents(stringSelection, null);
        }
    }

    public void copyTabsToClipboard() {
        int n = new SelectColumn().selectColumns();
        CaseResultTabList caseResultTabList = new CaseResultTabList(User.instance().getCaseResult(), n);
        StringSelection stringSelection = new StringSelection(caseResultTabList.getClipBoardText());
        this.getToolkit().getSystemClipboard().setContents(stringSelection, null);
    }

    public void copyToTableEdit() {
        CaseResult caseResult = User.instance().getCaseResult();
        int n = caseResult.getColumnCount();
        if (n > 11) {
            n = new SelectColumn().selectColumns();
        }
        CaseResultTabList caseResultTabList = new CaseResultTabList(caseResult, n);
        String string = User.instance().getCaseResult().getCaseName();
        if (string == null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd ");
            string = simpleDateFormat.format(new Date());
        }
        MdiMainFrame.getInstance().addAndSelect(new TableEditWindow(string, caseResultTabList.getTableEntries()));
    }

    private void copyForWordle() {
        CaseResult caseResult;
        int n;
        if (User.instance().getCaseResultLength() > 0 && (n = (caseResult = User.instance().getCaseResult()).getRowCount()) > caseResult.titleSize()) {
            StringBuilder stringBuilder = new StringBuilder("");
            for (int i = 1; i < caseResult.getColumnCount(); ++i) {
                int n2;
                String string = caseResult.getValueAt(0, i);
                try {
                    n2 = Integer.parseInt(caseResult.getValueAt(2, i));
                }
                catch (Exception exception) {
                    n2 = 0;
                }
                for (int j = 0; j < n2; ++j) {
                    stringBuilder.append(string).append(" ");
                }
                stringBuilder.append(ConstStr.LINE_SEPARATOR);
            }
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            this.getToolkit().getSystemClipboard().setContents(stringSelection, null);
        }
    }

    private void changeActRubric() {
        CaseResult caseResult = User.instance().getCaseResult();
        if (User.instance().getCaseResultLength() > 0) {
            this.savedSelectedIndex = this.caseShowTable.getSelectedRow();
            CaseRubric caseRubric = caseResult.getCaseRubric(this.savedSelectedIndex + caseResult.titleSize());
            RubricChange rubricChange = new RubricChange(null, User.instance().getActRepIndex(), caseResult.getMedisSorted(), caseRubric, null, false);
            MdiMainFrame.getInstance().addAndSelect(rubricChange);
        }
    }

    protected void rubricShowAction() {
        int n = this.caseShowTable.getSelectedRow();
        this.selectRubric(n, null);
    }

    protected void selectRubric(int n, String string) {
        if (User.instance().getCaseResultLength() > 0) {
            CaseResult caseResult = User.instance().getCaseResult();
            CaseRubric caseRubric = caseResult.getRubricAt(n + caseResult.titleSize());
            String string2 = RubricChangeFile.getRubricRemarks(caseRubric.getRubric());
            if (string2 == null || string2.length() == 0) {
                string2 = caseRubric.getCaseShowRemarks();
            }
            String[] stringArray = RubricShowUtil.makeRubricHtml(caseRubric.getRubric(), string2);
            RepMainFrame.getRepInstance().newRubricWindowAction(caseRubric.getRubric(), stringArray, string);
        }
    }

    public void sortByRubric() {
        if (User.instance().getCaseResultLength() > 0) {
            CaseResult caseResult = User.instance().getCaseResult();
            this.savedSelectedIndex = this.caseShowTable.getSelectedRow();
            if (caseResult.sortByRubricThenBuild(this.savedSelectedIndex + caseResult.titleSize())) {
                this.buildNow();
            }
        }
    }

    public void sortByPolar() {
        if (User.instance().getCaseResultLength() > 0) {
            CaseResult caseResult = User.instance().getCaseResult();
            this.savedSelectedIndex = this.caseShowTable.getSelectedRow();
            if (caseResult.sortByPolarThenBuild()) {
                this.buildNow();
            }
        }
    }

    public void filterAction(String string) {
        if (User.instance().getCaseResultLength() > 0) {
            if (this.filterBox == null) {
                this.filterBox = new FilterBox(this, string);
                if (!MdiMainFrame.getInstance().addAndSelectModal(this.filterBox)) {
                    this.filterBox.dispose();
                    this.filterBox = null;
                    Log.write(5, this.getClass().getName(), "no filter, because other modal window");
                }
            } else {
                this.filterBox.toFront();
                this.filterBox.requestFocus();
                if (string != null && string.length() > 0) {
                    this.filterBox.addToText(string);
                    Log.write(5, this.getClass().getName(), "filterBox.addToText: " + string);
                }
            }
        }
    }

    public void joinAction() {
        if (User.instance().getCaseResultLength() > 1 && this.caseShowTable != null && this.caseShowTable.getSelectedRow() >= 0) {
            this.joinBox = new JoinBox(this);
            if (!MdiMainFrame.getInstance().addAndSelectModal(this.joinBox)) {
                this.joinBox.dispose();
                this.joinBox = null;
                Log.write(5, this.getClass().getName(), "no join, because other modal window");
            }
        }
    }

    @Override
    public void combineRubrics(Vector<CaseRubric> vector, String string, RubricUtil.CombineType combineType, boolean bl) {
        this.autoselectLast = true;
        this.getFocusAnyway = true;
        CaseResult caseResult = User.instance().getCaseResult();
        if (caseResult.combineRubricsThenBuild(vector, string, combineType, bl)) {
            this.buildNow();
            Log.write(4, this.getClass().getName(), "combineRubrics done: " + string);
        } else {
            Log.write(4, this.getClass().getName(), "combineRubrics NOT done: " + string);
        }
    }

    @Override
    public void setFilterText(String string, int n) {
        Log.write(5, this.getClass().getName(), "setFilterText: " + n + ", " + string);
        try {
            CaseResult caseResult = User.instance().getCaseResult();
            if (n >= 0 && n <= 2) {
                this.savedSelectedIndex = this.caseShowTable.getSelectedRow();
                if (caseResult.setFilterTextThenBuild(string, n)) {
                    this.buildNow();
                    Log.write(4, this.getClass().getName(), "set FilterText: " + string);
                }
            } else {
                this.savedSelectedIndex = this.caseShowTable.getSelectedRow();
                if (caseResult.setFilterTextThenBuild("", 0)) {
                    this.filterBox = null;
                    this.buildNow();
                    Log.write(4, this.getClass().getName(), "set empty FilterText.");
                }
            }
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "Exception while filtering", exception);
        }
    }

    protected void setCaseShowTitle(String string) {
        int n;
        String string2 = string;
        if (string != null && (n = string2.lastIndexOf(46)) > 0) {
            string2 = string.substring(0, n);
        }
        CaseResult caseResult = User.instance().getCaseResult();
        if (string2 != null && caseResult != null) {
            caseResult.setCaseName(string2);
            if (PatientUtil.getPatientName() == null) {
                this.setTitle("jRep" + StringResource.getString("result_win_title_of") + string2);
            } else {
                this.setTitle("jRep" + StringResource.getString("result_win_title_of") + PatientUtil.getPatientName() + " : " + string2);
                caseResult.setPatName(PatientUtil.getPatientName());
            }
        } else if (PatientUtil.isShowPatName() && PatientUtil.getPatientName() != null) {
            this.setTitle("jRep" + StringResource.getString("result_win_title_of") + PatientUtil.getPatientName());
        } else {
            this.setTitle("jRep" + StringResource.getString("result_win_title"));
        }
    }

    public boolean loadCase() throws Exception {
        CaseResult caseResult;
        boolean bl = false;
        if (this.filterBox != null) {
            this.filterBox.closeAction();
            this.filterBox = null;
        }
        if ((caseResult = User.instance().getCaseResult()) != null) {
            this.checkDataChanged(BoxDef.STANDARD);
            JFileChooser jFileChooser = new JFileChooser(PatientUtil.getActPatDir());
            jFileChooser.addChoosableFileFilter(repFileFilter);
            jFileChooser.setFileFilter(repFileFilter);
            jFileChooser.setDialogTitle(StringResource.getString("load_case"));
            int n = jFileChooser.showOpenDialog(MdiMainFrame.getInstance().getDesktop());
            if (n == 0) {
                PatientUtil.setActPatDir(jFileChooser.getSelectedFile().getParent());
                bl = true;
                String string = jFileChooser.getSelectedFile().getName();
                FileCsvKey fileCsvKey = GetDataFile.getCaseDataRd(FileProcedures.addDirName(PatientUtil.getActPatDir(), string));
                if (fileCsvKey.isOpenRead()) {
                    this.setCaseShowTitle(string);
                    URL uRL = PatientUtil.findNewestImageFile();
                    RepMainFrame.getRepInstance().imageForRubricAction(PatientUtil.getPatientName(), uRL);
                    if (caseResult.loadCaseThenBuild(fileCsvKey)) {
                        this.buildNow();
                    }
                    fileCsvKey.close();
                    if (User.instance().getProperty("openNoteWithCase", false)) {
                        RepMainFrame.getRepInstance().openCaseNoteAction(PatientUtil.getActPatDir());
                    }
                }
                Log.write(4, this.getClass().getName(), "loadCase: " + PatientUtil.getActPatDir() + ", " + string);
            }
        }
        return bl;
    }

    public boolean loadFile(String string) {
        FileCsvKey fileCsvKey;
        if (this.filterBox != null) {
            this.filterBox.closeAction();
            this.filterBox = null;
        }
        if ((fileCsvKey = GetDataFile.getCaseDataRd(string)).isOpenRead()) {
            PatientUtil.setActPatDir(FileProcedures.getParentPath(string));
            this.setCaseShowTitle(FileProcedures.getFileName(string));
            URL uRL = PatientUtil.findNewestImageFile();
            RepMainFrame.getRepInstance().imageForRubricAction(PatientUtil.getPatientName(), uRL);
            CaseResult caseResult = User.instance().getCaseResult();
            if (caseResult.loadCaseThenBuild(fileCsvKey)) {
                this.buildNow();
            }
            fileCsvKey.close();
            if (User.instance().getProperty("openNoteWithCase", false)) {
                RepMainFrame.getRepInstance().openCaseNoteAction(PatientUtil.getActPatDir());
            }
            return true;
        }
        return false;
    }

    public boolean saveCase(boolean bl) {
        CaseResult caseResult;
        boolean bl2 = false;
        if (this.filterBox != null) {
            this.filterBox.closeAction();
            this.filterBox = null;
        }
        if ((caseResult = User.instance().getCaseResult()) != null) {
            Object object;
            Object object2;
            Serializable serializable;
            JFileChooser jFileChooser = new JFileChooser(PatientUtil.getActPatDir());
            jFileChooser.addChoosableFileFilter(repFileFilter);
            jFileChooser.setFileFilter(repFileFilter);
            jFileChooser.setDialogTitle(StringResource.getString("save_case"));
            if (caseResult.getCaseName() != null && bl) {
                serializable = FileProcedures.getFile(PatientUtil.getActPatDir(), caseResult.getCaseName() + ".rep");
                jFileChooser.setSelectedFile((File)serializable);
            } else {
                serializable = new SimpleDateFormat("yyyy-MM-dd ");
                object2 = serializable.format(new Date());
                object = FileProcOld.getFile(PatientUtil.getActPatDir(), (String)object2);
                jFileChooser.setSelectedFile((File)object);
            }
            int n = jFileChooser.showSaveDialog(MdiMainFrame.getInstance().getDesktop());
            if (n == 0) {
                PatientUtil.setActPatDir(jFileChooser.getSelectedFile().getParent());
                bl2 = true;
                object2 = jFileChooser.getSelectedFile().getName();
                if (!((String)object2).endsWith(".rep")) {
                    object2 = (String)object2 + ".rep";
                }
                if (((FileLn)(object = GetDataFile.getCaseDataWr(FileProcedures.addDirName(PatientUtil.getActPatDir(), (String)object2), false))).isOpenWrite()) {
                    this.setCaseShowTitle((String)object2);
                    caseResult.saveCase((FileLn)object);
                    ((FileLn)object).close();
                    if (User.instance().getProperty("ExternalAppUrl", "").length() > 5) {
                        ExtAppData extAppData = new ExtAppData();
                        extAppData.setJrepUser(User.instance().getUserName());
                        extAppData.setPatient(PatientUtil.getPatientName());
                        extAppData.setCaseFileName(FileProcedures.addDirName(PatientUtil.getActPatDir(), (String)object2));
                        SwingUtilities.invokeLater(() -> {
                            try {
                                ImageTransferable imageTransferable = this.getFrameImage();
                                extAppData.setCasePicturePng(imageTransferable.getPng());
                                HttpJsonSendGet.sendJson(HttpJsonSendGet.METHOD.POST, User.instance().getProperty("ExternalAppUrl", ""), extAppData);
                                Log.write(4, "ch.steph.repui.CaseShow", "sent to external application " + extAppData.getCaseFileName());
                            }
                            catch (Exception exception) {
                                Log.write(3, "ch.steph.repui.CaseShow", "exception while sending to external Application " + exception.getMessage());
                            }
                        });
                    }
                }
                Log.write(4, this.getClass().getName(), "saved case: " + PatientUtil.getActPatDir() + ", " + (String)object2);
            }
        }
        return bl2;
    }

    void saveResult() {
        CaseResult caseResult;
        if (this.filterBox != null) {
            this.filterBox.closeAction();
            this.filterBox = null;
        }
        if ((caseResult = User.instance().getCaseResult()) != null) {
            int n;
            JFileChooser jFileChooser = new JFileChooser(PatientUtil.getActPatDir());
            jFileChooser.addChoosableFileFilter(csvFileFilter);
            jFileChooser.setFileFilter(csvFileFilter);
            jFileChooser.setDialogTitle(StringResource.getString("save_result"));
            if (caseResult.getCaseName() != null) {
                File file = FileProcedures.getFile(PatientUtil.getActPatDir(), caseResult.getCaseName() + ".csv");
                jFileChooser.setSelectedFile(file);
            }
            if ((n = jFileChooser.showSaveDialog(MdiMainFrame.getInstance().getDesktop())) == 0) {
                FileCsv fileCsv;
                String string = jFileChooser.getSelectedFile().getParent();
                Object object = jFileChooser.getSelectedFile().getName();
                if (!((String)object).endsWith(".csv")) {
                    object = (String)object + ".csv";
                }
                if ((fileCsv = GetDataFile.getCaseDataWr(FileProcedures.addDirName(string, (String)object), false)).isOpenWrite()) {
                    String string2 = CaseResultTextList.getClipBoardHeader(PatientUtil.getPatientName(), caseResult.getCaseName());
                    fileCsv.write(string2);
                    for (int i = 0; i < caseResult.getRowCount(); ++i) {
                        StringBuilder stringBuilder = new StringBuilder("");
                        for (int j = 0; j < caseResult.getColumnCount(); ++j) {
                            stringBuilder.append(caseResult.getValueAt(i, j)).append(";");
                        }
                        fileCsv.writeLn(stringBuilder.toString());
                    }
                    fileCsv.close();
                }
            }
        }
    }

    public void printResultAction(String string) {
        if (this.filterBox != null) {
            this.filterBox.closeAction();
            this.filterBox = null;
        }
        new PrintResult(User.instance().getCaseResult(), PatientUtil.getPatientName(), User.instance().getCaseResult().getCaseName(), string).print("jRep", 0);
    }

    public void checkDataChanged(BoxDef boxDef) throws Exception {
        CaseResult caseResult;
        if (this.filterBox != null) {
            this.filterBox.closeAction();
            this.filterBox = null;
        }
        if ((caseResult = User.instance().getCaseResult()) != null && caseResult.isChanged()) {
            String[] stringArray;
            int n;
            if (boxDef == BoxDef.STANDARD) {
                n = 1;
                stringArray = new String[]{StringResource.getString("ask_not_saved_1"), StringResource.getString("ask_not_saved_2")};
            } else {
                n = 0;
                stringArray = new String[]{StringResource.getString("ask_not_saved_1"), StringResource.getString("ask_not_saved_2b")};
            }
            int n2 = JOptionPane.showConfirmDialog(MdiMainFrame.getInstance().getDesktop(), stringArray, "jRep", n);
            if (n2 == 0) {
                this.saveCase(true);
            }
            if (n2 == 2) {
                throw new Exception("Cancelled save");
            }
        }
    }

    public void newCaseAction() {
        this.jScrollPane.setViewportView(null);
        this.caseShowTable = new CaseShowTable();
        this.caseShowTable.addKeyListener(this.mainKeyListener);
        this.setCaseShowTitle(null);
        this.savedSelectedIndex = -1;
        Log.write(5, this.getClass().getName(), "newCaseAction done.");
    }

    private void buildNow() {
        this.searchMonitor = new WaitMonitor();
        RepMainFrame.getRepInstance().startAnalysing();
        Rep.getExecutor().execute(() -> {
            User.instance().getCaseResult().buildResult();
            this.searchMonitor.doNotifyNow();
        });
        this.searchMonitor.doWaitNow();
        if (this.jScrollPane != null) {
            this.setNewResult();
            User.instance().getCaseResult().multiTxtSetterAction();
        }
        RepMainFrame.getRepInstance().endAnalysing();
    }

    private void newCaseRubric(String object, boolean bl) {
        CaseResult caseResult = User.instance().getCaseResult();
        if (User.instance().getCaseResultLength() > 0) {
            this.savedSelectedIndex = this.caseShowTable.getSelectedRow();
            CaseRubric caseRubric = caseResult.getCaseRubric(this.savedSelectedIndex + caseResult.titleSize());
            if (caseRubric != null && bl) {
                String string = caseRubric.getCaseRubric();
                object = (String)object + string.substring(string.indexOf("  ") + "  ".length());
            }
        }
        RepMainFrame.getRepInstance().newCaseRubric((String)object);
    }

    private void setNewResult() {
        boolean bl = this.isSelected();
        boolean bl2 = false;
        Log.write(5, this.getClass().getName(), "setNewResult ");
        if (this.caseShowTable != null) {
            bl2 = this.caseShowTable.hasFocus();
        }
        this.jScrollPane.setViewportView(null);
        Rectangle rectangle = this.getBounds();
        this.caseShowTableModel = new CaseShowTableModel(User.instance().getCaseResult());
        this.caseShowTable = new CaseShowTable((TableModel)this.caseShowTableModel, User.instance().getCaseResult(), rectangle.width / 2);
        this.jScrollPane.setViewportView(this.caseShowTable);
        this.jScrollPane.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                CaseShow.this.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.jScrollPane.getVerticalScrollBar().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                CaseShow.this.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.jScrollPane.getHorizontalScrollBar().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                CaseShow.this.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.caseShowTable.addKeyListener(this.mainKeyListener);
        this.caseShowTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseClicked: " + mouseEvent.paramString());
                if (mouseEvent.getClickCount() >= 2) {
                    int n = CaseShow.this.caseShowTable.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                    int n2 = CaseShow.this.caseShowTable.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                    String string = null;
                    if (n2 > 0) {
                        string = User.instance().getCaseResult().getValueAt(0, n2);
                    }
                    CaseShow.this.selectRubric(n, string);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mousePressed: " + mouseEvent.paramString());
                int n = CaseShow.this.caseShowTable.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                CaseShow.this.caseShowTable.setColumnSelectionAllowed(false);
                CaseShow.this.caseShowTable.setRowSelectionAllowed(true);
                CaseShow.this.caseShowTable.setRowSelectionInterval(n, n);
                if (CaseShow.this.caseShowTable.getSelectedRow() >= 0 && mouseEvent.isPopupTrigger()) {
                    CaseRubric caseRubric = User.instance().getCaseResult().getCaseRubric(CaseShow.this.caseShowTable.getSelectedRow() + User.instance().getCaseResult().titleSize());
                    if (caseRubric.isNewRubric() && RepDataPool.getInstance().getRepFile(caseRubric.getOrgRep()).isEditExtern()) {
                        CaseShow.this.rubricChangeMenuItem.setEnabled(true);
                    } else {
                        CaseShow.this.rubricChangeMenuItem.setEnabled(false);
                    }
                    CaseShow.this.caseShowPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseReleased: " + mouseEvent.paramString());
                if (CaseShow.this.caseShowTable.getSelectedRow() >= 0 && mouseEvent.isPopupTrigger()) {
                    CaseRubric caseRubric = User.instance().getCaseResult().getCaseRubric(CaseShow.this.caseShowTable.getSelectedRow() + User.instance().getCaseResult().titleSize());
                    if (caseRubric.isNewRubric() && RepDataPool.getInstance().getRepFile(caseRubric.getOrgRep()).isEditExtern()) {
                        CaseShow.this.rubricChangeMenuItem.setEnabled(true);
                    } else {
                        CaseShow.this.rubricChangeMenuItem.setEnabled(false);
                    }
                    CaseShow.this.caseShowPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.caseShowTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                Log.write(5, this.getClass().getName(), "mouseClicked: " + mouseEvent.paramString());
                if (mouseEvent.getClickCount() >= 2) {
                    int n2 = CaseShow.this.caseShowTable.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                    if (n2 > 0) {
                        String string = User.instance().getCaseResult().getValueAt(0, n2);
                        RepMainFrame.getRepInstance().newMedicaFrameAction(string);
                    } else if (n2 == 0) {
                        if (CaseShow.this.tableHeaderLabelHeight == 0) {
                            CaseShow.this.tableHeaderLabelHeight = CaseShow.this.caseShowTable.getTableHeaderLabelHeight();
                        }
                        Point point = mouseEvent.getPoint();
                        int n3 = -1;
                        if (CaseShow.this.tableHeaderLabelHeight > 0) {
                            n3 = point.y / CaseShow.this.tableHeaderLabelHeight;
                        }
                        switch (n3) {
                            case 2: {
                                if (User.instance().getProperty("SortByRating", true)) {
                                    RepMainMenu.sortByRatingAction(false);
                                    break;
                                }
                                RepMainMenu.sortByHitAction(false);
                                break;
                            }
                            case 3: {
                                break;
                            }
                            case 4: {
                                RepMainMenu.sortByPolarAction(false);
                                break;
                            }
                        }
                        Log.write(5, this.getClass().getName(), "double click on row: " + n3);
                    }
                } else if (mouseEvent.getClickCount() == 1 && (n = CaseShow.this.caseShowTable.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()))) > 0) {
                    CaseShow.this.caseShowTable.setRowSelectionAllowed(false);
                    CaseShow.this.caseShowTable.setColumnSelectionAllowed(true);
                    CaseShow.this.caseShowTable.setColumnSelectionInterval(n, n);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    CaseShow.this.caseTitlePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    CaseShow.this.caseTitlePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        if (this.autoselectLast) {
            this.autoselectLast = false;
            this.caseShowTable.setColumnSelectionAllowed(false);
            this.caseShowTable.setRowSelectionAllowed(true);
            this.caseShowTable.setRowSelectionInterval(this.caseShowTable.getRowCount() - 1, this.caseShowTable.getRowCount() - 1);
        }
        if (this.savedSelectedIndex >= 0) {
            if (this.savedSelectedIndex < this.caseShowTable.getRowCount()) {
                this.caseShowTable.setColumnSelectionAllowed(false);
                this.caseShowTable.setRowSelectionAllowed(true);
                this.caseShowTable.setRowSelectionInterval(this.savedSelectedIndex, this.savedSelectedIndex);
            } else {
                this.caseShowTable.setColumnSelectionAllowed(false);
                this.caseShowTable.setRowSelectionAllowed(true);
                this.caseShowTable.setRowSelectionInterval(this.caseShowTable.getRowCount() - 1, this.caseShowTable.getRowCount() - 1);
            }
            this.savedSelectedIndex = -1;
        }
        if (bl) {
            RepMainFrame.getRepInstance().selectFrame(this);
            this.caseShowTable.requestFocus();
        }
        if (bl2 || this.getFocusAnyway) {
            this.caseShowTable.requestFocus();
            this.getFocusAnyway = false;
        }
    }

    public static enum BoxDef {
        STANDARD,
        PATLIST;

    }
}

