/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.User;
import ch.steph.reputil.FontUtil;
import ch.steph.util.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class CaseShowHeaderRenderer
implements TableCellRenderer {
    private TableCellRenderer delegate;
    private JLabel testLabel;

    public CaseShowHeaderRenderer(TableCellRenderer tableCellRenderer) {
        this.delegate = tableCellRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JLabel jLabel = (JLabel)this.delegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        String string = (String)object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        JPanel jPanel = new JPanel();
        int n3 = stringTokenizer.countTokens() - 1;
        jPanel.setLayout(new GridLayout(n3, 1));
        jPanel.setBackground(jLabel.getBackground());
        Border border = jLabel.getBorder();
        if (border instanceof EmptyBorder) {
            border = BorderFactory.createRaisedBevelBorder();
        }
        String string2 = stringTokenizer.nextToken();
        boolean bl3 = User.instance().getProperty("ColorForFamily", true);
        boolean bl4 = User.instance().getProperty("ColorForMiasma", false);
        Color color = Color.DARK_GRAY;
        Color color2 = UIManager.getColor("TableHeader.foreground");
        if (color2.getRed() > 128 && color2.getGreen() > 128) {
            color = Color.LIGHT_GRAY;
        }
        int n4 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            JLabel jLabel2 = n2 == 0 ? new JLabel(stringTokenizer.nextToken() + " ") : new JLabel(stringTokenizer.nextToken());
            jLabel2.setBorder(border);
            switch (n4) {
                case 0: {
                    if (n2 == 0 || !bl3) {
                        jLabel2.setForeground(color2);
                    } else {
                        jLabel2.setForeground(this.getFamilyColor(string2));
                    }
                    jLabel2.setFont(FontUtil.getBoldChangedFont());
                    break;
                }
                case 1: {
                    if (n2 == 0 || !bl4) {
                        jLabel2.setForeground(color);
                    } else {
                        jLabel2.setForeground(this.getMiasmaColor(string2));
                    }
                    jLabel2.setFont(FontUtil.getBoldChangedFont());
                    break;
                }
                default: {
                    try {
                        int n5 = Integer.parseInt(jLabel2.getText(), 10);
                        if (n5 < -9) {
                            jLabel2.setForeground(Color.RED.darker());
                            break;
                        }
                        jLabel2.setForeground(color);
                        break;
                    }
                    catch (Exception exception) {
                        jLabel2.setForeground(color);
                    }
                }
            }
            if (n2 == 0) {
                jLabel2.setHorizontalAlignment(4);
                this.testLabel = jLabel2;
            } else {
                jLabel2.setHorizontalAlignment(0);
            }
            jPanel.add(jLabel2);
            ++n4;
        }
        return jPanel;
    }

    private Color getFamilyColor(String string) {
        if (string != null && string.length() > 1) {
            switch (string.charAt(1)) {
                default: {
                    break;
                }
                case 'A': {
                    return Color.BLUE.darker();
                }
                case 'B': {
                    return Color.ORANGE;
                }
                case 'F': {
                    return Color.MAGENTA.brighter();
                }
                case 'G': {
                    return Color.CYAN.darker();
                }
                case 'H': {
                    return Color.MAGENTA.darker();
                }
                case 'I': {
                    return Color.GRAY;
                }
                case 'L': {
                    return Color.WHITE;
                }
                case 'M': {
                    return Color.GRAY.darker();
                }
                case 'N': {
                    return Color.MAGENTA.darker();
                }
                case 'O': {
                    return Color.GREEN;
                }
                case 'P': {
                    return Color.GREEN.darker();
                }
                case 'R': {
                    return Color.ORANGE.darker();
                }
                case 'S': {
                    return Color.RED.darker();
                }
                case 'T': {
                    return Color.RED.brighter();
                }
                case 'V': {
                    return Color.PINK.darker();
                }
                case 'W': {
                    return Color.BLUE.brighter();
                }
            }
        }
        try {
            return UIManager.getColor(Color.BLACK);
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "UI-Manager problem");
            return Color.BLACK;
        }
    }

    private Color getMiasmaColor(String string) {
        if (string != null && string.length() > 0) {
            switch (string.charAt(0)) {
                default: {
                    break;
                }
                case 'c': {
                    return Color.ORANGE.darker();
                }
                case 'l': {
                    return Color.RED.brighter();
                }
                case 'o': {
                    return Color.GRAY.darker();
                }
                case 'p': {
                    return Color.BLUE.darker();
                }
                case 's': {
                    return Color.YELLOW;
                }
                case 't': {
                    return Color.GREEN.darker();
                }
                case '2': {
                    return Color.YELLOW;
                }
                case '3': {
                    return new Color(255, 128, 0);
                }
                case 'a': {
                    return new Color(0, 128, 128);
                }
                case 'r': {
                    return Color.MAGENTA.brighter();
                }
                case 'e': {
                    return new Color(128, 0, 255);
                }
            }
        }
        return Color.DARK_GRAY;
    }

    int getTableHeaderLabelHeight() {
        return this.testLabel.getHeight();
    }
}

