/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.rep.CaseResult;
import ch.steph.repui.CaseRowTransferHandler;
import ch.steph.repui.CaseShowHeaderRenderer;
import ch.steph.reputil.FontUtil;
import ch.steph.util.Log;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.DropMode;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class CaseShowTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private int optimalFirstColumnSize = 100;
    private CaseResult caseResult;
    private CaseShowHeaderRenderer caseShowHeaderRenderer;

    public CaseShowTable() {
    }

    public CaseShowTable(TableModel tableModel, CaseResult caseResult, int n) {
        super(tableModel);
        int n2;
        int n3;
        int n4;
        Log.write(5, this.getClass().getName(), "Show elements. Rows: " + caseResult.getRowCount() + ", Cols: " + caseResult.getColumnCount() + ", MedisForRubric: " + caseResult.getMedisForRubric().length);
        this.caseResult = caseResult;
        this.setAutoResizeMode(0);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setShowGrid(true);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT_ROWS);
        this.setTransferHandler(new CaseRowTransferHandler(this));
        this.setRowHeight(this.getFont().getSize() + (this.getRowMargin() + 1) * 2);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(true);
        this.caseShowHeaderRenderer = new CaseShowHeaderRenderer(jTableHeader.getDefaultRenderer());
        jTableHeader.setDefaultRenderer(this.caseShowHeaderRenderer);
        FontMetrics fontMetrics = this.getFontMetrics(FontUtil.getBoldChangedFont());
        Insets insets = new Insets(1, 1, 1, 1);
        try {
            insets = UIManager.getBorder("TableHeader.cellBorder").getBorderInsets(jTableHeader);
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "UI-Manager problem");
        }
        int n5 = 4 + 2 * (insets.left + insets.right);
        int n6 = fontMetrics.stringWidth("{ 00 }") + n5;
        for (n4 = 1; n4 < this.getColumnCount() && n4 < 21; ++n4) {
            String string = caseResult.getValueAt(0, n4);
            if (string == null || string.length() <= 3) continue;
            n3 = fontMetrics.stringWidth(string) + n5;
            n2 = fontMetrics.stringWidth(caseResult.getValueAt(1, n4)) + n5;
            if (n2 > n3) {
                n3 = n2;
            }
            if (n3 <= n6) continue;
            n6 = n3;
        }
        for (n4 = 0; n4 < this.getColumnCount(); ++n4) {
            int n7;
            TableColumn tableColumn;
            if (this.getColumnModel() == null || (tableColumn = this.getColumnModel().getColumn(n4)) == null) continue;
            if (n4 == 0) {
                n3 = n5;
                for (n7 = 0; n7 < caseResult.getRowCount(); ++n7) {
                    n2 = fontMetrics.stringWidth(caseResult.getValueAt(n7, n4)) + n5;
                    if (n2 <= n3) continue;
                    n3 = n2;
                }
                this.optimalFirstColumnSize = n3;
                if (n3 > n) {
                    n3 = n;
                }
            } else {
                n3 = fontMetrics.stringWidth(caseResult.getValueAt(0, n4)) + n5;
                for (n7 = 1; n7 < 5; ++n7) {
                    try {
                        int n8 = fontMetrics.stringWidth(caseResult.getValueAt(n7, n4)) + n5;
                        if (n8 > n3) {
                            n3 = n8;
                        }
                        if (n3 >= n6) continue;
                        n3 = n6;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            tableColumn.setMinWidth(n3 / 2);
            tableColumn.setPreferredWidth(n3);
            tableColumn.setMaxWidth(n3 * 2);
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer;
        block7: {
            tableCellRenderer = super.getCellRenderer(n, n2);
            JLabel jLabel = (JLabel)((Object)tableCellRenderer);
            if (n2 == 0) {
                jLabel.setHorizontalAlignment(2);
                String string = this.caseResult.getValueAt(n + this.caseResult.titleSize(), 0);
                int n3 = string.indexOf("-P  ");
                try {
                    if (n3 >= 2 || string.startsWith(" 0*")) {
                        jLabel.setBackground(UIManager.getColor("TableHeader.background").darker());
                        break block7;
                    }
                    jLabel.setBackground(UIManager.getColor("TableHeader.background"));
                }
                catch (Exception exception) {
                    Log.write(4, this.getClass().getName(), "UI-Manager problem");
                }
            } else {
                jLabel.setHorizontalAlignment(0);
                try {
                    jLabel.setBackground(UIManager.getColor("Table.background"));
                }
                catch (Exception exception) {
                    Log.write(4, this.getClass().getName(), "UI-Manager problem");
                }
            }
        }
        return tableCellRenderer;
    }

    public boolean setFirstColumnSize(int n) {
        int n2;
        if (n > this.optimalFirstColumnSize) {
            n = this.optimalFirstColumnSize;
        }
        if ((n2 = this.getColumnModel().getColumn(0).getPreferredWidth()) != n) {
            this.getColumnModel().getColumn(0).setMinWidth(n / 2);
            this.getColumnModel().getColumn(0).setPreferredWidth(n);
            this.getColumnModel().getColumn(0).setMaxWidth(n * 2);
            this.revalidate();
            return true;
        }
        return false;
    }

    int getTableHeaderLabelHeight() {
        return this.caseShowHeaderRenderer.getTableHeaderLabelHeight();
    }
}

