/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.MdiNormalFrame;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.repmodel.CrAuthorTableModel;
import ch.steph.repui.CrAuthorSelectTable;
import ch.steph.repui.RepMainFrame;
import ch.steph.repui.RepMainMenu;
import ch.steph.util.IconUtil;
import ch.steph.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CrAuthorSelect
extends MdiNormalFrame {
    private static final long serialVersionUID = 1L;
    protected JScrollPane scrollPane;
    private JButton okButton;
    private JButton cancelButton;
    private CrAuthorTableModel crAuthorTableModel;
    private CrAuthorSelectTable crAuthorSelectTable;
    private int repIndex;
    private JTextField searchField;
    private JCheckBox noAuthor;
    private JCheckBox allAuthors;
    private JLabel status;

    public CrAuthorSelect(int n) {
        super(true, StringResource.getString("menu_help_author"), 12, "crAuthor");
        this.repIndex = n;
        this.setFrameIcon(IconUtil.getImageIcon(this, "icon/jRepSmall.gif"));
        this.initWindow();
    }

    private void initWindow() {
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                CrAuthorSelect.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.getContentPane().addKeyListener(keyListener);
        this.addKeyListener(keyListener);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        this.okButton = new JButton(StringResource.getString("button_select"));
        this.okButton.addActionListener(actionEvent -> this.okAction());
        this.okButton.setEnabled(true);
        this.okButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add(this.okButton);
        this.cancelButton = new JButton(StringResource.getString("button_cancel"));
        this.cancelButton.addActionListener(actionEvent -> this.closeAction());
        this.cancelButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add(this.cancelButton);
        this.getContentPane().add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)jPanel2, "Center");
        jPanel2.addKeyListener(keyListener);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel3, "North");
        jPanel3.addKeyListener(keyListener);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel4, "West");
        jPanel4.addKeyListener(keyListener);
        JLabel jLabel = new JLabel("  Filter:");
        jPanel4.add((Component)jLabel, "West");
        this.searchField = new JTextField(16);
        jPanel4.add((Component)this.searchField, "Center");
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                CrAuthorSelect.this.searchFieldTextValueChanged(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                CrAuthorSelect.this.searchFieldTextValueChanged(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                CrAuthorSelect.this.searchFieldTextValueChanged(documentEvent);
            }
        });
        this.searchField.addKeyListener(keyListener);
        this.searchField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n;
                char c;
                if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown() || (c = keyEvent.getKeyChar()) != '\uffff' && c != '\u0000' || (n = keyEvent.getKeyCode()) != 40 && n != 225)) {
                    keyEvent.consume();
                    CrAuthorSelect.this.crAuthorSelectTable.requestFocusInWindow();
                    CrAuthorSelect.this.crAuthorSelectTable.changeSelection(0, 2, false, false);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        JPanel jPanel5 = new JPanel();
        jPanel3.add((Component)jPanel5, "East");
        this.status = new JLabel();
        jPanel5.add(this.status);
        this.noAuthor = new JCheckBox(StringResource.getString("no_author"));
        jPanel5.add(this.noAuthor);
        this.allAuthors = new JCheckBox(StringResource.getString("all_authors"));
        jPanel5.add(this.allAuthors);
        this.scrollPane = new JScrollPane();
        this.scrollPane.addKeyListener(keyListener);
        jPanel2.add((Component)this.scrollPane, "Center");
        this.scrollPane.addKeyListener(keyListener);
        this.crAuthorTableModel = new CrAuthorTableModel(this.repIndex, this);
        this.crAuthorSelectTable = new CrAuthorSelectTable(this.crAuthorTableModel);
        this.crAuthorSelectTable.addKeyListener(keyListener);
        this.scrollPane.setViewportView(this.crAuthorSelectTable);
        this.allAuthors.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    CrAuthorSelect.this.crAuthorTableModel.setAllCheckBoxes(true);
                    CrAuthorSelect.this.crAuthorSelectTable.setEnabled(false);
                    CrAuthorSelect.this.noAuthor.setSelected(true);
                    CrAuthorSelect.this.noAuthor.setEnabled(false);
                } else {
                    CrAuthorSelect.this.crAuthorSelectTable.setEnabled(true);
                    CrAuthorSelect.this.crAuthorTableModel.setAllCheckBoxes(false);
                    CrAuthorSelect.this.noAuthor.setSelected(User.instance().getProperty("noAuthor", true));
                    CrAuthorSelect.this.noAuthor.setEnabled(true);
                }
                CrAuthorSelect.this.setStatus();
            }
        });
        this.noAuthor.setSelected(User.instance().getProperty("noAuthor", true));
        this.allAuthors.setSelected(User.instance().getProperty("allAuthors", false));
        this.setStatus();
    }

    @Override
    public void requestFocus() {
        Log.write(5, this.getClass().getName(), "requestFocus ");
        if (this.searchField != null) {
            this.searchField.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void mainKeyTyped(KeyEvent keyEvent) {
    }

    public void mainKeyPressed(KeyEvent keyEvent) {
        try {
            char c;
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown() || (c = Character.toUpperCase(keyEvent.getKeyChar())) != '\u001b')) {
                keyEvent.consume();
                if (this.searchField.getText().length() > 0) {
                    this.searchField.setText("");
                }
                this.searchField.requestFocus();
            }
            if ((c = RepMainMenu.mainMenuGetCtrlChar(keyEvent)) > '\u0000') {
                RepMainMenu.mainMenuActionDone(keyEvent, c);
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey", exception);
        }
    }

    private void searchFieldTextValueChanged(DocumentEvent documentEvent) {
        try {
            this.crAuthorTableModel.filterMedis(this.searchField.getText());
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "searchFieldTextValueChanged", exception);
        }
    }

    public void setStatus() {
        this.status.setText(this.crAuthorTableModel.getCheckedCount() + " / " + this.crAuthorTableModel.getAllCount() + " ");
    }

    protected void okAction() {
        try {
            boolean bl = false;
            if (User.instance().getProperty("allAuthors", false) != this.allAuthors.isSelected()) {
                User.instance().setProperty("allAuthors", this.allAuthors.isSelected());
                bl = true;
            }
            if (!this.allAuthors.isSelected()) {
                if (this.crAuthorTableModel.okAction()) {
                    bl = true;
                }
                if (User.instance().getProperty("noAuthor", true) != this.noAuthor.isSelected()) {
                    User.instance().setProperty("noAuthor", this.noAuthor.isSelected());
                    bl = true;
                }
            }
            if (bl) {
                this.showRestart();
            }
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "okAction", exception);
        }
        this.closeAction();
        RepMainFrame.getRepInstance().searchAgain();
    }

    public void showRestart() {
        JOptionPane.showInternalMessageDialog(RepMainFrame.getRepInstance().getDesktop(), StringResource.getString("message_author_restart"), StringResource.getString("menu_help_author"), 1);
    }
}

