/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.reputil.FontUtil;
import ch.steph.util.Log;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class CrAuthorSelectTable
extends JTable {
    private static final long serialVersionUID = 1L;

    public CrAuthorSelectTable(TableModel tableModel) {
        super(tableModel);
        this.setAutoResizeMode(4);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setShowGrid(true);
        this.setAutoCreateRowSorter(true);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(true);
        FontMetrics fontMetrics = this.getFontMetrics(FontUtil.getBoldChangedFont());
        Insets insets = new Insets(1, 1, 1, 1);
        try {
            insets = UIManager.getBorder("TableHeader.cellBorder").getBorderInsets(jTableHeader);
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "UI-Manager problem");
        }
        int n = 4 + 2 * (insets.left + insets.right);
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        if (tableColumn != null) {
            tableColumn.setMinWidth(20);
            tableColumn.setPreferredWidth(40);
            tableColumn.setMaxWidth(60);
        }
        for (int i = 1; i < this.getColumnCount(); ++i) {
            int n2 = 200;
            for (int j = 0; j < tableModel.getRowCount(); ++j) {
                int n3 = fontMetrics.stringWidth((String)tableModel.getValueAt(j, i)) + n;
                if (n3 <= n2) continue;
                n2 = n3;
            }
            if (this.getColumnModel() == null || (tableColumn = this.getColumnModel().getColumn(i)) == null) continue;
            tableColumn.setMinWidth(n2 / 2);
            tableColumn.setPreferredWidth(n2);
            tableColumn.setMaxWidth(n2 * 2);
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return Boolean.class;
        }
        return String.class;
    }
}

