/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.MdiModalFrame;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.CaseUInterface;
import ch.steph.repui.RepMainFrame;
import ch.steph.repui.RepMainMenu;
import ch.steph.util.Log;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FilterBox
extends MdiModalFrame {
    private static final long serialVersionUID = 1L;
    private JTextField filterText;
    private JComboBox<String> filterType;
    private CaseUInterface repCase;
    private String[] filter;

    public FilterBox(CaseUInterface caseUInterface, String string) {
        super(StringResource.getString("filter_title"));
        this.repCase = caseUInterface;
        User.instance().setProperty("cFilter", User.instance().getProperty("cFilter", 0) + 1);
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                FilterBox.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.getContentPane().addKeyListener(keyListener);
        this.getContentPane().setLayout(new GridLayout(2, 1));
        this.filterText = new JTextField("", 12);
        this.getContentPane().add(this.filterText);
        this.filterText.setToolTipText(StringResource.getString("filter_tooltip"));
        this.filter = caseUInterface.getFilterText();
        this.filterType = new JComboBox<String>(this.filter);
        this.getContentPane().add(this.filterType);
        this.pack();
        Rectangle rectangle = caseUInterface.getBounds();
        Rectangle rectangle2 = this.getBounds();
        Insets insets = this.getInsets();
        rectangle2.x = rectangle.x + insets.left;
        rectangle2.y = rectangle.y;
        this.setBounds(rectangle2);
        int n = User.instance().getProperty("filterSetting", 0);
        this.filterType.setSelectedIndex(n);
        this.filterText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FilterBox.this.filterTextTextValueChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FilterBox.this.filterTextTextValueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                FilterBox.this.filterTextTextValueChanged();
            }
        });
        if (string != null) {
            this.filterText.setText(string);
            this.filterText.setCaretPosition(string.length());
        }
        this.filterText.addKeyListener(keyListener);
        this.filterType.addKeyListener(keyListener);
        this.filterType.addItemListener(this::typeAction);
    }

    public void addToText(String string) {
        if (this.filterText != null) {
            this.filterText.setText(this.filterText.getText() + string);
            this.filterText.setCaretPosition(this.filterText.getText().length());
            this.filterText.requestFocus();
        }
    }

    @Override
    public void requestFocus() {
        if (this.filterText != null) {
            this.filterText.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    protected void mainKeyPressed(KeyEvent keyEvent) {
        try {
            char c = keyEvent.getKeyChar();
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
                if (c == '\n') {
                    keyEvent.consume();
                    this.closeAction();
                } else if (c == '\u001b') {
                    keyEvent.consume();
                    this.closeAction();
                }
            }
            if ((c = RepMainMenu.mainMenuGetCtrlChar(keyEvent)) > '\u0000' && c == 'M') {
                keyEvent.consume();
                RepMainFrame.getRepInstance().medicaDynaAction();
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey", exception);
        }
    }

    protected void typeAction(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            int n = this.filterType.getSelectedIndex();
            this.repCase.setFilterText(this.filterText.getText(), n);
            User.instance().setProperty("filterSetting", n);
        }
    }

    protected void filterTextTextValueChanged() {
        this.repCase.setFilterText(this.filterText.getText(), this.filterType.getSelectedIndex());
    }

    @Override
    public void closedAction() {
        super.closedAction();
        this.repCase.setFilterText("", 9999);
    }
}

