/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.repui.RegBox;
import ch.steph.reputil.CopyUtil;
import ch.steph.reputil.PatientUtil;
import ch.steph.reputil.RepUtil;
import ch.steph.util.Constants;
import ch.steph.util.FileCsv;
import ch.steph.util.FileProcedures;
import ch.steph.util.GetDataFile;
import ch.steph.util.Log;
import ch.steph.util.PwHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FirstIni
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Vector<String[]> lines;
    private Vector<JRadioButton> buttons;
    ButtonGroup group;
    private JCheckBox copyExample;
    private JTextField dataDir;
    private JCheckBox overwriteTemplates;
    private JTextField nameText;
    private JTextField patPw;
    private JButton okButton;

    public FirstIni(JFrame jFrame) {
        super((Frame)jFrame, true);
        Log.write(5, this.getClass().getName(), "start");
        this.setTitle("jRep");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FirstIni.this.closeAction();
            }
        });
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                FirstIni.this.mainKeyTyped(keyEvent);
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                FirstIni.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.addKeyListener(keyListener);
        FileCsv fileCsv = RepUtil.openFirstIniFile();
        String string = fileCsv.readLn();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 2));
        JLabel jLabel = new JLabel("  " + StringResource.getString("reg_user"));
        jPanel.add(jLabel);
        jLabel = new JLabel("  " + StringResource.getString("pat_pw_ini") + "  ");
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 5, 2));
        this.nameText = new JTextField(User.instance().getUserName());
        this.nameText.setColumns(26);
        jPanel2.add(this.nameText);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 5, 2));
        this.patPw = new JTextField();
        this.patPw.setColumns(26);
        if (User.instance().getProperty("patPw", "").length() > 0) {
            this.patPw.setText("\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022");
        } else if (this.nameText.getText().length() == 0) {
            this.patPw.setText(PwHelper.generateSecureRandomPassword(17));
        }
        jPanel2.add(this.patPw);
        jPanel.add(jPanel2);
        this.getContentPane().add((Component)jPanel, "North");
        JPanel jPanel3 = new JPanel();
        if (string != null && string.length() > 0) {
            JComponent jComponent;
            this.lines = new Vector();
            this.buttons = new Vector();
            String[] stringArray = fileCsv.readCSVLine();
            while (stringArray != null) {
                this.lines.addElement(stringArray);
                stringArray = fileCsv.readCSVLine();
            }
            jPanel3.setLayout(new GridLayout(1 + this.lines.size(), 1));
            JLabel jLabel2 = new JLabel(string, 0);
            jLabel2.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 10));
            jPanel3.add(jLabel2);
            this.group = new ButtonGroup();
            int n = User.instance().getProperty("firstIniIndex", 0);
            for (int i = 0; i < this.lines.size(); ++i) {
                stringArray = this.lines.elementAt(i);
                jComponent = new JRadioButton(stringArray[0], i == n);
                this.buttons.add((JRadioButton)jComponent);
                this.group.add((AbstractButton)jComponent);
                jPanel3.add(jComponent);
            }
            this.getContentPane().add((Component)jPanel3, "Center");
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridLayout(4, 1));
            this.copyExample = new JCheckBox(StringResource.getString("first_cb"));
            this.copyExample.setSelected(true);
            jPanel4.add(this.copyExample);
            jComponent = new JPanel();
            jComponent.setLayout(new FlowLayout(0, 5, 1));
            jLabel = new JLabel(StringResource.getString("option_data_dir"));
            jComponent.add(jLabel);
            String string2 = GetDataFile.getDataPath();
            this.dataDir = new JTextField(string2, 30);
            this.dataDir.setEditable(false);
            this.dataDir.addKeyListener(keyListener);
            jComponent.add(this.dataDir);
            JButton jButton = new JButton(StringResource.getString("button_search_dir"));
            jButton.addActionListener(actionEvent -> this.buttonSearchAction());
            jButton.addKeyListener(keyListener);
            jComponent.add(jButton);
            jPanel4.add(jComponent);
            this.overwriteTemplates = new JCheckBox(StringResource.getString("option_overwrite") + "  " + StringResource.getString("first_wait"));
            this.overwriteTemplates.setSelected(false);
            jPanel4.add(this.overwriteTemplates);
            jComponent = new JPanel();
            this.okButton = new JButton(StringResource.getString("button_ok"));
            this.okButton.addActionListener(actionEvent -> this.closeAction());
            jComponent.add(this.okButton);
            jPanel4.add(jComponent);
            this.okButton.addKeyListener(keyListener);
            this.okButton.getCursor();
            this.getContentPane().add((Component)jPanel4, "South");
            this.nameText.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    FirstIni.this.nameTextChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    FirstIni.this.nameTextChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    FirstIni.this.nameTextChanged();
                }
            });
            this.nameTextChanged();
            this.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle rectangle = this.getBounds();
            rectangle.x = 0 + (dimension.width - rectangle.width) / 2;
            rectangle.y = 0 + (dimension.height - rectangle.height) / 2;
            this.setBounds(rectangle);
            Log.write(4, this.getClass().getName(), "size: " + String.valueOf(rectangle));
            this.setVisible(true);
        }
    }

    protected void mainKeyTyped(KeyEvent keyEvent) {
        try {
            char c;
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown() || (c = Character.toUpperCase(keyEvent.getKeyChar())) != '\u001b')) {
                keyEvent.consume();
                this.closeAction();
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey: " + String.valueOf(keyEvent), exception);
        }
    }

    protected void mainKeyPressed(KeyEvent keyEvent) {
        try {
            char c;
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown() || (c = Character.toUpperCase(keyEvent.getKeyChar())) != '\n')) {
                keyEvent.consume();
                this.closeAction();
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey:" + String.valueOf(keyEvent), exception);
        }
    }

    protected void closeAction() {
        Log.write(5, this.getClass().getName(), "closeAction");
        User.instance().setProperty("Name", this.nameText.getText());
        if (!"\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022".equals(this.patPw.getText())) {
            if (this.patPw.getText().length() == 0) {
                User.instance().setProperty("patPw", "");
            } else {
                User.instance().setProperty("patPw", PwHelper.hashPassword(this.patPw.getText()));
            }
        }
        try {
            if (this.copyExample.isSelected()) {
                GetDataFile.setDataPath(this.dataDir.getText());
                if (GetDataFile.getDataPath().length() > 0) {
                    User.instance().setProperty("overwriteTemplates", this.overwriteTemplates.isSelected());
                    CopyUtil.copyListToExt(GetDataFile.getDataPath());
                    PatientUtil.setPatDir(0, Constants.PAT_DIR0, FileProcedures.addDirName(FileProcedures.addDirName(GetDataFile.getDataPath(), "Auswertungen"), Constants.PAT_DIR0));
                    PatientUtil.setPatDir(1, Constants.PAT_DIR1, FileProcedures.addDirName(FileProcedures.addDirName(GetDataFile.getDataPath(), "Auswertungen"), Constants.PAT_DIR1));
                    PatientUtil.setPatDir(2, Constants.PAT_DIR2, FileProcedures.addDirName(FileProcedures.addDirName(GetDataFile.getDataPath(), "Auswertungen"), Constants.PAT_DIR2));
                    PatientUtil.activatePatDir(Constants.PAT_DIR0);
                    PatientUtil.setSelectedPatient("Berta BEISPIEL");
                    User.instance().setProperty("overwriteTemplates", false);
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "Problem setting examples: ", exception);
        }
        try {
            for (int i = 0; i < this.buttons.size(); ++i) {
                int n;
                JRadioButton jRadioButton = this.buttons.get(i);
                if (!jRadioButton.isSelected()) continue;
                User.instance().setProperty("firstIniIndex", i);
                String[] stringArray = this.lines.elementAt(i);
                try {
                    n = Integer.parseInt(stringArray[1]);
                }
                catch (Exception exception) {
                    n = 1;
                }
                User.instance().setProperty("RepNr", n);
                try {
                    n = Integer.parseInt(stringArray[2]);
                }
                catch (Exception exception) {
                    n = 1;
                }
                User.instance().setProperty("actMM", n);
                User.instance().setProperty("actMMsearch", n);
                try {
                    n = Integer.parseInt(stringArray[3]);
                }
                catch (Exception exception) {
                    n = 26;
                }
                User.instance().setProperty("firstMain", n);
                try {
                    n = Integer.parseInt(stringArray[4]);
                }
                catch (Exception exception) {
                    n = 26;
                }
                User.instance().setProperty("firstCase", n);
            }
            Log.write(5, this.getClass().getName(), "Param written");
            this.setVisible(false);
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "Problem initializing: ", exception);
        }
        Log.write(5, this.getClass().getName(), "done");
    }

    protected void buttonSearchAction() {
        JFileChooser jFileChooser = new JFileChooser(this.dataDir.getText());
        jFileChooser.setDialogTitle(StringResource.getString("dialog_file"));
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this.getParent());
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getPath();
            this.dataDir.setText(string);
        }
    }

    private void nameTextChanged() {
        String string;
        String string2 = this.nameText.getText();
        if (!string2.equals(string = RegBox.name32FieldTextValueChanged(string2))) {
            SwingUtilities.invokeLater(() -> {
                this.nameText.setText(string);
                this.nameText.setCaretPosition(string.length());
            });
        }
        if (string.length() > 4) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }
}

