/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.MdiNormalFrame;
import ch.steph.apputil.ScreenUtil;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.Rep;
import ch.steph.rep.SearchResult;
import ch.steph.rep.SearchThread;
import ch.steph.repdata.CaseUiImpl;
import ch.steph.repdata.RepDataPool;
import ch.steph.repdata.Rubric;
import ch.steph.repmodel.InputListModel;
import ch.steph.repui.RepMainFrame;
import ch.steph.repui.RepMainMenu;
import ch.steph.reputil.FontUtil;
import ch.steph.reputil.InputUtil;
import ch.steph.reputil.RepUtil;
import ch.steph.reputil.RubricUtil;
import ch.steph.util.IconUtil;
import ch.steph.util.Log;
import ch.steph.util.MenuHint;
import ch.steph.util.TimeProbe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class InputAll
extends MdiNormalFrame {
    private static final long serialVersionUID = 1L;
    protected JTextField searchField;
    private JLabel statusField;
    private JButton searchButton;
    protected JList<Rubric> showList;
    protected InputListModel showListModel;
    private JScrollPane showListPane;
    protected JPopupMenu showListPopupMenu;
    private JPanel northPanel;
    private JComboBox<String> mediChoice;
    private JComboBox<String> valueChoice;
    private JCheckBox withMM;
    protected int showCount = 0;
    private int lastSelected = -1;
    private boolean doSelect;
    private String initSearchString;
    private SearchThread[] inputSearchThread;
    private SearchThread lastInputSearchThread;

    public InputAll(String string) {
        super(true, "", 11, "inall");
        User.instance().setProperty("cInputAll", User.instance().getProperty("cInputAll", 0) + 1);
        this.setFrameIcon(IconUtil.getImageIcon(this, "icon/1.gif"));
        this.initFrame();
        this.initProgram();
        this.addAllListener();
        this.initSearchString = string;
        Log.write(4, this.getClass().getName(), "jRep run");
        RepDataPool.getInstance().loadAllRep(this);
    }

    public void repLoadDone() {
        SwingUtilities.invokeLater(() -> this.statusField.setText(StringResource.getString("countField_rubric") + " ?"));
        if (this.initSearchString != null && this.initSearchString.length() > 0) {
            SwingUtilities.invokeLater(() -> {
                this.searchField.setEnabled(true);
                this.searchField.requestFocus();
                this.searchField.setText(this.initSearchString);
                this.searchNow();
            });
        } else {
            this.searchField.setEnabled(true);
            this.searchField.requestFocus();
        }
    }

    private void initFrame() {
        this.setNewTitleText(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.showListPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(StringResource.getString("menu_search_select"));
        jMenuItem.addActionListener(actionEvent -> this.selectForCaseResult());
        MenuHint.set(MenuHint.SHORTCUT.Enter, jMenuItem);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_search_sel_0"));
        jMenuItem.addActionListener(actionEvent -> this.selectForCaseResult(true));
        MenuHint.set('-', jMenuItem);
        this.showListPopupMenu.add(jMenuItem);
        this.showListPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_rubric_show"));
        jMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().rubricAction());
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_search_export"));
        jMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().exportRubricAction());
        this.showListPopupMenu.add(jMenuItem);
        this.showListPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_list_copy"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        jMenuItem.addActionListener(actionEvent -> this.copyToClipboard());
        this.showListPopupMenu.add(jMenuItem);
        this.showListPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_sub"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.SUB));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_add"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.ADD));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_add4"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.SUM4));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_add4o1"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.SUM4O1));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_count"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.COUNT));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_count4"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.COUNT4));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        if (User.instance().getProperty("MaxResultLen", 1) == 1) {
            User.instance().setProperty("MaxResultLen", 2000);
            User.instance().setProperty("MmAlwaysOpen", ScreenUtil.hasOpenMM());
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        this.searchField = new JTextField(16);
        this.searchField.setToolTipText(StringResource.getString("inputfield_tooltip"));
        jPanel2.add((Component)this.searchField, "Center");
        this.searchField.setEnabled(false);
        this.withMM = new JCheckBox("mit MM");
        this.withMM.setSelected(User.instance().getProperty("withMM", false));
        this.withMM.addActionListener(actionEvent -> {
            User.instance().setProperty("withMM", this.withMM.isSelected());
            this.searchButton.setEnabled(this.searchField.getText().length() > 1);
        });
        jPanel2.add((Component)this.withMM, "East");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.statusField = new JLabel(StringResource.getString("countField_rubric") + " ?", 0);
        this.statusField.setHorizontalAlignment(0);
        jPanel3.add((Component)this.statusField, "Center");
        this.mediChoice = new JComboBox();
        this.mediChoice.addItem("");
        this.mediChoice.setMaximumRowCount(User.instance().getProperty("DropdownRows", 20));
        String[] stringArray = RepUtil.getFullMediArray();
        for (int i = 1; i < stringArray.length; ++i) {
            this.mediChoice.addItem(stringArray[i]);
        }
        this.mediChoice.addItemListener(this::chooseMedi1Action);
        jPanel4.add(this.mediChoice, "West");
        this.valueChoice = new JComboBox();
        this.valueChoice.addItem("1");
        this.valueChoice.addItem("2");
        this.valueChoice.addItem("3");
        this.valueChoice.addItem("4");
        this.valueChoice.addItem("5");
        this.valueChoice.addItem("6");
        this.valueChoice.addItem("7");
        this.valueChoice.addItem("8");
        this.valueChoice.addItem("9");
        this.valueChoice.setSelectedIndex(User.instance().getProperty("initSearchValue", 2));
        this.valueChoice.setMaximumRowCount(User.instance().getProperty("DropdownRows", 20));
        this.valueChoice.addItemListener(this::chooseValueAction);
        jPanel4.add(this.valueChoice, "East");
        jPanel3.add((Component)jPanel4, "East");
        jPanel.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.setBackground(Color.lightGray);
        jPanel5.add((Component)jPanel, "Center");
        this.searchButton = new JButton(StringResource.getString("search_button"));
        this.searchButton.setEnabled(false);
        this.searchButton.setMargin(new Insets(0, 2, 0, 2));
        this.searchButton.addActionListener(actionEvent -> this.searchNow());
        jPanel5.add((Component)this.searchButton, "East");
        this.showListPane = new JScrollPane();
        this.showListModel = new InputListModel(null);
        this.showList = new JList<Rubric>(this.showListModel);
        this.showList.setFont(FontUtil.getChangedFont());
        this.showList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                Rubric rubric = (Rubric)object;
                String string = rubric.getShowRubric(true);
                JComponent jComponent = (JComponent)super.getListCellRendererComponent(jList, string, n, bl, bl2);
                return InputUtil.getCellRenderer(InputAll.this.showListModel, jComponent, rubric, string, InputAll.this.searchField.getText(), InputAll.this.lastInputSearchThread.getSearchResult(), bl);
            }
        });
        this.showListPane.getViewport().add(this.showList);
        this.northPanel = new JPanel();
        this.northPanel.setLayout(new BorderLayout());
        this.northPanel.setBackground(Color.lightGray);
        this.northPanel.add((Component)jPanel5, "North");
        this.getContentPane().add((Component)this.northPanel, "North");
        this.getContentPane().add((Component)this.showListPane, "Center");
    }

    private void initProgram() {
    }

    private void addAllListener() {
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                InputAll.this.searchFieldTextValueChanged(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                InputAll.this.searchFieldTextValueChanged(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                InputAll.this.searchFieldTextValueChanged(documentEvent);
            }
        });
        this.searchField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), "A: " + keyEvent.paramString());
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), "A: " + keyEvent.paramString());
                InputAll.this.searchFieldKeyPressed(keyEvent);
                InputAll.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.searchField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                RepMainFrame.getRepInstance().setMenuEnables(null);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.showList.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (InputAll.this.showList.getModel().getSize() == 0) {
                    InputAll.this.searchField.requestFocus();
                }
                RepMainFrame.getRepInstance().setMenuEnables(null);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.showList.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), "B: " + keyEvent.paramString());
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), "B: " + keyEvent.paramString());
                InputAll.this.resultListKeyPressed(keyEvent);
                InputAll.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.showList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseClicked: " + mouseEvent.paramString());
                if (mouseEvent.getClickCount() >= 2) {
                    InputAll.this.selectForCaseResult();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mousePressed: " + mouseEvent.paramString());
                if (InputAll.this.showList.getSelectedIndex() >= 0) {
                    if (mouseEvent.isPopupTrigger()) {
                        InputAll.this.showListPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                } else {
                    int n = InputAll.this.showList.locationToIndex(mouseEvent.getPoint());
                    InputAll.this.showList.setSelectedIndex(n);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseReleased: " + mouseEvent.paramString());
                if (InputAll.this.showList.getSelectedIndex() >= 0 && mouseEvent.isPopupTrigger()) {
                    InputAll.this.showListPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.showList.addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.selectionChanged();
            }
        });
        this.statusField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                InputAll.this.oldSearchAction();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.showListPane.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                InputAll.this.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.showListPane.getVerticalScrollBar().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                InputAll.this.oldSearchAction();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.showListPane.getHorizontalScrollBar().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                InputAll.this.oldSearchAction();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }

    void copyToClipboard() {
        try {
            int n;
            List<Rubric> list;
            StringBuilder stringBuilder = new StringBuilder("");
            int n2 = 100;
            if (User.instance().isSuperUser()) {
                n2 = 999999;
            }
            if ((list = this.getSelectedRubrics()) != null && list.size() > 1) {
                for (n = 0; n < list.size() && n < n2; ++n) {
                    stringBuilder.append(list.get(n).getShowRubric(false)).append("\n");
                }
            } else {
                for (n = 0; n < this.showList.getModel().getSize() && n < n2; ++n) {
                    stringBuilder.append(this.showList.getModel().getElementAt(n).getShowRubric(false)).append("\n");
                }
            }
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            this.getToolkit().getSystemClipboard().setContents(stringSelection, null);
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "copyToClipboard", exception);
        }
    }

    @Override
    public void requestFocus() {
        if (this.searchField != null && this.showList != null) {
            if (this.showList.hasFocus()) {
                return;
            }
            if (this.showList.getModel() != null && this.showList.getModel().getSize() > 0) {
                Log.write(5, this.getClass().getName(), "showList.requestFocus");
                this.showList.requestFocusInWindow();
            } else {
                Log.write(5, this.getClass().getName(), "searchField.requestFocus");
                this.searchField.requestFocusInWindow();
            }
        } else {
            super.requestFocus();
            Log.write(5, this.getClass().getName(), "super.requestFocus");
        }
    }

    private void searchFieldKeyPressed(KeyEvent keyEvent) {
        try {
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
                char c = keyEvent.getKeyChar();
                switch (c) {
                    case 'C': {
                        break;
                    }
                    case '\n': {
                        keyEvent.consume();
                        if (this.searchButton.isEnabled()) {
                            this.searchNow();
                            break;
                        }
                        if (this.showListModel.getSize() <= 0) break;
                        this.showAction();
                        break;
                    }
                    case '\u001b': {
                        keyEvent.consume();
                        if (this.searchField.getText().length() > 0) {
                            this.newSearchAction();
                            break;
                        }
                        this.closeAction();
                        break;
                    }
                    case '\u007f': {
                        keyEvent.consume();
                        this.newSearchAction();
                        break;
                    }
                    case '\u0000': 
                    case '\uffff': {
                        int n = keyEvent.getKeyCode();
                        if (n != 40 && n != 225) break;
                        keyEvent.consume();
                        if (this.showListModel.getSize() <= 0) break;
                        this.showAction();
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "searchFieldKeyEvents", exception);
        }
    }

    private void resultListKeyPressed(KeyEvent keyEvent) {
        try {
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
                char c = keyEvent.getKeyChar();
                switch (c) {
                    case 'C': {
                        keyEvent.consume();
                        this.copyToClipboard();
                        break;
                    }
                    case '\n': {
                        keyEvent.consume();
                        this.selectForCaseResult();
                        break;
                    }
                    case '-': {
                        this.selectForCaseResult(true);
                        break;
                    }
                    case '\t': {
                        keyEvent.consume();
                        this.oldSearchAction();
                        break;
                    }
                    case '\u001b': {
                        keyEvent.consume();
                        if (this.searchField.getText().length() > 0) {
                            this.newSearchAction();
                            break;
                        }
                        this.closeAction();
                        break;
                    }
                    case '\u007f': {
                        keyEvent.consume();
                        this.newSearchAction();
                        break;
                    }
                    case '\u0000': 
                    case '\uffff': {
                        int n = keyEvent.getKeyCode();
                        if (n != 38 && n != 224 || this.showList.getSelectedIndex() != 0) break;
                        keyEvent.consume();
                        this.searchField.requestFocus();
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "resultListKeyEvents", exception);
        }
    }

    private void mainKeyPressed(KeyEvent keyEvent) {
        try {
            char c = RepMainMenu.mainMenuGetCtrlChar(keyEvent);
            RepMainMenu.mainMenuActionDone(keyEvent, c);
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "keyEvents", exception);
        }
    }

    private void searchFieldTextValueChanged(DocumentEvent documentEvent) {
        try {
            if (this.searchField.getText().length() >= 2) {
                this.searchButton.setEnabled(true);
            } else {
                this.searchButton.setEnabled(false);
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "searchFieldTextValueChanged", exception);
        }
    }

    protected void chooseMedi1Action(ItemEvent itemEvent) {
        try {
            if (itemEvent.getStateChange() == 1 && this.searchField.getText().length() >= 2) {
                this.searchButton.setEnabled(true);
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "searchFieldTextValueChanged", exception);
        }
    }

    private void chooseValueAction(ItemEvent itemEvent) {
        try {
            if (itemEvent.getStateChange() == 1) {
                int n = this.valueChoice.getSelectedIndex();
                User.instance().setProperty("initSearchValue", n);
                if (this.searchField.getText().length() >= 2) {
                    this.searchButton.setEnabled(true);
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "searchFieldTextValueChanged", exception);
        }
    }

    protected int getShowListCount() {
        return this.showListModel.getSize();
    }

    protected Rubric getSelectedRubric() {
        int n;
        if (this.getShowListCount() > 0 && (n = this.showList.getSelectedIndex()) >= 0) {
            return this.showListModel.getByRubricIndex(n);
        }
        return null;
    }

    private List<Rubric> getSelectedRubrics() {
        int[] nArray;
        if (this.getShowListCount() > 0 && (nArray = this.showList.getSelectedIndices()) != null && nArray.length > 0) {
            ArrayList<Rubric> arrayList = new ArrayList<Rubric>();
            for (int n : nArray) {
                Rubric rubric = this.showListModel.getByRubricIndex(n);
                arrayList.add(rubric);
            }
            return arrayList;
        }
        return null;
    }

    protected void newSearchAction() {
        this.inputSearchThread = null;
        this.getAndShowSearchResult();
        this.searchField.setText("");
        this.doSelect = false;
        this.setNewTitleText(null);
        RepMainFrame.getRepInstance().setMainRubric(null);
        this.searchField.requestFocus();
        this.statusField.setText(StringResource.getString("countField_rubric") + " ?");
    }

    protected void oldSearchAction() {
        try {
            this.searchField.requestFocus();
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "oldSearchAction", exception);
        }
    }

    protected void showAction() {
        if (this.showListModel.getSize() > 0) {
            this.statusField.setText(StringResource.getString("countField_show") + this.showListModel.getSize());
            this.showList.requestFocus();
            if (this.showList.getSelectedIndex() < 0) {
                this.showList.setSelectedIndex(0);
            }
        } else {
            this.searchField.requestFocus();
        }
    }

    protected void selectForCaseResult() {
        this.selectForCaseResult(false);
    }

    protected void selectForCaseResult(boolean bl) {
        try {
            List<Rubric> list;
            Rubric rubric = this.getSelectedRubric();
            if (rubric != null && (list = this.getSelectedRubrics()) != null) {
                for (Rubric rubric2 : list) {
                    RepMainFrame.getRepInstance().selectRubricAction(rubric2, bl);
                }
            }
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "not in CaseResult", exception);
        }
    }

    protected void setNewTitleText(String string) {
        if (string != null && string.length() > 0) {
            this.setTitle("jRep " + string);
        } else {
            this.setTitle("jRep " + StringResource.getString("search_title_all"));
        }
    }

    public void combineAll(RubricUtil.CombineType combineType) {
        Rep.getExecutor().execute(() -> {
            List<Rubric> list = this.getSelectedRubrics();
            if (list.size() <= 1) {
                list = this.showListModel.getAllRubrics();
            }
            CaseUiImpl caseUiImpl = new CaseUiImpl(list, this.searchField.getText());
            caseUiImpl.finishResults(combineType);
            RepMainFrame.getRepInstance().addCombinedLine(caseUiImpl.getResultRubric());
        });
    }

    private void selectionChanged() {
        try {
            int n = this.showList.getSelectedIndex();
            Rubric rubric = null;
            if (n != this.lastSelected) {
                this.lastSelected = n;
                if (n >= 0 && (rubric = this.showListModel.getByRubricIndex(n)) != null) {
                    RepMainFrame.getRepInstance().showSelectedRubric(rubric);
                }
                RepMainFrame.getRepInstance().setMenuEnables(rubric);
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "selectionChanged", exception);
        }
    }

    private void searchNow() {
        this.searchButton.setEnabled(false);
        String string = "";
        if (!this.withMM.isSelected()) {
            string = " !MM:";
        }
        String string2 = this.searchField.getText() + string;
        String string3 = this.mediChoice.getItemAt(this.mediChoice.getSelectedIndex());
        String string4 = this.valueChoice.getItemAt(this.valueChoice.getSelectedIndex());
        Log.write(5, this.getClass().getName(), "search now: '" + string2);
        if (string2.length() == 0) {
            Log.write(2, this.getClass().getName(), "newSearchString empty");
            return;
        }
        RepMainFrame.getRepInstance().setMenuEnables(null);
        ScheduledFuture<?> scheduledFuture = Rep.getScheduledExecutor().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                int n = 0;
                for (SearchThread searchThread : InputAll.this.inputSearchThread) {
                    if (searchThread == null) continue;
                    n += searchThread.getRunCount();
                }
                if (n >= 0) {
                    int n2 = n;
                    SwingUtilities.invokeLater(() -> InputAll.this.statusField.setText(n2 + " Suche"));
                }
            }
        }, 53L, 53L, TimeUnit.MILLISECONDS);
        Rep.getExecutor().execute(() -> {
            TimeProbe timeProbe = new TimeProbe();
            String[] stringArray = User.instance().getRepTitles(false);
            this.inputSearchThread = new SearchThread[stringArray.length];
            boolean bl = false;
            for (int i = 1; i < 62; ++i) {
                boolean bl2;
                if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
                timeProbe.partEnds(1, "organize");
                this.inputSearchThread[i] = new SearchThread(i);
                this.inputSearchThread[i].getRepHeader();
                timeProbe.partEnds(2, "get Rep");
                if (string3.length() == 0) {
                    bl2 = this.inputSearchThread[i].searchWithString(string2);
                } else {
                    String[] stringArray2 = RepDataPool.getInstance().getRepHeader(i).getRepMedis();
                    bl2 = this.inputSearchThread[i].loadWithValue(string3, string4.charAt(0), string2, stringArray2);
                }
                this.lastInputSearchThread = this.inputSearchThread[i];
                if (bl2) {
                    bl = true;
                }
                timeProbe.partEnds(3, "search in Rep");
            }
            scheduledFuture.cancel(true);
            Log.write(5, this.getClass().getName(), timeProbe.getLogString());
            if (bl) {
                SwingUtilities.invokeLater(() -> this.getAndShowSearchResult());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void getAndShowSearchResult() {
        int n = 0;
        SearchResult searchResult = new SearchResult(null);
        if (this.inputSearchThread != null) {
            for (SearchThread searchThread : this.inputSearchThread) {
                if (searchThread == null) continue;
                n += searchThread.getRunCount();
                searchResult.addSearchResult(searchThread.getSearchResult());
            }
        }
        Log.write(5, this.getClass().getName(), "getAndShowSearchResult show result");
        if (n >= 0) {
            void var3_7;
            String string2 = StringResource.getString("search_ok");
            string2 = n + " " + string2;
            if (searchResult.isPartial()) {
                String string3 = "250000 / " + string2;
            }
            this.statusField.setText((String)var3_7);
            this.showListModel = new InputListModel(searchResult);
        } else {
            this.statusField.setText("0 " + StringResource.getString("search_ok"));
            this.showListModel = new InputListModel(null);
        }
        this.showList.setModel(this.showListModel);
        if (this.getShowListCount() == 0) {
            this.setNewTitleText(null);
        }
        if (this.doSelect && this.showList.getModel().getSize() > 0) {
            this.doSelect = false;
            this.showList.requestFocus();
            this.showList.setSelectedIndex(0);
        }
    }
}

