/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.MdiNormalFrame;
import ch.steph.apputil.ScreenUtil;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.Rep;
import ch.steph.rep.SearchThread;
import ch.steph.rep.ToolData;
import ch.steph.repdata.CaseUiImpl;
import ch.steph.repdata.RepDataPool;
import ch.steph.repdata.Rubric;
import ch.steph.repmodel.InputListModel;
import ch.steph.repui.RepMainFrame;
import ch.steph.repui.RepMainMenu;
import ch.steph.reputil.FontUtil;
import ch.steph.reputil.InputUtil;
import ch.steph.reputil.RepUtil;
import ch.steph.reputil.RubricUtil;
import ch.steph.util.GetDataFile;
import ch.steph.util.IconUtil;
import ch.steph.util.Log;
import ch.steph.util.MenuHint;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class InputRubr
extends MdiNormalFrame {
    private static final long serialVersionUID = 1L;
    private static final int PLAIN_SEARCH = -99;
    private JMenuItem popChangeRubricMenuItem;
    private JMenuItem popDeleteRubricMenuItem;
    private JMenuItem popPlusMenuItem;
    private JMenuItem popHierarchicMenuItem;
    private JTextField searchField;
    private JLabel statusField;
    private JComboBox<String> repChoice;
    private JList<Rubric> showList;
    private InputListModel showListModel;
    private JScrollPane showListPane;
    private JPopupMenu showListPopupMenu;
    private JComboBox<String> hierarchicChoice;
    private JPanel hierarchicPanel;
    private JPanel northPanel;
    private String[] repTitle;
    private int lastSelected = -1;
    private int actRepIndex;
    private boolean selectResult;
    private boolean isHierarchicSearch;
    private String[] hierarchicSearchStrings;
    private Rubric[] hierarchicRoot;
    private boolean hierarchicActionAllowed = true;
    private String newSearchString = "";
    private boolean searching = false;
    private int oldLevel = 0;
    private String oldSearchString = "";

    public InputRubr() {
        super(false, "", 2, "Main");
        this.setFrameIcon(IconUtil.getImageIcon(this, "icon/1.gif"));
        if (!"5c4e9b".equals(ToolData.makeToolString(1234L, "jRep", 4711))) {
            while (true) {
                // Infinite loop
            }
        }
        this.initFrame();
        this.initProgram();
        this.addAllListener();
        this.searchField.requestFocus();
        Log.write(4, this.getClass().getName(), "jRep run");
    }

    private void initFrame() {
        this.setNewTitleText(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.showListPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(StringResource.getString("menu_search_select"));
        jMenuItem.addActionListener(actionEvent -> this.selectForCaseResult());
        MenuHint.set(MenuHint.SHORTCUT.Enter, jMenuItem);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_search_sel_0"));
        jMenuItem.addActionListener(actionEvent -> this.selectForCaseResult(true));
        MenuHint.set('-', jMenuItem);
        this.showListPopupMenu.add(jMenuItem);
        this.popHierarchicMenuItem = new JMenuItem(StringResource.getString("menu_search_hierarchic"));
        this.popHierarchicMenuItem.addActionListener(actionEvent -> this.selectHierarchic(true));
        MenuHint.set(MenuHint.SHORTCUT.Space, this.popHierarchicMenuItem);
        this.showListPopupMenu.add(this.popHierarchicMenuItem);
        this.popPlusMenuItem = new JMenuItem(StringResource.getString("menu_search_plus"));
        this.popPlusMenuItem.addActionListener(actionEvent -> this.selectHierarchicForCaseResult());
        MenuHint.set('+', this.popPlusMenuItem);
        this.showListPopupMenu.add(this.popPlusMenuItem);
        this.showListPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_rubric_show"));
        jMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().rubricAction());
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_search_export"));
        jMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().exportRubricAction());
        this.showListPopupMenu.add(jMenuItem);
        this.showListPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_list_copy"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        jMenuItem.addActionListener(actionEvent -> this.copyToClipboard());
        this.showListPopupMenu.add(jMenuItem);
        this.showListPopupMenu.addSeparator();
        this.popChangeRubricMenuItem = new JMenuItem(StringResource.getString("rep_change"));
        this.popChangeRubricMenuItem.setAccelerator(KeyStroke.getKeyStroke(75, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        this.popChangeRubricMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().changeActRubric());
        this.popChangeRubricMenuItem.setEnabled(false);
        this.showListPopupMenu.add(this.popChangeRubricMenuItem);
        this.popDeleteRubricMenuItem = new JMenuItem(StringResource.getString("rep_delete"));
        this.popDeleteRubricMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().deleteRubric());
        this.popDeleteRubricMenuItem.setEnabled(false);
        this.showListPopupMenu.add(this.popDeleteRubricMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_sub"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.SUB));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_add"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.ADD));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_add4"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.SUM4));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_add4o1"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.SUM4O1));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_count"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.COUNT));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_count4"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.COUNT4));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        if (User.instance().getProperty("MaxResultLen", 1) == 1) {
            User.instance().setProperty("MaxResultLen", 2000);
            User.instance().setProperty("MmAlwaysOpen", ScreenUtil.hasOpenMM());
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        this.searchField = new JTextField(16);
        this.searchField.setToolTipText(StringResource.getString("inputfield_tooltip"));
        jPanel.add((Component)this.searchField, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.statusField = new JLabel(StringResource.getString("countField_rubric") + " ?", 0);
        this.statusField.setHorizontalAlignment(0);
        jPanel2.add((Component)this.statusField, "Center");
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBackground(Color.lightGray);
        jPanel3.add((Component)jPanel, "Center");
        this.repTitle = User.instance().getRepTitles(true);
        Vector<String> vector = new Vector<String>();
        if (this.repTitle != null) {
            for (int i = 1; i < 62; ++i) {
                if (this.repTitle[i].length() <= 0) continue;
                vector.add(this.repTitle[i]);
            }
        }
        this.repChoice = new JComboBox(vector);
        this.repChoice.setEditable(false);
        this.repChoice.setEnabled(false);
        this.repChoice.setMaximumRowCount(User.instance().getProperty("DropdownRows", 20));
        jPanel3.add(this.repChoice, "East");
        this.hierarchicPanel = new JPanel();
        this.hierarchicPanel.setLayout(new BorderLayout());
        this.hierarchicChoice = new JComboBox();
        this.hierarchicChoice.setEditable(false);
        this.hierarchicChoice.setEnabled(User.instance().getProperty("ShowHierarchic", false));
        this.hierarchicChoice.setMaximumRowCount(User.instance().getProperty("DropdownRows", 20));
        this.hierarchicPanel.add(this.hierarchicChoice, "Center");
        JLabel jLabel = new JLabel("  " + StringResource.getString("hierarchic_text") + "  ");
        this.hierarchicPanel.add((Component)jLabel, "East");
        this.showListPane = new JScrollPane();
        this.showListModel = new InputListModel(null);
        this.showList = new JList<Rubric>(this.showListModel);
        this.showList.setFont(FontUtil.getChangedFont());
        this.showList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                Rubric rubric = (Rubric)object;
                String string = rubric.getShowRubric(!InputRubr.this.isHierarchicSearch);
                JComponent jComponent = (JComponent)super.getListCellRendererComponent(jList, string, n, bl, bl2);
                return InputUtil.getCellRenderer(InputRubr.this.showListModel, jComponent, rubric, string, InputRubr.this.searchField.getText(), User.instance().getInputSearchThread().getSearchResult(), bl);
            }
        });
        this.showListPane.getViewport().add(this.showList);
        this.northPanel = new JPanel();
        this.northPanel.setLayout(new BorderLayout());
        this.northPanel.setBackground(Color.lightGray);
        this.northPanel.add((Component)jPanel3, "North");
        this.getContentPane().add((Component)this.northPanel, "North");
        this.getContentPane().add((Component)this.showListPane, "Center");
    }

    private void initProgram() {
        this.actRepIndex = User.instance().getProperty("RepNr", 1);
        this.actRepAction();
    }

    private void addAllListener() {
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                InputRubr.this.startSearch();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                InputRubr.this.startSearch();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                InputRubr.this.startSearch();
            }
        });
        this.searchField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), "A: " + keyEvent.paramString());
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), "A: " + keyEvent.paramString());
                InputRubr.this.searchFieldKeyPressed(keyEvent);
                InputRubr.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.searchField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                RepMainFrame.getRepInstance().setMenuEnables(null);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.showList.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (InputRubr.this.showList.getModel().getSize() == 0) {
                    InputRubr.this.searchField.requestFocus();
                }
                RepMainFrame.getRepInstance().setMenuEnables(null);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.showList.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), "B: " + keyEvent.paramString());
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), "B: " + keyEvent.paramString());
                InputRubr.this.resultListKeyPressed(keyEvent);
                InputRubr.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.showList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseClicked: " + mouseEvent.paramString());
                if (mouseEvent.getClickCount() >= 2) {
                    InputRubr.this.selectForCaseResult();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mousePressed: " + mouseEvent.paramString());
                if (InputRubr.this.showList.getSelectedIndex() >= 0) {
                    if (mouseEvent.isPopupTrigger()) {
                        InputRubr.this.showListPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                } else {
                    int n = InputRubr.this.showList.locationToIndex(mouseEvent.getPoint());
                    InputRubr.this.showList.setSelectedIndex(n);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseReleased: " + mouseEvent.paramString());
                if (InputRubr.this.showList.getSelectedIndex() >= 0 && mouseEvent.isPopupTrigger()) {
                    InputRubr.this.showListPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.showList.addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.selectionChanged();
            }
        });
        this.statusField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                InputRubr.this.oldSearchAction();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.repChoice.addItemListener(this::chooseRepAction);
        this.hierarchicChoice.addItemListener(this::chooseLevelAction);
        this.showListPane.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                InputRubr.this.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.showListPane.getVerticalScrollBar().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                InputRubr.this.oldSearchAction();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.showListPane.getHorizontalScrollBar().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                InputRubr.this.oldSearchAction();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }

    private void actRepAction() {
        try {
            boolean bl;
            int n = this.actRepIndex;
            do {
                if (bl = this.getRep()) continue;
                ++this.actRepIndex;
                if (this.actRepIndex < 62) continue;
                this.actRepIndex = 1;
            } while (!bl && n != this.actRepIndex);
            if (this.repTitle != null) {
                this.repChoice.setSelectedItem(this.repTitle[this.actRepIndex]);
                this.repaint();
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "actRepAction", exception);
        }
    }

    private void chooseRepAction(ItemEvent itemEvent) {
        try {
            if (this.repTitle != null && itemEvent.getStateChange() == 1) {
                this.searchField.requestFocus();
                this.saveNewSearchString();
                this.newSearchAction(false);
                for (int i = 1; i < 62; ++i) {
                    if (!itemEvent.getItem().equals(this.repTitle[i]) || i == this.actRepIndex) continue;
                    this.actRepIndex = i;
                    this.getRep();
                }
                this.setNewSearchString();
                RepMainFrame.getRepInstance().setMainRubric(null);
                this.oldSearchAction();
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "chooseRepAction", exception);
        }
    }

    private void chooseLevelAction(ItemEvent itemEvent) {
        if (this.hierarchicActionAllowed) {
            try {
                if (itemEvent.getStateChange() == 1) {
                    this.setNewSearchString();
                }
            }
            catch (Exception exception) {
                Log.write(2, this.getClass().getName(), "chooseRepAction", exception);
            }
        }
    }

    protected void chooseRepAction(int n) {
        try {
            this.actRepIndex = n;
            this.actRepAction();
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "chooseRepAction", exception);
        }
    }

    boolean getRep() {
        try {
            if (this.repTitle[this.actRepIndex] == null || this.repTitle[this.actRepIndex].length() == 0) {
                return false;
            }
            RepMainFrame.getRepInstance().changeRepAction(this.actRepIndex);
            SearchThread searchThread = User.instance().getNewInputSearchThread(this.actRepIndex);
            if (searchThread.getRepHeader()) {
                if (searchThread.isHierarchic()) {
                    this.hierarchicActionAllowed = false;
                    this.isHierarchicSearch = User.instance().getProperty("ShowHierarchic", false);
                    String[] stringArray = searchThread.getHierarchicLevels();
                    this.hierarchicChoice.removeAllItems();
                    if (stringArray != null) {
                        this.hierarchicSearchStrings = new String[stringArray.length];
                        this.hierarchicRoot = new Rubric[stringArray.length];
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (stringArray[i].length() <= 0) continue;
                            this.hierarchicSearchStrings[i] = "";
                            this.hierarchicRoot[i] = null;
                            this.hierarchicChoice.addItem(stringArray[i]);
                        }
                        this.hierarchicChoice.setSelectedIndex(0);
                    }
                    this.hierarchicActionAllowed = true;
                } else {
                    this.isHierarchicSearch = false;
                }
                this.showHierarchicPanelAndSetVar();
                RepMainFrame.getRepInstance().setMenuEnables(null);
                Rep.getExecutor().execute(() -> {
                    User.instance().getInputSearchThread().getRepFile();
                    RepMainFrame.getRepInstance().setFirstLoadDone();
                    if (User.instance().getInputSearchThread().getRepFile().isMemoryException()) {
                        this.statusField.setText("Memory Exception");
                    }
                    this.repChoice.setEnabled(true);
                });
                return true;
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "getRep", exception);
        }
        return false;
    }

    public void showHierarchicPanelAndSetVar() {
        SearchThread searchThread = User.instance().getInputSearchThread();
        if (searchThread.isHierarchic() && User.instance().getProperty("ShowHierarchic", false)) {
            this.northPanel.add((Component)this.hierarchicPanel, "Center");
            this.isHierarchicSearch = true;
        } else {
            this.northPanel.remove(this.hierarchicPanel);
            this.isHierarchicSearch = false;
        }
        this.getContentPane().doLayout();
        this.getContentPane().invalidate();
        this.getContentPane().validate();
    }

    void copyToClipboard() {
        try {
            int n;
            List<Rubric> list;
            StringBuilder stringBuilder = new StringBuilder("");
            int n2 = 100;
            if (User.instance().isSuperUser()) {
                n2 = 999999;
            }
            if ((list = this.getSelectedRubrics()) != null && list.size() > 1) {
                for (n = 0; n < list.size() && n < n2; ++n) {
                    stringBuilder.append(list.get(n).getShowRubric(false)).append("\n");
                }
            } else {
                for (n = 0; n < this.showList.getModel().getSize() && n < n2; ++n) {
                    stringBuilder.append(this.showList.getModel().getElementAt(n).getShowRubric(!this.isHierarchicSearch)).append("\n");
                }
            }
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            this.getToolkit().getSystemClipboard().setContents(stringSelection, null);
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "copyToClipboard", exception);
        }
    }

    @Override
    public void requestFocus() {
        if (this.searchField != null && this.showList != null) {
            if (this.showList.hasFocus()) {
                return;
            }
            if (this.showList.getModel() != null && this.showList.getModel().getSize() > 0) {
                Log.write(5, this.getClass().getName(), "showList.requestFocus");
                this.showList.requestFocusInWindow();
            } else {
                Log.write(5, this.getClass().getName(), "searchField.requestFocus");
                this.searchField.requestFocusInWindow();
            }
        } else {
            super.requestFocus();
            Log.write(5, this.getClass().getName(), "super.requestFocus");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void searchFieldKeyPressed(KeyEvent keyEvent) {
        try {
            this.selectResult = false;
            if (keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown()) return;
            char c = keyEvent.getKeyChar();
            switch (c) {
                case 'C': {
                    return;
                }
                case '\n': {
                    keyEvent.consume();
                    this.showAction();
                    return;
                }
                case '\u001b': {
                    keyEvent.consume();
                    this.newSearchAction(true);
                    return;
                }
                case '\u007f': {
                    keyEvent.consume();
                    this.newSearchAction(true);
                    return;
                }
                default: {
                    int n;
                    if (this.fxKeyEvent(keyEvent)) {
                        keyEvent.consume();
                        return;
                    }
                    if (c != '\uffff' && c != '\u0000' || (n = keyEvent.getKeyCode()) != 40 && n != 225) return;
                    keyEvent.consume();
                    this.showAction();
                }
            }
            return;
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "searchFieldKeyEvents", exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resultListKeyPressed(KeyEvent keyEvent) {
        try {
            this.selectResult = false;
            if (keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown()) return;
            char c = keyEvent.getKeyChar();
            switch (c) {
                case 'C': {
                    keyEvent.consume();
                    this.copyToClipboard();
                    return;
                }
                case '\n': {
                    keyEvent.consume();
                    this.selectForCaseResult();
                    return;
                }
                case '\t': {
                    keyEvent.consume();
                    this.oldSearchAction();
                    return;
                }
                case '\b': {
                    keyEvent.consume();
                    this.oldSearchAction();
                    if (this.searchField.getText().length() <= 0) return;
                    this.newSearchString = this.searchField.getText().substring(0, this.searchField.getText().length() - 1);
                    this.setNewSearchString();
                    return;
                }
                case '\u001b': 
                case '\u007f': {
                    keyEvent.consume();
                    this.newSearchAction(true);
                    return;
                }
                case ' ': {
                    keyEvent.consume();
                    this.selectHierarchic(true);
                    return;
                }
                case '+': 
                case '\u0209': {
                    keyEvent.consume();
                    this.selectHierarchicForCaseResult();
                    return;
                }
                case '-': {
                    keyEvent.consume();
                    this.selectForCaseResult(true);
                    return;
                }
                default: {
                    if (this.fxKeyEvent(keyEvent)) {
                        keyEvent.consume();
                        return;
                    }
                    if (c == '\uffff' || c == '\u0000') {
                        int n = keyEvent.getKeyCode();
                        switch (n) {
                            case 39: 
                            case 227: {
                                keyEvent.consume();
                                this.selectResult = true;
                                this.selectHierarchic(false);
                                return;
                            }
                            case 37: 
                            case 226: {
                                keyEvent.consume();
                                if (this.hierarchicChoice.getSelectedIndex() <= 0) return;
                                this.selectResult = true;
                                this.newSearchAction(false);
                                return;
                            }
                            case 38: 
                            case 224: {
                                if (this.showList.getSelectedIndex() != 0) return;
                                keyEvent.consume();
                                this.searchField.requestFocus();
                            }
                        }
                        return;
                    }
                    if (!Character.isLetterOrDigit(c) && !Character.isSpaceChar(c) && c != '-' && c != '_') return;
                    keyEvent.consume();
                    if (this.searchField.getText().length() > 0) {
                        this.newSearchAction(false);
                    }
                    this.newSearchString = "" + keyEvent.getKeyChar();
                    SwingUtilities.invokeLater(() -> this.setNewSearchString());
                }
            }
            return;
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "resultListKeyEvents", exception);
        }
    }

    private boolean fxKeyEvent(KeyEvent keyEvent) {
        int n = -1;
        switch (keyEvent.getKeyCode()) {
            case 112: {
                RepMainFrame.getRepInstance().helpContextAction("RubrikEingabe");
                return true;
            }
            case 113: {
                n = RepUtil.getRepIndex("F2");
                break;
            }
            case 114: {
                n = RepUtil.getRepIndex("F3");
                break;
            }
            case 115: {
                n = RepUtil.getRepIndex("F4");
                break;
            }
            case 116: {
                n = RepUtil.getRepIndex("F5");
                break;
            }
            case 117: {
                n = RepUtil.getRepIndex("F6");
                break;
            }
            case 118: {
                n = RepUtil.getRepIndex("F7");
                break;
            }
            case 119: {
                n = RepUtil.getRepIndex("F8");
                break;
            }
            case 120: {
                n = RepUtil.getRepIndex("F9");
                break;
            }
            case 121: {
                n = RepUtil.getRepIndex("F10");
                break;
            }
            case 122: {
                n = RepUtil.getRepIndex("F11");
                break;
            }
            case 123: {
                n = RepUtil.getRepIndex("F12");
            }
        }
        if (n >= 0) {
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        return false;
    }

    private void saveNewSearchString() {
        if (this.isHierarchicSearch) {
            this.setHierarchicStrings();
        } else {
            this.newSearchString = this.searchField.getText();
        }
    }

    private void setNewSearchString() {
        int n;
        if (this.newSearchString.length() > 0 && !this.isHierarchicSearch) {
            this.searchNow(-99, this.searchField.getText(), null);
            if (!this.newSearchString.equals(this.searchField.getText())) {
                this.searchField.setText(this.newSearchString);
            }
        } else if (this.isHierarchicSearch && (n = this.hierarchicChoice.getSelectedIndex()) >= 0) {
            if (this.newSearchString.length() > 0) {
                this.hierarchicSearchStrings[n] = this.newSearchString;
            }
            this.searchNow(n, this.hierarchicSearchStrings[n], this.hierarchicRoot[n]);
            if (!this.searchField.getText().equals(this.hierarchicSearchStrings[n])) {
                this.searchField.setText(this.hierarchicSearchStrings[n]);
            }
        }
        this.newSearchString = "";
        this.searchField.setCaretPosition(this.searchField.getText().length());
        this.searchField.requestFocus();
    }

    protected void searchAgain() {
        this.getRep();
        this.saveNewSearchString();
        this.newSearchAction(false);
        this.setNewSearchString();
    }

    private void mainKeyPressed(KeyEvent keyEvent) {
        try {
            char c = RepMainMenu.mainMenuGetCtrlChar(keyEvent);
            RepMainMenu.mainMenuActionDone(keyEvent, c);
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "keyEvents", exception);
        }
    }

    private void startSearch() {
        try {
            if (!this.isHierarchicSearch) {
                this.searchNow(-99, this.searchField.getText(), null);
            } else {
                int n = this.hierarchicChoice.getSelectedIndex();
                this.hierarchicSearchStrings[n] = this.searchField.getText();
                this.searchNow(n, this.hierarchicSearchStrings[n], this.hierarchicRoot[n]);
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "searchFieldTextValueChanged", exception);
        }
    }

    protected boolean hasShowListEntries() {
        return this.showListModel.getSize() > 0;
    }

    protected Rubric getSelectedRubric() {
        int n;
        if (this.hasShowListEntries() && (n = this.showList.getSelectedIndex()) >= 0) {
            return this.showListModel.getByRubricIndex(n);
        }
        return null;
    }

    private List<Rubric> getSelectedRubrics() {
        int[] nArray;
        if (this.hasShowListEntries() && (nArray = this.showList.getSelectedIndices()) != null && nArray.length > 0) {
            ArrayList<Rubric> arrayList = new ArrayList<Rubric>();
            for (int n : nArray) {
                Rubric rubric = this.showListModel.getByRubricIndex(n);
                arrayList.add(rubric);
            }
            return arrayList;
        }
        return null;
    }

    protected String getSearchString() {
        return this.searchField.getText();
    }

    protected void newSearchAction(boolean bl) {
        String string = this.searchField.getText();
        SearchThread searchThread = User.instance().resetInputSearchThread();
        this.getAndShowSearchResult();
        this.searchField.setText("");
        this.setNewTitleText(null);
        RepMainFrame.getRepInstance().setMainRubric(null);
        if (searchThread != null && this.isHierarchicSearch && string.length() == 0) {
            int n = this.hierarchicChoice.getSelectedIndex();
            if (n > 0) {
                String[] stringArray = searchThread.getHierarchicLevels();
                for (int i = n; i < stringArray.length; ++i) {
                    this.hierarchicSearchStrings[i] = "";
                    this.hierarchicRoot[i] = null;
                    this.hierarchicChoice.removeItemAt(i);
                    this.hierarchicChoice.insertItemAt(searchThread.getHierarchicLevels()[i], i);
                }
                this.hierarchicChoice.setSelectedIndex(--n);
            }
            this.setNewSearchString();
        }
        if (bl) {
            this.searchField.requestFocus();
        }
    }

    protected void newCaseAction() {
        this.setNewTitleText(null);
    }

    protected void oldSearchAction() {
        try {
            this.searchField.requestFocus();
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "oldSearchAction", exception);
        }
    }

    protected void setHierarchicSearch() {
        this.hierarchicChoice.setEnabled(this.isHierarchicSearch);
        User.instance().getInputSearchThread().stopThreads();
        if (this.isHierarchicSearch) {
            if (this.searchField.getText().length() > 0 && this.hierarchicSearchStrings != null && (this.hierarchicSearchStrings[0] == null || this.hierarchicSearchStrings[0].length() == 0)) {
                this.hierarchicSearchStrings[0] = this.searchField.getText();
            }
        } else {
            this.setHierarchicStrings();
        }
        this.setNewSearchString();
    }

    private void setHierarchicStrings() {
        if (this.hierarchicSearchStrings != null && this.hierarchicSearchStrings[0] != null) {
            this.newSearchString = this.hierarchicSearchStrings[0];
            for (int i = 1; i < this.hierarchicSearchStrings.length; ++i) {
                if (this.hierarchicSearchStrings[i] == null || this.hierarchicSearchStrings[i].length() <= 0) continue;
                this.newSearchString = this.newSearchString + " " + this.hierarchicSearchStrings[i];
            }
        }
    }

    protected void showAction() {
        if (this.showListModel.getSize() > 0) {
            this.statusField.setText(StringResource.getString("countField_show") + this.showListModel.getSize());
            this.showList.requestFocus();
            if (this.showList.getSelectedIndex() < 0) {
                this.showList.setSelectedIndex(0);
            }
        } else {
            this.searchField.requestFocus();
        }
    }

    protected void selectHierarchic(boolean bl) {
        Rubric rubric = this.getSelectedRubric();
        if (rubric != null) {
            int n = this.hierarchicChoice.getSelectedIndex();
            if (rubric.hasHierarchic()) {
                if (n < this.hierarchicSearchStrings.length - 1) {
                    this.hierarchicRoot[++n] = rubric;
                    this.hierarchicChoice.removeItemAt(n);
                    SearchThread searchThread = User.instance().getInputSearchThread();
                    this.hierarchicChoice.insertItemAt(searchThread.getHierarchicLevels()[n] + " " + this.hierarchicRoot[n].getShowRubric(true), n);
                    String[] stringArray = searchThread.getHierarchicLevels();
                    for (int i = n + 1; i < stringArray.length; ++i) {
                        this.hierarchicSearchStrings[i] = "";
                        this.hierarchicRoot[i] = null;
                        this.hierarchicChoice.removeItemAt(i);
                        this.hierarchicChoice.insertItemAt(searchThread.getHierarchicLevels()[i], i);
                    }
                    this.hierarchicChoice.setSelectedIndex(n);
                    this.setNewSearchString();
                }
            } else if (bl) {
                this.selectForCaseResult();
            }
        }
    }

    protected void selectForCaseResult() {
        this.selectForCaseResult(false);
    }

    private void selectForCaseResult(boolean bl) {
        try {
            Rubric rubric = this.getSelectedRubric();
            if (rubric != null) {
                if (rubric.hasValues()) {
                    List<Rubric> list = this.getSelectedRubrics();
                    if (list != null) {
                        for (Rubric rubric2 : list) {
                            RepMainFrame.getRepInstance().selectRubricAction(rubric2, bl);
                        }
                    }
                } else if (rubric.hasHierarchic() && this.isHierarchicSearch) {
                    this.selectHierarchic(true);
                }
            }
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "not in CaseResult", exception);
        }
    }

    protected void selectHierarchicForCaseResult() {
        try {
            String string;
            Rubric rubric;
            SearchThread searchThread;
            Vector<Rubric> vector;
            Rubric rubric2 = this.getSelectedRubric();
            if (rubric2 != null && (vector = (searchThread = User.instance().getInputSearchThread()).getHierarchicWithChildren(rubric2)) != null && (rubric = RubricUtil.combineRubrics(vector, string = StringResource.getString("join_text_plus") + rubric2.getRubricKey() + "  " + rubric2.getRubricTextOnly(), RubricUtil.CombineType.ADD)) != null) {
                RepMainFrame.getRepInstance().selectRubricAction(rubric);
            }
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "selectHierarchicRubric", exception);
        }
    }

    protected void setNewTitleText(String string) {
        if (string != null && string.length() > 0) {
            this.setTitle("jRep " + string);
        } else if (User.instance().getCaseResultLength() > 0) {
            this.setTitle("jRep " + User.instance().getCaseResultLength() + StringResource.getString("title_result"));
        } else {
            this.setTitle("jRep " + StringResource.getString("search_search"));
        }
    }

    protected boolean isHierarchic() {
        return this.isHierarchicSearch;
    }

    private void selectionChanged() {
        try {
            int n = this.showList.getSelectedIndex();
            Rubric rubric = null;
            if (n != this.lastSelected) {
                this.popChangeRubricMenuItem.setEnabled(false);
                this.popDeleteRubricMenuItem.setEnabled(false);
                this.lastSelected = n;
                if (n >= 0 && (rubric = this.showListModel.getByRubricIndex(n)) != null) {
                    this.popHierarchicMenuItem.setEnabled(rubric.hasHierarchic());
                    this.popPlusMenuItem.setEnabled(rubric.hasHierarchic());
                    if (GetDataFile.getDataPath() != null) {
                        this.popChangeRubricMenuItem.setEnabled(true);
                        if (RepDataPool.getInstance().getRepFile(this.actRepIndex).isEditExtern()) {
                            this.popDeleteRubricMenuItem.setEnabled(rubric.isChanged());
                        } else {
                            this.popDeleteRubricMenuItem.setEnabled(true);
                        }
                    }
                    RepMainFrame.getRepInstance().showSelectedRubric(rubric);
                }
                RepMainFrame.getRepInstance().setMenuEnables(rubric);
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "selectionChanged", exception);
        }
    }

    private void searchNow(int n, String string, Rubric rubric) {
        Log.write(5, this.getClass().getName(), "search now: '" + string + "' level: " + n + " root: '" + String.valueOf(rubric) + "'");
        if (string == null) {
            Log.write(2, this.getClass().getName(), "newSearchString null");
            return;
        }
        SearchThread searchThread = User.instance().getInputSearchThread();
        if (searchThread == null) {
            Log.write(3, this.getClass().getName(), "searchThread null");
            return;
        }
        if (!this.oldSearchString.equals(string) && searchThread.changeSearchString(string)) {
            this.oldSearchString = string;
            return;
        }
        while (this.searching) {
            try {
                Thread.sleep(39L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.oldLevel != n || !this.oldSearchString.equals(string)) {
            this.searching = true;
            this.oldLevel = n;
            this.oldSearchString = string;
            RepMainFrame.getRepInstance().setMenuEnables(null);
            ScheduledFuture<?> scheduledFuture = Rep.getScheduledExecutor().scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    int n = User.instance().getInputSearchThread().getRunCount();
                    if (n >= 0) {
                        SwingUtilities.invokeLater(() -> {
                            String string = User.instance().getInputSearchThread().getRunText();
                            InputRubr.this.statusField.setText(n + " " + string);
                        });
                    }
                }
            }, 53L, 53L, TimeUnit.MILLISECONDS);
            Rep.getExecutor().execute(() -> {
                boolean bl = n == -99 ? User.instance().getInputSearchThread().searchWithString(string) : User.instance().getInputSearchThread().searchWithString(n, string, rubric);
                scheduledFuture.cancel(true);
                this.searching = false;
                if (bl) {
                    SwingUtilities.invokeLater(() -> this.getAndShowSearchResult());
                }
            });
        }
    }

    private void getAndShowSearchResult() {
        Object object = User.instance().getInputSearchThread().getRunText();
        if (object != null) {
            int n = User.instance().getInputSearchThread().getRunCount();
            object = n + " " + (String)object;
            if (User.instance().getInputSearchThread().getSearchResult().isPartial()) {
                object = "250000 / " + (String)object;
            }
            this.statusField.setText((String)object);
            this.showListModel = new InputListModel(User.instance().getInputSearchThread().getSearchResult());
        } else {
            this.statusField.setText(StringResource.getString("countField_rubric") + " ?");
            this.showListModel = new InputListModel(null);
        }
        this.showList.setModel(this.showListModel);
        if (this.hasShowListEntries()) {
            this.setNewTitleText(null);
        }
        if (this.selectResult && this.showList.getModel().getSize() > 0) {
            this.selectResult = false;
            this.showList.requestFocus();
            this.showList.setSelectedIndex(0);
        }
    }

    private void combineAll(RubricUtil.CombineType combineType) {
        Rep.getExecutor().execute(() -> {
            List<Rubric> list = this.getSelectedRubrics();
            if (list.size() <= 1) {
                list = this.showListModel.getAllRubrics();
            }
            CaseUiImpl caseUiImpl = new CaseUiImpl(list, this.searchField.getText());
            caseUiImpl.finishResults(combineType);
            RepMainFrame.getRepInstance().addCombinedLine(caseUiImpl.getResultRubric());
        });
    }

    @Override
    public void activatedAction() {
        SearchThread searchThread = User.instance().getInputSearchThread();
        if (searchThread != null) {
            RepMainFrame.getRepInstance().changeRepAction(this.actRepIndex);
        }
        super.activatedAction();
    }

    @Override
    public void closeAction() {
    }
}

