/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.MdiNormalFrame;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.Rep;
import ch.steph.rep.SearchThread;
import ch.steph.repdata.CaseUiImpl;
import ch.steph.repdata.RepDataPool;
import ch.steph.repdata.Rubric;
import ch.steph.repmodel.InputListModel;
import ch.steph.repui.RepMainFrame;
import ch.steph.repui.RepMainMenu;
import ch.steph.reputil.FontUtil;
import ch.steph.reputil.InputUtil;
import ch.steph.reputil.RepUtil;
import ch.steph.reputil.RubricUtil;
import ch.steph.util.GetDataFile;
import ch.steph.util.IconUtil;
import ch.steph.util.Log;
import ch.steph.util.MenuHint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class InputValue
extends MdiNormalFrame {
    private static final long serialVersionUID = 1L;
    private JMenuItem popChangeRubricMenuItem;
    private JMenuItem popDeleteRubricMenuItem;
    private JComboBox<String> mediChoice;
    private JComboBox<String> valueChoice;
    private JLabel statusField;
    private JComboBox<String> repChoice;
    protected JList<Rubric> showList;
    private JScrollPane showListPane;
    protected JPopupMenu showListPopupMenu;
    private InputListModel showListModel;
    private String[] repTitle;
    private String[] columnTitle;
    protected int showCount = 0;
    private boolean doSelect;
    private int lastSelected = -1;
    private int actRepIndex;
    private String actMedi = "";
    private String actValue = "";
    private String searchMedi = "";
    private String searchValue = "";
    private int searchRepIndex = -1;
    private JTextField searchField;
    private boolean searching = false;
    private String oldSearchString = "";
    private boolean searchOr = false;
    private boolean oldOrButton = false;

    public InputValue(int n) {
        super(true, "", 3, "inp2");
        User.instance().setProperty("cInputValue", User.instance().getProperty("cInputValue", 0) + 1);
        this.setFrameIcon(IconUtil.getImageIcon(this, "icon/1.gif"));
        this.actRepIndex = n;
        this.initFrame();
        this.initProgram();
        this.addAllListener();
        this.requestFocus();
        Log.write(4, this.getClass().getName(), "jRep run");
    }

    private void initFrame() {
        this.setTitleText(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.showListPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(StringResource.getString("menu_search_select"));
        jMenuItem.addActionListener(actionEvent -> this.selectForCaseResult());
        MenuHint.set(MenuHint.SHORTCUT.Enter, jMenuItem);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_search_sel_0"));
        jMenuItem.addActionListener(actionEvent -> this.selectForCaseResult(true));
        MenuHint.set('-', jMenuItem);
        this.showListPopupMenu.add(jMenuItem);
        this.showListPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_rubric_show"));
        jMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().rubricAction());
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_search_export"));
        jMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().exportRubricAction());
        this.showListPopupMenu.add(jMenuItem);
        this.showListPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_list_copy"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        jMenuItem.addActionListener(actionEvent -> this.copyToClipboard());
        this.showListPopupMenu.add(jMenuItem);
        this.showListPopupMenu.addSeparator();
        this.popChangeRubricMenuItem = new JMenuItem(StringResource.getString("rep_change"));
        this.popChangeRubricMenuItem.setAccelerator(KeyStroke.getKeyStroke(75, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        this.popChangeRubricMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().changeActRubric());
        this.popChangeRubricMenuItem.setEnabled(false);
        this.showListPopupMenu.add(this.popChangeRubricMenuItem);
        this.popDeleteRubricMenuItem = new JMenuItem(StringResource.getString("rep_delete"));
        this.popDeleteRubricMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().deleteRubric());
        this.popDeleteRubricMenuItem.setEnabled(false);
        this.showListPopupMenu.add(this.popDeleteRubricMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_sub"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.SUB));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_add"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.ADD));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_add4"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.SUM4));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_add4o1"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.SUM4O1));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_count"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.COUNT));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("rep_comb_count4"));
        jMenuItem.addActionListener(actionEvent -> this.combineAll(RubricUtil.CombineType.COUNT4));
        jMenuItem.setEnabled(true);
        this.showListPopupMenu.add(jMenuItem);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "West");
        if (User.instance().getCaseResult() != null) {
            this.actMedi = User.instance().getCaseResult().getValueAt(0, 1);
        }
        this.mediChoice = new JComboBox();
        this.mediChoice.addItem("");
        this.mediChoice.setMaximumRowCount(User.instance().getProperty("DropdownRows", 20));
        this.mediChoice.addItemListener(this::chooseMediAction);
        jPanel2.add(this.mediChoice, "West");
        JLabel jLabel = new JLabel(" " + StringResource.getString("medicomp_from") + " ", 0);
        jPanel2.add((Component)jLabel, "Center");
        this.valueChoice = new JComboBox();
        this.valueChoice.addItem("1");
        this.valueChoice.addItem("2");
        this.valueChoice.addItem("3");
        this.valueChoice.addItem("4");
        this.valueChoice.addItem("5");
        this.valueChoice.addItem("6");
        this.valueChoice.addItem("7");
        this.valueChoice.addItem("8");
        this.valueChoice.addItem("9");
        this.valueChoice.setSelectedIndex(User.instance().getProperty("initSearchValue", 2));
        this.valueChoice.setMaximumRowCount(User.instance().getProperty("DropdownRows", 20));
        this.actValue = (String)this.valueChoice.getSelectedItem();
        this.valueChoice.addItemListener(this::chooseValueAction);
        jPanel2.add(this.valueChoice, "East");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel3, "Center");
        this.searchField = new JTextField(6);
        this.searchField.setToolTipText(StringResource.getString("inputfield_tooltip"));
        jPanel3.add((Component)this.searchField, "West");
        this.searchField.setEnabled(false);
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                InputValue.this.searchFieldTextValueChanged(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                InputValue.this.searchFieldTextValueChanged(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                InputValue.this.searchFieldTextValueChanged(documentEvent);
            }
        });
        this.searchField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), "A: " + keyEvent.paramString());
                InputValue.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.showCount = 0;
        this.statusField = new JLabel("-", 0);
        this.statusField.setHorizontalAlignment(0);
        jPanel3.add((Component)this.statusField, "Center");
        this.repTitle = User.instance().getRepTitles(true);
        Vector<String> vector = new Vector<String>();
        if (this.repTitle != null) {
            for (int i = 1; i < 62; ++i) {
                if (this.repTitle[i].length() <= 0) continue;
                vector.add(this.repTitle[i]);
            }
        }
        this.repChoice = new JComboBox(vector);
        this.repChoice.setEditable(false);
        this.repChoice.setMaximumRowCount(User.instance().getProperty("DropdownRows", 20));
        jPanel.add(this.repChoice, "East");
        this.showListPane = new JScrollPane();
        this.showListModel = new InputListModel(null);
        this.showList = new JList<Rubric>(this.showListModel);
        this.showList.setFont(FontUtil.getChangedFont());
        this.showList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                Rubric rubric = (Rubric)object;
                String string = rubric.getShowRubric(true);
                JComponent jComponent = (JComponent)super.getListCellRendererComponent(jList, string, n, bl, bl2);
                return InputUtil.getCellRenderer(InputValue.this.showListModel, jComponent, rubric, string, InputValue.this.searchField.getText(), User.instance().getValueSearchThread().getSearchResult(), bl);
            }
        });
        this.showListPane.getViewport().add(this.showList);
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)this.showListPane, "Center");
    }

    private void initProgram() {
        this.actRepAction();
    }

    private void addAllListener() {
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                InputValue.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.addKeyListener(keyListener);
        this.getContentPane().addKeyListener(keyListener);
        this.mediChoice.addKeyListener(keyListener);
        this.valueChoice.addKeyListener(keyListener);
        this.showList.addKeyListener(keyListener);
        this.repChoice.addKeyListener(keyListener);
        this.showList.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (InputValue.this.showList.getModel().getSize() == 0) {
                    InputValue.this.mediChoice.requestFocus();
                }
                RepMainFrame.getRepInstance().setMenuEnables(null);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.showList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseClicked: " + mouseEvent.paramString());
                if (mouseEvent.getClickCount() >= 2) {
                    InputValue.this.selectForCaseResult();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mousePressed: " + mouseEvent.paramString());
                if (InputValue.this.showList.getSelectedIndex() >= 0) {
                    if (mouseEvent.isPopupTrigger()) {
                        InputValue.this.showListPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                } else {
                    int n = InputValue.this.showList.locationToIndex(mouseEvent.getPoint());
                    InputValue.this.showList.setSelectedIndex(n);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseReleased: " + mouseEvent.paramString());
                if (InputValue.this.showList.getSelectedIndex() >= 0 && mouseEvent.isPopupTrigger()) {
                    InputValue.this.showListPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.showList.addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.selectionChanged();
            }
        });
        this.repChoice.addItemListener(this::chooseRepAction);
        this.showListPane.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                InputValue.this.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.showListPane.getVerticalScrollBar().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                InputValue.this.mediChoice.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.showListPane.getHorizontalScrollBar().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                InputValue.this.mediChoice.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }

    private void actRepAction() {
        try {
            boolean bl = false;
            int n = this.actRepIndex;
            do {
                if (bl = this.getRep()) continue;
                ++this.actRepIndex;
                if (this.actRepIndex < 62) continue;
                this.actRepIndex = 1;
            } while (!bl && n != this.actRepIndex);
            if (this.repTitle != null) {
                this.repChoice.setSelectedItem(this.repTitle[this.actRepIndex]);
                this.repaint();
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "actRepAction", exception);
        }
    }

    private void chooseRepAction(ItemEvent itemEvent) {
        try {
            if (this.repTitle != null && itemEvent.getStateChange() == 1) {
                for (int i = 1; i < 62; ++i) {
                    if (!itemEvent.getItem().equals(this.repTitle[i]) || i == this.actRepIndex) continue;
                    this.actRepIndex = i;
                    this.getRep();
                }
                RepMainFrame.getRepInstance().setMainRubric(null);
                this.checkNewSearch();
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "chooseRepAction", exception);
        }
    }

    protected void chooseRepAction(int n) {
        try {
            this.actRepIndex = n;
            this.actRepAction();
            this.checkNewSearch();
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "chooseRepAction", exception);
        }
    }

    boolean getRep() {
        try {
            if (this.repTitle[this.actRepIndex] == null || this.repTitle[this.actRepIndex].length() == 0) {
                return false;
            }
            RepMainFrame.getRepInstance().changeRepAction(this.actRepIndex);
            SearchThread searchThread = User.instance().getNewValueSearchThread(this.actRepIndex);
            if (searchThread.getRepHeader()) {
                this.columnTitle = RepDataPool.getInstance().getRepHeader(this.actRepIndex).getRepMedisSorted();
                String string = null;
                int n = -1;
                if (this.actMedi.length() > 0) {
                    string = this.actMedi;
                }
                this.mediChoice.removeAllItems();
                this.mediChoice.addItem("");
                for (int i = 1; i < this.columnTitle.length; ++i) {
                    this.mediChoice.addItem(this.columnTitle[i]);
                    if (string == null || !string.equalsIgnoreCase(this.columnTitle[i])) continue;
                    n = i;
                }
                this.statusField.setText(this.columnTitle.length - 1 + " " + StringResource.getString("rubric_medix"));
                if (n >= 0) {
                    this.mediChoice.setSelectedIndex(n);
                }
                Rep.getExecutor().execute(() -> User.instance().getValueSearchThread().getRepFile());
                return true;
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "getRep", exception);
        }
        return false;
    }

    private void chooseMediAction(ItemEvent itemEvent) {
        String string;
        if (itemEvent.getStateChange() == 1 && !(string = (String)itemEvent.getItem()).equals(this.actMedi)) {
            this.actMedi = string;
            this.checkNewSearch();
            String[] stringArray = RubricUtil.getMedNameForRubric(this.actMedi);
            if (stringArray != null && stringArray.length > 1) {
                this.setTitleText(stringArray[0] + " - " + stringArray[1]);
            } else {
                this.setTitleText(null);
            }
        }
    }

    private void chooseValueAction(ItemEvent itemEvent) {
        String string;
        if (itemEvent.getStateChange() == 1 && !(string = (String)itemEvent.getItem()).equals(this.actValue)) {
            this.actValue = (String)itemEvent.getItem();
            this.checkNewSearch();
            int n = this.valueChoice.getSelectedIndex();
            User.instance().setProperty("initSearchValue", n);
        }
    }

    void copyToClipboard() {
        try {
            int n;
            List<Rubric> list;
            StringBuilder stringBuilder = new StringBuilder("");
            int n2 = 100;
            if (User.instance().isSuperUser()) {
                n2 = 999999;
            }
            if ((list = this.getSelectedRubrics()) != null && list.size() > 1) {
                for (n = 0; n < list.size() && n < n2; ++n) {
                    stringBuilder.append(list.get(n).getShowRubric(false)).append("\n");
                }
            } else {
                for (n = 0; n < this.showList.getModel().getSize() && n < n2; ++n) {
                    stringBuilder.append(this.showList.getModel().getElementAt(n).getShowRubric(true)).append("\n");
                }
            }
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            this.getToolkit().getSystemClipboard().setContents(stringSelection, null);
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "copyToClipboard", exception);
        }
    }

    @Override
    public void requestFocus() {
        if (this.mediChoice != null && this.showList != null) {
            if (this.showList.hasFocus()) {
                return;
            }
            if (this.showList.getModel() != null && this.showList.getModel().getSize() > 0) {
                Log.write(5, this.getClass().getName(), "showList.requestFocus");
                this.showList.requestFocusInWindow();
            } else {
                Log.write(5, this.getClass().getName(), "mediChoice.requestFocus");
                this.mediChoice.requestFocusInWindow();
            }
        } else {
            super.requestFocus();
            Log.write(5, this.getClass().getName(), "super.requestFocus");
        }
    }

    private void checkNewSearch() {
        SwingUtilities.invokeLater(() -> {
            if (this.actMedi.length() == 0 || this.actValue.length() == 0) {
                this.statusField.setText(this.columnTitle.length - 1 + " " + StringResource.getString("rubric_medix"));
                return;
            }
            this.searchByValueNow();
        });
    }

    protected void searchAgain() {
        this.searchMedi = "";
        this.doSelect = false;
        this.getRep();
    }

    private void mainKeyPressed(KeyEvent keyEvent) {
        try {
            char c;
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
                c = keyEvent.getKeyChar();
                if (c == '\n') {
                    keyEvent.consume();
                    if (this.getShowListCount() >= 250000) {
                        this.showAction();
                    } else if (this.getShowListCount() > 0 && !this.showList.hasFocus()) {
                        this.showList.requestFocus();
                        this.showList.setSelectedIndex(0);
                    } else {
                        this.selectForCaseResult();
                    }
                } else if (c == '\u001b') {
                    keyEvent.consume();
                    if (this.searchField.getText().length() > 0) {
                        this.searchField.setText("");
                    } else {
                        this.closeAction();
                    }
                } else if (c == '-') {
                    this.selectForCaseResult(true);
                } else if (this.fxKeyEvent(keyEvent)) {
                    keyEvent.consume();
                } else if (c == '\uffff' || c == '\u0000') {
                    int n = keyEvent.getKeyCode();
                    if (n == 40 || n == 225) {
                        if (this.getShowListCount() > 0 && this.searchField.hasFocus()) {
                            keyEvent.consume();
                            this.showList.requestFocus();
                            this.showList.setSelectedIndex(0);
                        }
                    } else if ((n == 38 || n == 224) && this.showList.hasFocus() && this.showList.getSelectedIndex() == 0) {
                        keyEvent.consume();
                        this.searchField.requestFocus();
                    }
                }
            }
            if ((c = RepMainMenu.mainMenuGetCtrlChar(keyEvent)) > '\u0000') {
                if (c == 'C') {
                    keyEvent.consume();
                    this.copyToClipboard();
                } else {
                    RepMainMenu.mainMenuActionDone(keyEvent, c);
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "keyEvents", exception);
        }
    }

    private boolean fxKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 112) {
            RepMainFrame.getRepInstance().helpContextAction("WertEingabe");
            return true;
        }
        if (keyEvent.getKeyCode() == 113) {
            int n = RepUtil.getRepIndex("F2");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 114) {
            int n = RepUtil.getRepIndex("F3");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 115) {
            int n = RepUtil.getRepIndex("F4");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 116) {
            int n = RepUtil.getRepIndex("F5");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 117) {
            int n = RepUtil.getRepIndex("F6");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 118) {
            int n = RepUtil.getRepIndex("F7");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 119) {
            int n = RepUtil.getRepIndex("F8");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 120) {
            int n = RepUtil.getRepIndex("F9");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 121) {
            int n = RepUtil.getRepIndex("F10");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 122) {
            int n = RepUtil.getRepIndex("F11");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 123) {
            int n = RepUtil.getRepIndex("F12");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        return false;
    }

    protected int getShowListCount() {
        return this.showListModel.getSize();
    }

    protected Rubric getSelectedRubric() {
        int n;
        if (this.getShowListCount() > 0 && (n = this.showList.getSelectedIndex()) >= 0) {
            return this.showListModel.getByRubricIndex(n);
        }
        return null;
    }

    private List<Rubric> getSelectedRubrics() {
        int[] nArray;
        if (this.getShowListCount() > 0 && (nArray = this.showList.getSelectedIndices()) != null && nArray.length > 0) {
            ArrayList<Rubric> arrayList = new ArrayList<Rubric>();
            for (int n : nArray) {
                Rubric rubric = this.showListModel.getByRubricIndex(n);
                arrayList.add(rubric);
            }
            return arrayList;
        }
        return null;
    }

    protected void showAction() {
        if (this.showCount > 0) {
            this.statusField.setText(StringResource.getString("countField_show") + this.showListModel.getSize());
            this.showList.requestFocus();
            if (this.showList.getSelectedIndex() < 0) {
                this.showList.setSelectedIndex(0);
            }
        } else {
            this.mediChoice.requestFocus();
        }
    }

    protected void selectForCaseResult() {
        this.selectForCaseResult(false);
    }

    protected void selectForCaseResult(boolean bl) {
        try {
            List<Rubric> list;
            Rubric rubric = this.getSelectedRubric();
            if (rubric != null && (list = this.getSelectedRubrics()) != null) {
                for (Rubric rubric2 : list) {
                    RepMainFrame.getRepInstance().selectRubricAction(rubric2, bl);
                }
            }
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "not in CaseResult", exception);
        }
    }

    protected void setTitleText(String string) {
        if (string != null && string.length() > 0) {
            this.setTitle("jRep  " + string);
        } else {
            this.setTitle("jRep  " + StringResource.getString("menu_med_x"));
        }
    }

    private void selectionChanged() {
        try {
            int n = this.showList.getSelectedIndex();
            Rubric rubric = null;
            if (n != this.lastSelected) {
                this.popChangeRubricMenuItem.setEnabled(false);
                this.popDeleteRubricMenuItem.setEnabled(false);
                this.lastSelected = n;
                if (n >= 0 && (rubric = this.showListModel.getByRubricIndex(n)) != null) {
                    if (GetDataFile.getDataPath() != null) {
                        this.popChangeRubricMenuItem.setEnabled(true);
                        if (RepDataPool.getInstance().getRepFile(this.actRepIndex).isEditExtern()) {
                            this.popDeleteRubricMenuItem.setEnabled(rubric.isChanged());
                        } else {
                            this.popDeleteRubricMenuItem.setEnabled(true);
                        }
                    }
                    RepMainFrame.getRepInstance().showSelectedRubric(rubric);
                }
                RepMainFrame.getRepInstance().setMenuEnables(rubric);
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "selectionChanged", exception);
        }
    }

    private void searchByValueNow() {
        while (this.searching) {
            try {
                Thread.sleep(31L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.actMedi.equals(this.searchMedi) && this.actValue.equals(this.searchValue) && this.searchRepIndex == this.actRepIndex) {
            return;
        }
        this.searchMedi = this.actMedi;
        this.searchValue = this.actValue;
        this.searchRepIndex = this.actRepIndex;
        this.searching = true;
        Log.write(5, this.getClass().getName(), "searchNow with RepIndex = " + this.searchRepIndex);
        RepMainFrame.getRepInstance().setMenuEnables(null);
        ScheduledFuture<?> scheduledFuture = Rep.getScheduledExecutor().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                int n = User.instance().getInputSearchThread().getRunCount();
                SwingUtilities.invokeLater(() -> {
                    if (n > 0) {
                        String string = User.instance().getValueSearchThread().getRunText();
                        InputValue.this.statusField.setText(n + " " + string);
                    } else {
                        InputValue.this.statusField.setText("-");
                    }
                });
            }
        }, 53L, 53L, TimeUnit.MILLISECONDS);
        Rep.getExecutor().execute(() -> {
            String[] stringArray = RepDataPool.getInstance().getRepHeader(this.actRepIndex).getRepMedis();
            boolean bl = User.instance().getValueSearchThread().loadWithValue(this.searchMedi, this.searchValue.charAt(0), this.searchField.getText(), stringArray);
            scheduledFuture.cancel(true);
            this.searching = false;
            if (bl) {
                SwingUtilities.invokeLater(() -> this.getAndShowSearchResult());
            }
        });
    }

    private void getAndShowSearchResult() {
        int n = User.instance().getValueSearchThread().getRunCount();
        if (n > 0) {
            Object object = User.instance().getValueSearchThread().getRunText();
            object = n + " " + (String)object;
            if (User.instance().getValueSearchThread().getSearchResult().isPartial()) {
                object = "250000 / " + (String)object;
            }
            this.statusField.setText((String)object);
            if (!this.searchField.isEnabled()) {
                this.searchField.setText("");
                this.searchField.setEnabled(true);
            }
        } else {
            this.statusField.setText("-");
        }
        this.showListModel = new InputListModel(User.instance().getValueSearchThread().getSearchResult());
        if (this.showList.getModel() != this.showListModel) {
            this.showList.setModel(this.showListModel);
            if (this.doSelect && this.showList.getModel().getSize() > 0) {
                this.doSelect = false;
                this.showList.requestFocus();
                this.showList.setSelectedIndex(0);
            }
        }
    }

    private void searchFieldTextValueChanged(DocumentEvent documentEvent) {
        try {
            this.searchNow(this.searchField.getText());
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "searchFieldTextValueChanged", exception);
        }
    }

    public void combineAll(RubricUtil.CombineType combineType) {
        Rep.getExecutor().execute(() -> {
            List<Rubric> list = this.getSelectedRubrics();
            if (list.size() <= 1) {
                list = this.showListModel.getAllRubrics();
            }
            CaseUiImpl caseUiImpl = new CaseUiImpl(list, this.searchField.getText());
            caseUiImpl.finishResults(combineType);
            RepMainFrame.getRepInstance().addCombinedLine(caseUiImpl.getResultRubric());
        });
    }

    @Override
    public void activatedAction() {
        RepMainFrame.getRepInstance().changeRepAction(this.actRepIndex);
        super.activatedAction();
    }

    private void searchNow(String string) {
        Log.write(5, this.getClass().getName(), "search now: '" + string + "'");
        if (string == null) {
            Log.write(2, this.getClass().getName(), "newSearchString null");
            return;
        }
        SearchThread searchThread = User.instance().getValueSearchThread();
        if (searchThread == null) {
            Log.write(3, this.getClass().getName(), "searchThread null");
            return;
        }
        if (this.searching) {
            try {
                Thread.sleep(39L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.searching = true;
        if (this.oldOrButton != this.searchOr || !this.oldSearchString.equals(string)) {
            this.oldSearchString = string;
            this.oldOrButton = this.searchOr;
            ScheduledFuture<?> scheduledFuture = Rep.getScheduledExecutor().scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    int n = User.instance().getValueSearchThread().getRunCount();
                    if (n >= 0) {
                        SwingUtilities.invokeLater(() -> {
                            String string = User.instance().getInputSearchThread().getRunText();
                            InputValue.this.statusField.setText(n + " " + string);
                        });
                    }
                }
            }, 57L, 57L, TimeUnit.MILLISECONDS);
            Rep.getExecutor().execute(() -> {
                boolean bl = User.instance().getValueSearchThread().searchWithString(string);
                this.searching = false;
                scheduledFuture.cancel(true);
                if (bl) {
                    SwingUtilities.invokeLater(() -> this.getAndShowSearchResult());
                }
            });
        }
    }
}

