/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.MdiNormalFrame;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.PanelKeyListener;
import ch.steph.rep.Rep;
import ch.steph.repdata.RepDataPool;
import ch.steph.repdata.Rubric;
import ch.steph.repmodel.MediCompareTableModel;
import ch.steph.repui.RepMainFrame;
import ch.steph.repui.RepMainMenu;
import ch.steph.reputil.RepUtil;
import ch.steph.reputil.RubricUtil;
import ch.steph.util.GetDataFile;
import ch.steph.util.IconUtil;
import ch.steph.util.Log;
import ch.steph.util.MenuHint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class MediCompare
extends MdiNormalFrame
implements PanelKeyListener {
    private static final long serialVersionUID = 1L;
    private JMenuItem popChangeRubricMenuItem;
    private JMenuItem popDeleteRubricMenuItem;
    private boolean rubricSet = false;
    private JPopupMenu showListPopupMenu;
    private JComboBox<String> mediChoice1;
    private JComboBox<String> mediChoice2;
    private JComboBox<String> valueChoice;
    private JComboBox<String> repChoice;
    private JLabel statusField;
    private JScrollPane jScrollPane;
    private MediCompareTableModel tableModel;
    protected JTable table;
    private String[] repTitle;
    private String[] columnTitle;
    private int lastSelected = -1;
    private int actRepIndex;
    private String actMedi1 = "";
    private String actMedi2 = "";

    public MediCompare(int n) {
        super(true, "", 4, "comp");
        this.setFrameIcon(IconUtil.getImageIcon(this, "icon/jRepSmall.gif"));
        this.actRepIndex = n;
        this.columnTitle = RepDataPool.getInstance().getRepHeader(n).getRepMedisSorted();
        this.initFrame();
        this.initProgram();
        this.addAllListener();
        this.requestFocus();
        User.instance().setProperty("cMedCompare", User.instance().getProperty("cMedCompare", 0) + 1);
        Log.write(4, this.getClass().getName(), "jRep run");
    }

    private void initFrame() {
        this.setTitle(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.showListPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(StringResource.getString("menu_search_select"));
        jMenuItem.addActionListener(actionEvent -> this.selectForCaseResult());
        MenuHint.set(MenuHint.SHORTCUT.Enter, jMenuItem);
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_search_sel_0"));
        jMenuItem.addActionListener(actionEvent -> this.selectForCaseResult(true));
        MenuHint.set('-', jMenuItem);
        this.showListPopupMenu.add(jMenuItem);
        this.showListPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_rubric_show"));
        jMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().rubricAction());
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_search_export"));
        jMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().exportRubricAction());
        this.showListPopupMenu.add(jMenuItem);
        this.showListPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("menu_list_copy"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        jMenuItem.addActionListener(actionEvent -> this.copyToClipboard());
        this.showListPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("menu_list_doubles_copy"));
        jMenuItem.addActionListener(actionEvent -> this.copyDoublesToClipboard());
        this.showListPopupMenu.add(jMenuItem);
        this.showListPopupMenu.addSeparator();
        this.popChangeRubricMenuItem = new JMenuItem(StringResource.getString("rep_change"));
        this.popChangeRubricMenuItem.setAccelerator(KeyStroke.getKeyStroke(75, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        this.popChangeRubricMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().changeActRubric());
        this.popChangeRubricMenuItem.setEnabled(false);
        this.showListPopupMenu.add(this.popChangeRubricMenuItem);
        this.popDeleteRubricMenuItem = new JMenuItem(StringResource.getString("rep_delete"));
        this.popDeleteRubricMenuItem.addActionListener(actionEvent -> RepMainFrame.getRepInstance().deleteRubric());
        this.popDeleteRubricMenuItem.setEnabled(false);
        this.showListPopupMenu.add(this.popDeleteRubricMenuItem);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (this.columnTitle != null) {
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(0, 0, 0));
            this.mediChoice1 = new JComboBox();
            this.mediChoice1.addItem("");
            this.mediChoice1.setMaximumRowCount(User.instance().getProperty("DropdownRows", 20));
            this.mediChoice1.addItemListener(this::chooseMedi1Action);
            jPanel2.add(this.mediChoice1, "West");
            this.mediChoice2 = new JComboBox();
            this.mediChoice2.addItem("");
            this.mediChoice2.setMaximumRowCount(User.instance().getProperty("DropdownRows", 20));
            this.mediChoice2.addItemListener(this::chooseMedi2Action);
            jPanel2.add(this.mediChoice2, "East");
            String string = null;
            String string2 = null;
            int n = -1;
            int n2 = -1;
            if (User.instance().getCaseResult() != null) {
                string = this.actMedi1 = User.instance().getCaseResult().getValueAt(0, 1);
                string2 = this.actMedi2 = User.instance().getCaseResult().getValueAt(0, 2);
            }
            for (int i = 1; i < this.columnTitle.length; ++i) {
                this.mediChoice1.addItem(this.columnTitle[i]);
                this.mediChoice2.addItem(this.columnTitle[i]);
                if (string != null && string.equalsIgnoreCase(this.columnTitle[i])) {
                    n = i;
                }
                if (string2 == null || !string2.equalsIgnoreCase(this.columnTitle[i])) continue;
                n2 = i;
            }
            if (n >= 0) {
                this.mediChoice1.setSelectedIndex(n);
            }
            if (n2 >= 0) {
                this.mediChoice2.setSelectedIndex(n2);
            }
            JLabel jLabel = new JLabel(" " + StringResource.getString("medicomp_from") + " ", 0);
            jPanel2.add((Component)jLabel, "Center");
            this.valueChoice = new JComboBox();
            this.valueChoice.addItem("1");
            this.valueChoice.addItem("2");
            this.valueChoice.addItem("3");
            this.valueChoice.addItem("4");
            this.valueChoice.addItem("5");
            this.valueChoice.addItem("6");
            this.valueChoice.addItem("7");
            this.valueChoice.addItem("8");
            this.valueChoice.addItem("9");
            this.valueChoice.setMaximumRowCount(User.instance().getProperty("DropdownRows", 20));
            this.valueChoice.setSelectedIndex(User.instance().getProperty("initSearchValue", 2));
            this.valueChoice.addItemListener(this::chooseValueAction);
            jPanel2.add(this.valueChoice, "East");
            jPanel.add((Component)jPanel2, "West");
            this.statusField = new JLabel("", 0);
            jPanel.add((Component)this.statusField, "Center");
            this.repTitle = User.instance().getRepTitles(true);
            Vector<String> vector = new Vector<String>();
            if (this.repTitle != null) {
                for (int i = 1; i < 62; ++i) {
                    if (this.repTitle[i].length() <= 0) continue;
                    vector.add(this.repTitle[i]);
                }
            }
            this.repChoice = new JComboBox(vector);
            this.repChoice.setEditable(false);
            this.repChoice.setMaximumRowCount(User.instance().getProperty("DropdownRows", 20));
            jPanel.add(this.repChoice, "East");
        }
        this.getContentPane().add((Component)jPanel, "North");
        this.jScrollPane = new JScrollPane();
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        try {
            this.jScrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "UI-Manager problem");
        }
        this.tableModel = new MediCompareTableModel(this.actRepIndex);
        this.table = new JTable(this.tableModel);
        this.table.setAutoResizeMode(3);
        this.table.setRowHeight(this.table.getFont().getSize() + (this.table.getRowMargin() + 1) * 2);
        this.table.getTableHeader().setMinimumSize(new Dimension(0, 0));
        this.table.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.table.getTableHeader().setMaximumSize(new Dimension(0, 0));
        int n = 2 + 5 * this.getFontMetrics(this.table.getFont()).stringWidth("0");
        this.table.getColumnModel().getColumn(0).setMinWidth(n);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(n);
        this.table.getColumnModel().getColumn(0).setMaxWidth(n);
        this.table.getColumnModel().getColumn(1).setMinWidth(n);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(n);
        this.table.getColumnModel().getColumn(1).setMaxWidth(n);
        this.jScrollPane.setViewportView(this.table);
    }

    private void initProgram() {
        this.actRepAction();
    }

    private void addAllListener() {
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                MediCompare.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.addKeyListener(keyListener);
        this.getContentPane().addKeyListener(keyListener);
        this.mediChoice1.addKeyListener(keyListener);
        this.mediChoice2.addKeyListener(keyListener);
        this.valueChoice.addKeyListener(keyListener);
        this.repChoice.addKeyListener(keyListener);
        this.jScrollPane.addKeyListener(keyListener);
        this.table.addKeyListener(keyListener);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseClicked: " + mouseEvent.paramString());
                if (mouseEvent.getClickCount() >= 2) {
                    MediCompare.this.selectForCaseResult();
                }
                MediCompare.this.selectionChanged();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mousePressed: " + mouseEvent.paramString());
                if (mouseEvent.isPopupTrigger()) {
                    MediCompare.this.showListPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
                MediCompare.this.selectionChanged();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseReleased: " + mouseEvent.paramString());
                if (mouseEvent.isPopupTrigger()) {
                    MediCompare.this.showListPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
                MediCompare.this.selectionChanged();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.repChoice.addItemListener(this::chooseRepAction);
    }

    private void actRepAction() {
        try {
            boolean bl;
            int n = this.actRepIndex;
            do {
                if (bl = this.getRep()) continue;
                ++this.actRepIndex;
                if (this.actRepIndex < 62) continue;
                this.actRepIndex = 1;
            } while (!bl && n != this.actRepIndex);
            if (this.repTitle != null) {
                this.repChoice.setSelectedItem(this.repTitle[this.actRepIndex]);
                this.repaint();
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "actRepAction", exception);
        }
    }

    private void chooseRepAction(ItemEvent itemEvent) {
        try {
            if (this.repTitle != null && itemEvent.getStateChange() == 1) {
                for (int i = 1; i < 62; ++i) {
                    if (!itemEvent.getItem().equals(this.repTitle[i]) || i == this.actRepIndex) continue;
                    this.actRepIndex = i;
                    this.getRep();
                }
                RepMainFrame.getRepInstance().setMainRubric(null);
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "chooseRepAction", exception);
        }
    }

    protected void chooseRepAction(int n) {
        try {
            this.actRepIndex = n;
            this.actRepAction();
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "chooseRepAction", exception);
        }
    }

    boolean getRep() {
        try {
            if (this.repTitle[this.actRepIndex] == null || this.repTitle[this.actRepIndex].length() == 0) {
                return false;
            }
            this.tableModel.setNewRep(this.actRepIndex);
            this.tableModel.getSearch();
            this.columnTitle = RepDataPool.getInstance().getRepHeader(this.actRepIndex).getRepMedisSorted();
            RepMainFrame.getRepInstance().changeRepAction(this.actRepIndex);
            String string = null;
            String string2 = null;
            int n = -1;
            int n2 = -1;
            if (this.actMedi1.length() > 0) {
                string = this.actMedi1.toLowerCase();
            }
            if (this.actMedi2.length() > 0) {
                string2 = this.actMedi2.toLowerCase();
            }
            this.mediChoice1.removeAllItems();
            this.mediChoice2.removeAllItems();
            this.mediChoice1.addItem("");
            this.mediChoice2.addItem("");
            for (int i = 1; i < this.columnTitle.length; ++i) {
                this.mediChoice1.addItem(this.columnTitle[i]);
                this.mediChoice2.addItem(this.columnTitle[i]);
                if (string != null && string.equals(this.columnTitle[i].toLowerCase())) {
                    n = i;
                }
                if (string2 == null || !string2.equals(this.columnTitle[i].toLowerCase())) continue;
                n2 = i;
            }
            if (n >= 0) {
                this.mediChoice1.setSelectedIndex(n);
            }
            if (n2 >= 0) {
                this.mediChoice2.setSelectedIndex(n2);
            }
            if (this.tableModel != null && this.valueChoice != null) {
                this.tableModel.setWert((String)this.valueChoice.getSelectedItem());
            }
            return true;
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "getRep", exception);
            return false;
        }
    }

    @Override
    public void copyToClipboard() {
        try {
            StringBuilder stringBuilder = new StringBuilder("");
            int n = 100;
            if (User.instance().isSuperUser()) {
                n = 999999;
            }
            for (int i = 0; i < this.tableModel.getRowCount() && i < n; ++i) {
                for (int j = 0; j < this.tableModel.getColumnCount(); ++j) {
                    String string = (String)this.tableModel.getValueAt(i, j);
                    if (string == null || string.length() == 0) {
                        stringBuilder.append(" ");
                    } else {
                        stringBuilder.append(string.trim());
                    }
                    if (j >= this.tableModel.getColumnCount() - 1) continue;
                    stringBuilder.append(";");
                }
                stringBuilder.append("\n");
            }
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            this.getToolkit().getSystemClipboard().setContents(stringSelection, null);
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "copyToClipboard", exception);
        }
    }

    void copyDoublesToClipboard() {
        try {
            StringBuilder stringBuilder = new StringBuilder("");
            int n = 100;
            if (User.instance().isSuperUser()) {
                n = 999999;
            }
            for (int i = 0; i < this.tableModel.getRowCount() && i < n; ++i) {
                if (this.tableModel.getValueAt(i, 0) == null || ((String)this.tableModel.getValueAt(i, 0)).length() <= 0 || this.tableModel.getValueAt(i, 1) == null || ((String)this.tableModel.getValueAt(i, 1)).length() <= 0) continue;
                for (int j = 0; j < this.tableModel.getColumnCount(); ++j) {
                    String string = (String)this.tableModel.getValueAt(i, j);
                    if (string == null || string.length() == 0) {
                        stringBuilder.append(" ");
                    } else {
                        stringBuilder.append(string.trim());
                    }
                    if (j >= this.tableModel.getColumnCount() - 1) continue;
                    stringBuilder.append(";");
                }
                stringBuilder.append("\n");
            }
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            this.getToolkit().getSystemClipboard().setContents(stringSelection, null);
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "copyDoublesToClipboard", exception);
        }
    }

    @Override
    public void requestFocus() {
        Log.write(5, this.getClass().getName(), "requestFocus ");
        if (this.mediChoice1 != null) {
            this.mediChoice1.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void setTitleText(String string) {
        if (string == null || string.length() == 0) {
            super.setTitle("jRep  " + StringResource.getString("menu_file_comp_medi"));
        } else {
            super.setTitle("jRep  " + string);
        }
    }

    protected void searchAgain() {
        this.tableModel.resetMedis();
        this.tableModel.setMedi1(this.actMedi1);
        this.tableModel.setMedi2(this.actMedi2);
        if (this.tableModel != null && this.valueChoice != null) {
            this.tableModel.setWert((String)this.valueChoice.getSelectedItem());
        }
        this.searchNow();
    }

    @Override
    public void mainKeyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mainKeyPressed(KeyEvent keyEvent) {
        try {
            char c;
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
                c = Character.toUpperCase(keyEvent.getKeyChar());
                if (c == '\u001b') {
                    keyEvent.consume();
                    this.closeAction();
                } else if (c == '\n') {
                    keyEvent.consume();
                    if (this.getShowListCount() > 0 && !this.table.hasFocus()) {
                        this.table.requestFocus();
                        this.table.setRowSelectionInterval(0, 0);
                    } else {
                        this.selectForCaseResult();
                    }
                } else if (this.fxKeyEvent(keyEvent)) {
                    keyEvent.consume();
                }
            }
            if ((c = RepMainMenu.mainMenuGetCtrlChar(keyEvent)) > '\u0000') {
                if (c == 'C') {
                    keyEvent.consume();
                    this.copyToClipboard();
                } else {
                    RepMainMenu.mainMenuActionDone(keyEvent, c);
                }
            }
            this.selectionChanged();
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey", exception);
        }
    }

    private boolean fxKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 112) {
            RepMainFrame.getRepInstance().helpContextAction("WertEingabe");
            return true;
        }
        if (keyEvent.getKeyCode() == 113) {
            int n = RepUtil.getRepIndex("F2");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 114) {
            int n = RepUtil.getRepIndex("F3");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 115) {
            int n = RepUtil.getRepIndex("F4");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 116) {
            int n = RepUtil.getRepIndex("F5");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 117) {
            int n = RepUtil.getRepIndex("F6");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 118) {
            int n = RepUtil.getRepIndex("F7");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 119) {
            int n = RepUtil.getRepIndex("F8");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 120) {
            int n = RepUtil.getRepIndex("F9");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 121) {
            int n = RepUtil.getRepIndex("F10");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 122) {
            int n = RepUtil.getRepIndex("F11");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        if (keyEvent.getKeyCode() == 123) {
            int n = RepUtil.getRepIndex("F12");
            if (this.repTitle[n].length() > 0) {
                this.chooseRepAction(n);
            }
            return true;
        }
        return false;
    }

    protected void chooseMedi1Action(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            String string = (String)itemEvent.getItem();
            if (this.tableModel != null) {
                this.tableModel.setMedi1(string);
            }
            this.actMedi1 = string;
            String[] stringArray = RubricUtil.getMedNameForRubric(string);
            if (stringArray != null && stringArray.length > 1) {
                this.setTitleText(stringArray[0] + " - " + stringArray[1]);
            } else {
                this.setTitleText(null);
            }
            if (this.tableModel != null && this.valueChoice != null) {
                this.tableModel.setWert((String)this.valueChoice.getSelectedItem());
            }
            this.searchNow();
        }
    }

    protected void chooseMedi2Action(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            String string = (String)itemEvent.getItem();
            if (this.tableModel != null) {
                this.tableModel.setMedi2(string);
            }
            this.actMedi2 = string;
            String[] stringArray = RubricUtil.getMedNameForRubric(string);
            if (stringArray != null && stringArray.length > 1) {
                this.setTitleText(stringArray[0] + " - " + stringArray[1]);
            } else {
                this.setTitleText(null);
            }
            if (this.tableModel != null && this.valueChoice != null) {
                this.tableModel.setWert((String)this.valueChoice.getSelectedItem());
            }
            this.searchNow();
        }
    }

    protected void chooseValueAction(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (this.tableModel != null) {
                this.tableModel.setWert((String)this.valueChoice.getSelectedItem());
            }
            User.instance().setProperty("initSearchValue", this.valueChoice.getSelectedIndex());
            this.searchNow();
        }
    }

    protected void selectForCaseResult() {
        this.selectForCaseResult(false);
    }

    private void selectForCaseResult(boolean bl) {
        List<Rubric> list;
        Rubric rubric = this.tableModel.getRubricAt(this.table.getSelectedRow());
        if (rubric != null && (list = this.getSelectedRubrics()) != null) {
            for (Rubric rubric2 : list) {
                RepMainFrame.getRepInstance().selectRubricAction(rubric2, bl);
            }
        }
    }

    protected int getShowListCount() {
        if (this.tableModel != null) {
            return this.tableModel.getRowCount();
        }
        return 0;
    }

    protected Rubric getSelectedRubric() {
        return this.tableModel.getRubricAt(this.table.getSelectedRow());
    }

    private List<Rubric> getSelectedRubrics() {
        int[] nArray;
        if (this.getShowListCount() > 0 && (nArray = this.table.getSelectedRows()) != null && nArray.length > 0) {
            ArrayList<Rubric> arrayList = new ArrayList<Rubric>();
            for (int n : nArray) {
                Rubric rubric = this.tableModel.getRubricAt(n);
                arrayList.add(rubric);
            }
            return arrayList;
        }
        return null;
    }

    private void selectionChanged() {
        SwingUtilities.invokeLater(() -> {
            int n = this.table.getSelectedRow();
            if (n != this.lastSelected) {
                this.popChangeRubricMenuItem.setEnabled(false);
                this.popDeleteRubricMenuItem.setEnabled(false);
                this.lastSelected = n;
                Rubric rubric = this.tableModel.getRubricAt(this.lastSelected);
                if (rubric != null) {
                    if (GetDataFile.getDataPath() != null) {
                        this.popChangeRubricMenuItem.setEnabled(true);
                        if (RepDataPool.getInstance().getRepFile(this.actRepIndex).isEditExtern()) {
                            this.popDeleteRubricMenuItem.setEnabled(rubric.isChanged());
                        } else {
                            this.popDeleteRubricMenuItem.setEnabled(true);
                        }
                    }
                    RepMainFrame.getRepInstance().showSelectedRubric(rubric);
                }
                this.rubricSet = true;
                RepMainFrame.getRepInstance().setMenuEnables(rubric);
            }
        });
    }

    private void searchNow() {
        RepMainFrame.getRepInstance().setMenuEnables(null);
        ScheduledFuture<?> scheduledFuture = Rep.getScheduledExecutor().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                MediCompare.this.statusField.setText(MediCompare.this.tableModel.getRunString());
            }
        }, 53L, 53L, TimeUnit.MILLISECONDS);
        Rep.getExecutor().execute(() -> {
            this.tableModel.searchNow();
            scheduledFuture.cancel(true);
            SwingUtilities.invokeLater(() -> this.statusField.setText(this.tableModel.getRunString()));
        });
    }

    @Override
    public void activatedAction() {
        RepMainFrame.getRepInstance().changeRepAction(this.actRepIndex);
        super.activatedAction();
    }

    @Override
    public void closedAction() {
        if (this.rubricSet) {
            RepMainFrame.getRepInstance().setMainRubric(null);
        }
        super.closedAction();
    }

    @Override
    public void historyChanged(Object object, int n) {
    }
}

