/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.MdiMainFrame;
import ch.steph.apputil.MdiNormalFrame;
import ch.steph.apputil.ScreenUtil;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.MultiTxtSetter;
import ch.steph.rep.PanelKeyListener;
import ch.steph.repui.MultiButton;
import ch.steph.repui.MultiShowPanel;
import ch.steph.repui.RepMainFrame;
import ch.steph.repui.RepMainMenu;
import ch.steph.reputil.MmUtil;
import ch.steph.util.IconUtil;
import ch.steph.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyVetoException;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class MultiFrame
extends MdiNormalFrame
implements PanelKeyListener,
MultiTxtSetter {
    private static final long serialVersionUID = 1L;
    private MultiShowPanel[] contentPanels;
    private String[] mmTitle;
    protected JComboBox<String> mmChoice = null;
    private static final int NO_MM = 62;
    private int actMm = 62;
    private int firstMM = 62;
    private int mmColumns;
    private String[] resMedi;
    private String[] resFilter;
    private int[] resHits;
    private int[] resSum;
    private int[] resPos;
    private int[] resDiff;
    private int resSize;
    private int textPos;
    private final Object synchronizeObject = new Object();

    public MultiFrame() {
        super(false, "jRep  " + StringResource.getString("mm"), 7, "multi");
        int n;
        this.setFrameIcon(IconUtil.getImageIcon(this, "icon/4.gif"));
        this.getContentPane().setLayout(new BorderLayout());
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                MultiFrame.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.getContentPane().addKeyListener(keyListener);
        this.addKeyListener(keyListener);
        this.mmColumns = ScreenUtil.hasOpenRubric() ? User.instance().getProperty("mmColumns", 2) : User.instance().getProperty("mmColumns", 1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, this.mmColumns));
        this.getContentPane().add((Component)jPanel, "Center");
        MultiButton multiButton = new MultiButton("-");
        this.getContentPane().add((Component)multiButton, "West");
        multiButton.addKeyListener(keyListener);
        multiButton.addActionListener(actionEvent -> this.leftAction());
        MultiButton multiButton2 = new MultiButton("+");
        this.getContentPane().add((Component)multiButton2, "East");
        multiButton2.addKeyListener(keyListener);
        multiButton2.addActionListener(actionEvent -> this.rightAction());
        this.mmTitle = User.instance().getMmTitles();
        if (this.mmTitle != null) {
            for (n = 0; n < this.mmTitle.length && this.firstMM >= 62; ++n) {
                if (this.mmTitle[n].length() <= 0) continue;
                this.firstMM = n;
            }
        }
        if (this.mmTitle != null) {
            this.mmChoice = new JComboBox();
            n = 0;
            for (String string : this.mmTitle) {
                if (string.length() <= 0) continue;
                ++n;
                this.mmChoice.addItem(string);
            }
            if (n > 0) {
                this.mmChoice.addItemListener(this::chooseMmAction);
            } else {
                this.mmChoice = null;
            }
            this.mmChoice.setMaximumRowCount(User.instance().getProperty("DropdownRows", 20));
        }
        this.contentPanels = new MultiShowPanel[this.mmColumns];
        for (n = 0; n < this.mmColumns; ++n) {
            this.contentPanels[n] = new MultiShowPanel(this);
            try {
                if (n == this.mmColumns - 1) {
                    this.contentPanels[n].initPanel(this, n != 0, this.mmChoice);
                } else {
                    this.contentPanels[n].initPanel(this, n != 0, null);
                }
            }
            catch (Exception exception) {
                Log.write(5, this.getClass().getName(), "Problem with content panel", exception);
            }
            jPanel.add(this.contentPanels[n]);
        }
        if (this.firstMM >= 62) {
            this.firstMM = 1;
        }
        n = this.firstMM;
        this.firstMM = User.instance().getProperty("actMM", this.firstMM);
        if (this.mmTitle == null || this.mmTitle.length <= this.firstMM || this.mmTitle[this.firstMM].length() == 0) {
            this.firstMM = n;
        }
        this.chooseMm(this.firstMM);
    }

    protected void chooseMmAction(ItemEvent itemEvent) {
        if (this.mmTitle != null && itemEvent.getStateChange() == 1) {
            for (int i = 1; i < 62; ++i) {
                if (!itemEvent.getItem().equals(this.mmTitle[i])) continue;
                this.chooseMm(i);
            }
        }
    }

    @Override
    public void requestFocus() {
        Log.write(5, this.getClass().getName(), "requestFocus ");
        if (this.contentPanels[0] != null) {
            this.contentPanels[0].requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public void activateWindows() {
        MdiMainFrame.getInstance().selectFrame(this);
        try {
            if (this.resMedi != null && User.instance().getProperty("MmOpenMaximized", true)) {
                this.setMaximum(true);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void focusToParent() {
        try {
            if (User.instance().getProperty("MmOpenMaximized", true)) {
                this.setMaximum(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        RepMainFrame.getRepInstance().checkAndGetFocus();
    }

    protected void setNormalFocus() {
        if (this.contentPanels != null && this.contentPanels[0] != null) {
            this.contentPanels[0].requestFocus();
        }
    }

    @Override
    public void mainKeyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mainKeyPressed(KeyEvent keyEvent) {
        try {
            char c;
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
                c = Character.toUpperCase(keyEvent.getKeyChar());
                switch (c) {
                    case '\u001b': {
                        keyEvent.consume();
                        this.focusToParent();
                        RepMainFrame.getRepInstance().newSearchAction();
                        break;
                    }
                    case ' ': {
                        keyEvent.consume();
                        this.contentPanels[0].doPgDown();
                        break;
                    }
                    case '\n': {
                        keyEvent.consume();
                        this.focusToParent();
                        break;
                    }
                    default: {
                        if (keyEvent.getKeyChar() == '+') {
                            keyEvent.consume();
                            this.rightAction();
                            break;
                        }
                        if (keyEvent.getKeyChar() == '-') {
                            keyEvent.consume();
                            this.leftAction();
                            break;
                        }
                        if (keyEvent.getKeyChar() == '>') {
                            keyEvent.consume();
                            this.endAction();
                            break;
                        }
                        if (keyEvent.getKeyChar() == '<') {
                            keyEvent.consume();
                            this.homeAction();
                            break;
                        }
                        if (keyEvent.getKeyCode() == 112) {
                            keyEvent.consume();
                            RepMainFrame.getRepInstance().helpContextAction("MM-Mehrere");
                            break;
                        }
                        int n = MmUtil.getMmIndex(c);
                        if (n < 1) break;
                        keyEvent.consume();
                        this.chooseMm(n);
                    }
                }
            }
            if ((c = RepMainMenu.mainMenuGetCtrlChar(keyEvent)) > '\u0000') {
                if (c == 'M') {
                    keyEvent.consume();
                    if (this.resMedi != null && User.instance().getProperty("MmOpenMaximized", true) && !this.isMaximum) {
                        this.setMaximum(true);
                    } else {
                        this.focusToParent();
                        RepMainFrame.getRepInstance().checkAndGetFocus();
                    }
                } else {
                    RepMainMenu.mainMenuActionDone(keyEvent, c);
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey", exception);
        }
    }

    protected void homeAction() {
        this.textPos = 1;
        this.leftAction();
    }

    protected void endAction() {
        this.textPos = this.resMedi.length - this.mmColumns - 2;
        this.rightAction();
    }

    protected void leftAction() {
        if (this.resMedi == null || this.resSize == 0) {
            return;
        }
        if (this.textPos <= 0) {
            return;
        }
        --this.textPos;
        for (int i = 0; i < this.mmColumns; ++i) {
            this.setTextPanel(i, i + this.textPos);
        }
        this.setNormalFocus();
    }

    protected void rightAction() {
        if (this.resMedi == null || this.resSize == 0) {
            return;
        }
        if (this.textPos >= this.resMedi.length - this.mmColumns - 1) {
            return;
        }
        ++this.textPos;
        for (int i = 0; i < this.mmColumns; ++i) {
            this.setTextPanel(i, i + this.textPos);
        }
        this.setNormalFocus();
    }

    protected void chooseMm(int n) {
        if (n < 62) {
            if (this.mmTitle == null) {
                n = this.actMm < 62 ? this.actMm : this.firstMM;
            } else if (this.mmTitle[n].length() == 0) {
                n = this.actMm < 62 ? (this.mmTitle[this.actMm].length() == 0 ? this.firstMM : this.actMm) : this.firstMM;
            }
            if (n != this.actMm) {
                this.actMm = n;
                if (this.mmChoice != null && this.mmTitle[this.actMm] != null && this.mmTitle[this.actMm].length() > 0) {
                    this.mmChoice.setSelectedItem(this.mmTitle[this.actMm]);
                }
                for (int i = 0; i < this.mmColumns; ++i) {
                    this.setTextPanel(i, i + this.textPos);
                }
                User.instance().setProperty("actMM", n);
            }
        }
        this.setNormalFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNewMedica(String[] stringArray, String[] stringArray2, int[] nArray, int[] nArray2, int n, int[] nArray3, int[] nArray4, int n2) {
        Object object = this.synchronizeObject;
        synchronized (object) {
            this.resMedi = stringArray;
            this.resFilter = stringArray2;
            this.resHits = nArray;
            this.resSum = nArray2;
            this.resSize = n;
            this.resPos = nArray3;
            this.resDiff = nArray4;
            this.textPos = n2 - 1;
            for (int i = 0; i < this.mmColumns; ++i) {
                this.setTextPanel(i, i + this.textPos);
            }
        }
    }

    private void setTextPanel(int n, int n2) {
        if (this.resMedi == null || n2 >= this.resMedi.length || this.resPos[n2] <= 0) {
            this.contentPanels[n].setNewMedica(this.actMm, null, null, 0, 0, 0, 0, 0);
        } else {
            this.contentPanels[n].setNewMedica(this.actMm, this.resMedi[n2], this.resFilter[n2], this.resPos[n2], this.resHits[n2], this.resSum[n2], this.resSize, this.resDiff[n2]);
        }
    }

    public int getActMm() {
        return this.actMm;
    }

    @Override
    public void closeWindows() {
        this.textPos = 0;
        for (int i = 0; i < this.mmColumns; ++i) {
            this.setTextPanel(i, i);
        }
        this.closeAction();
    }

    @Override
    public void historyChanged(Object object, int n) {
    }

    @Override
    public void copyToClipboard() {
        this.copyFrameToClipboard();
    }
}

