/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.PanelKeyListener;
import ch.steph.repui.MultiFrame;
import ch.steph.repui.RepMainMenu;
import ch.steph.reputil.MmUtil;
import ch.steph.util.FsetJEditorPane;
import ch.steph.util.GetDataFile;
import ch.steph.util.Log;
import ch.steph.util.MenuHint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Caret;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.icepdf.ri.common.ComponentKeyBinding;
import org.icepdf.ri.common.JRepSwingViewBuilder;
import org.icepdf.ri.common.MyAnnotationCallback;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.views.AnnotationCallback;

public class MultiShowPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private PanelKeyListener parent;
    protected JScrollPane scrollPane;
    private JViewport port;
    protected FsetJEditorPane htmlPanel;
    private String actMedicine;
    private String filter;
    private int pos;
    private int hits;
    private int sum;
    private int rubrics;
    private int diff;
    private boolean isSecond = false;
    private KeyListener mainKeyListener;
    protected String documentTitle;
    protected HTMLDocument actDocument;
    protected SwingController pdfController;
    private JPanel pdfComponentPanel;
    private MultiFrame menuParent;
    private JLabel statusLabel;
    private JPopupMenu popupMenu;
    private JMenu editMmMenu;
    private JMenuItem backMenu;
    private String[] extMmTitle;
    private ArrayList<Object> urlHistory = new ArrayList();
    private URL showedUrl;
    private int showMm;

    public MultiShowPanel(MultiFrame multiFrame) {
        super(new BorderLayout());
        Log.write(5, this.getClass().getName(), "start");
        this.menuParent = multiFrame;
        this.mainKeyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                MultiShowPanel.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.addKeyListener(this.mainKeyListener);
        this.popupMenu = new JPopupMenu();
        this.backMenu = new JMenuItem(StringResource.getString("back"));
        this.backMenu.addActionListener(actionEvent -> this.historyBackAction());
        this.backMenu.setEnabled(false);
        this.popupMenu.add(this.backMenu);
        JMenuItem jMenuItem = new JMenuItem(StringResource.getString("menu_result_copy"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        jMenuItem.addActionListener(actionEvent -> this.parent.copyToClipboard());
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        this.editMmMenu = new JMenu(StringResource.getString("menu_mm_edit"));
        for (String string : this.extMmTitle = MmUtil.getExtMMTitles()) {
            JMenuItem jMenuItem2 = new JMenuItem(string);
            jMenuItem2.addActionListener(this::editExtMM);
            this.editMmMenu.add(jMenuItem2);
            this.editMmMenu.setEnabled(false);
        }
        this.popupMenu.add(this.editMmMenu);
        this.popupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("pop_right"));
        jMenuItem.addActionListener(actionEvent -> this.rightAction());
        MenuHint.set('+', jMenuItem);
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("pop_left"));
        jMenuItem.addActionListener(actionEvent -> this.leftAction());
        MenuHint.set('-', jMenuItem);
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        jMenuItem = new JMenuItem(StringResource.getString("pop_end"));
        jMenuItem.addActionListener(actionEvent -> this.endAction());
        MenuHint.set('>', jMenuItem);
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("pop_home"));
        jMenuItem.addActionListener(actionEvent -> this.homeAction());
        MenuHint.set('<', jMenuItem);
        this.popupMenu.add(jMenuItem);
        this.makeNewPanel(true);
        this.makeNewPanelAfterLoading();
    }

    private void makeNewPanel(boolean bl) {
        if (this.parent != null) {
            this.parent.setTitle(null);
        }
        if (this.scrollPane != null) {
            this.remove(this.scrollPane);
        }
        if (this.pdfComponentPanel != null) {
            this.remove(this.pdfComponentPanel);
        }
        if (this.pdfController != null) {
            this.pdfController.closeDocument();
            this.pdfController.dispose();
        }
        this.scrollPane = null;
        this.port = null;
        this.htmlPanel = null;
        this.actDocument = null;
        this.pdfController = null;
        this.pdfComponentPanel = null;
        if (bl) {
            this.scrollPane = new JScrollPane();
            this.port = this.scrollPane.getViewport();
            this.port.addKeyListener(this.mainKeyListener);
            this.scrollPane.addKeyListener(this.mainKeyListener);
            this.htmlPanel = new FsetJEditorPane();
            this.port.add(this.htmlPanel);
            this.htmlPanel.setEditable(false);
            this.htmlPanel.setContentType("text/html");
            this.htmlPanel.addKeyListener(this.mainKeyListener);
            this.actDocument = (HTMLDocument)this.htmlPanel.getDocument();
            this.htmlPanel.addHyperlinkListener(hyperlinkEvent -> {
                block5: {
                    if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                        if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                            HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                            this.actDocument = (HTMLDocument)jEditorPane.getDocument();
                            this.actDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                        } else {
                            URL uRL = this.htmlPanel.getPage();
                            try {
                                this.htmlPanel.setFsetPage(hyperlinkEvent.getURL());
                                this.addResetUrlHistory(hyperlinkEvent.getURL(), false);
                            }
                            catch (Exception exception) {
                                if (uRL == null) break block5;
                                this.htmlPanel.setFsetPage(uRL);
                            }
                        }
                    }
                }
            });
            this.htmlPanel.addPropertyChangeListener("document", propertyChangeEvent -> {
                if (propertyChangeEvent.getNewValue() instanceof HTMLDocument) {
                    this.actDocument = (HTMLDocument)propertyChangeEvent.getNewValue();
                    this.actDocument.addDocumentListener(new DocumentListener(){

                        @Override
                        public void changedUpdate(DocumentEvent documentEvent) {
                        }

                        @Override
                        public void insertUpdate(DocumentEvent documentEvent) {
                            MultiShowPanel.this.actDocument = (HTMLDocument)documentEvent.getDocument();
                            MultiShowPanel.this.documentTitle = (String)MultiShowPanel.this.actDocument.getProperty("title");
                            SwingUtilities.invokeLater(() -> {
                                if (MultiShowPanel.this.documentTitle != null && MultiShowPanel.this.parent != null) {
                                    MultiShowPanel.this.parent.setTitle(MultiShowPanel.this.documentTitle);
                                }
                            });
                        }

                        @Override
                        public void removeUpdate(DocumentEvent documentEvent) {
                        }
                    });
                }
            });
            this.htmlPanel.addPropertyChangeListener("page", propertyChangeEvent -> {
                Caret caret = this.htmlPanel.getCaret();
                caret.setDot(1);
                caret.moveDot(1);
            });
            if (this.popupMenu != null) {
                this.htmlPanel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        Log.write(5, this.getClass().getName(), "mousePressed: " + mouseEvent.paramString());
                        if (mouseEvent.isPopupTrigger()) {
                            MultiShowPanel.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                        Log.write(5, this.getClass().getName(), "mouseReleased: " + mouseEvent.paramString());
                        if (mouseEvent.isPopupTrigger()) {
                            MultiShowPanel.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                    }
                });
            }
            this.add((Component)this.scrollPane, "Center");
        } else {
            this.pdfController = new SwingController();
            JRepSwingViewBuilder jRepSwingViewBuilder = new JRepSwingViewBuilder(this.pdfController);
            this.pdfComponentPanel = jRepSwingViewBuilder.buildViewerPanel();
            ComponentKeyBinding.install((SwingController)this.pdfController, (JComponent)this.pdfComponentPanel);
            this.pdfController.getDocumentViewController().setAnnotationCallback((AnnotationCallback)new MyAnnotationCallback(this.pdfController.getDocumentViewController()));
            this.add(this.pdfComponentPanel);
        }
    }

    private void makeNewPanelAfterLoading() {
        if (this.pdfController != null) {
            this.pdfController.getDocumentViewController().setFitMode(4);
            this.pdfController.setUtilityPaneVisible(false);
        }
        this.validate();
    }

    public void initPanel(PanelKeyListener panelKeyListener, boolean bl, JComboBox<String> jComboBox) {
        this.parent = panelKeyListener;
        this.actMedicine = "";
        this.isSecond = bl;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (jComboBox != null) {
            jPanel.add(jComboBox, "East");
        }
        this.statusLabel = new JLabel(StringResource.getString("panel_no_medicine"));
        jPanel.add((Component)this.statusLabel, "West");
        FontMetrics fontMetrics = this.getFontMetrics(this.statusLabel.getFont());
        int n = fontMetrics.getAscent();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 0, n));
        jPanel.add((Component)jPanel2, "Center");
        this.add((Component)jPanel, "North");
    }

    protected void mainKeyPressed(KeyEvent keyEvent) {
        char c;
        if (!keyEvent.isConsumed() && (c = RepMainMenu.mainMenuGetCtrlChar(keyEvent)) > '\u0000' && c == 'C') {
            this.parent.copyToClipboard();
        }
        if (!keyEvent.isConsumed()) {
            this.parent.mainKeyPressed(keyEvent);
        }
    }

    @Override
    public void requestFocus() {
        if (this.htmlPanel != null) {
            this.htmlPanel.requestFocus();
        } else if (this.scrollPane != null) {
            this.scrollPane.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void setNewMedica(int n, String string, String string2, int n2, int n3, int n4, int n5, int n6) {
        if (this.statusLabel != null && (string == null || n5 == 0 || n3 == 0 || n4 == 0)) {
            this.actMedicine = "";
            this.enableEditMmMenu();
        } else {
            this.actMedicine = string;
            this.filter = string2;
            this.enableEditMmMenu();
            this.pos = n2;
            this.hits = n3;
            this.sum = n4;
            this.rubrics = n5;
            this.diff = n6;
        }
        this.medicineAction(n);
    }

    private void medicineAction(int n) {
        this.showMm = n;
        String string = MmUtil.getFilenameFromMedi(this.actMedicine);
        if (string.length() > 0) {
            try {
                URL uRL = MmUtil.getUrlHtmMed(this.showMm, string, true);
                if (uRL == null) {
                    this.makeNewPanel(true);
                    this.htmlPanel.setText(MmUtil.getNoMedHTML(this.actMedicine, n != 0));
                    this.htmlPanel.getCaret().setDot(0);
                    this.showedUrl = null;
                    Log.write(5, this.getClass().getName(), "url is null: " + this.showMm + " " + string);
                } else if (this.showedUrl == null || !uRL.sameFile(this.showedUrl)) {
                    Log.write(5, this.getClass().getName(), "Load HTML showd URL: " + String.valueOf(this.showedUrl));
                    this.showedUrl = uRL;
                    this.addResetUrlHistory(uRL, true);
                    String string2 = uRL.getFile();
                    if (string2.endsWith(".pdf")) {
                        this.makeNewPanel(false);
                        Log.write(5, this.getClass().getName(), "Load PDF: " + this.showMm + " " + string);
                        this.pdfController.openDocument(string2);
                    } else {
                        if (this.port == null || !(this.port.getView() instanceof FsetJEditorPane)) {
                            this.makeNewPanel(true);
                        }
                        Log.write(5, this.getClass().getName(), "Load HTML: " + this.showMm + " " + string);
                        this.htmlPanel.setFsetPage(this.showedUrl);
                    }
                }
                this.makeNewPanelAfterLoading();
            }
            catch (Exception exception) {
                this.makeNewPanel(true);
                this.showedUrl = null;
                Log.write(5, this.getClass().getName(), "Not Loaded: " + this.showMm + " " + string, exception);
                this.makeNewPanelAfterLoading();
            }
        } else {
            this.makeNewPanel(true);
            this.showedUrl = null;
            Log.write(5, this.getClass().getName(), "empty filename: " + this.showMm);
            this.makeNewPanelAfterLoading();
        }
        this.setStatus();
    }

    private void setStatus() {
        if (this.statusLabel != null) {
            this.remove(this.statusLabel);
            Object object = this.actMedicine.length() == 0 ? StringResource.getString("panel_no_medicine") : (this.diff < 99999 ? (this.isSecond ? " " + this.actMedicine + this.filter + ": " + this.hits + StringResource.getString("panel_hits_second") + StringResource.getString("panel_diff") + this.diff : " " + this.actMedicine + this.filter + StringResource.getString("panel_pos") + this.pos + ", " + this.hits + StringResource.getString("panel_hits") + this.rubrics + StringResource.getString("panel_symptom") + StringResource.getString("panel_diff") + this.diff) : (this.isSecond ? " " + this.actMedicine + this.filter + ": " + this.hits + StringResource.getString("panel_hits_second") + StringResource.getString("panel_rating") + this.sum : " " + this.actMedicine + this.filter + StringResource.getString("panel_pos") + this.pos + ", " + this.hits + StringResource.getString("panel_hits") + this.rubrics + StringResource.getString("panel_symptom") + StringResource.getString("panel_rating") + this.sum));
            this.statusLabel.setText((String)object);
        }
    }

    public void doPgUp() {
        SwingUtilities.invokeLater(() -> {
            KeyEvent keyEvent = new KeyEvent(this.port.getView(), 401, System.currentTimeMillis(), 0, 33, '\uffff');
            this.port.getView().dispatchEvent(keyEvent);
            this.port.getView().requestFocus();
        });
    }

    public void doPgDown() {
        SwingUtilities.invokeLater(() -> {
            KeyEvent keyEvent = new KeyEvent(this.port.getView(), 401, System.currentTimeMillis(), 0, 34, '\uffff');
            this.port.getView().dispatchEvent(keyEvent);
            this.port.getView().requestFocus();
        });
    }

    protected void enableEditMmMenu() {
        boolean bl = true;
        if (GetDataFile.getDataPath() == null) {
            bl = false;
        }
        if (!User.instance().getProperty("externalRubric", true)) {
            bl = false;
        }
        if (this.actMedicine == null || this.actMedicine.length() == 0) {
            bl = false;
        }
        this.editMmMenu.setEnabled(bl);
    }

    protected void editExtMM(ActionEvent actionEvent) {
        for (int i = 0; i < this.extMmTitle.length; ++i) {
            if (!actionEvent.getActionCommand().equals(this.extMmTitle[i])) continue;
            MmUtil.editExtMM(i + 1, this.actMedicine);
            i = this.extMmTitle.length;
        }
    }

    protected void rightAction() {
        this.menuParent.rightAction();
    }

    protected void leftAction() {
        this.menuParent.leftAction();
    }

    protected void endAction() {
        this.menuParent.endAction();
    }

    protected void homeAction() {
        this.menuParent.homeAction();
    }

    public void historyBackAction() {
        if (this.urlHistory != null && this.urlHistory.size() > 1) {
            Object object = this.urlHistory.get(this.urlHistory.size() - 2);
            this.urlHistory.remove(this.urlHistory.size() - 1);
            if (object instanceof URL) {
                URL uRL = (URL)object;
                Log.write(5, this.getClass().getName(), "historyBack to url: " + String.valueOf(uRL));
                this.showedUrl = uRL;
                String string = uRL.getFile();
                if (string.endsWith(".pdf")) {
                    this.makeNewPanel(false);
                    this.pdfController.openDocument(string);
                } else {
                    this.makeNewPanel(true);
                    this.htmlPanel.setFsetPage(this.showedUrl);
                }
                this.makeNewPanelAfterLoading();
            }
            if (this.hasHistory()) {
                this.backMenu.setEnabled(true);
            } else {
                this.backMenu.setEnabled(false);
            }
        }
    }

    private boolean hasHistory() {
        return this.urlHistory != null && this.urlHistory.size() > 1;
    }

    private void addResetUrlHistory(Object object, boolean bl) {
        if (bl) {
            this.urlHistory = new ArrayList();
            Log.write(5, this.getClass().getName(), "resetHistory ");
        }
        if (object != null) {
            this.urlHistory.add(object);
            if (object instanceof URL) {
                Log.write(5, this.getClass().getName(), "addHistory: " + ((URL)object).getFile());
            } else if (object instanceof String[]) {
                Log.write(5, this.getClass().getName(), "addHistory: " + ((String[])object)[0]);
            } else {
                Log.write(5, this.getClass().getName(), "addHistory: " + String.valueOf(object));
            }
        }
        if (this.hasHistory()) {
            this.backMenu.setEnabled(true);
        } else {
            this.backMenu.setEnabled(false);
        }
    }
}

